/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.math;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.concord.energy2d.math.TransformableShape;

public class Blob2D
implements TransformableShape {
    private Point2D.Float[] points;
    private GeneralPath path;
    private int steps = 20;
    private float invStep = 1.0f / (float)this.steps;
    private float[] px = new float[4];
    private float[] py = new float[4];
    private List<Point2D.Float> pathPoints;

    public Blob2D(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("the number of x coodinates must be equal to that of the y coordinates.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("the number of points must be no less than 3.");
        }
        this.points = new Point2D.Float[x.length];
        int i = 0;
        while (i < x.length) {
            this.setPoint(i, x[i], y[i]);
            ++i;
        }
        this.path = new GeneralPath();
        this.pathPoints = new ArrayList<Point2D.Float>();
        this.update();
    }

    public Blob2D(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("the number of x coodinates must be equal to that of the y coordinates.");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("the number of points must be no less than 3.");
        }
        this.points = new Point2D.Float[x.length];
        int i = 0;
        while (i < x.length) {
            this.setPoint(i, x[i], y[i]);
            ++i;
        }
        this.path = new GeneralPath();
        this.pathPoints = new ArrayList<Point2D.Float>();
        this.update();
    }

    public Blob2D(Polygon p) {
        this.points = new Point2D.Float[p.npoints];
        int i = 0;
        while (i < this.points.length) {
            this.setPoint(i, p.xpoints[i], p.ypoints[i]);
            ++i;
        }
        this.path = new GeneralPath();
        this.pathPoints = new ArrayList<Point2D.Float>();
        this.update();
    }

    public boolean isClockwise() {
        float sum = 0.0f;
        int n = this.points.length;
        int i = 0;
        while (i < n - 1) {
            sum += (this.points[i + 1].x - this.points[i].x) * (this.points[i + 1].y + this.points[i].y);
            ++i;
        }
        return (sum += (this.points[0].x - this.points[n - 1].x) * (this.points[0].y + this.points[n - 1].y)) > 0.0f;
    }

    public Blob2D duplicate() {
        int n = this.points.length;
        float[] x = new float[n];
        float[] y = new float[n];
        int i = 0;
        while (i < n) {
            x[i] = this.points[i].x;
            y[i] = this.points[i].y;
            ++i;
        }
        return new Blob2D(x, y);
    }

    public Blob2D insertPointBefore(int k) {
        int n = this.points.length;
        float[] x = new float[n + 1];
        float[] y = new float[n + 1];
        if (k > 0 && k < n) {
            int i = 0;
            while (i < k) {
                x[i] = this.points[i].x;
                y[i] = this.points[i].y;
                ++i;
            }
            x[k] = 0.5f * (this.points[k].x + this.points[k - 1].x);
            y[k] = 0.5f * (this.points[k].y + this.points[k - 1].y);
            i = k + 1;
            while (i < n + 1) {
                x[i] = this.points[i - 1].x;
                y[i] = this.points[i - 1].y;
                ++i;
            }
        } else if (k == 0) {
            x[0] = 0.5f * (this.points[0].x + this.points[n - 1].x);
            y[0] = 0.5f * (this.points[0].y + this.points[n - 1].y);
            int i = 1;
            while (i < n + 1) {
                x[i] = this.points[i - 1].x;
                y[i] = this.points[i - 1].y;
                ++i;
            }
        } else {
            return this;
        }
        return new Blob2D(x, y);
    }

    public Blob2D deletePointBefore(int k) {
        int n = this.points.length;
        if (n < 4) {
            return this;
        }
        float[] x = new float[n - 1];
        float[] y = new float[n - 1];
        if (k > 0 && k < n) {
            int i = 0;
            while (i < k) {
                x[i] = this.points[i].x;
                y[i] = this.points[i].y;
                ++i;
            }
            i = k + 1;
            while (i < n) {
                x[i - 1] = this.points[i].x;
                y[i - 1] = this.points[i].y;
                ++i;
            }
        } else if (k == 0) {
            int i = 1;
            while (i < n) {
                x[i - 1] = this.points[i - 1].x;
                y[i - 1] = this.points[i - 1].y;
                ++i;
            }
        } else {
            return this;
        }
        return new Blob2D(x, y);
    }

    public GeneralPath getPath() {
        return this.path;
    }

    public float getPerimeter() {
        float dy;
        float dx;
        Point2D.Float p1;
        float perimeter = 0.0f;
        int n = this.pathPoints.size();
        Point2D.Float p2 = null;
        int i = 0;
        while (i < n - 1) {
            p1 = this.pathPoints.get(i);
            p2 = this.pathPoints.get(i + 1);
            dx = p2.x - p1.x;
            dy = p2.y - p1.y;
            perimeter = (float)((double)perimeter + Math.hypot(dx, dy));
            ++i;
        }
        if (p2 != null) {
            p1 = this.pathPoints.get(0);
            dx = p2.x - p1.x;
            dy = p2.y - p1.y;
            perimeter = (float)((double)perimeter + Math.hypot(dx, dy));
        }
        return perimeter;
    }

    public void update() {
        this.path.reset();
        this.pathPoints.clear();
        int n = this.points.length;
        this.path.moveTo(this.points[n - 1].x, this.points[n - 1].y);
        this.pathPoints.add(new Point2D.Float(this.points[n - 1].x, this.points[n - 1].y));
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < 4) {
                int index = (i + j - 2 + n) % n;
                this.px[j] = this.points[index].x;
                this.py[j] = this.points[index].y;
                ++j;
            }
            int k = 0;
            while (k < this.steps) {
                float u = (float)k * this.invStep;
                float sx = Blob2D.catmullrom(-2, u) * this.px[0] + Blob2D.catmullrom(-1, u) * this.px[1] + Blob2D.catmullrom(0, u) * this.px[2] + Blob2D.catmullrom(1, u) * this.px[3];
                float sy = Blob2D.catmullrom(-2, u) * this.py[0] + Blob2D.catmullrom(-1, u) * this.py[1] + Blob2D.catmullrom(0, u) * this.py[2] + Blob2D.catmullrom(1, u) * this.py[3];
                this.path.lineTo(sx *= 0.5f, sy *= 0.5f);
                this.pathPoints.add(new Point2D.Float(sx, sy));
                ++k;
            }
            ++i;
        }
        this.path.closePath();
    }

    public int getPathPointCount() {
        return this.pathPoints.size();
    }

    public Point2D.Float getPathPoint(int i) {
        if (i < 0 || i >= this.pathPoints.size()) {
            throw new IllegalArgumentException("index is out of bound.");
        }
        return this.pathPoints.get(i);
    }

    public void setPoints(List<Point2D.Float> p) {
        if (p.size() < 3) {
            throw new IllegalArgumentException("the number of points must be no less than 3.");
        }
        if (this.points == null || p.size() != this.points.length) {
            this.path = new GeneralPath();
        }
        this.points = new Point2D.Float[p.size()];
        int i = 0;
        while (i < this.points.length) {
            Point2D.Float pi = p.get(i);
            this.setPoint(i, pi.x, pi.y);
            ++i;
        }
        this.update();
    }

    public void setPoint(int i, float x, float y) {
        if (i < 0 || i >= this.points.length) {
            throw new IllegalArgumentException("index is out of bound.");
        }
        if (this.points[i] == null) {
            this.points[i] = new Point2D.Float(x, y);
        } else {
            this.points[i].setLocation(x, y);
        }
    }

    public Point2D.Float getPoint(int i) {
        if (i < 0 || i >= this.points.length) {
            throw new IllegalArgumentException("index is out of bound.");
        }
        return this.points[i];
    }

    public int getPointCount() {
        return this.points.length;
    }

    @Override
    public void translateBy(float dx, float dy) {
        Point2D.Float[] floatArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float p = floatArray[n2];
            p.x += dx;
            p.y += dy;
            ++n2;
        }
    }

    @Override
    public void rotateBy(float degree) {
        Rectangle2D r = this.path.getBounds2D();
        double cx = r.getCenterX();
        double cy = r.getCenterY();
        double a = Math.toRadians(degree);
        double sin = Math.sin(a);
        double cos = Math.cos(a);
        double dx = 0.0;
        double dy = 0.0;
        Point2D.Float[] floatArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            dx = (double)v.x - cx;
            dy = (double)v.y - cy;
            v.x = (float)(dx * cos - dy * sin + cx);
            v.y = (float)(dx * sin + dy * cos + cy);
            ++n2;
        }
    }

    @Override
    public void scale(float scale) {
        Rectangle2D r = this.path.getBounds2D();
        double cx = r.getCenterX();
        double cy = r.getCenterY();
        Point2D.Float[] floatArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            v.x = (float)(((double)v.x - cx) * (double)scale + cx);
            v.y = (float)(((double)v.y - cy) * (double)scale + cy);
            ++n2;
        }
    }

    @Override
    public void scaleX(float scale) {
        Rectangle2D r = this.path.getBounds2D();
        double cx = r.getCenterX();
        Point2D.Float[] floatArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            v.x = (float)(((double)v.x - cx) * (double)scale + cx);
            ++n2;
        }
    }

    @Override
    public void scaleY(float scale) {
        Rectangle2D r = this.path.getBounds2D();
        double cy = r.getCenterY();
        Point2D.Float[] floatArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            v.y = (float)(((double)v.y - cy) * (double)scale + cy);
            ++n2;
        }
    }

    @Override
    public void shearX(float shear) {
        Rectangle2D r = this.path.getBounds2D();
        double cy = r.getCenterY();
        Point2D.Float[] floatArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            v.x += (float)((double)v.y - cy) * shear;
            ++n2;
        }
    }

    @Override
    public void shearY(float shear) {
        Rectangle2D r = this.path.getBounds2D();
        double cx = r.getCenterX();
        Point2D.Float[] floatArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            v.y += (float)((double)v.x - cx) * shear;
            ++n2;
        }
    }

    @Override
    public void flipX() {
        float cx = (float)this.path.getBounds2D().getCenterX();
        float dx = 0.0f;
        Point2D.Float[] floatArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            dx = v.x - cx;
            v.x = cx - dx;
            ++n2;
        }
    }

    @Override
    public void flipY() {
        float cy = (float)this.path.getBounds2D().getCenterY();
        float dy = 0.0f;
        Point2D.Float[] floatArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            dy = v.y - cy;
            v.y = cy - dy;
            ++n2;
        }
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(Rectangle r) {
        return this.path.intersects(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.path.contains(x, y);
    }

    public Point2D.Float getBoundCenter() {
        Rectangle2D r = this.path.getBounds2D();
        return new Point2D.Float((float)r.getCenterX(), (float)r.getCenterY());
    }

    public void translateCenterTo(float x, float y) {
        Point2D.Float center = this.getCenter();
        this.translateBy(x - center.x, y - center.y);
    }

    @Override
    public Point2D.Float getCenter() {
        float xc = 0.0f;
        float yc = 0.0f;
        Point2D.Float[] floatArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D.Float v = floatArray[n2];
            xc += v.x;
            yc += v.y;
            ++n2;
        }
        return new Point2D.Float(xc / (float)this.points.length, yc / (float)this.points.length);
    }

    @Override
    public float getArea() {
        Point2D.Float v2;
        Point2D.Float v1;
        float area = 0.0f;
        int n = this.points.length;
        int i = 0;
        while (i < n - 1) {
            v1 = this.points[i];
            v2 = this.points[i + 1];
            area = (float)((double)area + (v1.getX() * v2.getY() - v2.getX() * v1.getY()));
            ++i;
        }
        v1 = this.points[n - 1];
        v2 = this.points[0];
        area = (float)((double)area + (v1.getX() * v2.getY() - v2.getX() * v1.getY()));
        return area * 0.5f;
    }

    @Override
    public Rectangle getBounds() {
        return this.path.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.path.contains(r);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.path.contains(x, y, w, h);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.path.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.path.getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.path.intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.path.intersects(x, y, w, h);
    }

    private static float catmullrom(int i, float u) {
        switch (i) {
            case -2: {
                return u * (u * (2.0f - u) - 1.0f);
            }
            case -1: {
                return u * u * (3.0f * u - 5.0f) + 2.0f;
            }
            case 0: {
                return u * ((4.0f - 3.0f * u) * u + 1.0f);
            }
            case 1: {
                return u * u * (u - 1.0f);
            }
        }
        return 0.0f;
    }
}

