/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.rk.AbstractAdaptiveRKSolverInterpolator;

public class CashKarp45
extends AbstractAdaptiveRKSolverInterpolator {
    private static final double A_11 = 0.2;
    private static final double A_21 = 0.075;
    private static final double A_22 = 0.225;
    private static final double A_31 = 0.3;
    private static final double A_32 = -0.9;
    private static final double A_33 = 1.2;
    private static final double A_41 = -0.2037037037037037;
    private static final double A_42 = 2.5;
    private static final double A_43 = -2.5925925925925926;
    private static final double A_44 = 1.2962962962962963;
    private static final double A_51 = 0.029495804398148147;
    private static final double A_52 = 0.341796875;
    private static final double A_53 = 0.041594328703703706;
    private static final double A_54 = 0.40034541377314814;
    private static final double A_55 = 0.061767578125;
    private static final double B4_1 = 0.10217737268518519;
    private static final double B4_2 = 0.0;
    private static final double B4_3 = 0.38390790343915343;
    private static final double B4_4 = 0.24459273726851852;
    private static final double B4_5 = 0.019321986607142856;
    private static final double B4_6 = 0.25;
    private static final double B5_1 = 0.09788359788359788;
    private static final double B5_2 = 0.0;
    private static final double B5_3 = 0.4025764895330113;
    private static final double B5_4 = 0.21043771043771045;
    private static final double B5_5 = 0.0;
    private static final double B5_6 = 0.2891022021456804;
    private double[] rate2;
    private double[] rate3;
    private double[] rate4;
    private double[] rate5;
    private double[] rate6;
    private double[] order4;

    public CashKarp45(ODE _ode) {
        this.ode = _ode;
    }

    @Override
    protected void allocateOtherArrays() {
        super.allocateOtherArrays();
        this.rate2 = new double[this.dimension];
        this.rate3 = new double[this.dimension];
        this.rate4 = new double[this.dimension];
        this.rate5 = new double[this.dimension];
        this.rate6 = new double[this.dimension];
        this.order4 = new double[this.dimension];
    }

    @Override
    protected double getMethodOrder() {
        return 5.0;
    }

    @Override
    protected int getNumberOfEvaluations() {
        return 6;
    }

    @Override
    protected void computeFinalRate() {
        this.ode.getRate(this.finalState, this.finalRate);
    }

    @Override
    protected double computeApproximations(double _step) {
        this.computeIntermediateStep(_step, this.finalState);
        int i = 0;
        while (i < this.dimension) {
            this.order4[i] = this.initialState[i] + _step * (0.10217737268518519 * this.initialRate[i] + 0.0 * this.rate2[i] + 0.38390790343915343 * this.rate3[i] + 0.24459273726851852 * this.rate4[i] + 0.019321986607142856 * this.rate5[i] + 0.25 * this.rate6[i]);
            ++i;
        }
        return super.computeError(this.order4);
    }

    @Override
    protected double[] computeIntermediateStep(double _step, double[] _state) {
        int i = 0;
        while (i < this.dimension) {
            _state[i] = this.initialState[i] + _step * 0.2 * this.initialRate[i];
            ++i;
        }
        this.ode.getRate(_state, this.rate2);
        i = 0;
        while (i < this.dimension) {
            _state[i] = this.initialState[i] + _step * (0.075 * this.initialRate[i] + 0.225 * this.rate2[i]);
            ++i;
        }
        this.ode.getRate(_state, this.rate3);
        i = 0;
        while (i < this.dimension) {
            _state[i] = this.initialState[i] + _step * (0.3 * this.initialRate[i] + -0.9 * this.rate2[i] + 1.2 * this.rate3[i]);
            ++i;
        }
        this.ode.getRate(_state, this.rate4);
        i = 0;
        while (i < this.dimension) {
            _state[i] = this.initialState[i] + _step * (-0.2037037037037037 * this.initialRate[i] + 2.5 * this.rate2[i] + -2.5925925925925926 * this.rate3[i] + 1.2962962962962963 * this.rate4[i]);
            ++i;
        }
        this.ode.getRate(_state, this.rate5);
        i = 0;
        while (i < this.dimension) {
            _state[i] = this.initialState[i] + _step * (0.029495804398148147 * this.initialRate[i] + 0.341796875 * this.rate2[i] + 0.041594328703703706 * this.rate3[i] + 0.40034541377314814 * this.rate4[i] + 0.061767578125 * this.rate5[i]);
            ++i;
        }
        this.ode.getRate(_state, this.rate6);
        i = 0;
        while (i < this.dimension) {
            _state[i] = this.initialState[i] + _step * (0.09788359788359788 * this.initialRate[i] + 0.0 * this.rate2[i] + 0.4025764895330113 * this.rate3[i] + 0.21043771043771045 * this.rate4[i] + 0.0 * this.rate5[i] + 0.2891022021456804 * this.rate6[i]);
            ++i;
        }
        return _state;
    }

    @Override
    public double[] interpolate(double _time, boolean useLeftApproximation, double[] _state) {
        return super.interpolateBootstrap2(_time, _state);
    }
}

