/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.rk.AbstractExplicitRKSolverInterpolator;

public abstract class AbstractAdaptiveRKSolverInterpolator
extends AbstractExplicitRKSolverInterpolator {
    private boolean estimate = false;
    private double actualStepSize;
    private double absoluteTolerance = Double.NaN;
    private double relativeTolerance = Double.NaN;
    protected double[] relTol;
    protected double[] absTol;
    private static final double fac1 = 0.33;
    private static final double fac2 = 6.0;
    private static final double beta = 0.0;
    private static final double safe = 0.9;
    private final double expO1 = 1.0 / this.getMethodOrder() - 0.0;
    private double errOld = 1.0E-4;
    private double fac = 0.0;

    protected abstract double computeApproximations(double var1);

    protected abstract void computeFinalRate();

    protected abstract double getMethodOrder();

    @Override
    protected void allocateOtherArrays() {
        this.relTol = new double[this.dimension];
        this.absTol = new double[this.dimension];
        this.setTolerances(1.0E-6, 1.0E-6);
    }

    @Override
    public void reinitialize(double[] _state) {
        super.reinitialize(_state);
        this.actualStepSize = this.estimate ? this.limitStepSize(this.estimateFirstStepSize(this.stepSize)) : this.limitStepSize(this.stepSize);
    }

    @Override
    public final void setEstimateFirstStep(boolean _estimate) {
        this.estimate = _estimate;
    }

    @Override
    public void setMaximumStepSize(double stepSize) {
        super.setMaximumStepSize(stepSize);
        this.actualStepSize = this.limitStepSize(this.actualStepSize);
    }

    @Override
    public final void setTolerances(double _absTol, double _relTol) {
        if (this.absoluteTolerance == _absTol && this.relativeTolerance == _relTol) {
            return;
        }
        this.absoluteTolerance = _absTol;
        this.relativeTolerance = _relTol;
        int i = 0;
        while (i < this.dimension) {
            this.absTol[i] = _absTol;
            this.relTol[i] = _relTol;
            ++i;
        }
        this.finalTime = Double.NaN;
        this.error_code = 0;
        this.actualStepSize = this.estimate ? this.limitStepSize(this.estimateFirstStepSize(this.stepSize)) : this.limitStepSize(this.stepSize);
    }

    public final void setTolerances(double[] _absTol, double[] _relTol) {
        this.relativeTolerance = Double.NaN;
        this.absoluteTolerance = Double.NaN;
        System.arraycopy(_absTol, 0, this.absTol, 0, this.dimension);
        System.arraycopy(_relTol, 0, this.relTol, 0, this.dimension);
        this.finalTime = Double.NaN;
        this.error_code = 0;
        this.actualStepSize = this.estimate ? this.limitStepSize(this.estimateFirstStepSize(this.stepSize)) : this.limitStepSize(this.stepSize);
    }

    @Override
    protected final void computeOneStep() {
        this.error_code = 0;
        int iterations = 0;
        while (iterations < 500) {
            double err = this.computeApproximations(this.actualStepSize);
            this.counter += this.evals;
            if (err <= 1.0) {
                this.computeFinalRate();
                this.finalTime = this.initialTime + this.actualStepSize;
                this.actualStepSize = iterations > 0 ? this.limitStepSize(Math.min(this.actualStepSize, this.estimatedStepSize(err))) : this.limitStepSize(this.estimatedStepSize(err));
                return;
            }
            this.actualStepSize = this.limitStepSize(Math.min(this.actualStepSize, this.estimatedStepSize(err)));
            ++iterations;
        }
        this.finalTime = Double.NaN;
        this.error_code = 1;
    }

    protected final double computeError(double[] _compState) {
        double error = 0.0;
        int i = 0;
        while (i < this.dimension) {
            double sk = this.absTol[i] + this.relTol[i] * Math.max(Math.abs(this.finalState[i]), Math.abs(this.initialState[i]));
            double errorI = (this.finalState[i] - _compState[i]) / sk;
            error += errorI * errorI;
            ++i;
        }
        return Math.sqrt(error / (double)this.dimension);
    }

    protected double estimatedStepSize(double err) {
        double fac11 = 0.0;
        if (err != 0.0) {
            fac11 = Math.pow(err, this.expO1);
            this.fac = fac11 / Math.exp(0.0 * Math.log(this.errOld));
            this.fac = Math.max(0.16666666666666666, Math.min(3.0303030303030303, this.fac / 0.9));
        } else {
            fac11 = 3.0303030303030303;
            this.fac = 0.16666666666666666;
        }
        if (err <= 1.0) {
            this.errOld = Math.max(err, 1.0E-4);
            return this.actualStepSize / this.fac;
        }
        return this.actualStepSize / Math.min(3.0303030303030303, fac11 / 0.9);
    }

    private double limitStepSize(double intendedStep) {
        if (intendedStep >= 0.0) {
            return Math.min(intendedStep, this.maximumStepSize);
        }
        return Math.max(intendedStep, -this.maximumStepSize);
    }

    private final double estimateFirstStepSize(double hMax) {
        int posneg = hMax < 0.0 ? -1 : 1;
        hMax = Math.abs(hMax);
        double normF = 0.0;
        double normX = 0.0;
        int i = 0;
        while (i < this.dimension) {
            double sk = this.absTol[i] + this.relTol[i] * Math.abs(this.initialState[i]);
            double aux = this.initialRate[i] / sk;
            normF += aux * aux;
            aux = this.initialState[i] / sk;
            normX += aux * aux;
            ++i;
        }
        double h = normF <= 1.0E-10 || normX <= 1.0E-10 ? 1.0E-6 : Math.sqrt(normX / normF) * 0.01;
        h = (double)posneg * Math.min(h, hMax);
        int i2 = 0;
        while (i2 < this.dimension) {
            this.finalState[i2] = this.initialState[i2] + h * this.initialRate[i2];
            ++i2;
        }
        this.ode.getRate(this.finalState, this.finalRate);
        double der2 = 0.0;
        int i3 = 0;
        while (i3 < this.dimension) {
            double sk = this.absTol[i3] + this.relTol[i3] * Math.abs(this.initialState[i3]);
            double aux = (this.finalRate[i3] - this.initialRate[i3]) / sk;
            der2 += aux * aux;
            ++i3;
        }
        double der12 = Math.max(Math.abs(der2 = Math.sqrt(der2) / h), Math.sqrt(normF));
        double h1 = der12 <= 1.0E-15 ? Math.max(1.0E-6, Math.abs(h) * 0.001) : Math.exp(1.0 / this.getMethodOrder() * Math.log(0.01 / der12));
        h = (double)posneg * Math.min(100.0 * h, h1);
        if (hMax != 0.0) {
            h = (double)posneg * Math.min(Math.abs(h), hMax);
        }
        return h;
    }
}

