/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.NeedsFinalUpdate;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DataPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;

public class ControlDataTable
extends ControlSwingElement
implements NeedsUpdate,
NeedsFinalUpdate,
DataCollector,
Resetable {
    private static final int TABLE_ADDED = 9;
    private boolean noRepeat = true;
    private boolean isSet = false;
    private boolean active = true;
    private double[] input;
    private double[] oldInput;
    private String[] columnNames = new String[0];
    private String[] columnFormats = new String[]{"0.000;-0.000"};
    private DataPanel dataPanel;
    private String numericFormat = "0.000";
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.dataPanel = new DataPanel();
        this.dataPanel.setRowNumberVisible(false);
        this.dataPanel.setAutoResizeMode(4);
        int i = 0;
        int n = this.dataPanel.getColumnCount();
        while (i < n) {
            this.dataPanel.setColumnFormat(i, "0.000;-0.000");
            ++i;
        }
        this.oldInput = null;
        this.input = null;
        this.isSet = false;
        this.dataPanel.getVisual().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent _evt) {
                if (ControlDataTable.this.getSimulation() == null || !OSPRuntime.isPopupTrigger(_evt)) {
                    return;
                }
                ControlDataTable.this.getPopupMenu(_evt.getX(), _evt.getY());
            }
        });
        return this.dataPanel;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.display.DataPanel";
    }

    @Override
    public Object getObject() {
        return this.dataPanel;
    }

    @Override
    public Component getComponent() {
        return this.dataPanel;
    }

    @Override
    public void initialize() {
        this.reset();
    }

    @Override
    public void reset() {
        this.dataPanel.clearData();
        this.oldInput = null;
        this.input = null;
        this.isSet = false;
    }

    @Override
    public void onExit() {
        this.reset();
    }

    @Override
    public void update() {
        block16: {
            int i;
            if (!this.active || !this.isSet || this.input == null) break block16;
            if (this.noRepeat) {
                if (this.oldInput == null || this.input.length != this.oldInput.length) {
                    this.oldInput = new double[this.input.length];
                } else {
                    boolean equal = true;
                    i = 0;
                    while (i < this.input.length) {
                        if (this.input[i] != this.oldInput[i]) {
                            equal = false;
                            break;
                        }
                        ++i;
                    }
                    if (equal) {
                        return;
                    }
                }
                int i2 = 0;
                while (i2 < this.input.length) {
                    this.oldInput[i2] = this.input[i2];
                    ++i2;
                }
            }
            int count = this.dataPanel.getColumnCount();
            this.dataPanel.appendRow(this.input);
            if (this.input.length != count) {
                i = 0;
                int n = Math.min(this.columnNames.length, this.input.length);
                while (i < n) {
                    this.dataPanel.setColumnNames(i, this.columnNames[i]);
                    ++i;
                }
                if (this.columnFormats == null) {
                    this.dataPanel.setNumericFormat(this.numericFormat);
                } else if (this.columnFormats.length >= this.input.length) {
                    i = 0;
                    n = this.input.length;
                    while (i < n) {
                        this.dataPanel.setColumnFormat(i, this.columnFormats[i]);
                        ++i;
                    }
                } else {
                    i = 0;
                    n = this.columnFormats.length;
                    while (i < n) {
                        this.dataPanel.setColumnFormat(i, this.columnFormats[i]);
                        ++i;
                    }
                    i = this.columnFormats.length;
                    n = this.input.length;
                    while (i < n) {
                        this.dataPanel.setColumnFormat(i, this.columnFormats[this.columnFormats.length - 1]);
                        ++i;
                    }
                }
            }
        }
    }

    @Override
    public void finalUpdate() {
        this.dataPanel.refreshTable();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("input");
            infoList.add("maxPoints");
            infoList.add("stride");
            infoList.add("active");
            infoList.add("norepeat");
            infoList.add("showRowNumber");
            infoList.add("columnNames");
            infoList.add("columnFormat");
            infoList.add("autoResizeMode");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("input")) {
            return "int|double|double[]";
        }
        if (_property.equals("maxPoints")) {
            return "int";
        }
        if (_property.equals("stride")) {
            return "int";
        }
        if (_property.equals("active")) {
            return "boolean";
        }
        if (_property.equals("norepeat")) {
            return "boolean";
        }
        if (_property.equals("showRowNumber")) {
            return "boolean";
        }
        if (_property.equals("columnNames")) {
            return "String|String[] TRANSLATABLE";
        }
        if (_property.equals("columnFormat")) {
            return "String|String[] TRANSLATABLE";
        }
        if (_property.equals("autoResizeMode")) {
            return "AutoResizeMode|int";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("AutoResizeMode") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("off")) {
                return new IntegerValue(0);
            }
            if (_value.equals("next")) {
                return new IntegerValue(1);
            }
            if (_value.equals("subsequent")) {
                return new IntegerValue(2);
            }
            if (_value.equals("last")) {
                return new IntegerValue(3);
            }
            if (_value.equals("all")) {
                return new IntegerValue(4);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.input = _value.getObject() instanceof double[] ? (double[])_value.getObject() : new double[]{_value.getDouble()};
                this.isSet = true;
                break;
            }
            case 1: {
                this.dataPanel.setMaxPoints(_value.getInteger());
                break;
            }
            case 2: {
                this.dataPanel.setStride(_value.getInteger());
                break;
            }
            case 3: {
                this.active = _value.getBoolean();
                break;
            }
            case 4: {
                this.noRepeat = _value.getBoolean();
                break;
            }
            case 5: {
                this.dataPanel.setRowNumberVisible(_value.getBoolean());
                break;
            }
            case 6: {
                if (_value.getObject() instanceof String[]) {
                    this.columnNames = (String[])_value.getObject();
                } else {
                    String names = _value.getString();
                    StringTokenizer tkn = new StringTokenizer(names, ",");
                    this.columnNames = new String[tkn.countTokens()];
                    int c = 0;
                    while (tkn.hasMoreTokens()) {
                        this.columnNames[c] = TeXParser.parseTeX(tkn.nextToken());
                        ++c;
                    }
                }
                int i = 0;
                int n = this.columnNames.length;
                while (i < n) {
                    this.dataPanel.setColumnNames(i, this.columnNames[i]);
                    ++i;
                }
                break;
            }
            case 7: {
                if (_value.getObject() instanceof String[]) {
                    this.columnFormats = (String[])_value.getObject();
                } else {
                    String formats = _value.getString();
                    StringTokenizer tkn = new StringTokenizer(formats, ",");
                    int nTokens = tkn.countTokens();
                    if (nTokens <= 1) {
                        this.columnFormats = null;
                        this.dataPanel.clearFormats();
                        this.numericFormat = formats;
                        this.dataPanel.setNumericFormat(this.numericFormat);
                        return;
                    }
                    this.columnFormats = new String[nTokens];
                    int c = 0;
                    while (tkn.hasMoreTokens()) {
                        this.columnFormats[c] = TeXParser.parseTeX(tkn.nextToken());
                        ++c;
                    }
                }
                int i = 0;
                int n = this.columnFormats.length;
                while (i < n) {
                    this.dataPanel.setColumnFormat(i, this.columnFormats[i]);
                    ++i;
                }
                break;
            }
            case 8: {
                this.dataPanel.setAutoResizeMode(_value.getInteger());
                break;
            }
            default: {
                super.setValue(_index - 9, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.oldInput = null;
                this.input = null;
                this.isSet = false;
                break;
            }
            case 1: {
                this.dataPanel.setMaxPoints(-1);
                break;
            }
            case 2: {
                this.dataPanel.setStride(1);
                break;
            }
            case 3: {
                this.active = true;
                break;
            }
            case 4: {
                this.noRepeat = true;
                break;
            }
            case 5: {
                this.dataPanel.setRowNumberVisible(false);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.columnFormats = null;
                this.numericFormat = "0.000;-0.000";
                this.dataPanel.setNumericFormat(this.numericFormat);
                break;
            }
            case 8: {
                this.dataPanel.setAutoResizeMode(4);
                break;
            }
            default: {
                super.setDefaultValue(_index - 9);
            }
        }
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return null;
            }
        }
        return super.getValue(_index - 9);
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "-1";
            }
            case 2: {
                return "1";
            }
            case 3: {
                return "true";
            }
            case 4: {
                return "true";
            }
            case 5: {
                return "false";
            }
            case 6: {
                return "<none>";
            }
            case 7: {
                return "0.000;-0.000";
            }
            case 8: {
                return "ALL";
            }
        }
        return super.getDefaultValueString(_index - 9);
    }
}

