/*
 * Decompiled with CFR 0.152.
 */
package _013CooLing.CoolingPrimaryv5_pkg;

import _013CooLing.CoolingPrimaryv5_pkg.CoolingPrimaryv5Simulation;
import _013CooLing.CoolingPrimaryv5_pkg.CoolingPrimaryv5View;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EJSODE;
import org.opensourcephysics.numerics.GeneralStateEvent;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEInterpolatorEventSolver;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.rk.CashKarp45;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoolingPrimaryv5
extends Model {
    public CoolingPrimaryv5Simulation _simulation = null;
    public CoolingPrimaryv5View _view = null;
    public CoolingPrimaryv5 _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    protected Hashtable<String, EJSODE> _privateOdesList = new Hashtable();
    public String materialStr = "Cu";
    public String dtStr = "1s";
    public double mass = 0.1;
    public double massGram = this.mass * 1000.0;
    public double C = 385.0;
    public double rho = 8933.0;
    public double h = 400.0;
    public double A = 6.0 * Math.pow(this.mass / this.rho, 0.6666666666666666);
    public double vol = this.mass / this.rho;
    public double volCmCubed = this.vol * 1000000.0;
    public double kappa = this.h * this.A / this.mass / this.C;
    public double backgroundT = 30.0;
    public double heating = 5.0;
    public boolean heatingOn = true;
    public boolean showTemperatureGraph;
    public boolean showTable;
    public String TMsg = "T = ";
    public String ToMsg = "To = ";
    public int stride = 10;
    public int counter = 50;
    public boolean showValue = false;
    public boolean differentMaterial = true;
    public boolean showpt = true;
    public double Ti;
    public double T = this.Ti = this.backgroundT;
    public double t = 0.0;
    public double dt = 5.0;
    public double tol = 1.0E-8;
    public String options = "";
    public String which_opt = "";
    public int N = 3;
    public double[][] object;
    public int heat_coeff = 0;
    public int surface_area = 1;
    public int obj_mass = 2;
    public int heat_capacity = 3;
    public int heat_rate = 4;
    public int obj_temp = 5;
    public double area = 30.0;
    public double temp_1 = this.backgroundT + 30.0;
    public double temp_2 = this.backgroundT + 30.0;
    public double temp_3 = this.backgroundT + 30.0;
    public int obj_1 = 0;
    public int obj_2 = 1;
    public int obj_3 = 2;
    public double mass_1;
    public double mass_2;
    public double mass_3;
    public double area_1 = this.area;
    public double area_2 = this.area;
    public double area_3 = this.area;
    public String temperature_unit = "";
    public String area_unit = "";
    public double initial_temp_1 = this.temp_1;
    public double initial_temp_2 = this.temp_2;
    public double initial_temp_3 = this.temp_3;
    public Color obj1_colour = Color.ORANGE;
    public Color obj2_colour = Color.MAGENTA;
    public Color obj3_colour = Color.LIGHT_GRAY;
    public Random random_number = new Random();
    public double BEST = 300.0;
    public double GOOD = 700.0;
    public double WORST = 1200.0;
    public int RANGE = 200;
    public boolean STEP = false;
    public int best_heat;
    public double min_mass = 0.01;
    public double max_mass = 5.0;
    public double min_temp = 0.0;
    public double max_temp = 150.0;
    public double min_area = 5.0;
    public double max_area = 100.0;
    public double fire_pos = 0.5;
    public double max_temp_graph = this.backgroundT;
    public double min_temp_graph = this.backgroundT;
    public boolean has_not_started = true;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_evolution1_Event1 = true;
    private boolean _isEnabled_constraints1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return CoolingPrimaryv5._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/2013CooLing/CoolingPrimaryv5.xml";
    }

    public static String _getModelDirectory() {
        return "2013CooLing/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(600, 353);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/sgeducation/lookang/Cooling,Heating Simulation/Cooling,heating simulator.png");
        hashSet.add("/2013CooLing/NewtonLawOfCooling/fire.gif");
        hashSet.add("/2013CooLing/NewtonLawOfCooling/fire.gif");
        hashSet.add("/2013CooLing/NewtonLawOfCooling/heating_an_object.jpg");
        hashSet.add("/2013CooLing/NewtonLawOfCooling/NewtonLawOfCooling.html");
        hashSet.add("/2013CooLing/NewtonLawOfCooling/newton_cooling_eqn.gif");
        hashSet.add("/2013CooLing/NewtonLawOfCooling/newton_cooling_ode_eqn.gif");
        hashSet.add("/users/sgeducation/lookang/Cooling,Heating Simulation/lookangphoto.png");
        hashSet.add("/users/sgeducation/lookang/Cooling,Heating Simulation/Cooling,heating simulator.png");
        hashSet.add("/users/sgeducation/lookang/Cooling,Heating Simulation/lookangphoto.png");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("2013CooLing/");
        n = 0;
        boolean bl2 = false;
        try {
            if ("true".equals(System.getProperty("org.osp.launcher"))) {
                OSPRuntime.setLauncherMode(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("F:/EJS_5.0 beta/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("F:/EJS_5.0 beta/bin/config/");
        }
        CoolingPrimaryv5._addHtmlPageInfo("Intro Page", "_default_", "Intro Page", "./CoolingPrimaryv5_Intro 1.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!CoolingPrimaryv5._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        CoolingPrimaryv5 coolingPrimaryv5 = new CoolingPrimaryv5(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!CoolingPrimaryv5._common_initialization(stringArray)) {
            return null;
        }
        CoolingPrimaryv5 coolingPrimaryv5 = new CoolingPrimaryv5("mainFrame", jFrame, null, null, stringArray, true);
        return (JComponent)coolingPrimaryv5._getView().getComponent("mainFrame");
    }

    public CoolingPrimaryv5() {
        this(null, null, null, null, null, false);
    }

    public CoolingPrimaryv5(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public CoolingPrimaryv5(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        ControlWindow.setKeepHidden(true);
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new CoolingPrimaryv5Simulation(this, string, frame, uRL, bl);
        this._simulation.processArguments(stringArray);
        ControlWindow.setKeepHidden(false);
    }

    @Override
    public String _getClassEjsModel() {
        return CoolingPrimaryv5._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return CoolingPrimaryv5._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return CoolingPrimaryv5._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_evolution1_Event1 = true;
        this._isEnabled_constraints1 = true;
        this.materialStr = "Cu";
        this.dtStr = "1s";
        this.mass = 0.1;
        this.massGram = this.mass * 1000.0;
        this.C = 385.0;
        this.rho = 8933.0;
        this.h = 400.0;
        this.A = 6.0 * Math.pow(this.mass / this.rho, 0.6666666666666666);
        this.vol = this.mass / this.rho;
        this.volCmCubed = this.vol * 1000000.0;
        this.kappa = this.h * this.A / this.mass / this.C;
        this.backgroundT = 30.0;
        this.heating = 5.0;
        this.heatingOn = true;
        this.TMsg = "T = ";
        this.ToMsg = "To = ";
        this.stride = 10;
        this.counter = 50;
        this.showValue = false;
        this.differentMaterial = true;
        this.showpt = true;
        this.T = this.Ti = this.backgroundT;
        this.t = 0.0;
        this.dt = 5.0;
        this.tol = 1.0E-8;
        this.N = 3;
        this.object = new double[this.N][6];
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.object[i][j] = 0.0;
            }
        }
        this.heat_coeff = 0;
        this.surface_area = 1;
        this.obj_mass = 2;
        this.heat_capacity = 3;
        this.heat_rate = 4;
        this.obj_temp = 5;
        this.area = 30.0;
        this.temp_1 = this.backgroundT + 30.0;
        this.temp_2 = this.backgroundT + 30.0;
        this.temp_3 = this.backgroundT + 30.0;
        this.obj_1 = 0;
        this.obj_2 = 1;
        this.obj_3 = 2;
        this.area_1 = this.area;
        this.area_2 = this.area;
        this.area_3 = this.area;
        this.temperature_unit = "";
        this.area_unit = "";
        this.initial_temp_1 = this.temp_1;
        this.initial_temp_2 = this.temp_2;
        this.initial_temp_3 = this.temp_3;
        this.obj1_colour = Color.ORANGE;
        this.obj2_colour = Color.MAGENTA;
        this.obj3_colour = Color.LIGHT_GRAY;
        this.random_number = new Random();
        this.BEST = 300.0;
        this.GOOD = 700.0;
        this.WORST = 1200.0;
        this.RANGE = 200;
        this.STEP = false;
        this.min_mass = 0.01;
        this.max_mass = 5.0;
        this.min_temp = 0.0;
        this.max_temp = 150.0;
        this.min_area = 5.0;
        this.max_area = 100.0;
        this.fire_pos = 0.5;
        this.max_temp_graph = this.backgroundT;
        this.min_temp_graph = this.backgroundT;
        this.has_not_started = true;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    public void _initializeSolvers() {
        for (EJSODE eJSODE : this._privateOdesList.values()) {
            eJSODE.initializeSolver();
        }
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        if (this.__shouldBreak) {
            return;
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
        this._ODEi_evolution1.automaticResetSolver();
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_evolution1) {
            this._ODEi_evolution1.step();
        }
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _freeMemory() {
        this.getSimulation().setEnded();
        this.object = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    public EJSODE _getODE(String string) {
        try {
            return this._privateOdesList.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ODEInterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    public String _setSolverClass(String string, String string2) {
        if (string2 == null) {
            System.err.println("Null solver class name!");
            return null;
        }
        try {
            return this._privateOdesList.get(string).setSolverClass(string2);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
            return null;
        }
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Object Values".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Thermal Energy ODE".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._automaticResetSolvers();
        }
        if ("Event 2".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1_Event1 = bl;
            this._ODEi_evolution1.initializeSolver();
        }
        if ("Messages".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this._view.temperaturePlottingPanel.setAntialiasTextOn(true);
        this._view.temperaturePlottingPanel.setAntialiasShapeOn(true);
        this.set_random_heat_capacity();
        for (int i = 0; i < this.N; ++i) {
            this.object[i][this.obj_mass] = this.mass;
            this.object[i][this.surface_area] = this.area / 100.0 / 100.0;
            this.object[i][this.heat_coeff] = this.h;
            this.cal_heat_rate(i);
        }
        this.mass_1 = this.object[this.obj_1][this.obj_mass];
        this.mass_2 = this.object[this.obj_2][this.obj_mass];
        this.mass_3 = this.object[this.obj_3][this.obj_mass];
        this.options = "Slow Heating ;Fast Heating ;Super Fast Heating";
        this.temp_range();
        this.temperature_unit = "\u00b0C";
        this.area_unit = "cm^2";
    }

    public void _constraints1() {
        if (this._isPlaying()) {
            this.has_not_started = false;
        }
        this.TMsg = "T = " + this._view.format(this.T, "0.0");
        this.ToMsg = "To = " + this._view.format(this.backgroundT, "0.0");
        if (this.t > 450.0 - this.dt) {
            this._pause();
        }
    }

    public void changeTimeStep() {
        if (this.dtStr.equals("1hr")) {
            this.dt = 3600.0;
        } else if (this.dtStr.equals("10min")) {
            this.dt = 600.0;
        } else if (this.dtStr.equals("1min")) {
            this.dt = 60.0;
        } else if (this.dtStr.equals("10s")) {
            this.dt = 10.0;
        } else if (this.dtStr.equals("1s")) {
            this.dt = 1.0;
        }
        this.resetTime();
    }

    public void changeMaterial() {
        if (this.materialStr.equals("Cu")) {
            this.C = 385.0;
            this.rho = 8933.0;
        } else if (this.materialStr.equals("Al")) {
            this.C = 903.0;
            this.rho = 2702.0;
        } else if (this.materialStr.equals("Fe")) {
            this.C = 447.0;
            this.rho = 7870.0;
        }
        this.A = 6.0 * Math.pow(this.mass / this.rho, 0.6666666666666666);
        this.vol = this.mass / this.rho;
        this.volCmCubed = this.vol * 1000000.0;
        this.kappa = this.h * this.A / this.mass / this.C;
        this.resetTime();
    }

    public void resetTime() {
        this.t = 0.0;
        this.T = this.Ti;
        this._view.dataTable.clearData();
    }

    public void cal_heat_rate(int n) {
        this.object[n][this.heat_rate] = this.object[n][this.heat_coeff] * this.object[n][this.surface_area] / this.object[n][this.obj_mass] / this.object[n][this.heat_capacity];
        this.cleardata();
    }

    public double cal_temp(int n, double d) {
        double d2 = -this.object[n][this.heat_rate] * (d - this.backgroundT);
        if (this.heatingOn) {
            d2 = this.heating / this.object[n][this.heat_capacity] / this.object[n][this.obj_mass];
        }
        return d2;
    }

    public double check_temperature(double d) {
        if (d > this.max_temp) {
            d = this.max_temp;
        }
        if (d < this.min_temp) {
            d = this.min_temp;
        }
        return d;
    }

    public double check_mass(double d) {
        if (d > this.max_mass) {
            d = this.max_mass;
        }
        if (d < this.min_mass) {
            d = this.min_mass;
        }
        return d;
    }

    public double check_area(double d) {
        if (d > this.max_area) {
            d = this.max_area;
        }
        if (d < this.min_area) {
            d = this.min_area;
        }
        return d;
    }

    public double max_temp_obj() {
        double d = Math.max(this.initial_temp_1, this.initial_temp_2);
        d = Math.max(d, this.initial_temp_3);
        return d;
    }

    public double min_temp_obj() {
        double d = Math.min(this.initial_temp_1, this.initial_temp_2);
        d = Math.min(d, this.initial_temp_3);
        return d;
    }

    public void temp_range() {
        if (this.heatingOn) {
            this.max_temp_heat_on();
            this.min_temp_graph = this.min_temp_obj() - 5.0;
        } else {
            this.max_temp_graph = Math.max(this.max_temp_obj(), this.backgroundT) + 5.0;
            this.min_temp_graph = Math.min(this.min_temp_obj(), this.backgroundT) - 5.0;
        }
    }

    public void cleardata() {
        this._view.dataTable.clearData();
        this._view.clearData();
        this.temp_1 = this.initial_temp_1;
        this.temp_2 = this.initial_temp_2;
        this.temp_3 = this.initial_temp_3;
        this.has_not_started = true;
        this.temp_range();
        this.counter = 50;
        this.t = 0.0;
    }

    public void set_random_heat_capacity() {
        int n;
        this.best_heat = 0;
        if (this.differentMaterial) {
            for (n = 0; n < this.N; ++n) {
                this.object[n][this.heat_capacity] = this.BEST + (double)this.random_number.nextInt(this.RANGE);
            }
            n = this.random_number.nextInt(3);
            this.object[n][this.heat_capacity] = this.GOOD + (double)this.random_number.nextInt(this.RANGE);
            int n2 = this.random_number.nextInt(3);
            if (n2 == n) {
                n2 = n2 != this.N ? ++n2 : --n2;
            }
            this.object[n2][this.heat_capacity] = this.WORST + (double)this.random_number.nextInt(this.RANGE);
        } else {
            double d = 250 + this.random_number.nextInt(50);
            for (n = 0; n < this.N; ++n) {
                this.object[n][this.heat_capacity] = d;
            }
        }
        for (n = 1; n < this.N; ++n) {
            if (!(this.object[n][this.heat_capacity] < this.object[this.best_heat][this.heat_capacity])) continue;
            this.best_heat = n;
        }
    }

    public boolean draw_graph() {
        if (this._isPlaying()) {
            return true;
        }
        return this.STEP;
    }

    public void service_opts() {
        if (this.which_opt.startsWith("Slow")) {
            this.heating = 5.0;
        }
        if (this.which_opt.startsWith("Fast")) {
            this.heating = 15.0;
        }
        if (this.which_opt.startsWith("Super Fast")) {
            this.heating = 25.0;
        }
        this.max_temp_heat_on();
    }

    public void max_temp_heat_on() {
        this.max_temp_graph = this.temp_1 + this.heating / this.object[0][this.heat_capacity] / this.object[0][this.obj_mass] * 450.0;
        double d = this.temp_2 + this.heating / this.object[1][this.heat_capacity] / this.object[1][this.obj_mass] * 450.0;
        if (this.max_temp_graph < d) {
            this.max_temp_graph = d;
        }
        if (this.max_temp_graph < (d = this.temp_3 + this.heating / this.object[2][this.heat_capacity] / this.object[2][this.obj_mass] * 450.0)) {
            this.max_temp_graph = d;
        }
        this.max_temp_graph += 5.0;
    }

    public boolean _method_for_twoStateButton_enabled() {
        return this._isPaused();
    }

    public void _method_for_twoStateButton_actionOn() {
        this.heatingOn = false;
        this.cleardata();
    }

    public void _method_for_twoStateButton_actionOff() {
        this.heatingOn = true;
        this.cleardata();
    }

    public void _method_for_comboBox_action() {
        this.service_opts();
        this.cleardata();
    }

    public boolean _method_for_backgroundTPanel_visible() {
        return !this.heatingOn;
    }

    public void _method_for_bTField_action() {
        this.backgroundT = Math.min(40.0, this.backgroundT);
        this.backgroundT = Math.max(10.0, this.backgroundT);
        this.cleardata();
    }

    public void _method_for_DifferentMaterial_actionOn() {
        this.differentMaterial = false;
        this.set_random_heat_capacity();
        for (int i = 0; i < this.N; ++i) {
            this.cal_heat_rate(i);
        }
    }

    public void _method_for_DifferentMaterial_actionOff() {
        this.differentMaterial = true;
        this.set_random_heat_capacity();
        for (int i = 0; i < this.N; ++i) {
            this.cal_heat_rate(i);
        }
    }

    public void _method_for_startStopButton_actionOn() {
        this._play();
        this.STEP = false;
    }

    public void _method_for_startStopButton_actionOff() {
        this._pause();
        this.STEP = false;
    }

    public void _method_for_resetButton_action() {
        this.cleardata();
    }

    public void _method_for_Temp1Field_action() {
        this.temp_1 = this.initial_temp_1 = this.check_temperature(this.initial_temp_1);
        this.cleardata();
    }

    public void _method_for_mass1Field_action() {
        this.object[this.obj_1][this.obj_mass] = this.mass_1 = this.check_mass(this.mass_1);
        this.cal_heat_rate(this.obj_1);
    }

    public void _method_for_surface_areaField_action() {
        this.area_1 = this.check_area(this.area_1);
        this.object[this.obj_1][this.surface_area] = this.area_1 / 100.0 / 100.0;
        this.cal_heat_rate(this.obj_1);
    }

    public String _method_for_TMsg_text() {
        return this._format(this.temp_1, "0.00") + this.temperature_unit;
    }

    public void _method_for_Temp2Field_action() {
        this.temp_2 = this.initial_temp_2 = this.check_temperature(this.initial_temp_2);
        this.cleardata();
    }

    public void _method_for_mass2Field_action() {
        this.object[this.obj_2][this.obj_mass] = this.mass_2 = this.check_mass(this.mass_2);
        this.cal_heat_rate(this.obj_2);
        this.temp_range();
    }

    public void _method_for_surface_area2Field_action() {
        this.area_2 = this.check_area(this.area_2);
        this.object[this.obj_2][this.surface_area] = this.area_2 / 100.0 / 100.0;
        this.cal_heat_rate(this.obj_2);
    }

    public String _method_for_TMsg2_text() {
        return this._format(this.temp_2, "0.00") + this.temperature_unit;
    }

    public void _method_for_Temp3Field_action() {
        this.temp_3 = this.initial_temp_3 = this.check_temperature(this.initial_temp_3);
        this.cleardata();
    }

    public void _method_for_mass3Field_action() {
        this.object[this.obj_3][this.obj_mass] = this.mass_3 = this.check_mass(this.mass_3);
        this.cal_heat_rate(this.obj_3);
        this.temp_range();
    }

    public void _method_for_surface_area3Field_action() {
        this.area_3 = this.check_area(this.area_3);
        this.object[this.obj_3][this.surface_area] = this.area_3 / 100.0 / 100.0;
        this.cal_heat_rate(this.obj_3);
    }

    public String _method_for_Obj3WorldView_BRmessage() {
        return String.format("%3.0f s", this.t);
    }

    public String _method_for_TMsg3_text() {
        return this._format(this.temp_3, "0.00") + this.temperature_unit;
    }

    public double[] _method_for_dataTable_input() {
        return new double[]{this.t, this.temp_1, this.temp_2, this.temp_3};
    }

    public boolean _method_for_dataTable_active() {
        return this._isPaused();
    }

    public double _method_for_object1_x() {
        return this.t - 0.5;
    }

    public boolean _method_for_object1_visible() {
        return this._isPaused();
    }

    public boolean _method_for_TemperatureMarker1_active() {
        return this._isPaused();
    }

    public double _method_for_object2_x() {
        return this.t - 0.5;
    }

    public boolean _method_for_object2_visible() {
        return this._isPaused();
    }

    public boolean _method_for_TemperatureMarker2_active() {
        return this._isPaused();
    }

    public double _method_for_object3_x() {
        return this.t - 0.5;
    }

    public boolean _method_for_object3_visible() {
        return this._isPaused();
    }

    public boolean _method_for_TemperatureMarker3_active() {
        return this._isPaused();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
        __translatorUtil = new TranslatorUtil();
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _ODE_evolution1
    implements EJSODE {
        private ODESolverInterpolator __solver = null;
        private ODEInterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = CashKarp45.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustInitialize = true;
        private boolean __isEnabled = true;
        private boolean __mustUserReinitialize = false;
        private boolean __mustReinitialize = true;

        _ODE_evolution1() {
            this.__instantiateSolver();
            CoolingPrimaryv5.this._privateOdesList.put("Thermal Energy ODE", this);
        }

        @Override
        public ODEInterpolatorEventSolver getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        @Override
        public String setSolverClass(String string) {
            String string2 = "org.opensourcephysics.numerics.";
            if ((string = string.trim().toLowerCase()).indexOf("euler") >= 0) {
                string = string.indexOf("rich") >= 0 ? string2 + "rk.EulerRichardson" : string2 + "rk.Euler";
            } else if (string.indexOf("verlet") >= 0) {
                string = string2 + "symplectic.VelocityVerlet";
            } else if (string.indexOf("runge") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("rk4") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("boga") >= 0) {
                string = string2 + "rk.BogackiShampine23";
            } else if (string.indexOf("cash") >= 0) {
                string = string2 + "rk.CashKarp45";
            } else if (string.indexOf("fehl") >= 0) {
                string = string.indexOf("7") >= 0 ? string2 + "rk.Fehlberg78" : string2 + "rk.Fehlberg8";
            } else if (string.indexOf("dorm") >= 0 || string.indexOf("dopri") >= 0) {
                string = string.indexOf("8") >= 0 ? string2 + "rk.Dopri853" : string2 + "rk.Dopri5";
            } else if (string.indexOf("radau") >= 0) {
                string = string2 + "rk.Radau5";
            } else if (string.indexOf("qss") >= 0) {
                string = string2 + "qss.Qss3";
            } else {
                System.err.println("There is no solver with this name " + string);
                return null;
            }
            try {
                this.setSolverClass(Class.forName(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        private void __instantiateSolver() {
            this.__state = new double[4];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{ODE.class};
                Object[] objectArray = new Object[]{this};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (ODESolverInterpolator)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new ODEInterpolatorEventSolver(this.__solver);
            this.__mustInitialize = true;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.__isEnabled = bl;
        }

        @Override
        public double getIndependentVariableValue() {
            return this.__eventSolver.getIndependentVariableValue();
        }

        @Override
        public double getInternalStepSize() {
            return this.__eventSolver.getSolver().getInternalStepSize();
        }

        @Override
        public boolean isAccelerationIndependentOfVelocity() {
            return false;
        }

        @Override
        public void initializeSolver() {
            this.__pushState();
            this.__eventSolver.removeAllEvents();
            this.__eventSolver.initialize(CoolingPrimaryv5.this.dt);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            if (CoolingPrimaryv5.this._isEnabled_evolution1_Event1 && CoolingPrimaryv5.this._isEnabled_evolution1) {
                this.__eventSolver.addEvent(new _ODE_evolution1_Event1());
            }
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__eventSolver.setTolerances(CoolingPrimaryv5.this.tol, CoolingPrimaryv5.this.tol);
            this.__mustReinitialize = true;
            this.__mustInitialize = false;
        }

        private void __pushState() {
            int n = 0;
            if (this.__state[n] != CoolingPrimaryv5.this.temp_1) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = CoolingPrimaryv5.this.temp_1;
            if (this.__state[n] != CoolingPrimaryv5.this.temp_2) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = CoolingPrimaryv5.this.temp_2;
            if (this.__state[n] != CoolingPrimaryv5.this.temp_3) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = CoolingPrimaryv5.this.temp_3;
            if (this.__state[n] != CoolingPrimaryv5.this.t) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = CoolingPrimaryv5.this.t;
        }

        public void resetSolver() {
            this.__mustUserReinitialize = true;
        }

        public void automaticResetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            int n = JOptionPane.showConfirmDialog(CoolingPrimaryv5.this._view.getComponent(CoolingPrimaryv5.this._simulation.getMainWindow()), Simulation.getEjsString("ODEError.Continue"), Simulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                CoolingPrimaryv5.this._pause();
            }
            this.__mustReinitialize = true;
        }

        @Override
        public double step() {
            return this.__privateStep(false);
        }

        @Override
        public double solverStep() {
            return this.__privateStep(true);
        }

        private double __privateStep(boolean bl) {
            if (!this.__isEnabled) {
                return 0.0;
            }
            if (CoolingPrimaryv5.this.dt == 0.0) {
                return 0.0;
            }
            if (this.__mustInitialize) {
                this.initializeSolver();
            }
            this.__eventSolver.setStepSize(CoolingPrimaryv5.this.dt);
            this.__eventSolver.setInternalStepSize(CoolingPrimaryv5.this.dt);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setTolerances(CoolingPrimaryv5.this.tol, CoolingPrimaryv5.this.tol);
            this.__pushState();
            if (this.__mustUserReinitialize) {
                this.__eventSolver.userReinitialize();
                this.__mustUserReinitialize = false;
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != 0) {
                    this.__errorAction();
                }
            } else if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != 0) {
                    this.__errorAction();
                }
            }
            double d = bl ? this.__eventSolver.maxStep() : this.__eventSolver.step();
            int n = 0;
            CoolingPrimaryv5.this.temp_1 = this.__state[n++];
            CoolingPrimaryv5.this.temp_2 = this.__state[n++];
            CoolingPrimaryv5.this.temp_3 = this.__state[n++];
            CoolingPrimaryv5.this.t = this.__state[n++];
            if (this.__eventSolver.getErrorCode() != 0) {
                this.__errorAction();
            }
            return d;
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            dArray2[dArray2.length - 1] = 0.0;
            int n = -1;
            int n2 = 0;
            double d = dArray[n2++];
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            double d4 = dArray[n2++];
            int n3 = 0;
            dArray2[n3++] = CoolingPrimaryv5.this.cal_temp(CoolingPrimaryv5.this.obj_1, d);
            dArray2[n3++] = CoolingPrimaryv5.this.cal_temp(CoolingPrimaryv5.this.obj_2, d2);
            dArray2[n3++] = CoolingPrimaryv5.this.cal_temp(CoolingPrimaryv5.this.obj_3, d3);
            dArray2[n3++] = 1.0;
        }

        private class _ODE_evolution1_Event1
        implements GeneralStateEvent {
            private _ODE_evolution1_Event1() {
            }

            public int getTypeOfEvent() {
                return 2;
            }

            public int getRootFindingMethod() {
                return 0;
            }

            public int getMaxIterations() {
                return 100;
            }

            public String toString() {
                return "Event 2";
            }

            public double getTolerance() {
                return 1.0E-5;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                double d = dArray[n++];
                double d2 = dArray[n++];
                double d3 = dArray[n++];
                double d4 = dArray[n++];
                return (double)CoolingPrimaryv5.this.counter - d4;
            }

            public boolean action() {
                int n = 0;
                CoolingPrimaryv5.this.temp_1 = _ODE_evolution1.this.__state[n++];
                CoolingPrimaryv5.this.temp_2 = _ODE_evolution1.this.__state[n++];
                CoolingPrimaryv5.this.temp_3 = _ODE_evolution1.this.__state[n++];
                CoolingPrimaryv5.this.t = _ODE_evolution1.this.__state[n++];
                boolean bl = this.userDefinedAction();
                int n2 = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = CoolingPrimaryv5.this.temp_1;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = CoolingPrimaryv5.this.temp_2;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = CoolingPrimaryv5.this.temp_3;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = CoolingPrimaryv5.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                CoolingPrimaryv5.this.counter += 50;
                CoolingPrimaryv5.this._pause();
                return true;
            }
        }
    }
}

