/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.opensourcephysics.analysis.FourierSinCosAnalysis;
import org.opensourcephysics.display.ColorIcon;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FourierPanel
extends JPanel {
    protected Dataset sourceData;
    protected PlottingPanel plot;
    protected DataTable table;
    protected DatasetManager fourierManager;
    protected JSplitPane splitPane;
    protected JCheckBox[] buttons;
    protected JPanel plotPanel;

    public FourierPanel() {
        super(new BorderLayout());
        this.createGUI();
    }

    protected void createGUI() {
        this.fourierManager = new DatasetManager();
        this.fourierManager.setXPointsLinked(true);
        this.table = new DataTable();
        this.table.add(this.fourierManager);
        this.plot = new PlottingPanel("", "", "");
        this.plotPanel = new JPanel(new BorderLayout());
        this.plotPanel.add((Component)this.plot, "Center");
        this.splitPane = new JSplitPane(1);
        this.splitPane.setResizeWeight(1.0);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.splitPane.setRightComponent(jScrollPane);
        this.splitPane.setLeftComponent(this.plotPanel);
        this.add((Component)this.splitPane, "Center");
    }

    protected void refreshFourierData(Dataset dataset, String string) {
        JDialog jDialog = (JDialog)this.getTopLevelAncestor();
        jDialog.setTitle(ToolsRes.getString("DataToolTab.Dialog.Fourier.Title"));
        this.fourierManager.removeDatasets();
        Data data = FourierPanel.createFourierData(dataset);
        if (data == null) {
            return;
        }
        ArrayList<Dataset> arrayList = data.getDatasets();
        this.createButtons(arrayList);
        for (Dataset object2 : arrayList) {
            this.fourierManager.addDataset(object2);
        }
        this.table.refreshTable();
        string = TeXParser.removeSubscripting(string);
        String string2 = TeXParser.removeSubscripting(dataset.getXColumnName());
        String string22 = TeXParser.removeSubscripting(dataset.getYColumnName());
        this.plot.setTitle(String.valueOf(string) + " [" + string2 + ", " + (String)string22 + "]");
        this.refreshPlot();
    }

    protected void refreshPlot() {
        this.plot.removeDrawables(Dataset.class);
        String string = "";
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttons[n].isSelected()) {
                Dataset dataset = this.fourierManager.getDataset(n);
                this.plot.addDrawable(dataset);
                this.plot.setXLabel(dataset.getXColumnName());
                if (string.length() > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + dataset.getYColumnName();
            }
            ++n;
        }
        this.plot.setYLabel(string);
        this.plot.repaint();
    }

    protected void createButtons(ArrayList<Dataset> arrayList) {
        if (this.buttons == null) {
            this.buttons = new JCheckBox[arrayList.size()];
            JPanel jPanel = new JPanel();
            this.plotPanel.add((Component)jPanel, "South");
            int n = 0;
            while (n < this.buttons.length) {
                Dataset dataset = arrayList.get(n);
                this.buttons[n] = new PlotCheckBox(dataset.getYColumnName(), dataset.getFillColor());
                jPanel.add(this.buttons[n]);
                ++n;
            }
            this.buttons[0].setSelected(true);
        }
    }

    public static Data createFourierData(Dataset dataset) {
        Object object;
        if (dataset == null) {
            return null;
        }
        Object object2 = dataset.getXPoints();
        double[] dArray = dataset.getYPoints();
        if (dArray.length < 2) {
            return null;
        }
        if (dArray.length % 2 == 1) {
            object = new double[dArray.length - 1];
            double[] dArray2 = new double[((Object)object).length];
            System.arraycopy(object2, 0, object, 0, ((Object)object).length);
            System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
            dataset.clear();
            dataset.append((double[])object, dArray2);
            object2 = object;
            dArray = dArray2;
        }
        object = new FourierSinCosAnalysis();
        ((FourierSinCosAnalysis)object).doAnalysis((double[])object2, dArray, 0);
        return object;
    }

    class PlotCheckBox
    extends JCheckBox {
        ColorIcon icon;
        Color outlineColor;
        Color fillColor;

        PlotCheckBox(String string, Color color) {
            super(string);
            this.fillColor = Color.WHITE;
            this.outlineColor = color;
            this.icon = new ColorIcon(this.fillColor, this.outlineColor, 13, 13);
            this.setIcon(this.icon);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    PlotCheckBox.this.setSelected(jCheckBox.isSelected());
                    FourierPanel.this.refreshPlot();
                }
            });
        }

        public void setSelected(boolean bl) {
            this.icon.setColor(bl ? this.outlineColor : this.fillColor);
            super.setSelected(bl);
        }
    }
}

