/*
 * Decompiled with CFR 0.152.
 */
package users.uned.hvargas.virtHeatflowUNED_pkg;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.collaborative.AbstractModelCollaborative;
import org.colos.ejs.library.collaborative.SimulationCollaborative;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorResourceUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ode_solvers.EjsS_ODE;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngine;
import org.opensourcephysics.numerics.ode_solvers.rk.RK4;
import org.opensourcephysics.numerics.ode_solvers.symplectic.VelocityVerletSavvy;
import org.opensourcephysics.tools.ResourceLoader;
import users.uned.hvargas.virtHeatflowUNED_pkg.virtHeatflowUNEDSimulation;
import users.uned.hvargas.virtHeatflowUNED_pkg.virtHeatflowUNEDView;

public class virtHeatflowUNED
extends AbstractModelCollaborative {
    public virtHeatflowUNEDSimulation _simulation = null;
    public virtHeatflowUNEDView _view = null;
    public virtHeatflowUNED _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    protected Hashtable<String, EjsS_ODE> _privateOdesList = new Hashtable();
    public double t = 0.0;
    public double t_ejs = 0.0;
    public double tant = 0.0;
    public double dt = 0.5;
    public int fps = 25;
    public int opSensor = 1;
    public boolean cSensor1 = true;
    public boolean cSensor2 = false;
    public boolean cSensor3 = false;
    public boolean sp1Visible = false;
    public boolean sp2Visible = false;
    public boolean sp3Visible = false;
    public double maxTemp = 80.0;
    public double minTemp = 25.0;
    public int lengthCubeUp = 54;
    public int widthCubeUp = 10;
    public int highCubeUp = 8;
    public int lengthCubeDown = this.lengthCubeUp;
    public int widthCubeDown = this.widthCubeUp;
    public int highCubeDown = 7;
    public int ticks = 10;
    public int npoints = 700;
    public boolean connectedPoints = true;
    public boolean noRepeat = true;
    public int marker = 0;
    public int markersize = 1;
    public Object sb = null;
    public Object sbuilder = null;
    public Object sbuilderSave = null;
    public Object df = null;
    public Object simbolos = null;
    public double K1 = 26.9248;
    public double Tp11 = 38.7412;
    public double Tp12 = 3.7423;
    public double Tz1 = 18.3454;
    public double Tr1 = 0.0;
    public double K2 = 22.37;
    public double Tp21 = 50.4604;
    public double Tp22 = 4.0143;
    public double Tz2 = 22.4213;
    public double Tr2 = 0.0;
    public double K3 = 22.0059;
    public double Tp31 = 56.4467;
    public double Tp32 = 4.2866;
    public double Tz3 = 26.7033;
    public double Tr3 = 0.0;
    public double a11 = (this.Tp11 + this.Tp12) / (this.Tp11 * this.Tp12);
    public double a21 = 1.0 / (this.Tp11 * this.Tp12);
    public double b11 = this.K1 * this.Tz1 / (this.Tp11 * this.Tp12);
    public double b21 = this.K1 / (this.Tp11 * this.Tp12);
    public double Beta21 = this.b21 - this.a11 * this.b11;
    public double a12 = (this.Tp21 + this.Tp22) / (this.Tp21 * this.Tp22);
    public double a22 = 1.0 / (this.Tp21 * this.Tp22);
    public double b12 = this.K2 * this.Tz2 / (this.Tp21 * this.Tp22);
    public double b22 = this.K2 / (this.Tp21 * this.Tp22);
    public double Beta22 = this.b22 - this.a12 * this.b12;
    public double a13 = (this.Tp31 + this.Tp32) / (this.Tp31 * this.Tp32);
    public double a23 = 1.0 / (this.Tp31 * this.Tp32);
    public double b13 = this.K3 * this.Tz3 / (this.Tp31 * this.Tp32);
    public double b23 = this.K3 / (this.Tp31 * this.Tp32);
    public double Beta23 = this.b23 - this.a13 * this.b13;
    public double T1 = 43.3616;
    public double T2 = 37.5369;
    public double T3 = 36.2715;
    public double Vh = 3.0;
    public double linear_T1 = this.T1;
    public double linear_T2 = this.T2;
    public double linear_T3 = this.T3;
    public double linear_Vh = this.Vh;
    public double aux_T1 = 0.0;
    public double aux_T2 = 0.0;
    public double aux_T3 = 0.0;
    public double Vfmax = 5.0;
    public double Vfmin = 3.0;
    public double Vfslider = 3.0;
    public double Vf = 3.0;
    public double[] T;
    public double stationary_T1 = this.T1;
    public double stationary_T2 = this.T2;
    public double stationary_T3 = this.T3;
    public double stationary_Vh = this.Vh;
    public boolean manualMode = true;
    public double setPoint1 = this.T1;
    public double setPoint2 = this.T2;
    public double setPoint3 = this.T3;
    public double setPoint = this.T1;
    public double Kc1 = 0.1;
    public double Ti1 = 2.0;
    public double Td1 = 0.0;
    public double Kc2 = 0.1;
    public double Ti2 = 2.0;
    public double Td2 = 0.0;
    public double Kc3 = 0.1;
    public double Ti3 = 2.0;
    public double Td3 = 0.0;
    public double K = 0.1;
    public double Ti = 2.0;
    public double Td = 0.0;
    public double vmin1 = 0.0;
    public double vmax1 = 5.0;
    public double vmin2 = 0.0;
    public double vmax2 = 5.0;
    public double vmin3 = 0.0;
    public double vmax3 = 5.0;
    public int pidVariables = 11;
    public double[] pidControl1;
    public double[] pidControl2;
    public double[] pidControl3;
    public double manualVh = this.Vh;
    public double manualVhslider = this.Vh;
    public double T1view = this.T1;
    public double T2view = this.T2;
    public double T3view = this.T3;
    public double Vhview = this.Vh;
    public int colors = 40;
    public double[] levels;
    public Object[] levelColors;
    public double deltaColor = 255.0 / (this.maxTemp - this.minTemp);
    public double deltaColorHeat = 255.0 / (this.vmax1 - this.vmin1);
    public int red;
    public int _red;
    public Object colorHeater = null;
    public double[] ox;
    public Object[] colorTemp;
    public double[][] poscolors;
    public double _t = 0.0;
    public double _dt = this.Vf / (2.0 * this.Vfmax);
    public double[] axis1;
    public double[] axis2;
    public double[] axis3;
    public double[] axis4;
    public double cx = 1.0;
    public double cy = this.widthCubeDown / 2;
    public double cz = this.highCubeDown + this.highCubeUp / 2;
    public double highBlower = 3.0;
    public double ratioBlowerA = 2.0;
    public double ratioBlowerB = 2.0;
    public double highBlowerInt = 1.0;
    public double ratioBlowerIntA = 1.0;
    public double ratioBlowerIntB = 1.0;
    public double posBlowerIntX = 0.0;
    public double movCX1 = this.cx;
    public double movCY1 = this.highBlower * Math.sin(1.5707963267948966 * this._t) + this.cy;
    public double movCZ1 = this.highBlower * Math.cos(1.5707963267948966 * this._t) + this.cz;
    public double movCX2 = this.cx;
    public double movCY2 = this.highBlower * Math.sin(1.5707963267948966 * (this._t + 45.0)) + this.cy;
    public double movCZ2 = this.highBlower * Math.cos(1.5707963267948966 * (this._t + 45.0)) + this.cz;
    public double movCX3 = this.cx;
    public double movCY3 = this.highBlower * Math.sin(1.5707963267948966 * (this._t + 90.0)) + this.cy;
    public double movCZ3 = this.highBlower * Math.cos(1.5707963267948966 * (this._t + 90.0)) + this.cz;
    public double movCX4 = this.cx;
    public double movCY4 = this.highBlower * Math.sin(1.5707963267948966 * (this._t + 135.0)) + this.cy;
    public double movCZ4 = this.highBlower * Math.cos(1.5707963267948966 * (this._t + 135.0)) + this.cz;
    public double angles1 = 0.0;
    public double angles2 = 0.0;
    public double angles3 = 0.0;
    public double angles4 = 0.0;
    public double ratioHeaterA = 6.0;
    public double ratioHeaterB = 6.0;
    public double highHeater = 0.8;
    public double posHeaterX = 4.5;
    public String setpointTLabel = "Setpoint S1 [\u00baC] =";
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_initialization2 = true;
    private boolean _isEnabled_initialization3 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_evolution2 = true;
    private boolean _isEnabled_evolution3 = true;
    private boolean _isEnabled_evolution4 = true;
    private _ODE_evolution3 _ODEi_evolution3;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return virtHeatflowUNED._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/users/uned/hvargas/virtHeatflowUNED.ejs";
    }

    public static String _getModelDirectory() {
        return "users/uned/hvargas/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(751, 544);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/uned/hvargas/Heatflow_Intro.html");
        hashSet.add("/users/uned/hvargas/_library/flag_en.png");
        hashSet.add("/users/uned/hvargas/_library/Tune_Icon2.gif");
        hashSet.add("/users/uned/hvargas/_library/PlottingPanel.gif");
        hashSet.add("/users/uned/hvargas/_library/flag_es.png");
        hashSet.add("/users/uned/hvargas/_library/heatflow_logo.png");
        hashSet.add("/users/uned/hvargas/_library/graspingHand.gif");
        hashSet.add("/users/uned/hvargas/_library/saveSmall.gif");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/uned/hvargas/");
        n = 0;
        boolean bl2 = false;
        try {
            if ("true".equals(System.getProperty("org.osp.launcher"))) {
                OSPRuntime.setLauncherMode(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("/Users/andreuglasmann/Documents/Davidson College/Work Study/Fall 2013/EJS_5.0 beta/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("/Users/andreuglasmann/Documents/Davidson College/Work Study/Fall 2013/EJS_5.0 beta/bin/config/");
        }
        virtHeatflowUNED._addHtmlPageInfo("Intro Page", "_default_", "Intro Page", "/users/uned/hvargas/Heatflow_Intro.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!virtHeatflowUNED._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        virtHeatflowUNED virtHeatflowUNED2 = new virtHeatflowUNED(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!virtHeatflowUNED._common_initialization(stringArray)) {
            return null;
        }
        virtHeatflowUNED virtHeatflowUNED2 = new virtHeatflowUNED("MainFrame", jFrame, null, null, stringArray, true);
        return (JComponent)virtHeatflowUNED2._getView().getComponent("MainFrame");
    }

    public virtHeatflowUNED() {
        this(null, null, null, null, null, false);
    }

    public virtHeatflowUNED(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public virtHeatflowUNED(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        ControlWindow.setKeepHidden(true);
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new virtHeatflowUNEDSimulation(this, string, frame, uRL, bl);
        this._simulation.processArguments(stringArray);
        ControlWindow.setKeepHidden(false);
    }

    @Override
    public String _getClassEjsModel() {
        return virtHeatflowUNED._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return virtHeatflowUNED._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return virtHeatflowUNED._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public SimulationCollaborative getSimulationCollaborative() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_initialization2 = true;
        this._isEnabled_initialization3 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_evolution2 = true;
        this._isEnabled_evolution3 = true;
        this._isEnabled_evolution4 = true;
        this.t = 0.0;
        this.t_ejs = 0.0;
        this.tant = 0.0;
        this.dt = 0.5;
        this.fps = 25;
        this.opSensor = 1;
        this.cSensor1 = true;
        this.cSensor2 = false;
        this.cSensor3 = false;
        this.sp1Visible = false;
        this.sp2Visible = false;
        this.sp3Visible = false;
        this.maxTemp = 80.0;
        this.minTemp = 25.0;
        this.lengthCubeUp = 54;
        this.widthCubeUp = 10;
        this.highCubeUp = 8;
        this.lengthCubeDown = this.lengthCubeUp;
        this.widthCubeDown = this.widthCubeUp;
        this.highCubeDown = 7;
        this.ticks = 10;
        this.npoints = 700;
        this.connectedPoints = true;
        this.noRepeat = true;
        this.marker = 0;
        this.markersize = 1;
        this.sb = null;
        this.sbuilder = null;
        this.sbuilderSave = null;
        this.df = null;
        this.simbolos = null;
        this.K1 = 26.9248;
        this.Tp11 = 38.7412;
        this.Tp12 = 3.7423;
        this.Tz1 = 18.3454;
        this.Tr1 = 0.0;
        this.K2 = 22.37;
        this.Tp21 = 50.4604;
        this.Tp22 = 4.0143;
        this.Tz2 = 22.4213;
        this.Tr2 = 0.0;
        this.K3 = 22.0059;
        this.Tp31 = 56.4467;
        this.Tp32 = 4.2866;
        this.Tz3 = 26.7033;
        this.Tr3 = 0.0;
        this.a11 = (this.Tp11 + this.Tp12) / (this.Tp11 * this.Tp12);
        this.a21 = 1.0 / (this.Tp11 * this.Tp12);
        this.b11 = this.K1 * this.Tz1 / (this.Tp11 * this.Tp12);
        this.b21 = this.K1 / (this.Tp11 * this.Tp12);
        this.Beta21 = this.b21 - this.a11 * this.b11;
        this.a12 = (this.Tp21 + this.Tp22) / (this.Tp21 * this.Tp22);
        this.a22 = 1.0 / (this.Tp21 * this.Tp22);
        this.b12 = this.K2 * this.Tz2 / (this.Tp21 * this.Tp22);
        this.b22 = this.K2 / (this.Tp21 * this.Tp22);
        this.Beta22 = this.b22 - this.a12 * this.b12;
        this.a13 = (this.Tp31 + this.Tp32) / (this.Tp31 * this.Tp32);
        this.a23 = 1.0 / (this.Tp31 * this.Tp32);
        this.b13 = this.K3 * this.Tz3 / (this.Tp31 * this.Tp32);
        this.b23 = this.K3 / (this.Tp31 * this.Tp32);
        this.Beta23 = this.b23 - this.a13 * this.b13;
        this.T1 = 43.3616;
        this.T2 = 37.5369;
        this.T3 = 36.2715;
        this.Vh = 3.0;
        this.linear_T1 = this.T1;
        this.linear_T2 = this.T2;
        this.linear_T3 = this.T3;
        this.linear_Vh = this.Vh;
        this.aux_T1 = 0.0;
        this.aux_T2 = 0.0;
        this.aux_T3 = 0.0;
        this.Vfmax = 5.0;
        this.Vfmin = 3.0;
        this.Vfslider = 3.0;
        this.Vf = 3.0;
        this.T = new double[this.colors];
        this.stationary_T1 = this.T1;
        this.stationary_T2 = this.T2;
        this.stationary_T3 = this.T3;
        this.stationary_Vh = this.Vh;
        this.manualMode = true;
        this.setPoint1 = this.T1;
        this.setPoint2 = this.T2;
        this.setPoint3 = this.T3;
        this.setPoint = this.T1;
        this.Kc1 = 0.1;
        this.Ti1 = 2.0;
        this.Td1 = 0.0;
        this.Kc2 = 0.1;
        this.Ti2 = 2.0;
        this.Td2 = 0.0;
        this.Kc3 = 0.1;
        this.Ti3 = 2.0;
        this.Td3 = 0.0;
        this.K = 0.1;
        this.Ti = 2.0;
        this.Td = 0.0;
        this.vmin1 = 0.0;
        this.vmax1 = 5.0;
        this.vmin2 = 0.0;
        this.vmax2 = 5.0;
        this.vmin3 = 0.0;
        this.vmax3 = 5.0;
        this.pidVariables = 11;
        this.pidControl1 = new double[this.pidVariables];
        this.pidControl2 = new double[this.pidVariables];
        this.pidControl3 = new double[this.pidVariables];
        this.manualVh = this.Vh;
        this.manualVhslider = this.Vh;
        this.T1view = this.T1;
        this.T2view = this.T2;
        this.T3view = this.T3;
        this.Vhview = this.Vh;
        this.colors = 40;
        this.levels = new double[this.colors - 1];
        for (int i = 0; i < this.colors - 1; ++i) {
            this.levels[i] = 0.0;
        }
        this.levelColors = new Object[this.colors];
        this.deltaColor = 255.0 / (this.maxTemp - this.minTemp);
        this.deltaColorHeat = 255.0 / (this.vmax1 - this.vmin1);
        this.ox = new double[]{-1.0, 0.0, 0.0};
        this.colorTemp = new Object[this.colors];
        this.poscolors = new double[this.colors][3];
        this._t = 0.0;
        this._dt = this.Vf / (2.0 * this.Vfmax);
        this.axis1 = new double[]{0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, -Math.sin(1.5707963267948966 * this._t), -Math.cos(1.5707963267948966 * this._t)};
        this.axis2 = new double[]{0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, -Math.sin(1.5707963267948966 * (this._t + 45.0)), -Math.cos(1.5707963267948966 * (this._t + 45.0))};
        this.axis3 = new double[]{0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, -Math.sin(1.5707963267948966 * (this._t + 90.0)), -Math.cos(1.5707963267948966 * (this._t + 90.0))};
        this.axis4 = new double[]{0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, -Math.sin(1.5707963267948966 * (this._t + 135.0)), -Math.cos(1.5707963267948966 * (this._t + 135.0))};
        this.cx = 1.0;
        this.cy = this.widthCubeDown / 2;
        this.cz = this.highCubeDown + this.highCubeUp / 2;
        this.highBlower = 3.0;
        this.ratioBlowerA = 2.0;
        this.ratioBlowerB = 2.0;
        this.highBlowerInt = 1.0;
        this.ratioBlowerIntA = 1.0;
        this.ratioBlowerIntB = 1.0;
        this.posBlowerIntX = 0.0;
        this.movCX1 = this.cx;
        this.movCY1 = this.highBlower * Math.sin(1.5707963267948966 * this._t) + this.cy;
        this.movCZ1 = this.highBlower * Math.cos(1.5707963267948966 * this._t) + this.cz;
        this.movCX2 = this.cx;
        this.movCY2 = this.highBlower * Math.sin(1.5707963267948966 * (this._t + 45.0)) + this.cy;
        this.movCZ2 = this.highBlower * Math.cos(1.5707963267948966 * (this._t + 45.0)) + this.cz;
        this.movCX3 = this.cx;
        this.movCY3 = this.highBlower * Math.sin(1.5707963267948966 * (this._t + 90.0)) + this.cy;
        this.movCZ3 = this.highBlower * Math.cos(1.5707963267948966 * (this._t + 90.0)) + this.cz;
        this.movCX4 = this.cx;
        this.movCY4 = this.highBlower * Math.sin(1.5707963267948966 * (this._t + 135.0)) + this.cy;
        this.movCZ4 = this.highBlower * Math.cos(1.5707963267948966 * (this._t + 135.0)) + this.cz;
        this.angles1 = 0.0;
        this.angles2 = 0.0;
        this.angles3 = 0.0;
        this.angles4 = 0.0;
        this.ratioHeaterA = 6.0;
        this.ratioHeaterB = 6.0;
        this.highHeater = 0.8;
        this.posHeaterX = 4.5;
        this.setpointTLabel = "Setpoint S1 [\u00baC] =";
        this._ODEi_evolution3 = new _ODE_evolution3();
    }

    public void _initializeSolvers() {
        for (EjsS_ODE ejsS_ODE : this._privateOdesList.values()) {
            ejsS_ODE.initializeSolver();
        }
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_initialization1;
        boolean bl2 = this._isEnabled_initialization2;
        boolean bl3 = this._isEnabled_initialization3;
        if (bl) {
            this._initialization1();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (bl2) {
            this._initialization2();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (bl3) {
            this._initialization3();
        }
        if (this.__shouldBreak) {
            return;
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
        this._ODEi_evolution3.automaticResetSolver();
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution3.resetSolver();
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_evolution1;
        boolean bl2 = this._isEnabled_evolution2;
        boolean bl3 = this._isEnabled_evolution3;
        boolean bl4 = this._isEnabled_evolution4;
        if (bl) {
            this._evolution1();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (bl2) {
            this._evolution2();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (bl3) {
            this._ODEi_evolution3.step();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (bl4) {
            this._evolution4();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
    }

    @Override
    public void _freeMemory() {
        this.getSimulation().setEnded();
        this.T = null;
        this.pidControl1 = null;
        this.pidControl2 = null;
        this.pidControl3 = null;
        this.levels = null;
        this.levelColors = null;
        this.ox = null;
        this.colorTemp = null;
        this.poscolors = null;
        this.axis1 = null;
        this.axis2 = null;
        this.axis3 = null;
        this.axis4 = null;
        this._ODEi_evolution3 = null;
        System.gc();
    }

    public EjsS_ODE _getODE(String string) {
        try {
            return this._privateOdesList.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    public String _setSolverClass(String string, String string2) {
        if (string2 == null) {
            System.err.println("Null solver class name!");
            return null;
        }
        try {
            return this._privateOdesList.get(string).setSolverClass(string2);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
            return null;
        }
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("InitControl".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("InitRegister".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization2 = bl;
        }
        if ("InitView".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization3 = bl;
        }
        if ("Control".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
        }
        if ("PreLinear".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution2 = bl;
        }
        if ("Linear2doOrder".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution3 = bl;
            this._automaticResetSolvers();
        }
        if ("PostLinear".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution4 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.setControl(1);
        this.setControl(2);
        this.setControl(3);
        this._setFPS(this.fps);
    }

    public void _initialization2() {
        this.sb = new StringBuffer();
        this.sbuilder = new StringBuilder();
        this.sbuilderSave = new StringBuilder();
        this.simbolos = new DecimalFormatSymbols();
        ((DecimalFormatSymbols)this.simbolos).setDecimalSeparator('.');
        this.df = new DecimalFormat("0.00", (DecimalFormatSymbols)this.simbolos);
    }

    public void _initialization3() {
        int n;
        for (n = 1; n < this.colors; ++n) {
            this.levels[n - 1] = 6 + this.lengthCubeUp * n / this.colors;
        }
        this.colored();
        for (n = 0; n < this.colors; ++n) {
            this.poscolors[n][0] = this.lengthCubeUp * n / this.colors;
            this.poscolors[n][1] = (double)this.widthCubeUp / 2.0;
            this.poscolors[n][2] = (double)this.highCubeDown + (double)this.highCubeUp / 2.0;
        }
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Container container = this._view.getContainer("MainFrame");
        SwingUtilities.updateComponentTreeUI(container);
    }

    public void _evolution1() {
        this.t = this.t_ejs;
        if (!this.manualMode) {
            switch (this.opSensor) {
                case 1: {
                    this.linear_Vh = this.controlSignal(this.pidControl1, this.linear_T1, this.setPoint1);
                    this.setPoint2 = this.linear_T2;
                    this.setPoint3 = this.linear_T3;
                    break;
                }
                case 2: {
                    this.linear_Vh = this.controlSignal(this.pidControl2, this.linear_T2, this.setPoint2);
                    this.setPoint1 = this.linear_T1;
                    this.setPoint3 = this.linear_T3;
                    break;
                }
                case 3: {
                    this.linear_Vh = this.controlSignal(this.pidControl3, this.linear_T3, this.setPoint3);
                    this.setPoint1 = this.linear_T1;
                    this.setPoint2 = this.linear_T2;
                }
            }
            this.manualVh = this.linear_Vh;
            this.manualVhslider = this.linear_Vh;
        } else {
            this.linear_Vh = this.manualVh;
            this.setPoint1 = this.linear_T1;
            this.setPoint2 = this.linear_T2;
            this.setPoint3 = this.linear_T3;
            switch (this.opSensor) {
                case 1: {
                    this.setPoint = this.setPoint1;
                    break;
                }
                case 2: {
                    this.setPoint = this.setPoint2;
                    break;
                }
                case 3: {
                    this.setPoint = this.setPoint3;
                }
            }
        }
        this.Vhview = this.linear_Vh;
        this.T1view = this.linear_T1;
        this.T2view = this.linear_T2;
        this.T3view = this.linear_T3;
        this.colored();
        this.moveBlower();
        this.recordData();
    }

    public void _evolution2() {
        this.linear_T1 -= this.stationary_T1;
        this.linear_T2 -= this.stationary_T2;
        this.linear_T3 -= this.stationary_T3;
        this.linear_Vh -= this.stationary_Vh;
        this._t += this._dt;
    }

    public void _evolution4() {
        this.linear_T1 += this.stationary_T1;
        this.linear_T2 += this.stationary_T2;
        this.linear_T3 += this.stationary_T3;
        this.linear_Vh += this.stationary_Vh;
    }

    public double dlinear_T1(double d, double d2) {
        return d + this.b11 * d2;
    }

    public double daux_T1(double d, double d2, double d3) {
        return -this.a21 * d - this.a11 * d2 + this.Beta21 * d3;
    }

    public double dlinear_T2(double d, double d2) {
        return d + this.b12 * d2;
    }

    public double daux_T2(double d, double d2, double d3) {
        return -this.a22 * d - this.a12 * d2 + this.Beta22 * d3;
    }

    public double dlinear_T3(double d, double d2) {
        return d + this.b13 * d2;
    }

    public double daux_T3(double d, double d2, double d3) {
        return -this.a23 * d - this.a13 * d2 + this.Beta23 * d3;
    }

    private void setControl(int n) {
        switch (n) {
            case 1: {
                this.initControl(this.pidControl1, this.linear_T1, this.Kc1, this.dt, this.Ti1, this.Td1, this.Ti1 / 10.0, 1.0, 1.0, this.vmin1, this.vmax1);
                break;
            }
            case 2: {
                this.initControl(this.pidControl2, this.linear_T2, this.Kc2, this.dt, this.Ti2, this.Td2, this.Ti2 / 10.0, 1.0, 1.0, this.vmin2, this.vmax2);
                break;
            }
            case 3: {
                this.initControl(this.pidControl3, this.linear_T3, this.Kc3, this.dt, this.Ti3, this.Td3, this.Ti3 / 10.0, 1.0, 1.0, this.vmin3, this.vmax3);
            }
        }
    }

    public void resetControls(int n) {
        switch (n) {
            case 1: {
                this.setControl(1);
                this.K = this.Kc1;
                this.Ti = this.Ti1;
                this.Td = this.Td1;
                break;
            }
            case 2: {
                this.setControl(2);
                this.K = this.Kc2;
                this.Ti = this.Ti2;
                this.Td = this.Td2;
                break;
            }
            case 3: {
                this.setControl(3);
                this.K = this.Kc3;
                this.Ti = this.Ti3;
                this.Td = this.Td3;
            }
        }
    }

    public void changeControl(int n) {
        switch (n) {
            case 1: {
                this.changeSaturation(this.pidControl1, this.vmin1, this.vmax1);
                break;
            }
            case 2: {
                this.changeSaturation(this.pidControl2, this.vmin2, this.vmax2);
                break;
            }
            case 3: {
                this.changeSaturation(this.pidControl3, this.vmin3, this.vmax3);
            }
        }
    }

    private void initControl(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d8;
        dArray[3] = d9;
        dArray[4] = d10;
        dArray[5] = d2 * d3 / d4;
        dArray[6] = d3 / d6;
        dArray[7] = d5 / (d5 + d7 * d3);
        dArray[8] = d2 * d7 * dArray[7];
        dArray[9] = this.Vh;
        dArray[10] = 0.0;
    }

    private double controlSignal(double[] dArray, double d, double d2) {
        double d3 = dArray[1] * (dArray[2] * d2 - d);
        dArray[10] = dArray[7] * dArray[10] - dArray[8] * (d - dArray[0]);
        double d4 = this.Ti == 0.0 ? d3 + dArray[10] : d3 + dArray[9] + dArray[10];
        double d5 = d4 < dArray[3] ? dArray[3] : (d4 > dArray[4] ? dArray[4] : d4);
        dArray[9] = this.manualMode ? this.manualVh : dArray[9] + dArray[5] * (d2 - d) + dArray[6] * (d5 - d4);
        dArray[0] = d;
        return d5;
    }

    private void changeSaturation(double[] dArray, double d, double d2) {
        dArray[3] = d;
        dArray[4] = d2;
    }

    public void colored() {
        int n;
        this.T[0] = this.T1view;
        this.T[this.colors / 2] = this.T2view;
        this.T[this.colors - 1] = this.T3view;
        for (n = 1; n < this.colors / 2; ++n) {
            this.T[n] = this.T[n - 1] - (this.T[0] - this.T[this.colors / 2]) / (double)(this.colors / 2 - 1);
        }
        for (n = this.colors / 2 + 1; n < this.colors - 1; ++n) {
            this.T[n] = this.T[n - 1] - (this.T[this.colors / 2] - this.T[this.colors - 1]) / (double)(this.colors / 2 - 2);
        }
        for (n = 0; n < this.colors; ++n) {
            this.red = 255 - (int)(this.deltaColor * (this.maxTemp - this.T[n]));
            this._red = 255 - (int)(this.deltaColorHeat * (this.vmax1 - this.Vhview));
            if (this.red > 255) {
                this.red = 255;
            }
            if (this.red < 0) {
                this.red = 0;
            }
            this.levelColors[n] = new Color(this.red, 255 - this.red, 255 - this.red, this.red / 4);
            this.colorTemp[n] = this.levelColors[n];
            this.colorHeater = new Color(this._red, this._red, 0, 255);
        }
    }

    public void moveBlower() {
        this._dt = this.Vf / (2.0 * this.Vfmax);
        this.axis1[6] = 0.0;
        this.axis1[7] = -Math.sin(1.5707963267948966 * this._t);
        this.axis1[8] = -Math.cos(1.5707963267948966 * this._t);
        this.angles1 = 1.5707963267948966 * this._t;
        this.axis2[6] = 0.0;
        this.axis2[7] = -Math.sin(1.5707963267948966 * (this._t + 45.0));
        this.angles1 = 1.5707963267948966 * this._t;
        this.axis2[8] = -Math.cos(1.5707963267948966 * (this._t + 45.0));
        this.angles2 = 1.5707963267948966 * (this._t + 45.0);
        this.axis3[6] = 0.0;
        this.axis3[7] = -Math.sin(1.5707963267948966 * (this._t + 90.0));
        this.axis3[8] = -Math.cos(1.5707963267948966 * (this._t + 90.0));
        this.angles3 = 1.5707963267948966 * (this._t + 90.0);
        this.axis4[6] = 0.0;
        this.axis4[7] = -Math.sin(1.5707963267948966 * (this._t + 135.0));
        this.axis4[8] = -Math.cos(1.5707963267948966 * (this._t + 135.0));
        this.angles4 = 1.5707963267948966 * (this._t + 135.0);
        this.movCX1 = this.cx;
        this.movCY1 = this.highBlower * Math.sin(1.5707963267948966 * this._t) * 2.0 / 3.0 + this.cy;
        this.movCZ1 = this.highBlower * Math.cos(1.5707963267948966 * this._t) * 2.0 / 3.0 + this.cz;
        this.movCX2 = this.cx;
        this.movCY2 = this.highBlower * Math.sin(1.5707963267948966 * (this._t + 45.0)) * 2.0 / 3.0 + this.cy;
        this.movCZ2 = this.highBlower * Math.cos(1.5707963267948966 * (this._t + 45.0)) * 2.0 / 3.0 + this.cz;
        this.movCX3 = this.cx;
        this.movCY3 = this.highBlower * Math.sin(1.5707963267948966 * (this._t + 90.0)) * 2.0 / 3.0 + this.cy;
        this.movCZ3 = this.highBlower * Math.cos(1.5707963267948966 * (this._t + 90.0)) * 2.0 / 3.0 + this.cz;
        this.movCX4 = this.cx;
        this.movCY4 = this.highBlower * Math.sin(1.5707963267948966 * (this._t + 135.0)) * 2.0 / 3.0 + this.cy;
        this.movCZ4 = this.highBlower * Math.cos(1.5707963267948966 * (this._t + 135.0)) * 2.0 / 3.0 + this.cz;
    }

    public void recordData() {
        if (this.t != this.tant) {
            this.tant = this.t;
            ((StringBuilder)this.sbuilder).append(((DecimalFormat)this.df).format(this.t) + " ");
            ((StringBuilder)this.sbuilder).append(((DecimalFormat)this.df).format(this.T1view) + " ");
            ((StringBuilder)this.sbuilder).append(((DecimalFormat)this.df).format(this.T2view) + " ");
            ((StringBuilder)this.sbuilder).append(((DecimalFormat)this.df).format(this.T3view) + " ");
            ((StringBuilder)this.sbuilder).append(((DecimalFormat)this.df).format(this.Vhview) + " ");
            ((StringBuilder)this.sbuilder).append(((DecimalFormat)this.df).format(this.Vf) + " ");
            switch (this.opSensor) {
                case 1: {
                    ((StringBuilder)this.sbuilder).append(((DecimalFormat)this.df).format(this.setPoint1) + "\n");
                    break;
                }
                case 2: {
                    ((StringBuilder)this.sbuilder).append(((DecimalFormat)this.df).format(this.setPoint2) + "\n");
                    break;
                }
                case 3: {
                    ((StringBuilder)this.sbuilder).append(((DecimalFormat)this.df).format(this.setPoint3) + "\n");
                }
            }
            if (this.t > (double)this.npoints * this.dt) {
                ((StringBuilder)this.sbuilder).delete(0, ((StringBuilder)this.sbuilder).indexOf("\n") + 1);
            }
        }
    }

    public String generaMfile() {
        String string = "simulacion";
        Date date = new Date();
        ((StringBuffer)this.sb).append("% Data from console in " + string + " mode" + "\n");
        ((StringBuffer)this.sb).append("% Date: " + date.toString() + "\n");
        ((StringBuffer)this.sb).append("% UNED Remote Lab: The Heatflow System\n");
        ((StringBuffer)this.sb).append("% data format: t T1 T2 T3 Vh Vf ref\n\n");
        ((StringBuffer)this.sb).append("dat=[\n");
        ((StringBuffer)this.sb).append(((StringBuilder)this.sbuilder).toString());
        ((StringBuffer)this.sb).append("];\n");
        if (this.opSensor == 1) {
            ((StringBuffer)this.sb).append("kp1=" + ((DecimalFormat)this.df).format(this.Kc1) + ";" + "\n");
            ((StringBuffer)this.sb).append("ti1=" + ((DecimalFormat)this.df).format(this.Ti1) + ";" + "\n");
            ((StringBuffer)this.sb).append("td1=" + ((DecimalFormat)this.df).format(this.Td1) + ";" + "\n");
        } else if (this.opSensor == 2) {
            ((StringBuffer)this.sb).append("kp2=" + ((DecimalFormat)this.df).format(this.Kc2) + ";" + "\n");
            ((StringBuffer)this.sb).append("ti2=" + ((DecimalFormat)this.df).format(this.Ti2) + ";" + "\n");
            ((StringBuffer)this.sb).append("td2=" + ((DecimalFormat)this.df).format(this.Td2) + ";" + "\n");
        } else if (this.opSensor == 3) {
            ((StringBuffer)this.sb).append("kp3=" + ((DecimalFormat)this.df).format(this.Kc3) + ";" + "\n");
            ((StringBuffer)this.sb).append("ti3=" + ((DecimalFormat)this.df).format(this.Ti3) + ";" + "\n");
            ((StringBuffer)this.sb).append("td3=" + ((DecimalFormat)this.df).format(this.Td3) + ";" + "\n");
        }
        ((StringBuffer)this.sb).append("t=dat(:,1);\n");
        ((StringBuffer)this.sb).append("T1=dat(:,2);\n");
        ((StringBuffer)this.sb).append("T2=dat(:,3);\n");
        ((StringBuffer)this.sb).append("T3=dat(:,4);\n");
        ((StringBuffer)this.sb).append("Vh=dat(:,5);\n");
        ((StringBuffer)this.sb).append("Vf=dat(:,6);\n");
        ((StringBuffer)this.sb).append("ref=dat(:,7);\n");
        ((StringBuffer)this.sb).append("plot([t'],[T1'; T2'; T3'; Vh'; Vf'; ref']);");
        return ((StringBuffer)this.sb).toString();
    }

    public void _method_for_SaveGraph_action() {
        String string = "HeatFlowGraph";
        string = "Sim" + string;
        this._saveImage(string, "PanelPlot");
    }

    public void _method_for_SaveRegister_action() {
        String string = "registroHeatflow.m";
        string = "Sim" + string;
        this._saveText(string, this.generaMfile());
    }

    public boolean _method_for_MANUAL_enabled() {
        return !this.manualMode;
    }

    public void _method_for_MANUAL_action() {
        this.manualMode = true;
        this.sp1Visible = false;
        this.sp2Visible = false;
        this.sp3Visible = false;
    }

    public void _method_for_PIDController_action() {
        this.manualMode = false;
        if (this.opSensor == 1) {
            this.sp1Visible = true;
            this.sp2Visible = false;
            this.sp3Visible = false;
        } else if (this.opSensor == 2) {
            this.sp1Visible = false;
            this.sp2Visible = true;
            this.sp3Visible = false;
        } else if (this.opSensor == 3) {
            this.sp1Visible = false;
            this.sp2Visible = false;
            this.sp3Visible = true;
        }
    }

    public void _method_for_Spanish_action() {
        this._simulation.setLocale("es");
    }

    public void _method_for_English_action() {
        this._simulation.setLocale("en");
    }

    public double _method_for_drawingPanel3D_maximumZ() {
        return this.highCubeDown + this.highCubeUp;
    }

    public double _method_for_coneBlower1_x() {
        return this.movCX1 - 6.0;
    }

    public double _method_for_coneBlower2_x() {
        return this.movCX2 - 6.0;
    }

    public double _method_for_coneBlower3_x() {
        return this.movCX3 - 6.0;
    }

    public double _method_for_coneBlower4_x() {
        return this.movCX4 - 6.0;
    }

    public double _method_for_groupBoxes3D_sizeX() {
        return 2 * this.lengthCubeUp / this.colors;
    }

    public double _method_for_CubeSuperior_x() {
        return (double)this.lengthCubeUp / 2.0;
    }

    public double _method_for_CubeSuperior_y() {
        return (double)this.widthCubeUp / 2.0;
    }

    public double _method_for_CubeSuperior_z() {
        return (double)this.highCubeDown + (double)this.highCubeUp / 2.0;
    }

    public double _method_for_cylinderHeater_x() {
        return this.posHeaterX - 6.0;
    }

    public double _method_for_cylinderHeater_y() {
        return this.widthCubeDown / 2;
    }

    public double _method_for_cylinderHeater_z() {
        return this.highCubeDown + this.highCubeUp / 2;
    }

    public double _method_for_CylinderBottom_y() {
        return this.widthCubeDown / 2;
    }

    public double _method_for_CylinderBottom_z() {
        return this.highCubeDown + this.highCubeUp / 2;
    }

    public double _method_for_cubeInferior_x() {
        return (double)(this.lengthCubeDown - 6) / 2.0;
    }

    public double _method_for_cubeInferior_y() {
        return (double)this.widthCubeDown / 2.0;
    }

    public double _method_for_cubeInferior_z() {
        return (double)this.highCubeDown / 2.0;
    }

    public double _method_for_cubeInferior_sizeX() {
        return this.lengthCubeDown + 6;
    }

    public double _method_for_cubeSensor1_y() {
        return (double)(this.widthCubeDown / 2) - 0.5;
    }

    public double _method_for_cubeSensor2_y() {
        return (double)(this.widthCubeDown / 2) - 0.5;
    }

    public double _method_for_cubeSensor3_y() {
        return (double)(this.widthCubeDown / 2) - 0.5;
    }

    public double _method_for_cubeHF_y() {
        return this.widthCubeDown / 2;
    }

    public double _method_for_cubeHF_z() {
        return this.highCubeDown + this.highCubeUp / 2;
    }

    public double _method_for_cylinderIntBlower_x() {
        return this.posBlowerIntX - 6.0;
    }

    public double _method_for_cylinderIntBlower_y() {
        return this.widthCubeDown / 2;
    }

    public double _method_for_cylinderIntBlower_z() {
        return this.highCubeDown + this.highCubeUp / 2;
    }

    public double _method_for_cylinderIntBlower_sizeX() {
        return this.ratioBlowerIntA * 2.0;
    }

    public double _method_for_cylinderIntBlower_sizeY() {
        return this.ratioBlowerIntB * 2.0;
    }

    public double _method_for_cylinderIntBlower_sizeZ() {
        return this.highBlowerInt * 2.0;
    }

    public boolean _method_for_setPoint_enabled() {
        return !this.manualMode;
    }

    public void _method_for_setPoint_pressaction() {
        this._pause();
    }

    public void _method_for_setPoint_action() {
        if (this.opSensor == 1) {
            this.setPoint1 = this.setPoint;
        } else if (this.opSensor == 2) {
            this.setPoint2 = this.setPoint;
        } else {
            this.setPoint3 = this.setPoint;
        }
        this._play();
    }

    public void _method_for_voltHeat_pressaction() {
        this._pause();
    }

    public void _method_for_voltHeat_action() {
        this.manualVh = this.manualVhslider;
        this._play();
    }

    public void _method_for_voltFan_pressaction() {
        this._pause();
    }

    public void _method_for_voltFan_action() {
        this.Vf = this.Vfslider;
        this._play();
    }

    public void _method_for_Fps_pressaction() {
        this._pause();
    }

    public void _method_for_Fps_action() {
        this._setFPS(this.fps);
        this._play();
    }

    public void _method_for_ControlT1_action() {
        this.opSensor = 1;
        this.resetControls(1);
        this.setpointTLabel = this._getStringProperty("setpointT1Label");
        this.setPoint = this.linear_T1;
        if (!this.manualMode) {
            this.sp1Visible = true;
            this.sp2Visible = false;
            this.sp3Visible = false;
        }
    }

    public void _method_for_ControlT2_action() {
        this.opSensor = 2;
        this.resetControls(2);
        this.setpointTLabel = this._getStringProperty("setpointT2Label");
        this.setPoint = this.linear_T2;
        if (!this.manualMode) {
            this.sp1Visible = false;
            this.sp2Visible = true;
            this.sp3Visible = false;
        }
    }

    public void _method_for_ControlT3_action() {
        this.opSensor = 3;
        this.resetControls(3);
        this.setpointTLabel = this._getStringProperty("setpointT3Label");
        this.setPoint = this.linear_T3;
        if (!this.manualMode) {
            this.sp1Visible = false;
            this.sp2Visible = false;
            this.sp3Visible = true;
        }
    }

    public void _method_for_K_action() {
        if (this.cSensor1) {
            this.Kc1 = this.K;
            this.resetControls(1);
        } else if (this.cSensor2) {
            this.Kc2 = this.K;
            this.resetControls(2);
        } else {
            this.Kc3 = this.K;
            this.resetControls(3);
        }
    }

    public void _method_for_Ti_action() {
        if (this.cSensor1) {
            this.Ti1 = this.Ti;
            this.resetControls(1);
        } else if (this.cSensor2) {
            this.Ti2 = this.Ti;
            this.resetControls(2);
        } else {
            this.Ti3 = this.Ti;
            this.resetControls(3);
        }
    }

    public void _method_for_Td_action() {
        if (this.cSensor1) {
            this.Td1 = this.Td;
            this.resetControls(1);
        } else if (this.cSensor2) {
            this.Td2 = this.Td;
            this.resetControls(2);
        } else {
            this.Td3 = this.Td;
            this.resetControls(3);
        }
    }

    public void _method_for_Play_action() {
        this._play();
    }

    public boolean _method_for_Pause_enabled() {
        return this._isPlaying();
    }

    public void _method_for_Pause_action() {
        this._pause();
    }

    public void _method_for_Reset_action() {
        this._reset();
    }

    public boolean _method_for_SP_editable() {
        return !this.manualMode;
    }

    public void _method_for_SP_action() {
        if (this.setPoint > 75.0) {
            this.setPoint = 75.0;
        } else if (this.setPoint < 25.0) {
            this.setPoint = 25.0;
        }
        if (this.opSensor == 1) {
            this.setPoint1 = this.setPoint;
        } else if (this.opSensor == 2) {
            this.setPoint2 = this.setPoint;
        } else {
            this.setPoint3 = this.setPoint;
        }
    }

    public void _method_for_Vh_action() {
        if (this.manualVh > 5.0) {
            this.manualVh = 5.0;
        } else if (this.manualVh < 0.0) {
            this.manualVh = 0.0;
        }
        this.manualVhslider = this.manualVh;
    }

    static {
        __translatorUtil = new TranslatorResourceUtil("users.uned.hvargas.virtHeatflowUNED_pkg.virtHeatflowUNED");
        __translatorUtil.addTranslation("es");
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }

    private class _ODE_evolution3
    implements EjsS_ODE,
    VelocityVerletSavvy {
        private SolverEngine __solver = null;
        private InterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = RK4.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustInitialize = true;
        private boolean __isEnabled = true;
        private boolean __mustUserReinitialize = false;
        private boolean __mustReinitialize = true;

        _ODE_evolution3() {
            this.__instantiateSolver();
            virtHeatflowUNED.this._privateOdesList.put("Linear2doOrder", this);
        }

        @Override
        public InterpolatorEventSolver getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        @Override
        public String setSolverClass(String string) {
            String string2 = "org.opensourcephysics.numerics.ode_solvers.";
            if ((string = string.trim().toLowerCase()).indexOf("euler") >= 0) {
                string = string.indexOf("rich") >= 0 ? string2 + "rk.EulerRichardson" : string2 + "rk.Euler";
            } else if (string.indexOf("verlet") >= 0) {
                string = string2 + "symplectic.VelocityVerlet";
            } else if (string.indexOf("runge") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("rk4") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("boga") >= 0) {
                string = string2 + "rk.BogackiShampine23";
            } else if (string.indexOf("cash") >= 0) {
                string = string2 + "rk.CashKarp45";
            } else if (string.indexOf("fehl") >= 0) {
                string = string.indexOf("7") >= 0 ? string2 + "rk.Fehlberg78" : string2 + "rk.Fehlberg8";
            } else if (string.indexOf("dorm") >= 0 || string.indexOf("dopri") >= 0) {
                string = string.indexOf("8") >= 0 ? string2 + "rk.Dopri853" : string2 + "rk.Dopri5";
            } else if (string.indexOf("radau") >= 0) {
                string = string2 + "rk.Radau5";
            } else {
                System.err.println("There is no solver with this name " + string);
                return null;
            }
            try {
                this.setSolverClass(Class.forName(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        private void __instantiateSolver() {
            this.__state = new double[7];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{};
                Object[] objectArray = new Object[]{};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (SolverEngine)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new InterpolatorEventSolver(this.__solver, this);
            this.__mustInitialize = true;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.__isEnabled = bl;
        }

        @Override
        public double getIndependentVariableValue() {
            return this.__eventSolver.getIndependentVariableValue();
        }

        @Override
        public double getInternalStepSize() {
            return this.__eventSolver.getInternalStepSize();
        }

        @Override
        public boolean isAccelerationIndependentOfVelocity() {
            return false;
        }

        @Override
        public void initializeSolver() {
            this.__pushState();
            this.__eventSolver.initialize(virtHeatflowUNED.this.dt);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.removeAllEvents();
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__mustReinitialize = true;
            this.__mustInitialize = false;
        }

        private void __pushState() {
            int n = 0;
            if (this.__state[n] != virtHeatflowUNED.this.linear_T1) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = virtHeatflowUNED.this.linear_T1;
            if (this.__state[n] != virtHeatflowUNED.this.aux_T1) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = virtHeatflowUNED.this.aux_T1;
            if (this.__state[n] != virtHeatflowUNED.this.linear_T2) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = virtHeatflowUNED.this.linear_T2;
            if (this.__state[n] != virtHeatflowUNED.this.aux_T2) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = virtHeatflowUNED.this.aux_T2;
            if (this.__state[n] != virtHeatflowUNED.this.linear_T3) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = virtHeatflowUNED.this.linear_T3;
            if (this.__state[n] != virtHeatflowUNED.this.aux_T3) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = virtHeatflowUNED.this.aux_T3;
            if (this.__state[n] != virtHeatflowUNED.this.t_ejs) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = virtHeatflowUNED.this.t_ejs;
        }

        public void resetSolver() {
            this.__mustUserReinitialize = true;
        }

        public void automaticResetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            int n = JOptionPane.showConfirmDialog(virtHeatflowUNED.this._view.getComponent(virtHeatflowUNED.this._simulation.getMainWindow()), Simulation.getEjsString("ODEError.Continue"), Simulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                virtHeatflowUNED.this._pause();
            }
            this.__mustReinitialize = true;
        }

        @Override
        public double step() {
            return this.__privateStep(false);
        }

        @Override
        public double solverStep() {
            return this.__privateStep(true);
        }

        private double __privateStep(boolean bl) {
            if (!this.__isEnabled) {
                return 0.0;
            }
            if (virtHeatflowUNED.this.dt == 0.0) {
                return 0.0;
            }
            if (this.__mustInitialize) {
                this.initializeSolver();
            }
            this.__eventSolver.setStepSize(virtHeatflowUNED.this.dt);
            this.__eventSolver.setInternalStepSize(virtHeatflowUNED.this.dt);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__pushState();
            if (this.__mustUserReinitialize) {
                this.__eventSolver.userReinitialize();
                this.__mustUserReinitialize = false;
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                    this.__errorAction();
                }
            } else if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                    this.__errorAction();
                }
            }
            double d = bl ? this.__eventSolver.maxStep() : this.__eventSolver.step();
            int n = 0;
            virtHeatflowUNED.this.linear_T1 = this.__state[n++];
            virtHeatflowUNED.this.aux_T1 = this.__state[n++];
            virtHeatflowUNED.this.linear_T2 = this.__state[n++];
            virtHeatflowUNED.this.aux_T2 = this.__state[n++];
            virtHeatflowUNED.this.linear_T3 = this.__state[n++];
            virtHeatflowUNED.this.aux_T3 = this.__state[n++];
            virtHeatflowUNED.this.t_ejs = this.__state[n++];
            if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                this.__errorAction();
            }
            return d;
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            dArray2[dArray2.length - 1] = 0.0;
            int n = -1;
            int n2 = 0;
            double d = dArray[n2++];
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            double d4 = dArray[n2++];
            double d5 = dArray[n2++];
            double d6 = dArray[n2++];
            double d7 = dArray[n2++];
            int n3 = 0;
            dArray2[n3++] = virtHeatflowUNED.this.dlinear_T1(d2, virtHeatflowUNED.this.linear_Vh);
            dArray2[n3++] = virtHeatflowUNED.this.daux_T1(d, d2, virtHeatflowUNED.this.linear_Vh);
            dArray2[n3++] = virtHeatflowUNED.this.dlinear_T2(d4, virtHeatflowUNED.this.linear_Vh);
            dArray2[n3++] = virtHeatflowUNED.this.daux_T2(d3, d4, virtHeatflowUNED.this.linear_Vh);
            dArray2[n3++] = virtHeatflowUNED.this.dlinear_T3(d6, virtHeatflowUNED.this.linear_Vh);
            dArray2[n3++] = virtHeatflowUNED.this.daux_T3(d5, d6, virtHeatflowUNED.this.linear_Vh);
            dArray2[n3++] = 1.0;
        }
    }
}

