/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.MatrixTransformation;
import org.opensourcephysics.numerics.VectorMath;

public class Matrix3DTransformation
implements MatrixTransformation {
    protected double[] origin = new double[3];
    protected double[][] matrix = new double[3][3];
    protected double[][] inverseMatrix = null;

    public Matrix3DTransformation(double[][] dArray) {
        if (dArray == null) {
            this.matrix[2][2] = 1.0;
            this.matrix[1][1] = 1.0;
            this.matrix[0][0] = 1.0;
            return;
        }
        int n = 0;
        while (n < dArray.length) {
            System.arraycopy(dArray[n], 0, this.matrix[n], 0, dArray[n].length);
            ++n;
        }
    }

    public static Matrix3DTransformation rotationX(double d) {
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(null);
        double[][] dArray = matrix3DTransformation.matrix;
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        dArray[0][0] = 1.0;
        dArray[1][1] = d3;
        dArray[1][2] = -d2;
        dArray[2][1] = d2;
        dArray[2][2] = d3;
        double[][] dArray2 = new double[3][3];
        matrix3DTransformation.inverseMatrix = dArray2;
        dArray2[0][0] = 1.0;
        dArray2[1][1] = d3;
        dArray2[1][2] = d2;
        dArray2[2][1] = -d2;
        dArray2[2][2] = d3;
        return matrix3DTransformation;
    }

    public static Matrix3DTransformation rotationY(double d) {
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(null);
        double[][] dArray = matrix3DTransformation.matrix;
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        dArray[1][1] = 1.0;
        dArray[0][0] = d3;
        dArray[0][2] = d2;
        dArray[2][0] = -d2;
        dArray[2][2] = d3;
        double[][] dArray2 = new double[3][3];
        matrix3DTransformation.inverseMatrix = dArray2;
        dArray2[1][1] = 1.0;
        dArray2[0][0] = d3;
        dArray2[0][2] = -d2;
        dArray2[2][0] = d2;
        dArray2[2][2] = d3;
        return matrix3DTransformation;
    }

    public static Matrix3DTransformation rotationZ(double d) {
        double d2;
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(null);
        double[][] dArray = matrix3DTransformation.matrix;
        double d3 = Math.sin(d);
        dArray[0][0] = d2 = Math.cos(d);
        dArray[0][1] = -d3;
        dArray[1][0] = d3;
        dArray[1][1] = d2;
        dArray[2][2] = 1.0;
        double[][] dArray2 = new double[3][3];
        matrix3DTransformation.inverseMatrix = dArray2;
        dArray2[0][0] = d2;
        dArray2[0][1] = d3;
        dArray2[1][0] = -d3;
        dArray2[1][1] = d2;
        dArray2[2][2] = 1.0;
        return matrix3DTransformation;
    }

    public static Matrix3DTransformation rotation(double d, double[] dArray) {
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(null);
        double[][] dArray2 = matrix3DTransformation.matrix;
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = d2 * d2 + d3 * d3 + d4 * d4;
        if (d5 != 1.0) {
            d5 = 1.0 / Math.sqrt(d5);
            d2 *= d5;
            d3 *= d5;
            d4 *= d5;
        }
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double d8 = 1.0 - d6;
        dArray2[0][0] = d8 * d2 * d2 + d6;
        dArray2[0][1] = d8 * d2 * d3 - d7 * d4;
        dArray2[0][2] = d8 * d2 * d4 + d7 * d3;
        dArray2[1][0] = d8 * d2 * d3 + d7 * d4;
        dArray2[1][1] = d8 * d3 * d3 + d6;
        dArray2[1][2] = d8 * d3 * d4 - d7 * d2;
        dArray2[2][0] = d8 * d2 * d4 - d7 * d3;
        dArray2[2][1] = d8 * d3 * d4 + d7 * d2;
        dArray2[2][2] = d8 * d4 * d4 + d6;
        double[][] dArray3 = new double[3][3];
        matrix3DTransformation.inverseMatrix = dArray3;
        dArray3[0][0] = dArray2[0][0];
        dArray3[1][0] = dArray2[0][1];
        dArray3[2][0] = dArray2[0][2];
        dArray3[0][1] = dArray2[1][0];
        dArray3[1][1] = dArray2[1][1];
        dArray3[2][1] = dArray2[1][2];
        dArray3[0][2] = dArray2[2][0];
        dArray3[1][2] = dArray2[2][1];
        dArray3[2][2] = dArray2[2][2];
        return matrix3DTransformation;
    }

    public static Matrix3DTransformation Quaternion(double[] dArray) {
        return Matrix3DTransformation.Quaternion(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public static Matrix3DTransformation Quaternion(double d, double d2, double d3, double d4) {
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(null);
        double[][] dArray = matrix3DTransformation.matrix;
        double d5 = d * d + d2 * d2 + d3 * d3 + d4 * d4;
        if (d5 != 1.0) {
            d5 = 1.0 / Math.sqrt(d5);
            d *= d5;
            d2 *= d5;
            d3 *= d5;
            d4 *= d5;
        }
        double d6 = 2.0 * d2 * d2;
        double d7 = 2.0 * d3 * d3;
        double d8 = 2.0 * d4 * d4;
        double d9 = 2.0 * d2 * d3;
        double d10 = 2.0 * d2 * d4;
        double d11 = 2.0 * d3 * d4;
        double d12 = 2.0 * d * d2;
        double d13 = 2.0 * d * d3;
        double d14 = 2.0 * d * d4;
        dArray[0][0] = 1.0 - d7 - d8;
        dArray[0][1] = d9 - d14;
        dArray[0][2] = d10 + d13;
        dArray[1][0] = d9 + d14;
        dArray[1][1] = 1.0 - d6 - d8;
        dArray[1][2] = d11 - d12;
        dArray[2][0] = d10 - d13;
        dArray[2][1] = d11 + d12;
        dArray[2][2] = 1.0 - d6 - d7;
        double[][] dArray2 = new double[3][3];
        matrix3DTransformation.inverseMatrix = dArray2;
        dArray2[0][0] = dArray[0][0];
        dArray2[1][0] = dArray[0][1];
        dArray2[2][0] = dArray[0][2];
        dArray2[0][1] = dArray[1][0];
        dArray2[1][1] = dArray[1][1];
        dArray2[2][1] = dArray[1][2];
        dArray2[0][2] = dArray[2][0];
        dArray2[1][2] = dArray[2][1];
        dArray2[2][2] = dArray[2][2];
        return matrix3DTransformation;
    }

    public boolean setMatrix(double[][] dArray) {
        if (this.matrix.equals(dArray)) {
            return false;
        }
        int n = 0;
        while (n < 3) {
            System.arraycopy(dArray[n], 0, this.matrix[n], 0, 3);
            ++n;
        }
        this.inverseMatrix = null;
        return true;
    }

    public boolean setMatrix(double[] dArray) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n < 3) {
            if (this.matrix[n][0] != dArray[n2++]) {
                this.matrix[n][0] = dArray[n2];
                bl = true;
            }
            if (this.matrix[n][1] != dArray[n2++]) {
                this.matrix[n][1] = dArray[n2];
                bl = true;
            }
            if (this.matrix[n][2] != dArray[n2++]) {
                this.matrix[n][2] = dArray[n2];
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this.inverseMatrix = null;
        }
        return bl;
    }

    @Override
    public Object clone() {
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(this.matrix);
        matrix3DTransformation.origin = (double[])this.origin.clone();
        if (this.inverseMatrix == null) {
            return matrix3DTransformation;
        }
        matrix3DTransformation.inverseMatrix = new double[3][3];
        int n = 0;
        while (n < this.inverseMatrix.length) {
            System.arraycopy(this.inverseMatrix[n], 0, matrix3DTransformation.inverseMatrix[n], 0, this.inverseMatrix[n].length);
            ++n;
        }
        return matrix3DTransformation;
    }

    @Override
    public final double[] getFlatMatrix(double[] dArray) {
        if (dArray == null) {
            dArray = new double[16];
        }
        dArray[0] = this.matrix[0][0];
        dArray[4] = this.matrix[0][1];
        dArray[8] = this.matrix[0][2];
        dArray[1] = this.matrix[1][0];
        dArray[5] = this.matrix[1][1];
        dArray[9] = this.matrix[1][2];
        dArray[2] = this.matrix[2][0];
        dArray[3] = 0.0;
        dArray[6] = this.matrix[2][1];
        dArray[7] = 0.0;
        dArray[10] = this.matrix[2][2];
        dArray[11] = 0.0;
        dArray[12] = this.origin[0];
        dArray[13] = this.origin[1];
        dArray[14] = this.origin[2];
        dArray[15] = 1.0;
        return dArray;
    }

    public final double[] getTransposedFlatMatrix(double[] dArray) {
        if (dArray == null) {
            dArray = new double[]{this.matrix[0][0], this.matrix[0][1], this.matrix[0][2], 0.0, this.matrix[1][0], this.matrix[1][1], this.matrix[1][2], 0.0, this.matrix[2][0], this.matrix[2][1], this.matrix[2][2], 0.0, this.origin[0], this.origin[1], this.origin[2], 1.0};
        }
        return dArray;
    }

    public final double[] toQuaternion(double[] dArray) {
        boolean bl;
        double d;
        double d2;
        double d3;
        double d4 = Math.sqrt(this.matrix[0][0] + this.matrix[1][1] + this.matrix[2][2] + 1.0) / 2.0;
        double d5 = this.matrix[2][1] - this.matrix[1][2];
        double d6 = this.matrix[0][2] - this.matrix[2][0];
        double d7 = this.matrix[1][0] - this.matrix[0][1];
        if (this.matrix[0][0] >= this.matrix[1][1] && this.matrix[0][0] >= this.matrix[2][2]) {
            d3 = this.matrix[0][0] - this.matrix[1][1] - this.matrix[2][2] + 1.0;
            d2 = this.matrix[1][0] + this.matrix[0][1];
            d = this.matrix[2][0] + this.matrix[0][2];
            bl = d5 >= 0.0;
        } else if (this.matrix[1][1] >= this.matrix[2][2]) {
            d3 = this.matrix[1][0] + this.matrix[0][1];
            d2 = this.matrix[1][1] - this.matrix[0][0] - this.matrix[2][2] + 1.0;
            d = this.matrix[2][1] + this.matrix[1][2];
            bl = d6 >= 0.0;
        } else {
            d3 = this.matrix[2][0] + this.matrix[0][2];
            d2 = this.matrix[2][1] + this.matrix[1][2];
            d = this.matrix[2][2] - this.matrix[0][0] - this.matrix[1][1] + 1.0;
            boolean bl2 = bl = d7 >= 0.0;
        }
        if (bl) {
            d5 += d3;
            d6 += d2;
            d7 += d;
        } else {
            d5 -= d3;
            d6 -= d2;
            d7 -= d;
        }
        double d8 = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
        if (d8 == 0.0) {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
            dArray[3] = 0.0;
        } else {
            double d9 = Math.sqrt(1.0 - d4 * d4) / d8;
            dArray[0] = d4;
            dArray[1] = d9 * d5;
            dArray[2] = d9 * d6;
            dArray[3] = d9 * d7;
        }
        return dArray;
    }

    public static Matrix3DTransformation createAlignmentTransformation(double[] dArray, double[] dArray2) {
        dArray = VectorMath.normalize((double[])dArray.clone());
        dArray2 = VectorMath.normalize((double[])dArray2.clone());
        double d = Math.acos(VectorMath.dot(dArray, dArray2));
        double[] dArray3 = VectorMath.cross3D(dArray, dArray2);
        return Matrix3DTransformation.rotation(d, dArray3);
    }

    public void setOrigin(double d, double d2, double d3) {
        this.origin[0] = d;
        this.origin[1] = d2;
        this.origin[2] = d3;
    }

    public final void multiply(Matrix3DTransformation matrix3DTransformation) {
        this.multiply(matrix3DTransformation.matrix);
    }

    public final void multiply(double[][] dArray) {
        int n = 0;
        int n2 = this.matrix.length;
        while (n < n2) {
            double[] dArray2 = (double[])this.matrix[n].clone();
            int n3 = 0;
            int n4 = this.matrix[0].length;
            while (n3 < n4) {
                this.matrix[n][n3] = 0.0;
                int n5 = 0;
                while (n5 < n4) {
                    double[] dArray3 = this.matrix[n];
                    int n6 = n3;
                    dArray3[n6] = dArray3[n6] + dArray2[n5] * dArray[n5][n3];
                    ++n5;
                }
                ++n3;
            }
            ++n;
        }
        this.inverseMatrix = null;
    }

    public double[] setOrigin(double[] dArray) {
        this.origin[0] = dArray[0];
        this.origin[1] = dArray[1];
        this.origin[2] = dArray[2];
        return dArray;
    }

    @Override
    public double[] direct(double[] dArray) {
        dArray[0] = dArray[0] - this.origin[0];
        dArray[1] = dArray[1] - this.origin[1];
        dArray[2] = dArray[2] - this.origin[2];
        double[] dArray2 = (double[])dArray.clone();
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            dArray[n] = this.origin[n];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n;
                dArray[n4] = dArray[n4] + this.matrix[n][n3] * dArray2[n3];
                ++n3;
            }
            ++n;
        }
        return dArray;
    }

    public double[][] direct(double[][] dArray) {
        int n;
        int n2;
        double[] dArray2;
        if (this.inverseMatrix == null) {
            this.calcInverse();
            if (this.inverseMatrix == null) {
                throw new UnsupportedOperationException("The inverse matrix does not exist.");
            }
        }
        int n3 = 0;
        while (n3 < 3) {
            dArray2 = (double[])dArray[n3].clone();
            n2 = 0;
            while (n2 < 3) {
                dArray[n3][n2] = 0.0;
                n = 0;
                while (n < 3) {
                    double[] dArray3 = dArray[n3];
                    int n4 = n2;
                    dArray3[n4] = dArray3[n4] + dArray2[n] * this.inverseMatrix[n][n2];
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < 3) {
            dArray2 = new double[]{dArray[0][n3], dArray[1][n3], dArray[2][n3]};
            n2 = 0;
            while (n2 < 3) {
                dArray[n2][n3] = 0.0;
                n = 0;
                while (n < 3) {
                    double[] dArray4 = dArray[n2];
                    int n5 = n3;
                    dArray4[n5] = dArray4[n5] + this.matrix[n2][n] * dArray2[n];
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        return dArray;
    }

    @Override
    public double[] inverse(double[] dArray) throws UnsupportedOperationException {
        if (this.inverseMatrix == null) {
            this.calcInverse();
            if (this.inverseMatrix == null) {
                throw new UnsupportedOperationException("The inverse matrix does not exist.");
            }
        }
        dArray[0] = dArray[0] - this.origin[0];
        dArray[1] = dArray[1] - this.origin[1];
        dArray[2] = dArray[2] - this.origin[2];
        double[] dArray2 = (double[])dArray.clone();
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            dArray[n] = this.origin[n];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n;
                dArray[n4] = dArray[n4] + this.inverseMatrix[n][n3] * dArray2[n3];
                ++n3;
            }
            ++n;
        }
        return dArray;
    }

    public double[][] inverse(double[][] dArray) {
        int n;
        int n2;
        double[] dArray2;
        if (this.inverseMatrix == null) {
            this.calcInverse();
            if (this.inverseMatrix == null) {
                throw new UnsupportedOperationException("The inverse matrix does not exist.");
            }
        }
        int n3 = 0;
        while (n3 < 3) {
            dArray2 = (double[])dArray[n3].clone();
            n2 = 0;
            while (n2 < 3) {
                dArray[n3][n2] = 0.0;
                n = 0;
                while (n < 3) {
                    double[] dArray3 = dArray[n3];
                    int n4 = n2;
                    dArray3[n4] = dArray3[n4] + dArray2[n] * this.matrix[n][n2];
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < 3) {
            dArray2 = new double[]{dArray[0][n3], dArray[1][n3], dArray[2][n3]};
            n2 = 0;
            while (n2 < 3) {
                dArray[n2][n3] = 0.0;
                n = 0;
                while (n < 3) {
                    double[] dArray4 = dArray[n2];
                    int n5 = n3;
                    dArray4[n5] = dArray4[n5] + this.inverseMatrix[n2][n] * dArray2[n];
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        return dArray;
    }

    public double[] getOrigin() {
        return this.origin;
    }

    private void calcInverse() {
        LUPDecomposition lUPDecomposition = new LUPDecomposition(this.matrix);
        this.inverseMatrix = lUPDecomposition.inverseMatrixComponents();
    }

    public static XML.ObjectLoader getLoader() {
        return new Affine3DTransformationLoader();
    }

    protected static class Affine3DTransformationLoader
    extends XMLLoader {
        protected Affine3DTransformationLoader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            Matrix3DTransformation matrix3DTransformation = (Matrix3DTransformation)object;
            xMLControl.setValue("matrix", matrix3DTransformation.matrix);
            if (matrix3DTransformation.inverseMatrix != null) {
                xMLControl.setValue("inverse", matrix3DTransformation.inverseMatrix);
            }
            xMLControl.setValue("origin", matrix3DTransformation.origin);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new Matrix3DTransformation(null);
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Matrix3DTransformation matrix3DTransformation = (Matrix3DTransformation)object;
            matrix3DTransformation.matrix = (double[][])xMLControl.getObject("matrix");
            matrix3DTransformation.inverseMatrix = (double[][])xMLControl.getObject("inverse");
            matrix3DTransformation.origin = (double[])xMLControl.getObject("origin");
            return object;
        }
    }
}

