/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils.transformations;

import org.opensourcephysics.drawing3d.utils.transformations.AxisRotation;

public class CustomAxisRotation
extends AxisRotation {
    private double[] axis = new double[]{1.0, 0.0, 0.0};
    private double x = 1.0;
    private double y = 0.0;
    private double z = 0.0;
    private double cos = 1.0;
    private double sin = 0.0;

    @Override
    public boolean setAngle(double theta) {
        return this.setAngleAndAxis(theta, this.axis);
    }

    public boolean setAxis(double[] newAxis) {
        return this.setAngleAndAxis(this.angle, newAxis);
    }

    public double[] getAxis() {
        return (double[])this.axis.clone();
    }

    public boolean setAngleAndAxis(double theta, double[] newAxis) {
        boolean changed = false;
        if (!this.axis.equals(newAxis)) {
            System.arraycopy(newAxis, 0, this.axis, 0, 3);
            this.x = this.axis[0];
            this.y = this.axis[1];
            this.z = this.axis[2];
            double norm = this.x * this.x + this.y * this.y + this.z * this.z;
            if (norm != 1.0) {
                norm = 1.0 / Math.sqrt(norm);
                this.x *= norm;
                this.y *= norm;
                this.z *= norm;
            }
            changed = true;
        }
        if (this.angle != theta) {
            this.angle = theta;
            this.sin = Math.sin(this.angle);
            this.cos = Math.cos(this.angle);
            changed = true;
        }
        if (changed) {
            this.computeMatrix(this.sin, this.cos);
            if (this.mElement != null) {
                this.mElement.addChange(256);
            }
        }
        return changed;
    }

    @Override
    protected void computeMatrix(double s, double c) {
        double t = 1.0 - c;
        this.matrix[0][0] = t * this.x * this.x + c;
        this.matrix[0][1] = t * this.x * this.y - s * this.z;
        this.matrix[0][2] = t * this.x * this.z + s * this.y;
        this.matrix[1][0] = t * this.x * this.y + s * this.z;
        this.matrix[1][1] = t * this.y * this.y + c;
        this.matrix[1][2] = t * this.y * this.z - s * this.x;
        this.matrix[2][0] = t * this.x * this.z - s * this.y;
        this.matrix[2][1] = t * this.y * this.z + s * this.x;
        this.matrix[2][2] = t * this.z * this.z + c;
        this.inverseMatrix[0][0] = this.matrix[0][0];
        this.inverseMatrix[1][0] = this.matrix[0][1];
        this.inverseMatrix[2][0] = this.matrix[0][2];
        this.inverseMatrix[0][1] = this.matrix[1][0];
        this.inverseMatrix[1][1] = this.matrix[1][1];
        this.inverseMatrix[2][1] = this.matrix[1][2];
        this.inverseMatrix[0][2] = this.matrix[2][0];
        this.inverseMatrix[1][2] = this.matrix[2][1];
        this.inverseMatrix[2][2] = this.matrix[2][2];
    }

    @Override
    public Object clone() {
        CustomAxisRotation m = new CustomAxisRotation();
        m.setAngleAndAxis(this.getAngle(), this.getAxis());
        m.origin = (double[])this.origin.clone();
        return m;
    }
}

