/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils.transformations;

import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.numerics.Matrix3DTransformation;

public abstract class AxisRotation
extends Matrix3DTransformation {
    protected double angle = 0.0;
    protected Element mElement;

    protected AxisRotation() {
        super(null);
        this.inverseMatrix = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    }

    public void setElement(Element element) {
        this.mElement = element;
    }

    @Override
    public double[] setOrigin(double[] origin) {
        if (this.mElement != null) {
            this.mElement.addChange(256);
        }
        return super.setOrigin(origin);
    }

    @Override
    public void setOrigin(double ox, double oy, double oz) {
        if (this.mElement != null) {
            this.mElement.addChange(256);
        }
        super.setOrigin(ox, oy, oz);
    }

    public boolean setAngle(double theta) {
        if (this.angle == theta) {
            return false;
        }
        this.angle = theta;
        this.computeMatrix(Math.sin(this.angle), Math.cos(this.angle));
        if (this.mElement != null) {
            this.mElement.addChange(256);
        }
        return true;
    }

    public double getAngle() {
        return this.angle;
    }

    protected abstract void computeMatrix(double var1, double var3);
}

