/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.display.TextLine;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementText;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public class SimpleElementText
extends SimpleElement {
    private double[] coordinates = new double[3];
    private double[] pixel = new double[3];
    private AffineTransform transform = new AffineTransform();

    public SimpleElementText(ElementText _element) {
        super(_element);
        this.objects = new Object3D[]{new Object3D(this, 0)};
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        if ((_cummulativeChange & 0x136) != 0) {
            this.computePosition();
            this.projectPoint();
        } else if ((_cummulativeChange & 0x40) != 0) {
            this.projectPoint();
        }
    }

    @Override
    public void styleChanged(int _change) {
        if (_change == 5) {
            TextLine textLine = ((ElementText)this.element).getTextLine();
            switch (this.style.getRelativePosition()) {
                default: {
                    textLine.setJustification(0);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    textLine.setJustification(2);
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    textLine.setJustification(1);
                    break;
                }
            }
        } else {
            super.styleChanged(_change);
        }
    }

    @Override
    public void draw(Graphics2D _g2, int _index) {
        Color theColor = this.element.getPanel().projectColor(this.style.getLineColor(), this.objects[0].getDistance());
        this.drawIt(_g2, theColor);
    }

    @Override
    public void drawQuickly(Graphics2D _g2) {
        this.drawIt(_g2, this.style.getLineColor());
    }

    private void computePosition() {
        System.arraycopy(Element.STD_ORIGIN, 0, this.coordinates, 0, 3);
        this.element.sizeAndToSpaceFrame(this.coordinates);
    }

    private void projectPoint() {
        System.arraycopy(this.coordinates, 0, this.pixel, 0, 3);
        this.element.getPanel().projectPosition(this.pixel);
        this.objects[0].setDistance(this.pixel[2] * this.style.getDepthFactor());
    }

    private void drawIt(Graphics2D _g2, Color _color) {
        ElementText textElement = (ElementText)this.element;
        TextLine textLine = textElement.getTextLine();
        textLine.setColor(_color);
        double angle = textElement.getRotationAngle();
        if (angle != 0.0) {
            AffineTransform originalTransform = _g2.getTransform();
            this.transform.setTransform(originalTransform);
            this.transform.rotate(-angle, this.pixel[0], this.pixel[1]);
            _g2.setTransform(this.transform);
            textLine.drawText(_g2, (int)this.pixel[0], (int)this.pixel[1]);
            _g2.setTransform(originalTransform);
        } else {
            textLine.drawText(_g2, (int)this.pixel[0], (int)this.pixel[1]);
        }
    }
}

