/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Vector4f;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementCone;
import org.opensourcephysics.drawing3d.ElementCylinder;
import org.opensourcephysics.drawing3d.ElementEllipsoid;
import org.opensourcephysics.drawing3d.ElementObject;
import org.opensourcephysics.drawing3d.ElementSphere;
import org.opensourcephysics.drawing3d.ElementSurface;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;
import org.opensourcephysics.drawing3d.utils.Style;
import org.opensourcephysics.tools.ResourceLoader;

public class Java3dStyle {
    private Style style;
    private float shininess = 50.0f;
    private Appearance appearance;
    private TransparencyAttributes transparency;
    private Texture texture1 = null;
    private Texture texture2 = null;
    private Texture2D tex2D = null;
    private ImageComponent2D image2D = null;
    private int imgWidth = 0;
    private int imgHeight = 0;

    Java3dStyle(Style _style) {
        this.style = _style;
        this.appearance = new Appearance();
        this.appearance.setCapability(8);
        this.appearance.setCapability(9);
        this.appearance.setCapability(15);
        this.appearance.setCapability(14);
        this.appearance.setCapability(1);
        this.appearance.setCapability(0);
        this.appearance.setCapability(3);
        this.appearance.setCapability(13);
        this.appearance.setCapability(12);
        this.appearance.setCapability(7);
        this.appearance.setCapability(17);
        this.appearance.setCapability(16);
        this.appearance.setCapability(5);
        this.appearance.setCapability(11);
        this.appearance.setCapability(21);
        this.appearance.setCapability(19);
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCapability(1);
        pa.setCapability(3);
        pa.setCapability(5);
        this.appearance.setPolygonAttributes(pa);
        LineAttributes la = new LineAttributes();
        la.setLineAntialiasingEnable(true);
        la.setLineWidth(this.style.getLineWidth());
        la.setCapability(1);
        this.appearance.setLineAttributes(la);
        PointAttributes pat = new PointAttributes();
        pat.setCapability(1);
        pat.setCapability(3);
        this.appearance.setPointAttributes(pat);
        RenderingAttributes ra = new RenderingAttributes();
        ra.setCapability(6);
        ra.setCapability(10);
        this.appearance.setRenderingAttributes(ra);
        this.transparency = new TransparencyAttributes();
        this.transparency.setCapability(3);
        this.transparency.setCapability(1);
        this.appearance.setTransparencyAttributes(this.transparency);
        Material m = new Material();
        m.setCapability(1);
        this.appearance.setMaterial(m);
        ColoringAttributes c = new ColoringAttributes();
        c.setCapability(1);
        this.appearance.setColoringAttributes(c);
        this.applyStyleChange(0);
        this.applyStyleChange(2);
        this.applyStyleChange(1);
        this.applyStyleChange(3);
        this.applyStyleChange(4);
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public void applyStyleChange(int _change) {
        switch (_change) {
            case 0: {
                Color lineColor = this.style.getLineColor();
                float[] lineComponents = lineColor.getRGBComponents(null);
                this.appearance.getRenderingAttributes().setIgnoreVertexColors(true);
                this.appearance.getColoringAttributes().setColor(lineComponents[0], lineComponents[1], lineComponents[2]);
                this.transparency.setTransparency(1.0f - lineComponents[3]);
                if (lineComponents[3] != 1.0f) {
                    this.appearance.getPolygonAttributes().setCullFace(0);
                    this.transparency.setTransparencyMode(1);
                } else {
                    this.appearance.getPolygonAttributes().setCullFace(1);
                    this.transparency.setTransparencyMode(4);
                }
                this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
                this.appearance.getMaterial().setShininess(this.shininess);
                this.appearance.getMaterial().setDiffuseColor(lineComponents[0], lineComponents[1], lineComponents[2]);
                break;
            }
            case 1: {
                this.appearance.getLineAttributes().setLineWidth(this.style.getLineWidth());
                break;
            }
            case 2: {
                Paint fillPaint = this.style.getFillColor();
                if (!(fillPaint instanceof Color)) break;
                Color fillColor = (Color)fillPaint;
                float[] fillComponents = fillColor.getRGBComponents(null);
                this.appearance.getMaterial().setAmbientColor((float)((double)fillComponents[0] * this.style.getAmbientFactor()), (float)((double)fillComponents[1] * this.style.getAmbientFactor()), (float)((double)fillComponents[2] * this.style.getAmbientFactor()));
                this.appearance.getMaterial().setDiffuseColor(fillComponents[0], fillComponents[1], fillComponents[2]);
                if (fillComponents[3] != 1.0f) {
                    this.transparency.setTransparencyMode(2);
                } else {
                    this.appearance.getPolygonAttributes().setCullFace(1);
                    this.transparency.setTransparencyMode(4);
                }
                this.transparency.setTransparency(1.0f - fillComponents[3]);
                this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
                this.appearance.getMaterial().setShininess(this.shininess);
                break;
            }
            case 3: {
                if (this.style.isDrawingFill()) {
                    this.turnFillOn();
                    break;
                }
                if (!this.style.isDrawingLines()) break;
                this.turnLinesOn();
                break;
            }
            case 4: {
                if (!this.style.isDrawingLines() || this.style.isDrawingFill()) break;
                this.turnLinesOn();
                break;
            }
            case 10: {
                this.setTexture(this.style.getTextures(), this.style.getTransparency(), this.style.getCombine());
                break;
            }
            case 8: {
                this.appearance.getPolygonAttributes().setPolygonOffset(0.1f);
                this.appearance.getPolygonAttributes().setPolygonOffsetFactor((float)this.style.getDepthFactor());
            }
        }
    }

    private void setTexture(Object[] textures, double transparency, boolean combine) {
        URL url;
        TransparencyAttributes ta = null;
        TextureUnitState[] textureUnitState = new TextureUnitState[2];
        boolean t1 = false;
        boolean t2 = false;
        if (transparency <= 0.0 || transparency >= 1.0) {
            transparency = Double.NaN;
        }
        if (textures[0] == null && textures[1] == null) {
            this.appearance.setTexture(null);
            return;
        }
        if (textures[0] != null) {
            if (textures[0] instanceof BufferedImage) {
                if (((BufferedImage)textures[0]).getWidth() != this.imgWidth || ((BufferedImage)textures[0]).getHeight() != this.imgHeight) {
                    this.image2D = new ImageComponent2D(2, ((BufferedImage)textures[0]).getWidth(), ((BufferedImage)textures[0]).getHeight());
                    this.image2D.setCapability(3);
                    this.tex2D = new Texture2D(1, 6, this.image2D.getWidth(), this.image2D.getHeight());
                    this.tex2D.setCapability(7);
                    this.tex2D.setCapability(1);
                    this.tex2D.setMagFilter(1);
                    this.image2D.set((BufferedImage)textures[0]);
                    this.tex2D.setImage(0, (ImageComponent)this.image2D);
                    this.tex2D.setEnable(true);
                    this.texture1 = this.tex2D;
                    this.imgWidth = ((BufferedImage)textures[0]).getWidth();
                    this.imgHeight = ((BufferedImage)textures[0]).getHeight();
                } else {
                    this.image2D.set((BufferedImage)textures[0]);
                    this.tex2D.setImage(0, (ImageComponent)this.image2D);
                    this.tex2D.setEnable(true);
                    this.texture1 = this.tex2D;
                }
            } else {
                url = ResourceLoader.getResource(textures[0].toString()).getURL();
                this.texture1 = new TextureLoader(url, 1, null).getTexture();
                this.texture1.setBoundaryModeT(3);
                this.texture1.setBoundaryModeS(3);
            }
        }
        if (textures[1] != null) {
            if (textures[1] instanceof BufferedImage) {
                this.texture2 = new TextureLoader((BufferedImage)textures[1], 5).getTexture();
            } else {
                url = ResourceLoader.getResource(textures[1].toString()).getURL();
                this.texture2 = new TextureLoader(url, 1, null).getTexture();
            }
            this.texture2.setBoundaryModeT(3);
            this.texture2.setBoundaryModeS(3);
        }
        if (!Double.isNaN(transparency)) {
            ta = new TransparencyAttributes();
            ta.setTransparencyMode(2);
            ta.setTransparency((float)transparency);
        }
        TextureAttributes texAttr1 = new TextureAttributes();
        if (combine) {
            texAttr1.setTextureMode(3);
        } else {
            texAttr1.setTextureMode(5);
        }
        TextureAttributes texAttr2 = new TextureAttributes();
        if (combine) {
            texAttr2.setTextureMode(2);
        } else {
            texAttr2.setTextureMode(5);
        }
        if (textures[0] != null && textures[1] != null) {
            textureUnitState[0] = new TextureUnitState(this.texture1, texAttr1, null);
            textureUnitState[0].setCapability(1);
            textureUnitState[1] = new TextureUnitState(this.texture2, texAttr2, null);
            textureUnitState[1].setCapability(1);
            t2 = true;
            t1 = true;
        } else if (textures[0] == null && textures[1] != null) {
            t1 = false;
            t2 = true;
        } else {
            t1 = true;
            t2 = false;
        }
        Element element = this.style.getElement();
        Java3dElement j3dElement = (Java3dElement)element.getImplementingObject();
        if (!j3dElement.isPrimitive()) {
            if (this.texture1 != null) {
                this.texture1.setMinFilter(5);
            }
            if (this.texture2 != null) {
                this.texture2.setMinFilter(5);
            }
            int flag = 0;
            float[] u = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            float[] v = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            if (element instanceof ElementSphere || element instanceof ElementEllipsoid || element instanceof ElementObject) {
                u[0] = 1.0f;
                v[2] = 1.0f;
            }
            if (element instanceof ElementCylinder) {
                u[0] = 1.0f;
                v[2] = 1.0f;
            }
            if (element instanceof ElementCone || element instanceof ElementSurface) {
                u[0] = 1.0f;
                v[1] = 1.0f;
            }
            TexCoordGeneration texGen = new TexCoordGeneration(flag, 1, new Vector4f(u), new Vector4f(v), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
            texGen.setCapability(1);
            texGen.setEnable(true);
            this.appearance.setTexCoordGeneration(texGen);
        } else {
            this.appearance.setTexCoordGeneration(null);
        }
        if (t1 && !t2 && j3dElement.isPrimitive()) {
            this.appearance.setTextureUnitState(null);
            this.appearance.setTexture(this.texture1);
        } else if (t1 && !t2 && !j3dElement.isPrimitive()) {
            this.appearance.setTexture(this.texture1);
        } else if (!t1 && t2 && j3dElement.isPrimitive()) {
            this.appearance.setTextureUnitState(null);
            this.appearance.setTexture(this.texture2);
        } else if (!t1 && t2 && !j3dElement.isPrimitive()) {
            this.appearance.setTexture(this.texture2);
        } else {
            this.appearance.setTextureUnitState(textureUnitState);
        }
        this.appearance.setTransparencyAttributes(ta);
        element.addChange(128);
    }

    private void turnFillOn() {
        Paint fill = this.style.getFillColor();
        this.appearance.getPolygonAttributes().setPolygonMode(2);
        this.appearance.getPolygonAttributes().setCullFace(1);
        if (fill instanceof Color) {
            this.appearance.getMaterial().setDiffuseColor(new Color3f((Color)fill));
        }
        this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
    }

    private void turnLinesOn() {
        this.appearance.getPolygonAttributes().setPolygonMode(1);
        this.appearance.getPolygonAttributes().setCullFace(0);
        this.appearance.getMaterial().setDiffuseColor(new Color3f(this.style.getLineColor()));
        this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
    }
}

