/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import org.opensourcephysics.drawing3d.ElementTrail;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementTrail
extends Java3dElement {
    private LineStripArray lines = null;
    private int[] stripVertexCounts;
    private int currentSize;
    private int temp;
    private double[] points;
    private static int previousSize = 2500;
    private BranchGroup bg = null;

    public Java3dElementTrail(ElementTrail _element) {
        super(_element);
        this.getAppearance().getLineAttributes().setLineAntialiasingEnable(true);
        this.getAppearance().getPointAttributes().setPointSize(0.1f);
        this.points = new double[3 * previousSize];
        this.temp = 0;
        this.currentSize = 0;
        this.initTrail();
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        double[][] p;
        super.processChanges(_change, _cummulativeChange);
        if ((_change & 8) != 0 && (p = ((ElementTrail)this.element).getData2D()) != null) {
            if (p[0].length == 1 && this.lines != null) {
                this.points = new double[3 * previousSize];
                this.initTrail();
            }
            this.currentSize = p[0].length;
            if (this.currentSize > 0 && this.currentSize < previousSize) {
                int i;
                if (this.currentSize > this.temp) {
                    i = this.temp;
                    while (i < this.currentSize) {
                        this.points[i * 3] = p[0][i];
                        this.points[i * 3 + 1] = p[1][i];
                        this.points[i * 3 + 2] = p[2][i];
                        ++i;
                    }
                    this.temp = this.currentSize;
                } else {
                    i = 0;
                    while (i < this.currentSize) {
                        this.points[i * 3] = p[0][i];
                        this.points[i * 3 + 1] = p[1][i];
                        this.points[i * 3 + 2] = p[2][i];
                        ++i;
                    }
                    this.temp = this.currentSize;
                }
            }
            if (this.currentSize >= previousSize || this.currentSize * 3 >= this.points.length) {
                double[] newArray = new double[this.temp * 3];
                System.arraycopy(this.points, 0, newArray, 0, this.temp * 3);
                this.points = new double[this.currentSize * 3 * 2];
                int i = 0;
                while (i < this.temp) {
                    this.points[i * 3] = newArray[i * 3];
                    this.points[i * 3 + 1] = newArray[i * 3 + 1];
                    this.points[i * 3 + 2] = newArray[i * 3 + 2];
                    ++i;
                }
                if (this.currentSize > previousSize || this.currentSize * 3 > this.points.length) {
                    i = this.temp;
                    while (i < this.currentSize) {
                        this.points[i * 3] = p[0][i];
                        this.points[i * 3 + 1] = p[1][i];
                        this.points[i * 3 + 2] = p[2][i];
                        ++i;
                    }
                    this.temp = this.currentSize;
                }
                previousSize = this.currentSize * 2;
                this.initTrail();
            }
            if (this.currentSize > 2) {
                this.stripVertexCounts[0] = Math.max(2, this.currentSize);
                this.lines.setStripVertexCounts(this.stripVertexCounts);
            }
            if (this.currentSize == ((ElementTrail)this.element).getMaximum()) {
                int i = 0;
                while (i < this.currentSize - 1) {
                    this.points[i * 3] = this.points[(i + 1) * 3];
                    this.points[i * 3 + 1] = this.points[(i + 1) * 3 + 1];
                    this.points[i * 3 + 2] = this.points[(i + 1) * 3 + 2];
                    ++i;
                }
            }
        }
    }

    private void initTrail() {
        this.stripVertexCounts = new int[]{Math.max(2, this.currentSize)};
        this.lines = new LineStripArray(this.points.length / 3, 129, this.stripVertexCounts);
        this.lines.setCapability(19);
        this.lines.setCapability(3);
        this.lines.setCapability(20);
        this.lines.setCapability(1);
        this.lines.setCoordRefDouble(this.points);
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)new Shape3D((Geometry)this.lines, this.getAppearance()));
        this.addNode((Node)this.bg);
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

