/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Vector3f;
import org.opensourcephysics.drawing3d.ElementSurface;
import org.opensourcephysics.drawing3d.java3d.Java3dAbstractTile;

public class Java3dElementSurface
extends Java3dAbstractTile {
    private BranchGroup bgSurface;
    private QuadArray lines = null;
    private Shape3D shape = null;
    private Appearance appLines = this.getAppLines();

    public Java3dElementSurface(ElementSurface _element) {
        super(_element);
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    protected Vector3f[] createStandardNormals(double[][][] data, int _nx, int _ny, int _nz) {
        int nTotal = data.length;
        Vector3f[] normals = new Vector3f[nTotal];
        int i = 0;
        while (i < nTotal) {
            Vector3f u1 = new Vector3f();
            u1.sub(new Vector3f((float)data[i][0][0], (float)data[i][0][1], (float)data[i][0][2]), new Vector3f((float)data[i][1][0], (float)data[i][1][1], (float)data[i][1][2]));
            Vector3f u2 = new Vector3f();
            u2.sub(new Vector3f((float)data[i][1][0], (float)data[i][1][1], (float)data[i][1][2]), new Vector3f((float)data[i][2][0], (float)data[i][2][1], (float)data[i][2][2]));
            normals[i] = new Vector3f();
            normals[i].cross(u1, u2);
            normals[i].normalize();
            ++i;
        }
        return normals;
    }

    @Override
    protected double[][][] createStandardTile(int _nx, int _ny, int _nz) {
        double[][][] data = ((ElementSurface)this.element).getData();
        if (data == null) {
            return new double[0][0][3];
        }
        int nu = data.length - 1;
        int nv = data[0].length - 1;
        double[][][] coord = new double[nu * nv][4][3];
        int tile = 0;
        int i = 0;
        int nvertex = nu * nv * 4;
        this.lines = new QuadArray(nvertex * 2, 3);
        this.lines.setCapability(0);
        this.lines.setCapability(1);
        int v = 0;
        while (v < nv) {
            int u = 0;
            while (u < nu) {
                int k = 0;
                while (k < 3) {
                    coord[tile][0][k] = data[u][v][k];
                    coord[tile][1][k] = data[u + 1][v][k];
                    coord[tile][2][k] = data[u + 1][v + 1][k];
                    coord[tile][3][k] = data[u][v + 1][k];
                    ++k;
                }
                this.lines.setCoordinate(i++, coord[tile][0]);
                this.lines.setCoordinate(i++, coord[tile][1]);
                this.lines.setCoordinate(i++, coord[tile][2]);
                this.lines.setCoordinate(i++, coord[tile][3]);
                this.lines.setCoordinate(i++, coord[tile][3]);
                this.lines.setCoordinate(i++, coord[tile][2]);
                this.lines.setCoordinate(i++, coord[tile][1]);
                this.lines.setCoordinate(i++, coord[tile][0]);
                ++u;
                ++tile;
            }
            ++v;
        }
        this.setLines();
        return coord;
    }

    private void setLines() {
        if (this.lines == null) {
            return;
        }
        this.shape = new Shape3D();
        this.shape.setGeometry((Geometry)this.lines);
        this.shape.setAppearance(this.appLines);
        int i = this.bg.indexOfChild((Node)this.bgSurface);
        this.bgSurface = new BranchGroup();
        this.bgSurface.setCapability(17);
        this.bgSurface.setCapability(14);
        this.bgSurface.setCapability(13);
        this.bgSurface.setCapability(12);
        this.bgSurface.addChild((Node)this.shape);
        if (this.bg.numChildren() > 1 && i != -1) {
            this.bg.setChild((Node)this.bgSurface, i);
        } else if (this.bg.numChildren() > 1 && i == -1) {
            this.bg.setChild((Node)this.bgSurface, 1);
        } else {
            this.bg.addChild((Node)this.bgSurface);
        }
    }

    private Appearance getAppLines() {
        Appearance app = new Appearance();
        app.setCapability(15);
        app.setCapability(14);
        app.setCapability(9);
        app.setCapability(12);
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCapability(1);
        pa.setCapability(3);
        pa.setCapability(5);
        app.setPolygonAttributes(pa);
        app.getPolygonAttributes().setPolygonMode(1);
        LineAttributes la = new LineAttributes();
        la.setLineAntialiasingEnable(true);
        la.setLineWidth(1.0f);
        la.setCapability(0);
        la.setCapability(1);
        app.setLineAttributes(la);
        RenderingAttributes ra = new RenderingAttributes();
        ra.setCapability(6);
        ra.setCapability(10);
        app.setRenderingAttributes(ra);
        TransparencyAttributes transparency = new TransparencyAttributes();
        transparency.setCapability(3);
        transparency.setCapability(1);
        app.setTransparencyAttributes(transparency);
        ColoringAttributes c = new ColoringAttributes();
        c.setCapability(1);
        app.setColoringAttributes(c);
        app.getColoringAttributes().setColor(0.0f, 0.0f, 0.0f);
        return app;
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        super.processChanges(_change, _cummulativeChange);
        if ((_change & 1) != 0) {
            this.appLines.getRenderingAttributes().setVisible(this.element.isVisible());
        }
    }

    @Override
    public void styleChanged(int _change) {
        if (this.appLines == null) {
            return;
        }
        if (_change == 4) {
            if (!this.element.getStyle().isDrawingLines()) {
                this.appLines.getRenderingAttributes().setVisible(false);
            } else {
                this.appLines.getRenderingAttributes().setVisible(true);
            }
        } else if (_change == 1) {
            this.appLines.getLineAttributes().setLineWidth(this.element.getStyle().getLineWidth());
        } else if (_change == 0) {
            Color lineColor = this.element.getStyle().getLineColor();
            float[] lineComponents = lineColor.getRGBComponents(null);
            this.appLines.getRenderingAttributes().setIgnoreVertexColors(true);
            this.appLines.getColoringAttributes().setColor(lineComponents[0], lineComponents[1], lineComponents[2]);
            this.appLines.getPolygonAttributes().setCullFace(0);
            this.appLines.getTransparencyAttributes().setTransparencyMode(4);
        } else if (_change == 10) {
            if (this.element.getStyle().getTextures()[0] == null && this.element.getStyle().getTextures()[1] == null) {
                this.appLines.getRenderingAttributes().setVisible(this.element.getStyle().isDrawingLines());
            } else {
                this.appLines.getRenderingAttributes().setVisible(false);
            }
            super.styleChanged(_change);
        } else {
            super.styleChanged(_change);
        }
    }
}

