/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import org.opensourcephysics.drawing3d.ElementCylinder;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementCylinder
extends Java3dElement {
    private Cylinder cylinder;
    private TransformGroup tg;
    private BranchGroup bg;
    private Transform3D t = new Transform3D();
    private Transform3D tq;
    private Quat4d quat;
    double[][][] standardCylinder;
    private int nr = 0;
    private int nu = 0;
    private int nv = 0;

    public Java3dElementCylinder(ElementCylinder _element) {
        super(_element);
        this.t.rotX(-1.5707963267948966);
        this.quat = new Quat4d(this.element.getPanel().getCamera().getQuatMapping());
        this.tq = new Transform3D();
        this.tq.set(this.quat);
        this.t.mul(this.tq);
        this.tg = new TransformGroup();
        this.tg.setCapability(14);
        this.tg.setCapability(13);
        this.tg.setTransform(this.t);
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        super.processChanges(_change, _cummulativeChange);
        if ((_change & 0x10) != 0) {
            int slices;
            int stacks;
            if (this.element.getStyle().getResolution().getType() == 1) {
                double dx = Math.abs(this.element.getSizeX()) / 2.0;
                double dy = Math.abs(this.element.getSizeY()) / 2.0;
                stacks = Math.max((int)Math.round(0.49 + Math.max(dx, dy) / this.element.getStyle().getResolution().getMaxLength()), 1);
                slices = Math.max((int)Math.round(0.49 + (double)Math.abs(((ElementCylinder)this.element).getMaximumAngle() - ((ElementCylinder)this.element).getMinimumAngle()) * (Math.PI / 180) * (dx + dy) / this.element.getStyle().getResolution().getMaxLength()), 1);
            } else {
                slices = this.element.getStyle().getResolution().getN2();
                stacks = this.element.getStyle().getResolution().getN3();
            }
            slices = Math.max(3, slices);
            this.nr = this.nv = (stacks = Math.max(1, stacks));
            this.nu = slices;
            if (((ElementCylinder)this.element).checkStandarCylinder() && this.element.getStyle().isDrawingFill()) {
                this.primitive = true;
                this.createPrimitiveCylinder();
            } else {
                this.primitive = false;
                this.createTileCylinder();
            }
            this.styleChanged(10);
        }
        if ((_change & 8) != 0) {
            if (((ElementCylinder)this.element).checkStandarCylinder() && this.element.getStyle().isDrawingFill()) {
                if (this.primitive) {
                    return;
                }
                this.primitive = true;
                this.createPrimitiveCylinder();
            } else {
                this.primitive = false;
                this.createTileCylinder();
            }
            this.styleChanged(10);
        }
    }

    private void createTileCylinder() {
        this.standardCylinder = ElementCylinder.createStandardCylinder(this.nr, this.nu, this.nv, ((ElementCylinder)this.element).getMinimumAngle(), ((ElementCylinder)this.element).getMaximumAngle(), ((ElementCylinder)this.element).isClosedTop(), ((ElementCylinder)this.element).isClosedBottom(), ((ElementCylinder)this.element).isClosedLeft(), ((ElementCylinder)this.element).isClosedRight());
        int totalN = this.standardCylinder.length;
        int tileSize = this.standardCylinder[0].length;
        Point3d[] coords = new Point3d[totalN * tileSize * 2];
        int n = 0;
        while (n < totalN) {
            int j = 0;
            while (j < tileSize) {
                coords[n * tileSize + j + totalN * tileSize] = new Point3d(this.standardCylinder[n][j][0], this.standardCylinder[n][j][1], this.standardCylinder[n][j][2]);
                if (j == 0) {
                    coords[n * tileSize + j + 3] = new Point3d(this.standardCylinder[n][j][0], this.standardCylinder[n][j][1], this.standardCylinder[n][j][2]);
                } else if (j == 1) {
                    coords[n * tileSize + j + 1] = new Point3d(this.standardCylinder[n][j][0], this.standardCylinder[n][j][1], this.standardCylinder[n][j][2]);
                } else if (j == 2) {
                    coords[n * tileSize + j - 1] = new Point3d(this.standardCylinder[n][j][0], this.standardCylinder[n][j][1], this.standardCylinder[n][j][2]);
                } else {
                    coords[n * tileSize + j - 3] = new Point3d(this.standardCylinder[n][j][0], this.standardCylinder[n][j][1], this.standardCylinder[n][j][2]);
                }
                ++j;
            }
            ++n;
        }
        GeometryInfo gi = new GeometryInfo(2);
        gi.setCoordinates(coords);
        NormalGenerator ng = new NormalGenerator();
        ng.setCreaseAngle((float)Math.toRadians(40.0));
        ng.generateNormals(gi);
        GeometryArray figura = gi.getGeometryArray();
        Shape3D shape = new Shape3D((Geometry)figura, this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)shape);
        this.tg = new TransformGroup();
        this.tg.setCapability(14);
        this.tg.setCapability(13);
        if (this.quat.z != 0.0 && this.quat.w != 0.0) {
            this.quat.y = -this.quat.z;
            this.quat.z = 0.0;
            this.tq.set(this.quat);
        }
        this.tg.setTransform(this.tq);
        this.tg.addChild((Node)this.bg);
        this.addNode((Node)this.tg);
    }

    private void createPrimitiveCylinder() {
        if (this.cylinder != null || this.standardCylinder != null) {
            this.tg.removeChild((Node)this.bg);
        }
        this.cylinder = new Cylinder(0.5f, 1.0f, 35, this.nu, this.nr, this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)this.cylinder);
        this.tg = new TransformGroup();
        this.tg.setCapability(14);
        this.tg.setCapability(13);
        this.tg.setTransform(this.t);
        this.tg.addChild((Node)this.bg);
        this.addNode((Node)this.tg);
    }

    @Override
    public void styleChanged(int _change) {
        super.styleChanged(_change);
        if (_change == 4 || _change == 3) {
            if (this.element.getStyle().isDrawingLines() && !this.element.getStyle().isDrawingFill()) {
                if (this.nr == 0 && this.nv == 0 && this.nu == 0) {
                    this.processChanges(16, 0);
                }
                this.primitive = false;
                this.createTileCylinder();
            }
            if (this.element.getStyle().isDrawingFill() && ((ElementCylinder)this.element).checkStandarCylinder()) {
                if (this.primitive) {
                    return;
                }
                if (this.nr == 0 && this.nv == 0 && this.nu == 0) {
                    this.processChanges(16, 0);
                }
                this.primitive = true;
                this.createPrimitiveCylinder();
            }
        }
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }
}

