/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Font;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.TextLine;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementText;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementText;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

public class ElementText
extends Element {
    private String text = "";
    private Font font;
    private boolean trueSize = false;
    private double rotationAngle = 0.0;
    private TextLine textLine = new TextLine();

    public ElementText() {
        this.setSizeXYZ(0.2, 0.2, 0.2);
        this.setFont(new Font("dialog", 0, 12));
        this.getStyle().setRelativePosition(0);
        this.getStyle().setFillColor(this.getStyle().getLineColor());
    }

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleElementText(this);
            }
            case 1: 
        }
        return new Java3dElementText(this);
    }

    public void setText(String _text) {
        if (this.text != null && this.text.equals(_text)) {
            return;
        }
        this.text = TeXParser.parseTeX(_text);
        this.textLine.setText(this.text);
        this.addChange(8);
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font _font) {
        this.font = _font;
        this.textLine.setFont(_font);
        this.addChange(8);
    }

    public Font getFont() {
        return this.font;
    }

    public void setRotationAngle(double _angle) {
        this.rotationAngle = _angle;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setTrueSize(boolean _s) {
        this.trueSize = _s;
        this.addChange(64);
        this.addChange(8);
    }

    public boolean isTrueSize() {
        return this.trueSize;
    }

    @Override
    public void setSizeX(double _sizeX) {
        if (!this.isTrueSize()) {
            _sizeX = 0.4;
        }
        super.setSizeX(_sizeX);
    }

    @Override
    public void setSizeY(double _sizeY) {
        if (!this.isTrueSize()) {
            _sizeY = 0.4;
        }
        super.setSizeY(_sizeY);
    }

    @Override
    public void setSizeZ(double _sizeZ) {
        if (!this.isTrueSize()) {
            _sizeZ = 0.4;
        }
        super.setSizeZ(_sizeZ);
    }

    public TextLine getTextLine() {
        return this.textLine;
    }

    @Override
    public double getDiagonalSize() {
        if (this.trueSize) {
            return 0.0;
        }
        return super.getDiagonalSize();
    }

    @Override
    protected void getExtrema(double[] min, double[] max) {
        if (this.trueSize) {
            System.arraycopy(Element.STD_ORIGIN, 0, min, 0, 3);
            System.arraycopy(Element.STD_ORIGIN, 0, max, 0, 3);
            this.sizeAndToSpaceFrame(min);
            this.sizeAndToSpaceFrame(max);
        } else {
            super.getExtrema(min, max);
        }
    }
}

