/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementCylinder;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementCylinder;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class ElementCylinder
extends Element {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngle = 0;
    private int maxAngle = 360;

    public ElementCylinder() {
        this.getStyle().setResolution(new Resolution(3, 12, 5));
    }

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleElementCylinder(this);
            }
            case 1: 
        }
        return new Java3dElementCylinder(this);
    }

    public void setClosedBottom(boolean close) {
        if (this.closedBottom == close) {
            return;
        }
        this.closedBottom = close;
        this.addChange(8);
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean close) {
        if (this.closedTop == close) {
            return;
        }
        this.closedTop = close;
        this.addChange(8);
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean close) {
        if (this.closedLeft == close) {
            return;
        }
        this.closedLeft = close;
        this.addChange(8);
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean close) {
        if (this.closedRight == close) {
            return;
        }
        this.closedRight = close;
        this.addChange(8);
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setMinimumAngle(int angle) {
        if (this.minAngle == angle) {
            return;
        }
        this.minAngle = Math.max(0, Math.min(360, angle));
        this.addChange(8);
    }

    public int getMinimumAngle() {
        return this.minAngle;
    }

    public void setMaximumAngle(int angle) {
        if (this.maxAngle == angle) {
            return;
        }
        this.maxAngle = Math.max(0, Math.min(360, angle));
        this.addChange(8);
    }

    public int getMaximumAngle() {
        return this.maxAngle;
    }

    public boolean checkStandarCylinder() {
        return this.closedBottom && this.closedTop && this.minAngle == 0 && this.maxAngle == 360;
    }

    public static double[][][] createStandardCylinder(int nr, int nu, int nz, double angle1, double angle2, boolean top, boolean bottom, boolean left, boolean right) {
        int k;
        int totalN = nu * nz;
        if (bottom) {
            totalN += nr * nu;
        }
        if (top) {
            totalN += nr * nu;
        }
        if (Math.abs(angle2 - angle1) < 360.0) {
            if (left) {
                totalN += nr * nz;
            }
            if (right) {
                totalN += nr * nz;
            }
        }
        double[][][] data = new double[totalN][4][3];
        double[] cosu = new double[nu + 1];
        double[] sinu = new double[nu + 1];
        int u = 0;
        while (u <= nu) {
            double angle = ((double)(nu - u) * angle1 + (double)u * angle2) * (Math.PI / 180) / (double)nu;
            cosu[u] = Math.cos(angle) / 2.0;
            sinu[u] = Math.sin(angle) / 2.0;
            ++u;
        }
        int tile = 0;
        double[] vectorx = Element.X_UNIT_VECTOR;
        double[] vectory = Element.Y_UNIT_VECTOR;
        double[] vectorz = Element.Z_UNIT_VECTOR;
        double[] center = new double[]{-vectorz[0] / 2.0, -vectorz[1] / 2.0, -vectorz[2] / 2.0};
        double aux = 1.0 / (double)nz;
        int j = 0;
        while (j < nz) {
            int u2 = 0;
            while (u2 < nu) {
                k = 0;
                while (k < 3) {
                    data[tile][0][k] = center[k] + cosu[u2] * vectorx[k] + sinu[u2] * vectory[k] + (double)j * aux * vectorz[k];
                    data[tile][1][k] = center[k] + cosu[u2 + 1] * vectorx[k] + sinu[u2 + 1] * vectory[k] + (double)j * aux * vectorz[k];
                    data[tile][2][k] = center[k] + cosu[u2 + 1] * vectorx[k] + sinu[u2 + 1] * vectory[k] + (double)(j + 1) * aux * vectorz[k];
                    data[tile][3][k] = center[k] + cosu[u2] * vectorx[k] + sinu[u2] * vectory[k] + (double)(j + 1) * aux * vectorz[k];
                    ++k;
                }
                ++u2;
                ++tile;
            }
            ++j;
        }
        if (bottom) {
            int u3 = 0;
            while (u3 < nu) {
                int i = 0;
                while (i < nr) {
                    int k2 = 0;
                    while (k2 < 3) {
                        data[tile][0][k2] = ((double)(nr - i) * center[k2] + (double)i * data[u3][0][k2]) / (double)nr;
                        data[tile][1][k2] = ((double)(nr - i - 1) * center[k2] + (double)(i + 1) * data[u3][0][k2]) / (double)nr;
                        data[tile][2][k2] = ((double)(nr - i - 1) * center[k2] + (double)(i + 1) * data[u3][1][k2]) / (double)nr;
                        data[tile][3][k2] = ((double)(nr - i) * center[k2] + (double)i * data[u3][1][k2]) / (double)nr;
                        ++k2;
                    }
                    ++i;
                    ++tile;
                }
                ++u3;
            }
        }
        if (top) {
            int ref = nu * (nz - 1);
            center[0] = vectorz[0];
            center[1] = vectorz[1];
            center[2] = vectorz[2] - 0.5;
            int u4 = 0;
            while (u4 < nu) {
                int i = 0;
                while (i < nr) {
                    int k3 = 0;
                    while (k3 < 3) {
                        data[tile][0][k3] = ((double)(nr - i) * center[k3] + (double)i * data[ref + u4][3][k3]) / (double)nr;
                        data[tile][1][k3] = ((double)(nr - i - 1) * center[k3] + (double)(i + 1) * data[ref + u4][3][k3]) / (double)nr;
                        data[tile][2][k3] = ((double)(nr - i - 1) * center[k3] + (double)(i + 1) * data[ref + u4][2][k3]) / (double)nr;
                        data[tile][3][k3] = ((double)(nr - i) * center[k3] + (double)i * data[ref + u4][2][k3]) / (double)nr;
                        ++k3;
                    }
                    ++i;
                    ++tile;
                }
                ++u4;
            }
        }
        if (Math.abs(angle2 - angle1) < 360.0) {
            center[0] = -vectorz[0] / 2.0;
            center[1] = -vectorz[1] / 2.0;
            center[2] = -vectorz[2] / 2.0;
            if (right) {
                aux = 1.0 / (double)nz;
                j = 0;
                while (j < nz) {
                    int i = 0;
                    while (i < nr) {
                        k = 0;
                        while (k < 3) {
                            data[tile][0][k] = ((double)(nr - i) * center[k] + (double)i * data[0][0][k]) / (double)nr + (double)j * aux * vectorz[k];
                            data[tile][1][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[0][0][k]) / (double)nr + (double)j * aux * vectorz[k];
                            data[tile][2][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[0][0][k]) / (double)nr + (double)(j + 1) * aux * vectorz[k];
                            data[tile][3][k] = ((double)(nr - i) * center[k] + (double)i * data[0][0][k]) / (double)nr + (double)(j + 1) * aux * vectorz[k];
                            ++k;
                        }
                        ++i;
                        ++tile;
                    }
                    ++j;
                }
            }
            if (left) {
                aux = 1.0 / (double)nz;
                int ref = nu - 1;
                int j2 = 0;
                while (j2 < nz) {
                    int i = 0;
                    while (i < nr) {
                        int k4 = 0;
                        while (k4 < 3) {
                            data[tile][0][k4] = ((double)(nr - i) * center[k4] + (double)i * data[ref][1][k4]) / (double)nr + (double)j2 * aux * vectorz[k4];
                            data[tile][1][k4] = ((double)(nr - i - 1) * center[k4] + (double)(i + 1) * data[ref][1][k4]) / (double)nr + (double)j2 * aux * vectorz[k4];
                            data[tile][2][k4] = ((double)(nr - i - 1) * center[k4] + (double)(i + 1) * data[ref][1][k4]) / (double)nr + (double)(j2 + 1) * aux * vectorz[k4];
                            data[tile][3][k4] = ((double)(nr - i) * center[k4] + (double)i * data[ref][1][k4]) / (double)nr + (double)(j2 + 1) * aux * vectorz[k4];
                            ++k4;
                        }
                        ++i;
                        ++tile;
                    }
                    ++j2;
                }
            }
        }
        return data;
    }
}

