/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.NumberField;

public class ScaleInspector
extends JDialog {
    protected DrawingPanel drawingPanel;
    protected JPanel dataPanel;
    protected JLabel xMinLabel;
    protected JLabel xMaxLabel;
    protected JLabel yMinLabel;
    protected JLabel yMaxLabel;
    protected NumberField xMinField;
    protected NumberField xMaxField;
    protected NumberField yMinField;
    protected NumberField yMaxField;
    protected JCheckBox xMinCheckBox;
    protected JCheckBox xMaxCheckBox;
    protected JCheckBox yMinCheckBox;
    protected JCheckBox yMaxCheckBox;
    protected JButton okButton;

    public ScaleInspector(DrawingPanel drawingPanel) {
        super(JOptionPane.getFrameForComponent(drawingPanel), JOptionPane.getFrameForComponent(drawingPanel) != null);
        this.drawingPanel = drawingPanel;
        this.setTitle(DialogsRes.SCALE_SCALE);
        this.setResizable(false);
        this.createGUI();
        this.pack();
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        final AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = ScaleInspector.this.xMinCheckBox.isSelected() ? Double.NaN : ScaleInspector.this.xMinField.getValue();
                double d2 = ScaleInspector.this.xMaxCheckBox.isSelected() ? Double.NaN : ScaleInspector.this.xMaxField.getValue();
                ScaleInspector.this.drawingPanel.setPreferredMinMaxX(d, d2);
                ScaleInspector.this.drawingPanel.paintImmediately(ScaleInspector.this.drawingPanel.getBounds());
                ScaleInspector.this.updateDisplay();
            }
        };
        final AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = ScaleInspector.this.yMinCheckBox.isSelected() ? Double.NaN : ScaleInspector.this.yMinField.getValue();
                double d2 = ScaleInspector.this.yMaxCheckBox.isSelected() ? Double.NaN : ScaleInspector.this.yMaxField.getValue();
                ScaleInspector.this.drawingPanel.setPreferredMinMaxY(d, d2);
                ScaleInspector.this.drawingPanel.paintImmediately(ScaleInspector.this.drawingPanel.getBounds());
                ScaleInspector.this.updateDisplay();
            }
        };
        this.xMinLabel = new JLabel(DialogsRes.SCALE_MIN);
        this.xMinField = new DecimalField(4, 2);
        this.xMinField.setMaximumSize(this.xMinField.getPreferredSize());
        this.xMinField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                abstractAction.actionPerformed(null);
                ScaleInspector.this.xMinField.requestFocusInWindow();
            }
        });
        this.xMinField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                abstractAction.actionPerformed(null);
            }
        });
        this.xMinCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.xMinCheckBox.addActionListener(abstractAction);
        this.xMaxLabel = new JLabel(DialogsRes.SCALE_MAX);
        this.xMaxField = new DecimalField(4, 2);
        this.xMaxField.setMaximumSize(this.xMaxField.getPreferredSize());
        this.xMaxField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                abstractAction.actionPerformed(null);
                ScaleInspector.this.xMaxField.requestFocusInWindow();
            }
        });
        this.xMaxField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                abstractAction.actionPerformed(null);
            }
        });
        this.xMaxCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.xMaxCheckBox.addActionListener(abstractAction);
        this.yMinLabel = new JLabel(DialogsRes.SCALE_MIN);
        this.yMinField = new DecimalField(4, 2);
        this.yMinField.setMaximumSize(this.yMinField.getPreferredSize());
        this.yMinField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                abstractAction2.actionPerformed(null);
                ScaleInspector.this.yMinField.requestFocusInWindow();
            }
        });
        this.yMinField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                abstractAction2.actionPerformed(null);
            }
        });
        this.yMinCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.yMinCheckBox.addActionListener(abstractAction2);
        this.yMaxLabel = new JLabel(DialogsRes.SCALE_MAX);
        this.yMaxField = new DecimalField(4, 2);
        this.yMaxField.setMaximumSize(this.yMaxField.getPreferredSize());
        this.yMaxField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                abstractAction2.actionPerformed(null);
                ScaleInspector.this.yMaxField.requestFocusInWindow();
            }
        });
        this.yMaxField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                abstractAction2.actionPerformed(null);
            }
        });
        this.yMaxCheckBox = new JCheckBox(DialogsRes.SCALE_AUTO);
        this.yMaxCheckBox.addActionListener(abstractAction2);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        String string = DialogsRes.SCALE_HORIZONTAL;
        jPanel3.setBorder(BorderFactory.createTitledBorder(string));
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        string = DialogsRes.SCALE_VERTICAL;
        jPanel4.setBorder(BorderFactory.createTitledBorder(string));
        this.dataPanel = new JPanel(new GridLayout(2, 1));
        this.dataPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add((Component)this.dataPanel, "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.xMaxLabel);
        box.add(this.xMaxField);
        box.add(this.xMaxCheckBox);
        jPanel3.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.xMinLabel);
        box.add(this.xMinField);
        box.add(this.xMinCheckBox);
        jPanel3.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.yMaxLabel);
        box.add(this.yMaxField);
        box.add(this.yMaxCheckBox);
        jPanel4.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.yMinLabel);
        box.add(this.yMinField);
        box.add(this.yMinCheckBox);
        jPanel4.add(box);
        this.dataPanel.add(jPanel4);
        this.dataPanel.add(jPanel3);
        this.xMinLabel.setAlignmentX(1.0f);
        this.xMaxLabel.setAlignmentX(1.0f);
        this.yMinLabel.setAlignmentX(1.0f);
        this.yMaxLabel.setAlignmentX(1.0f);
        this.xMinField.setAlignmentX(1.0f);
        this.xMaxField.setAlignmentX(1.0f);
        this.yMinField.setAlignmentX(1.0f);
        this.yMaxField.setAlignmentX(1.0f);
        this.xMinCheckBox.setAlignmentX(1.0f);
        this.xMaxCheckBox.setAlignmentX(1.0f);
        this.yMinCheckBox.setAlignmentX(1.0f);
        this.yMaxCheckBox.setAlignmentX(1.0f);
        this.okButton = new JButton(DialogsRes.SCALE_OK);
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScaleInspector.this.setVisible(false);
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel2.add((Component)jPanel5, "South");
        jPanel5.add(this.okButton);
    }

    public void updateDisplay() {
        this.xMinCheckBox.setSelected(this.drawingPanel.isAutoscaleXMin());
        this.xMinField.setEnabled(!this.xMinCheckBox.isSelected());
        this.xMinField.setValue(this.drawingPanel.getXMin());
        this.xMaxCheckBox.setSelected(this.drawingPanel.isAutoscaleXMax());
        this.xMaxField.setEnabled(!this.xMaxCheckBox.isSelected());
        this.xMaxField.setValue(this.drawingPanel.getXMax());
        this.yMinCheckBox.setSelected(this.drawingPanel.isAutoscaleYMin());
        this.yMinField.setEnabled(!this.yMinCheckBox.isSelected());
        this.yMinField.setValue(this.drawingPanel.getYMin());
        this.yMaxCheckBox.setSelected(this.drawingPanel.isAutoscaleYMax());
        this.yMaxField.setEnabled(!this.yMaxCheckBox.isSelected());
        this.yMaxField.setValue(this.drawingPanel.getYMax());
    }
}

