/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.RadioButtonInterface;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.TeXParser;

public class ControlTabbedPanel
extends ControlContainer {
    private static final int TABBEDPANEL_PROPERTIES = 3;
    private static final int TABBEDPANEL_SELECTED_INDEX = 2;
    private static final int TABBEDPANEL_TOOLTIP = 12;
    protected JTabbedPane tabbedpanel;
    private String[] tabTitles = null;
    private String[] tooltipsArray = null;
    protected IntegerValue internalValue;
    private boolean addingChild = false;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.tabbedpanel = new JTabbedPane(1);
        this.internalValue = new IntegerValue(-1);
        this.tabbedpanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                ControlTabbedPanel.this.internalValue.value = ControlTabbedPanel.this.tabbedpanel.getSelectedIndex();
                ControlTabbedPanel.this.variableChanged(2, ControlTabbedPanel.this.internalValue);
                if (ControlTabbedPanel.this.isUnderEjs && !ControlTabbedPanel.this.addingChild) {
                    ControlTabbedPanel.this.setFieldListValue(2, ControlTabbedPanel.this.internalValue);
                }
            }
        });
        return this.tabbedpanel;
    }

    @Override
    public void add(ControlElement _child) {
        int index;
        String header = _child.getProperty("name");
        if (this.tabTitles != null && (index = this.tabbedpanel.getTabCount()) < this.tabTitles.length) {
            header = this.tabTitles[index];
        }
        this.addingChild = true;
        if (header != null) {
            this.tabbedpanel.add(_child.getComponent(), header);
        } else {
            this.tabbedpanel.add(_child.getComponent(), "   ");
        }
        this.addingChild = false;
        if (_child instanceof RadioButtonInterface) {
            this.radioButtons.add((ControlSwingElement)_child);
            ((RadioButtonInterface)((Object)_child)).setControlParent(this);
        }
    }

    private void refreshTitles() {
        if (this.tabTitles == null) {
            int n = this.tabbedpanel.getTabCount();
            int i = 0;
            while (i < n) {
                String header = this.tabbedpanel.getComponentAt(i).getName();
                if (header != null) {
                    this.tabbedpanel.setTitleAt(i, header);
                }
                ++i;
            }
            return;
        }
        int n = Math.min(this.tabbedpanel.getTabCount(), this.tabTitles.length);
        int i = 0;
        while (i < n) {
            this.tabbedpanel.setTitleAt(i, this.tabTitles[i]);
            ++i;
        }
    }

    private void refreshToolTips() {
        if (this.tooltipsArray == null) {
            int n = this.tabbedpanel.getTabCount();
            int i = 0;
            while (i < n) {
                String tooltip = this.tabbedpanel.getComponentAt(i).getName();
                if (tooltip != null) {
                    this.tabbedpanel.setToolTipTextAt(i, tooltip);
                }
                ++i;
            }
            return;
        }
        int n = Math.min(this.tabbedpanel.getTabCount(), this.tooltipsArray.length);
        int i = 0;
        while (i < n) {
            this.tabbedpanel.setToolTipTextAt(i, this.tooltipsArray[i]);
            ++i;
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("placement");
            infoList.add("tabTitles");
            infoList.add("selected");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("placement")) {
            return "Placement|int";
        }
        if (_property.equals("tabTitles")) {
            return "String|String[] TRANSLATABLE";
        }
        if (_property.equals("tooltip")) {
            return "String|String[] TRANSLATABLE";
        }
        if (_property.equals("selected")) {
            return "int";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.tabbedpanel.getTabPlacement() == _value.getInteger()) break;
                this.tabbedpanel.setTabPlacement(_value.getInteger());
                break;
            }
            case 1: {
                if (_value.getObject() instanceof String[]) {
                    this.tabTitles = (String[])_value.getObject();
                } else {
                    String text = _value.getString();
                    if (text == null) {
                        this.tabTitles = null;
                    } else {
                        StringTokenizer tkn = new StringTokenizer(text, ",");
                        this.tabTitles = new String[tkn.countTokens()];
                        int c = 0;
                        while (tkn.hasMoreTokens()) {
                            this.tabTitles[c] = TeXParser.parseTeX(tkn.nextToken());
                            ++c;
                        }
                    }
                }
                this.refreshTitles();
                break;
            }
            case 2: {
                int tab = _value.getInteger();
                if (tab <= 0 || tab >= this.tabbedpanel.getTabCount()) break;
                this.tabbedpanel.setSelectedIndex(tab);
                break;
            }
            default: {
                super.setValue(_index - 3, _value);
                break;
            }
            case 12: {
                if (_value.getObject() instanceof String[]) {
                    this.tooltipsArray = (String[])_value.getObject();
                } else {
                    String text = _value.getString();
                    if (text == null) {
                        this.tooltipsArray = null;
                    } else {
                        StringTokenizer tkn = new StringTokenizer(text, ",");
                        this.tooltipsArray = new String[tkn.countTokens()];
                        int c = 0;
                        while (tkn.hasMoreTokens()) {
                            this.tooltipsArray[c] = TeXParser.parseTeX(tkn.nextToken());
                            ++c;
                        }
                    }
                }
                this.refreshToolTips();
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.tabbedpanel.setTabPlacement(1);
                break;
            }
            case 1: {
                this.tabTitles = null;
                this.refreshTitles();
                break;
            }
            case 2: {
                break;
            }
            default: {
                super.setDefaultValue(_index - 3);
                break;
            }
            case 12: {
                this.tooltipsArray = null;
                this.refreshToolTips();
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "TOP";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(_index - 3);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(_index - 3);
    }
}

