/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.border.EmptyBorder;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlMenu;
import org.colos.ejs.library.control.value.Value;

public class ControlMenuBar
extends ControlContainer {
    protected JMenuBar menubar;
    private Rectangle myBorder = null;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.menubar = new JMenuBar();
        return this.menubar;
    }

    @Override
    public boolean acceptsChild(ControlElement _child) {
        return _child.getVisual() instanceof JMenu;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("borderPainted");
            infoList.add("border");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("borderPainted")) {
            return "boolean";
        }
        if (_property.equals("border")) {
            return "Margins|Object";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.menubar.setBorderPainted(_value.getBoolean());
                break;
            }
            case 1: {
                Rectangle rect;
                if (!(_value.getObject() instanceof Rectangle) || (rect = (Rectangle)_value.getObject()) == this.myBorder) break;
                this.menubar.setBorder(new EmptyBorder(rect.x, rect.y, rect.width, rect.height));
                this.myBorder = rect;
                break;
            }
            default: {
                super.setValue(_index - 2, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.menubar.setBorderPainted(true);
                break;
            }
            case 1: {
                this.menubar.setBorder(null);
                this.myBorder = null;
                break;
            }
            default: {
                super.setDefaultValue(_index - 2);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "true";
            }
            case 1: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(_index - 2);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(_index - 2);
    }

    @Override
    public void add(ControlElement _child) {
        if (!(_child instanceof ControlMenu)) {
            return;
        }
        this.children.add(_child);
        this.menubar.add((JMenu)_child.getVisual());
        if (this.getControlWindow() != null) {
            this.getControlWindow().adjustSize();
        }
        this.propagateProperty(_child, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(_child, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(_child, "background", this.getPropagatedProperty("background"));
    }

    @Override
    public void remove(ControlElement _child) {
        if (!(_child instanceof ControlMenu)) {
            return;
        }
        this.children.remove(_child);
        this.menubar.remove(_child.getVisual());
        if (this.getControlWindow() != null) {
            this.getControlWindow().adjustSize();
        }
    }
}

