/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.ToolTipManager;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.TeXParser;

public class ControlMenu
extends ControlContainer {
    protected static final int MENU_ADDED = 5;
    protected JMenu menu;
    private String imageFile = null;
    private String labelString = "";
    private static List<String> infoList = null;

    public ControlMenu() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
    }

    @Override
    protected Component createVisual() {
        this.menu = new JMenu();
        return this.menu;
    }

    @Override
    public boolean acceptsChild(ControlElement _child) {
        if (_child.getVisual() instanceof JMenuItem) {
            return true;
        }
        return _child.getVisual() instanceof JSeparator;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("text");
            infoList.add("image");
            infoList.add("alignment");
            infoList.add("action");
            infoList.add("mnemonic");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("text")) {
            return "String NotTrimmed TRANSLATABLE";
        }
        if (_property.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (_property.equals("alignment")) {
            return "Alignment|int";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        if (_property.equals("mnemonic")) {
            return "String TRANSLATABLE";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.labelString.equals(_value.getString())) break;
                this.labelString = _value.getString();
                if (this.labelString == null) {
                    this.labelString = "";
                }
                this.menu.setText(TeXParser.parseTeX(_value.getString()));
                break;
            }
            case 1: {
                if (_value.getString().equals(this.imageFile)) {
                    return;
                }
                this.imageFile = _value.getString();
                this.menu.setIcon(this.getIcon(this.imageFile));
                break;
            }
            case 2: {
                this.menu.setHorizontalAlignment(_value.getInteger());
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, _value.getString());
                break;
            }
            case 4: {
                this.menu.setMnemonic(_value.getString().charAt(0));
                break;
            }
            default: {
                super.setValue(_index - 5, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.labelString = "";
                this.menu.setText("");
                break;
            }
            case 1: {
                this.imageFile = null;
                this.menu.setIcon(null);
                break;
            }
            case 2: {
                this.menu.setHorizontalAlignment(0);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 4: {
                this.menu.setMnemonic(-1);
                break;
            }
            default: {
                super.setDefaultValue(_index - 5);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "CENTER";
            }
            case 3: {
                return "<no_action>";
            }
            case 4: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(_index - 5);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(_index - 5);
    }
}

