/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d.utils;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.utils.ControlRotation3DTransformation;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.utils.transformations.AxisRotation;
import org.opensourcephysics.drawing3d.utils.transformations.CustomAxisRotation;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Transformation;

public class ControlRotationAxis3DTransformation
extends ControlRotation3DTransformation {
    private CustomAxisRotation axisRotation;
    private static List<String> infoList = null;

    @Override
    protected Transformation createTransformation() {
        this.origin = new double[]{0.0, 0.0, 0.0};
        this.axisRotation = new CustomAxisRotation();
        this.rotation = this.axisRotation;
        return this.rotation;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("position");
            infoList.add("axis");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("position")) {
            return "double[]";
        }
        if (_property.equals("axis")) {
            return "int[]|double[]";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public String getPropertyCommonName(String _property) {
        if (_property.equals("position")) {
            return "origin";
        }
        return super.getPropertyCommonName(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                super.setValue(ControlRotation3DTransformation.ORIGIN, _value);
                break;
            }
            case 1: {
                double[] newAxis = null;
                if (_value.getObject() instanceof double[]) {
                    newAxis = (double[])_value.getObject();
                    this.axisRotation.setAxis(newAxis);
                    break;
                }
                if (!(_value.getObject() instanceof int[])) break;
                int[] newAxisInt = (int[])_value.getObject();
                newAxis = new double[]{newAxisInt[0], newAxisInt[1], newAxisInt[2]};
                this.axisRotation.setAxis(newAxis);
                break;
            }
            default: {
                super.setValue(_index - 2, _value);
            }
        }
        if (this.isUnderEjs && this.myParent != null) {
            this.myParent.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                super.setDefaultValue(ControlRotation3DTransformation.ORIGIN);
                break;
            }
            case 1: {
                this.axisRotation.setAxis(new double[]{1.0, 0.0, 0.0});
                break;
            }
            default: {
                super.setDefaultValue(_index - 2);
            }
        }
        if (this.isUnderEjs && this.myParent != null) {
            this.myParent.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return super.getDefaultValueString(ControlRotation3DTransformation.ORIGIN);
            }
            case 1: {
                return "new double[]{1,0,0}";
            }
        }
        return super.getDefaultValueString(_index - 2);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(_index - 3);
    }

    @Override
    public Object clone() {
        ControlRotationAxis3DTransformation ct = new ControlRotationAxis3DTransformation();
        ct.enabled = this.enabled;
        ct.transformation = (Matrix3DTransformation)this.transformation.clone();
        ct.myParent = null;
        ct.rotation = (AxisRotation)ct.transformation;
        ct.axisRotation = (CustomAxisRotation)ct.transformation;
        ct.origin = (double[])this.origin.clone();
        return ct;
    }
}

