/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d.utils;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.utils.ControlTransformation3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.utils.transformations.AxisRotation;

public abstract class ControlRotation3DTransformation
extends ControlTransformation3D {
    public static int ORIGIN = 0;
    protected AxisRotation rotation;
    protected double[] origin;
    private static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.utils.transformations.AxisRotation";
    }

    @Override
    protected void setAffectedElement(Element element) {
        this.rotation.setElement(element);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("origin");
            infoList.add("angle");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("origin")) {
            return "double[]";
        }
        if (_property.equals("angle")) {
            return "int|double";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                double[] newOrigin = null;
                if (_value.getObject() instanceof double[]) {
                    newOrigin = (double[])_value.getObject();
                } else if (_value.getObject() instanceof int[]) {
                    int[] newOriginInt = (int[])_value.getObject();
                    newOrigin = new double[]{newOriginInt[0], newOriginInt[1], newOriginInt[2]};
                }
                if (newOrigin == null || newOrigin.equals(this.origin)) break;
                System.arraycopy(newOrigin, 0, this.origin, 0, 3);
                this.rotation.setOrigin(newOrigin);
                break;
            }
            case 1: {
                if (_value instanceof IntegerValue) {
                    this.rotation.setAngle((double)_value.getInteger() * (Math.PI / 180));
                    break;
                }
                this.rotation.setAngle(_value.getDouble());
                break;
            }
            default: {
                super.setValue(_index - 2, _value);
            }
        }
        if (this.isUnderEjs && this.myParent != null) {
            this.myParent.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.origin = new double[]{0.0, 0.0, 0.0};
                this.rotation.setOrigin(this.origin);
                break;
            }
            case 1: {
                this.rotation.setAngle(0.0);
                break;
            }
            default: {
                super.setDefaultValue(_index - 2);
            }
        }
        if (this.isUnderEjs && this.myParent != null) {
            this.myParent.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "new double[]{0,0,0}";
            }
            case 1: {
                return "0";
            }
        }
        return super.getDefaultValueString(_index - 2);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(_index - 3);
    }
}

