/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.collaborative;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.colos.ejs.library.collaborative.QuestionStudentTool;

public class ReceiverUDP
extends Thread {
    private boolean active;
    private InetAddress serverIP;
    private int portServer;
    private int portOpenned;
    private DatagramSocket socketUDP;
    private byte[] bufferUDPReceive;
    private byte[] bufferUDPSendChalk;
    private byte[] bufferUDPSend;
    private byte[] bufferUDPEndChalk;
    private DatagramPacket stepSend;
    private DatagramPacket stepReceive;
    private DatagramPacket stepReceiveChalk;
    private DatagramPacket stepSendChalk;
    private DatagramPacket endChalk;
    private QuestionStudentTool tool;
    private final String STEP = "step";
    private final String STEP_OK = "stepOK";
    private final String STEP_T = "steT";
    private final String END_CHALK = "endC";
    protected boolean stepOkTeacher = false;

    public ReceiverUDP(ThreadGroup group, InetAddress serverIP, int portServer, int portOpenned, QuestionStudentTool tool) {
        super(group, "Receiver UDP EJS");
        this.initialize();
        this.serverIP = serverIP;
        this.portServer = portServer;
        this.portOpenned = portOpenned;
        this.tool = tool;
        this.bufferUDPSend = "stepOK".getBytes();
        this.bufferUDPSendChalk = "step".getBytes();
        this.bufferUDPEndChalk = "endC".getBytes();
        this.stepSend = new DatagramPacket(this.bufferUDPSend, this.bufferUDPSend.length, this.serverIP, this.portServer);
        this.stepSendChalk = new DatagramPacket(this.bufferUDPSendChalk, this.bufferUDPSendChalk.length, this.serverIP, this.portServer);
        this.endChalk = new DatagramPacket(this.bufferUDPEndChalk, this.bufferUDPEndChalk.length, this.serverIP, this.portServer);
    }

    public ReceiverUDP(InetAddress serverIP, int portServer, int portOpenned, QuestionStudentTool tool) {
        this.initialize();
        this.serverIP = serverIP;
        this.portServer = portServer;
        this.portOpenned = portOpenned;
        this.tool = tool;
        this.bufferUDPSend = "stepOK".getBytes();
        this.bufferUDPSendChalk = "step".getBytes();
        this.bufferUDPEndChalk = "endC".getBytes();
        this.stepSend = new DatagramPacket(this.bufferUDPSend, this.bufferUDPSend.length, this.serverIP, this.portServer);
        this.stepSendChalk = new DatagramPacket(this.bufferUDPSendChalk, this.bufferUDPSendChalk.length, this.serverIP, this.portServer);
        this.endChalk = new DatagramPacket(this.bufferUDPEndChalk, this.bufferUDPEndChalk.length, this.serverIP, this.portServer);
    }

    private void initialize() {
        this.active = true;
        this.socketUDP = null;
        this.bufferUDPReceive = new byte[4];
        this.bufferUDPSendChalk = new byte[4];
        this.bufferUDPSend = new byte[6];
        this.bufferUDPEndChalk = new byte[4];
        this.stepSend = null;
        this.stepReceive = new DatagramPacket(this.bufferUDPReceive, this.bufferUDPReceive.length);
    }

    protected void connect() {
        try {
            this.socketUDP = new DatagramSocket(this.portOpenned);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.tool.setText(QuestionStudentTool.spanish ? "Error abriendo el canal UDP" : "Error openning UDP tunnel");
        }
    }

    protected void disconnect() {
        this.active = false;
        this.socketUDP.close();
        this.tool.setText(QuestionStudentTool.spanish ? "Cliente UDP terminado" : "Client UDP finished");
    }

    protected synchronized DatagramSocket getSocketUDP() {
        return this.socketUDP;
    }

    protected DatagramPacket getDatagramPacketUDPChalk() {
        return this.stepSendChalk;
    }

    protected DatagramPacket getDatagramPacketUDPChalkReceive() {
        return this.stepReceiveChalk;
    }

    protected DatagramPacket getDatagramPacketUDPEndChalk() {
        return this.endChalk;
    }

    @Override
    public void run() {
        while (this.active) {
            try {
                this.socketUDP.receive(this.stepReceive);
                String temp = new String(this.stepReceive.getData(), 0, this.stepReceive.getData().length);
                if (temp.equals("step")) {
                    this.tool.sim.step();
                    this.socketUDP.send(this.stepSend);
                } else if (temp.equals("steT")) {
                    this.stepOkTeacher = true;
                }
                Thread.yield();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.active = false;
                this.tool.setText(QuestionStudentTool.spanish ? "Error en el Thread UDP" : "Error in the UDP Thread");
            }
        }
    }
}

