/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.collaborative;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.colos.ejs.library.Animation;
import org.colos.ejs.library.collaborative.DataSocket;
import org.colos.ejs.library.collaborative.QuestionStudentTool;
import org.colos.ejs.library.collaborative.ReceiverUDP;
import org.opensourcephysics.display.OSPRuntime;

public class Receiver
extends Thread {
    private boolean active = true;
    private Socket serverSock;
    private InetAddress serverIP;
    private ObjectInputStream input;
    private ObjectOutputStream output;
    private Vector<DataSocket> Buffer;
    private String identity;
    private QuestionStudentTool tool;
    protected static String labelEnd = "FinishSession";
    protected static String labelID = "ID";
    protected static String labelNotEntry = "Can not entry";
    protected static String labelEntry = "Can entry";
    protected static String labelGiveChalk = "GiveChalk";
    protected static String labelGiveRequestChalk = "GiveChalk_OK";
    protected static String labelRemoveChalk = "RemoveChalk";
    protected static String labelRemoveRequestChalk = "RemoveChalk_OK";
    protected static String labelPlay = "play";
    protected static String labelPause = "pause";
    protected static String labelReset = "reset";
    protected static String labelVar = "variable";
    protected static String labelInitialize = "initialize";
    protected static String labelUpdate = "update";
    protected static String labelUpdateAfterModelAction = "updateAfterModelAction";
    protected static String labelExperiment = "experiment";
    protected static String labelStepRequest = "step_OK";
    protected static String labelExperimentCol = "expCol";
    private ReceiverUDP recUDP = null;

    public Receiver(ThreadGroup group, Vector<DataSocket> vectorDataSocket, String name, QuestionStudentTool tool) {
        super(group, "Receiver EJS");
        this.Buffer = vectorDataSocket;
        this.identity = name;
        this.tool = tool;
    }

    public Receiver(Vector<DataSocket> vectorDataSocket, String name, QuestionStudentTool tool) {
        this.Buffer = vectorDataSocket;
        this.identity = name;
        this.tool = tool;
    }

    protected boolean connect(String serverIPString, int port) {
        block6: {
            this.serverIP = InetAddress.getByName(serverIPString);
            this.serverSock = new Socket(this.serverIP, port);
            if (this.serverSock.isConnected()) break block6;
            System.out.println(QuestionStudentTool.spanish ? "Socket no conectado" : "Socket not connected");
            return false;
        }
        try {
            this.inputStream(this.serverSock);
            this.outStream(this.serverSock);
            DataSocket aux = new DataSocket(this.identity, null, labelID, null);
            this.output.writeObject(aux);
            System.out.println(QuestionStudentTool.spanish ? "Enviando objeto identificaci\ufffdn..." : "Sending the identification object...");
            this.recUDP = OSPRuntime.appletMode ? new ReceiverUDP(this.serverIP, port, this.serverSock.getLocalPort(), this.tool) : new ReceiverUDP(Animation.getThreadGroup(), this.serverIP, port, this.serverSock.getLocalPort(), this.tool);
            this.recUDP.connect();
            this.active = true;
            return true;
        }
        catch (UnknownHostException e) {
            this.tool.setText(QuestionStudentTool.spanish ? "Error en la conexi\ufffdn con el servidor" : "Error in the server connection");
            if (this.tool.isThereInterface()) {
                this.tool.acceptButton.setEnabled(true);
                this.tool.cancelButton.setEnabled(false);
                this.tool.userField.setEditable(true);
            }
            this.tool.sim.connectControls();
            return false;
        }
        catch (IOException e) {
            this.tool.setText(QuestionStudentTool.spanish ? "Error en los buffers" : "Error in the buffers");
            if (this.tool.isThereInterface()) {
                this.tool.acceptButton.setEnabled(true);
                this.tool.cancelButton.setEnabled(false);
                this.tool.userField.setEditable(true);
            }
            this.tool.sim.connectControls();
            return false;
        }
    }

    private void inputStream(Socket server) {
        try {
            this.input = new ObjectInputStream(new BufferedInputStream(server.getInputStream()));
        }
        catch (IOException e) {
            this.tool.setText(QuestionStudentTool.spanish ? "Error IOException intentando abrir el InputStream" : "Error IOException trying open the InputStream");
        }
    }

    private void outStream(Socket server) {
        try {
            this.output = new ObjectOutputStream(server.getOutputStream());
            this.output.flush();
        }
        catch (IOException e) {
            this.tool.setText(QuestionStudentTool.spanish ? "Error IOException intentando abrir el OutputStream" : "Error IOException trying open the OutputStream");
        }
    }

    protected void disconnectTeacher() {
        this.tool.setText(QuestionStudentTool.spanish ? "Desconectada la sesi\ufffdn del teacher" : "Disconnect session from the teacher");
        if (this.tool.isThereInterface()) {
            this.tool.acceptButton.setEnabled(true);
            this.tool.cancelButton.setEnabled(false);
            this.tool.userField.setEditable(true);
        }
        if (this.tool.sim.getChalk()) {
            this.tool.sim.setChalk(false);
        }
        this.tool.sim.connectControls();
    }

    protected void disconnect() {
        this.active = false;
        if (this.tool.sim.getChalk()) {
            this.tool.sim.setChalk(false);
        }
        DataSocket aux = new DataSocket(null, null, "Finish", null);
        try {
            this.output.writeObject(aux);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            this.output.close();
            this.input.close();
        }
        catch (IOException e) {
            this.tool.setText(QuestionStudentTool.spanish ? "Error IOException en los buffers" : "Error IOException close or open the OutputStream/InputStream");
        }
        try {
            this.serverSock.close();
        }
        catch (IOException e) {
            this.tool.setText(QuestionStudentTool.spanish ? "Error IOException cerrando el socket" : "Error IOException closing the socket");
        }
        this.Buffer.removeAllElements();
    }

    @Override
    public void run() {
        this.recUDP.start();
        while (this.active) {
            try {
                DataSocket aux = (DataSocket)this.input.readObject();
                if (aux.getSignal().equals(labelEnd)) {
                    this.active = false;
                    this.disconnectTeacher();
                    this.tool.stopTimer();
                    JOptionPane.showMessageDialog(null, QuestionStudentTool.spanish ? "El profesor ha cerrado la sesi\ufffdn" : "The teacher has closed the session", QuestionStudentTool.spanish ? "Informaci\ufffdn" : "Information", 1);
                } else if (aux.getSignal().equals(labelNotEntry)) {
                    this.active = false;
                    this.disconnectTeacher();
                    this.tool.setText(QuestionStudentTool.spanish ? "Hay muchos clientes" : "There are a lot of clients");
                } else if (aux.getSignal().equals(labelEntry)) {
                    this.tool.setText(QuestionStudentTool.spanish ? "Conectado" : "Connected");
                } else if (aux.getSignal().equals(labelPlay)) {
                    this.tool.sim.setIsPlaying(true);
                } else if (aux.getSignal().equals(labelPause)) {
                    this.tool.sim.pause();
                } else if (aux.getSignal().equals(labelReset)) {
                    this.tool.sim.reset();
                    this.tool.sim.disconnectControls();
                } else if (aux.getSignal().equals(labelVar)) {
                    this.tool.sim.setVariable(aux.getObject().toString(), aux.value);
                    this.tool.sim.update();
                } else if (aux.getSignal().equals(labelInitialize)) {
                    this.tool.sim.initialize();
                } else if (aux.getSignal().equals(labelUpdateAfterModelAction)) {
                    this.tool.sim.setVariables((String)aux.getObject());
                    this.tool.sim.update();
                } else if (aux.getSignal().equals(labelUpdate)) {
                    this.tool.sim.setVariables((String)aux.getObject());
                    this.tool.sim.update();
                } else if (aux.getSignal().equals(labelExperiment)) {
                    this.tool.sim.runExperiment((String)aux.getObject());
                } else if (aux.getSignal().equals(labelGiveChalk)) {
                    this.output.writeObject(new DataSocket(null, null, labelGiveRequestChalk, null));
                    this.tool.sim.setChalk(true);
                    this.tool.sim.connectControls();
                    this.tool.setText(QuestionStudentTool.spanish ? "Tiza asignada" : "Chalk assigned");
                } else if (aux.getSignal().equals(labelRemoveChalk)) {
                    this.output.writeObject(new DataSocket(null, null, labelRemoveRequestChalk, null));
                    this.recUDP.getSocketUDP().send(this.recUDP.getDatagramPacketUDPEndChalk());
                    this.tool.sim.setChalk(false);
                    this.tool.sim.disconnectControls();
                    this.tool.setText(QuestionStudentTool.spanish ? "Tiza quitada" : "Chalk removed");
                } else if (aux.getSignal().equals(labelExperimentCol)) {
                    this.tool.sim.setExperimentCol((String)aux.getObject());
                }
                Thread.yield();
            }
            catch (IOException e) {
                this.tool.setText(QuestionStudentTool.spanish ? "Error IOException leyendo el objeto" : "Error IOException reading the object");
                this.tool.setStateConnection(false);
                this.active = false;
                if (this.tool.sim.getChalk()) {
                    this.tool.sim.setChalk(false);
                }
                JOptionPane.showMessageDialog(null, QuestionStudentTool.spanish ? "El profesor ha cerrado temporalmente la sesi\ufffdn" : "The teacher has closed temporarily the session", QuestionStudentTool.spanish ? "Informaci\ufffdn" : "Information", 1);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                this.tool.setStateConnection(false);
                this.active = false;
                if (this.tool.sim.getChalk()) {
                    this.tool.sim.setChalk(false);
                }
                this.tool.sim.connectControls();
                JOptionPane.showMessageDialog(null, QuestionStudentTool.spanish ? "El profesor ha cerrado temporalmente la sesi\ufffdn" : "The teacher has closed temporarily the session", QuestionStudentTool.spanish ? "Informaci\ufffdn" : "Information", 1);
            }
        }
        this.tool.setText(QuestionStudentTool.spanish ? "Cliente finalizado" : "Client finished");
    }

    protected void finishClient() {
        this.disconnect();
        this.recUDP.disconnect();
    }

    protected DataSocket extractObject() {
        if (this.Buffer.size() <= 0) {
            return null;
        }
        DataSocket exit = this.Buffer.remove(0);
        return exit;
    }

    protected Vector<DataSocket> extractVectorDataSocket() {
        if (this.Buffer.size() <= 0) {
            return null;
        }
        Vector<DataSocket> VectorDataSocket = this.Buffer;
        this.Buffer = new Vector();
        return VectorDataSocket;
    }

    protected ObjectOutputStream getOutput() {
        return this.output;
    }

    protected ObjectInputStream getInput() {
        return this.input;
    }

    protected DatagramSocket getUDP() {
        return this.recUDP.getSocketUDP();
    }

    protected boolean getStepOk() {
        return this.recUDP.stepOkTeacher;
    }

    protected void setStepOk(boolean value) {
        this.recUDP.stepOkTeacher = false;
    }

    protected DatagramPacket getDataUDPChalk() {
        return this.recUDP.getDatagramPacketUDPChalk();
    }

    protected DatagramPacket getDataUDPChalkReceive() {
        return this.recUDP.getDatagramPacketUDPChalkReceive();
    }

    protected void setActive(boolean _state) {
        this.active = _state;
    }

    protected boolean getActive() {
        return this.active;
    }
}

