/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.collaborative;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.SocketException;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.colos.ejs.library.collaborative.ConfTeacherTool;
import org.colos.ejs.library.collaborative.ConnectionEJS;
import org.colos.ejs.library.collaborative.DataSocket;
import org.colos.ejs.library.collaborative.SessionEJS;

class ReadInputThread
extends Thread {
    private boolean active = true;
    private ConnectionEJS connection;
    private ObjectInputStream input;
    private Vector<DataSocket> buffer = new Vector();
    private SessionEJS parent;

    public ReadInputThread(ThreadGroup group, Vector<DataSocket> out, ConnectionEJS con, SessionEJS parent) {
        super(group, "Read input EJS");
        this.input = con.connectionInput();
        this.connection = con;
        this.parent = parent;
    }

    public ReadInputThread(Vector<DataSocket> out, ConnectionEJS con, SessionEJS parent) {
        this.input = con.connectionInput();
        this.connection = con;
        this.parent = parent;
    }

    public void stopReaderActive() {
        this.active = false;
    }

    public void stopReader() {
        this.active = false;
        try {
            this.input.close();
        }
        catch (IOException e) {
            System.err.println("Error IOException in ObjectInputStream " + e.getMessage());
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void run() {
        while (this.active) {
            try {
                DataSocket auxiliar = (DataSocket)this.input.readObject();
                if (auxiliar.getSignal().equals("Finish")) {
                    if (this.connection.getChalk()) {
                        this.parent.getMyList().sim.connectControls();
                        this.parent.getMyList().sim.setIsThereChalk(false);
                        this.connection.removeChalk();
                        this.parent.getMyList().activeTheTree();
                    }
                    this.active = false;
                } else if (auxiliar.getSignal().equals("GiveChalk_OK")) {
                    this.parent.getMyList().sim.disconnectControls();
                } else if (auxiliar.getSignal().equals("RemoveChalk_OK")) {
                    this.parent.getMyList().sim.connectControls();
                } else if (auxiliar.getSignal().equals("play")) {
                    this.parent.getMyList().sim.play();
                } else if (auxiliar.getSignal().equals("pause")) {
                    this.parent.getMyList().sim.pause();
                } else if (auxiliar.getSignal().equals("reset")) {
                    this.parent.getMyList().sim.reset();
                    this.parent.getMyList().sim.disconnectControls();
                } else if (auxiliar.getSignal().equals("variable")) {
                    this.parent.getMyList().sim.setVariable(auxiliar.getObject().toString(), auxiliar.value);
                    this.parent.getMyList().sim.update();
                    this.parent.getMyList().sim.apply(auxiliar.getObject().toString());
                } else if (auxiliar.getSignal().equals("initialize")) {
                    this.parent.getMyList().sim.initialize();
                } else if (auxiliar.getSignal().equals("updateAfterModelAction")) {
                    this.parent.getMyList().sim.setVariables((String)auxiliar.getObject());
                    this.parent.getMyList().sim.updateAfterModelAction();
                } else if (auxiliar.getSignal().equals("experiment")) {
                    this.parent.getMyList().sim.runExperiment((String)auxiliar.getObject());
                } else {
                    this.buffer.add(auxiliar);
                }
                Thread.yield();
            }
            catch (SocketException e) {
                System.err.println(ConfTeacherTool.spanish ? "ERROR en SocketException " : "ERROR in SocketException " + e.getMessage());
                this.active = false;
            }
            catch (IOException e) {
                System.err.println(ConfTeacherTool.spanish ? "ERROR en IOException. Conexi\ufffdn cerrada " : "ERROR in IOException. Connection Closed " + e.getMessage());
                this.active = false;
            }
            catch (ClassNotFoundException e) {
                System.err.println(ConfTeacherTool.spanish ? "ERROR en excepci\ufffdn ClasNotFound" : "ERROR ClasNotFound exception " + e.getMessage());
                this.active = false;
            }
        }
        if (this.connection.getChalk()) {
            this.parent.getMyList().sim.connectControls();
            this.parent.getMyList().sim.setIsThereChalk(false);
            this.connection.removeChalk();
            this.parent.getMyList().activeTheTree();
            JOptionPane.showMessageDialog(null, ConfTeacherTool.spanish ? "Estudiante desconectado\n Tiza devuelta" : "Student disconnected\n Chalk returned", ConfTeacherTool.spanish ? "Informaci\ufffdn" : "Information", 1);
        }
        System.out.println(ConfTeacherTool.spanish ? "Saliendo del lector..." : "Getting out of the reader...");
    }

    public DataSocket extractObject() {
        if (this.buffer.size() <= 0) {
            return null;
        }
        DataSocket exit = this.buffer.remove(0);
        System.out.println("Ver tama\ufffdo " + this.buffer.size());
        return exit;
    }
}

