/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.collaborative;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.colos.ejs.library.Animation;
import org.colos.ejs.library.collaborative.DataSocket;
import org.colos.ejs.library.collaborative.Receiver;
import org.colos.ejs.library.collaborative.SimulationCollaborative;
import org.opensourcephysics.display.OSPRuntime;

public class QuestionStudentTool {
    private static final String strAccept = "Accept";
    private static final String strCancel = "Cancel";
    private static QuestionStudentTool QUESTION_TOOL = null;
    private static Dimension defaultSize = new Dimension(300, 200);
    private Dimension dim;
    protected SimulationCollaborative sim;
    protected JFrame mainFrame = null;
    protected JButton acceptButton;
    protected JButton cancelButton;
    protected JLabel question;
    protected JLabel userLabel;
    protected JTextField userField;
    protected JPanel panel;
    protected JPanel panelUser;
    protected JTextArea statusArea;
    protected JScrollPane panelArea;
    protected ArrayList<String> _listParam = new ArrayList();
    protected Receiver client;
    protected Vector<DataSocket> vector = new Vector();
    protected String username = null;
    private boolean isCollaborative = false;
    protected static boolean spanish = false;
    private boolean connected = false;
    Timer timer = null;
    private int connections = 1;

    public QuestionStudentTool() {
        this(defaultSize, null, null);
    }

    public QuestionStudentTool(Dimension dim, SimulationCollaborative sim, ArrayList<String> _listP) {
        this.dim = dim;
        this.sim = sim;
        this._listParam = _listP;
        try {
            if (sim.getModel()._getParameter("is_collaborative") != null && sim.getModel()._getParameter("is_collaborative").equals("true")) {
                this.isCollaborative = true;
            }
            if (this.isCollaborative) {
                this.username = sim.getModel()._getParameter("username") != null ? sim.getModel()._getParameter("username") : "carlos";
                if (sim.getModel()._getParameter("language") != null && sim.getModel()._getParameter("language").equals("es")) {
                    spanish = true;
                }
            }
        }
        catch (Exception e) {
            System.err.println(spanish ? "No hay par\ufffdmetros para el applet" : "Null Student Applet Parameters");
        }
    }

    protected static QuestionStudentTool getTool(SimulationCollaborative sim, ArrayList<String> _listP) {
        if (QUESTION_TOOL == null) {
            QUESTION_TOOL = new QuestionStudentTool(defaultSize, sim, _listP);
        }
        return QUESTION_TOOL;
    }

    protected static QuestionStudentTool getTool(Dimension dim, SimulationCollaborative sim, ArrayList<String> _listP) {
        if (QUESTION_TOOL == null) {
            QUESTION_TOOL = new QuestionStudentTool(dim, sim, _listP);
        }
        return QUESTION_TOOL;
    }

    protected void createGUI() {
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.setSize(this.dim);
        this.mainFrame.setResizable(false);
        this.acceptButton = new JButton(strAccept);
        this.acceptButton.setHorizontalAlignment(0);
        this.acceptButton.setActionCommand(strAccept);
        this.cancelButton = new JButton(strCancel);
        this.cancelButton.setHorizontalAlignment(0);
        this.cancelButton.setActionCommand(strCancel);
        this.cancelButton.setEnabled(false);
        this.question = new JLabel();
        this.question.setForeground(new Color(255, 0, 0));
        this.question.setFont(new Font("Times", 2, 13));
        this.question.setText("Do you want to take a virtual class?");
        this.question.setHorizontalAlignment(0);
        this.userLabel = new JLabel("User");
        this.userLabel.setHorizontalAlignment(0);
        this.userField = new JTextField();
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.question, "Center");
        this.panelUser = new JPanel();
        this.panelUser.setLayout(new GridLayout(2, 2));
        this.panelUser.add(this.userLabel);
        this.panelUser.add(this.userField);
        this.panelUser.add(this.acceptButton);
        this.panelUser.add(this.cancelButton);
        this.panelUser.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), this.panelUser.getBorder()));
        this.statusArea = new JTextArea();
        this.statusArea.setFont(new Font("Courier", 1, 10));
        this.statusArea.setLineWrap(true);
        this.statusArea.setWrapStyleWord(true);
        this.panelArea = new JScrollPane(this.statusArea);
        this.panelArea.setVerticalScrollBarPolicy(22);
        this.panelArea.setPreferredSize(new Dimension(150, 80));
        this.panelArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Communication channel"), BorderFactory.createEmptyBorder(5, 5, 5, 5)), this.panelArea.getBorder()));
        MyActionListener myListener = new MyActionListener(this.mainFrame, this.statusArea, this.userField);
        this.acceptButton.addActionListener(myListener);
        this.cancelButton.addActionListener(myListener);
        this.mainFrame.getContentPane().add((Component)this.panel, "North");
        this.mainFrame.getContentPane().add((Component)this.panelUser, "Center");
        this.mainFrame.getContentPane().add((Component)this.panelArea, "South");
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainFrame.setLocation((d.width - QuestionStudentTool.defaultSize.width) / 2, (d.height - QuestionStudentTool.defaultSize.height) / 2);
    }

    protected void setText(String text) {
        if (this.mainFrame == null) {
            System.err.println(text);
            return;
        }
        this.statusArea.append("\n");
        this.statusArea.append(text);
    }

    protected boolean isThereInterface() {
        return this.mainFrame != null;
    }

    protected Receiver getReceiver() {
        return this.client;
    }

    protected void setVisible(boolean visible) {
        if (this.mainFrame == null) {
            return;
        }
        this.mainFrame.setVisible(visible);
    }

    protected boolean getIsCollaborative() {
        return this.isCollaborative;
    }

    protected void initReceiver() {
        if (this.timer == null) {
            this.timer = new Timer(4000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (!QuestionStudentTool.this.connected) {
                            QuestionStudentTool.this.client = OSPRuntime.appletMode ? new Receiver(QuestionStudentTool.this.vector, QuestionStudentTool.this.username, QUESTION_TOOL) : new Receiver(Animation.getThreadGroup(), QuestionStudentTool.this.vector, QuestionStudentTool.this.username, QUESTION_TOOL);
                            boolean state = QuestionStudentTool.this.client.connect(QuestionStudentTool.this._listParam.get(0), Integer.valueOf(QuestionStudentTool.this._listParam.get(1)));
                            System.out.println(String.valueOf(QuestionStudentTool.this._listParam.get(0)) + " " + Integer.valueOf(QuestionStudentTool.this._listParam.get(1)) + " " + QuestionStudentTool.this.connections);
                            if (state) {
                                QuestionStudentTool.this.sim.disconnectControls();
                                QuestionStudentTool.this.client.setPriority(10);
                                QuestionStudentTool.this.client.setActive(true);
                                QuestionStudentTool.this.client.start();
                                QuestionStudentTool.this.connections = 1;
                                JOptionPane.showMessageDialog(null, spanish ? "Conectado a la sesi\ufffdn colaborativa\nCierre la ventana para continuar" : "Connected to the collab session\nClose the window to continue", spanish ? "Informaci\ufffdn" : "Information", 1);
                            } else {
                                if (QuestionStudentTool.this.client.getActive()) {
                                    QuestionStudentTool.this.client.setActive(false);
                                }
                                QuestionStudentTool.this.sim.connectControls();
                                QuestionStudentTool questionStudentTool = QuestionStudentTool.this;
                                questionStudentTool.connections = questionStudentTool.connections + 1;
                                if (QuestionStudentTool.this.connections > 15) {
                                    QuestionStudentTool.this.stopTimer();
                                    QuestionStudentTool.this.connections = 1;
                                }
                            }
                            QuestionStudentTool.this.connected = state;
                        }
                    }
                    catch (Exception ep) {
                        ep.printStackTrace();
                    }
                }
            });
            this.timer.start();
        }
    }

    protected void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            System.out.println(spanish ? "El temporizador ha expirado" : "The timer has expired");
        }
    }

    protected void setStateConnection(boolean _state) {
        this.connected = _state;
    }

    protected void finishReceiver() {
        if (this.client != null) {
            this.client.disconnect();
            this.sim.connectControls();
        }
    }

    private class MyActionListener
    implements ActionListener {
        JTextArea _panelArea;
        String identification = null;

        MyActionListener(JFrame frame, JTextArea area, JTextField userField) {
            this._panelArea = area;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            if (action.equals(QuestionStudentTool.strAccept)) {
                if (QuestionStudentTool.this.userField.getText().equals("")) {
                    JOptionPane.showMessageDialog(QuestionStudentTool.this.mainFrame, "Student name", "Error in the identification", 0);
                } else {
                    this._panelArea.setText("Connecting with the teacher..");
                    QuestionStudentTool.this.acceptButton.setEnabled(false);
                    QuestionStudentTool.this.cancelButton.setEnabled(true);
                    QuestionStudentTool.this.userField.setEditable(false);
                    this.identification = QuestionStudentTool.this.userField.getText();
                    QuestionStudentTool.this.sim.disconnectControls();
                    QuestionStudentTool.this.client = OSPRuntime.appletMode ? new Receiver(QuestionStudentTool.this.vector, this.identification, QUESTION_TOOL) : new Receiver(Animation.getThreadGroup(), QuestionStudentTool.this.vector, this.identification, QUESTION_TOOL);
                    QuestionStudentTool.this.client.connect(QuestionStudentTool.this._listParam.get(0), Integer.valueOf(QuestionStudentTool.this._listParam.get(1)));
                    System.out.println(String.valueOf(QuestionStudentTool.this._listParam.get(0)) + " " + Integer.valueOf(QuestionStudentTool.this._listParam.get(1)));
                    QuestionStudentTool.this.client.setPriority(10);
                    QuestionStudentTool.this.client.start();
                }
            } else if (action.equals(QuestionStudentTool.strCancel)) {
                this._panelArea.append("\nDisconnecting...");
                QuestionStudentTool.this.client.disconnect();
                QuestionStudentTool.this.userField.setEditable(true);
                QuestionStudentTool.this.cancelButton.setEnabled(false);
                QuestionStudentTool.this.acceptButton.setEnabled(true);
                if (QuestionStudentTool.this.sim.getChalk()) {
                    QuestionStudentTool.this.sim.setChalk(false);
                }
                QuestionStudentTool.this.sim.connectControls();
            }
        }
    }
}

