/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.collaborative;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.colos.ejs.library.collaborative.DataNode;
import org.opensourcephysics.tools.ResourceLoader;

public class MyTreeCellRender
extends JLabel
implements TreeCellRenderer {
    private static final long serialVersionUID = 1L;
    protected static Font defaultFontRoot;
    protected static Font defaultFontStudent;
    protected static ImageIcon collapsedIconStudent;
    protected static ImageIcon expandedIconStudent;
    protected static ImageIcon collapsedIconRoot;
    protected static ImageIcon expandedIconRoot;
    protected static ImageIcon leafIcon;
    private boolean chalk = false;
    private boolean selected = false;
    protected static final Color SelectedBackgroundColor;

    static {
        SelectedBackgroundColor = Color.yellow;
        try {
            defaultFontRoot = new Font("Serif", 1, 16);
            defaultFontStudent = new Font("Serif", 1, 12);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            collapsedIconStudent = ResourceLoader.getIcon("/org/colos/ejs/library/collaborative/images/collapsed.gif");
            expandedIconStudent = ResourceLoader.getIcon("/org/colos/ejs/library/collaborative/images/expanded.gif");
            collapsedIconRoot = ResourceLoader.getIcon("/org/colos/ejs/library/collaborative/images/collapsedR.gif");
            expandedIconRoot = ResourceLoader.getIcon("/org/colos/ejs/library/collaborative/images/expandedR.gif");
            leafIcon = ResourceLoader.getIcon("/org/colos/ejs/library/collaborative/images/leaf.gif");
        }
        catch (Exception e) {
            System.out.println("Images not found: " + e);
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean _selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, this.selected, expanded, leaf, row, hasFocus);
        this.setText(stringValue);
        this.setToolTipText(stringValue);
        if (expanded) {
            if (((DefaultMutableTreeNode)value).isRoot()) {
                this.setIcon(expandedIconRoot);
            } else {
                this.setIcon(expandedIconStudent);
            }
        } else if (!leaf) {
            if (((DefaultMutableTreeNode)value).isRoot()) {
                this.setIcon(collapsedIconRoot);
            } else {
                this.setIcon(collapsedIconStudent);
            }
        } else {
            this.setIcon(leafIcon);
        }
        DataNode userObject = (DataNode)((DefaultMutableTreeNode)value).getUserObject();
        if (hasFocus) {
            this.setForeground(Color.red);
        } else {
            this.setForeground(userObject.getColor());
        }
        if (userObject.getFont() == null) {
            if (((DefaultMutableTreeNode)value).isRoot()) {
                this.setFont(defaultFontRoot);
            } else {
                this.setFont(defaultFontStudent);
            }
        } else {
            this.setFont(userObject.getFont());
        }
        this.selected = _selected;
        return this;
    }

    public void setChalk(boolean value) {
        this.chalk = value;
    }

    @Override
    public void paint(Graphics g) {
        Color cColor = null;
        Icon currentIcon = this.getIcon();
        if (this.chalk & this.selected) {
            cColor = Color.yellow;
        } else if (this.chalk) {
            this.setForeground(Color.blue);
        } else {
            cColor = this.getParent() != null ? this.getParent().getBackground() : this.getBackground();
        }
        g.setColor(cColor);
        if (currentIcon != null && this.getText() != null) {
            int offset = currentIcon.getIconWidth() + this.getIconTextGap();
            if (this.getComponentOrientation().isLeftToRight()) {
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            }
        } else {
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(g);
    }
}

