/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.collaborative;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.colos.ejs.library.Animation;
import org.colos.ejs.library.collaborative.ConfTeacherTool;
import org.colos.ejs.library.collaborative.DataNode;
import org.colos.ejs.library.collaborative.MyTreeCellRender;
import org.colos.ejs.library.collaborative.MyTreeNode;
import org.colos.ejs.library.collaborative.ServerEJS;
import org.colos.ejs.library.collaborative.SessionEJS;
import org.colos.ejs.library.collaborative.SimulationCollaborative;
import org.opensourcephysics.display.OSPRuntime;

public class ListStudentsTree {
    JFrame mainframe;
    JMenuBar menuBar;
    JMenuItem menuItemConnect;
    JMenuItem menuItemDisconnect;
    JMenuItem menuItemGive;
    JMenuItem menuItemRemove;
    JMenuItem menuItemRemoveStudent;
    JPanel panel;
    JTree treeStudents;
    JScrollPane scrollP;
    JTextArea txtArea;
    JScrollPane panelArea;
    DefaultTreeModel treeModel;
    protected static ListStudentsTree STUDENT_TREE = null;
    protected static Dimension defaultSize = new Dimension(300, 250);
    protected Dimension dim;
    protected SimulationCollaborative sim;
    protected int port;
    private String director_name = null;
    protected ServerEJS server;
    protected SessionEJS mySession;

    public ListStudentsTree() {
        this(defaultSize, null, 50001, "director");
    }

    public ListStudentsTree(Dimension dim, SimulationCollaborative simulation, int port, String directorname) {
        this.dim = dim;
        this.sim = simulation;
        this.port = port;
        this.director_name = directorname;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.err.println("Error loading L&F: " + exc);
        }
        this.createGUI();
        this.mySession = new SessionEJS(this);
        this.server = OSPRuntime.appletMode ? new ServerEJS(this.mySession, this.port) : new ServerEJS(Animation.getThreadGroup(), this.mySession, this.port);
    }

    protected static ListStudentsTree getTool(SimulationCollaborative simulation, int port, String directorname) {
        if (STUDENT_TREE == null) {
            STUDENT_TREE = new ListStudentsTree(defaultSize, simulation, port, directorname);
        }
        return STUDENT_TREE;
    }

    protected static ListStudentsTree getTool(Dimension dim, SimulationCollaborative simulation, int port, String directorname) {
        if (STUDENT_TREE == null) {
            STUDENT_TREE = new ListStudentsTree(dim, simulation, port, directorname);
        }
        return STUDENT_TREE;
    }

    protected static ListStudentsTree getTool() {
        return STUDENT_TREE;
    }

    private void createGUI() {
        this.menuBar = this.performMenuBar();
        this.panel = new JPanel(true);
        this.mainframe = new JFrame(ConfTeacherTool.spanish ? "Lista de conectados" : "List of connected people");
        this.mainframe.getContentPane().add("Center", this.panel);
        this.mainframe.setJMenuBar(this.menuBar);
        this.mainframe.setBackground(Color.lightGray);
        DefaultMutableTreeNode root = this.createNewNode(ConfTeacherTool.spanish ? "Director de sesi\ufffdn(" + this.director_name + ")" : "Session director(" + this.director_name + ")", null);
        this.treeModel = new DefaultTreeModel(root);
        this.treeStudents = new JTree(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this.treeStudents);
        this.treeStudents.setCellRenderer(new MyTreeCellRender());
        this.treeStudents.setRowHeight(-1);
        this.scrollP = new JScrollPane();
        this.scrollP.setPreferredSize(new Dimension(300, 250));
        this.scrollP.getViewport().add(this.treeStudents);
        this.panel.setLayout(new BorderLayout());
        this.panel.add("Center", this.scrollP);
        this.panel.add("South", this.performTextArea());
    }

    protected void finish() {
        this.mainframe.setVisible(false);
    }

    protected void setText(String text) {
        this.txtArea.append("\n" + text);
    }

    protected void setVisible(boolean visible) {
        this.mainframe.pack();
        this.mainframe.setVisible(visible);
    }

    protected boolean isVisible() {
        return this.mainframe.isVisible();
    }

    protected void addNode(String name, String[] _args) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeModel.getRoot();
        int newIndex = this.treeModel.getChildCount(parent);
        this.treeModel.insertNodeInto(this.createNewNode(name, _args), parent, newIndex);
    }

    protected void removeNode(String user) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeModel.getRoot();
        int i = 0;
        while (i < this.treeModel.getChildCount(parent)) {
            DefaultMutableTreeNode aux = (DefaultMutableTreeNode)this.treeModel.getChild(parent, i);
            if (user.equals(((DataNode)aux.getUserObject()).toString())) {
                this.treeModel.removeNodeFromParent(aux);
                return;
            }
            ++i;
        }
    }

    protected JMenuBar performMenuBar() {
        JMenuBar _menuBar = new JMenuBar();
        JMenu menu = new JMenu(ConfTeacherTool.spanish ? "Opciones" : "Options");
        _menuBar.add(menu);
        this.menuItemDisconnect = menu.add(new JMenuItem(ConfTeacherTool.spanish ? "Desconectar" : "Disconnect"));
        this.menuItemConnect = menu.add(new JMenuItem(ConfTeacherTool.spanish ? "Conectar" : "Connect"));
        this.menuItemConnect.setEnabled(false);
        this.menuItemDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListStudentsTree.this.disconnectItemAction(e);
            }
        });
        this.menuItemConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListStudentsTree.this.connectItemAction(e);
            }
        });
        JMenuItem menuItem = menu.add(new JMenuItem(ConfTeacherTool.spanish ? "Salir" : "Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListStudentsTree.this.mainframe.setVisible(false);
                ListStudentsTree.this.disconnectItemAction(e);
                STUDENT_TREE = null;
            }
        });
        menu = new JMenu(ConfTeacherTool.spanish ? "Estudiantes" : "Students");
        _menuBar.add(menu);
        this.menuItemRemoveStudent = menu.add(new JMenuItem(ConfTeacherTool.spanish ? "Borrar Alumno" : "Remove Student"));
        this.menuItemRemoveStudent.addActionListener(new RemoveAction());
        this.menuItemGive = menu.add(new JMenuItem(ConfTeacherTool.spanish ? "Dar la tiza" : "Give the chalk"));
        this.menuItemRemove = menu.add(new JMenuItem(ConfTeacherTool.spanish ? "Quitar la tiza" : "Remove the chalk"));
        this.menuItemRemove.setEnabled(false);
        this.menuItemGive.addActionListener(new GiveChalk(this.menuItemRemove, this.menuItemRemoveStudent));
        this.menuItemRemove.addActionListener(new RemoveChalk(this.menuItemGive, this.menuItemRemoveStudent));
        return _menuBar;
    }

    protected DefaultMutableTreeNode createNewNode(String name, String[] _args) {
        return new MyTreeNode((Object)new DataNode(null, Color.black, name), _args);
    }

    protected void connectItemAction(ActionEvent e) {
        this.activeTheTree();
        this.menuItemConnect.setEnabled(false);
        this.menuItemDisconnect.setEnabled(true);
        this.sim.setTeacherSim(true);
        this.mySession = new SessionEJS(this);
        this.server = OSPRuntime.appletMode ? new ServerEJS(this.mySession, this.port) : new ServerEJS(Animation.getThreadGroup(), this.mySession, this.port);
    }

    protected void disconnectItemAction(ActionEvent e) {
        this.menuItemConnect.setEnabled(true);
        this.menuItemDisconnect.setEnabled(false);
        this.server.disconnect();
        this.sim.setTeacherSim(false);
    }

    protected void activeTheTree() {
        MyTreeCellRender aux = (MyTreeCellRender)this.treeStudents.getCellRenderer();
        aux.setChalk(false);
        this.treeStudents.setEnabled(true);
        this.menuItemRemove.setEnabled(false);
        this.menuItemGive.setEnabled(true);
        this.menuItemRemoveStudent.setEnabled(true);
    }

    private JScrollPane performTextArea() {
        this.txtArea = new JTextArea();
        this.txtArea.setFont(new Font("Serif", 2, 14));
        this.txtArea.setLineWrap(true);
        this.txtArea.setWrapStyleWord(true);
        this.panelArea = new JScrollPane(this.txtArea);
        this.panelArea.setVerticalScrollBarPolicy(22);
        this.panelArea.setPreferredSize(new Dimension(250, 150));
        this.panelArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ConfTeacherTool.spanish ? "Canal de comunicaci\ufffdn" : "Communication channel"), BorderFactory.createEmptyBorder(5, 5, 5, 5)), this.panelArea.getBorder()));
        return this.panelArea;
    }

    class GiveChalk
    implements ActionListener {
        private JMenuItem remove;
        private JMenuItem removeStudent;

        GiveChalk(JMenuItem remove, JMenuItem removeStudent) {
            this.remove = remove;
            this.removeStudent = removeStudent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath pathNodeSelec = ListStudentsTree.this.treeStudents.getSelectionPath();
            if (pathNodeSelec == null) {
                return;
            }
            DefaultMutableTreeNode nodeSelec = (DefaultMutableTreeNode)pathNodeSelec.getLastPathComponent();
            if (nodeSelec.isRoot()) {
                return;
            }
            ListStudentsTree.this.mySession.giveChalkConnection(nodeSelec.getUserObject().toString());
            this.remove.setEnabled(true);
            this.removeStudent.setEnabled(false);
            ((JMenuItem)e.getSource()).setEnabled(false);
            MyTreeCellRender aux = (MyTreeCellRender)ListStudentsTree.this.treeStudents.getCellRenderer();
            aux.setChalk(true);
            ListStudentsTree.this.treeStudents.setEnabled(false);
        }
    }

    class RemoveAction
    implements ActionListener {
        RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath pathNodeSelec = ListStudentsTree.this.treeStudents.getSelectionPath();
            if (pathNodeSelec == null) {
                return;
            }
            DefaultMutableTreeNode nodeSelec = (DefaultMutableTreeNode)pathNodeSelec.getLastPathComponent();
            if (nodeSelec.isRoot()) {
                return;
            }
            ListStudentsTree.this.mySession.closeConnectionSession(nodeSelec.getUserObject().toString());
        }
    }

    class RemoveChalk
    implements ActionListener {
        private JMenuItem give;
        private JMenuItem removeStudent;

        RemoveChalk(JMenuItem give, JMenuItem removeStudent) {
            this.give = give;
            this.removeStudent = removeStudent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath pathNodeSelec = ListStudentsTree.this.treeStudents.getSelectionPath();
            if (pathNodeSelec == null) {
                return;
            }
            DefaultMutableTreeNode nodeSelec = (DefaultMutableTreeNode)pathNodeSelec.getLastPathComponent();
            if (nodeSelec.isRoot()) {
                return;
            }
            ListStudentsTree.this.mySession.removeChalkConnection(nodeSelec.getUserObject().toString());
            this.give.setEnabled(true);
            this.removeStudent.setEnabled(true);
            ((JMenuItem)e.getSource()).setEnabled(false);
            MyTreeCellRender aux = (MyTreeCellRender)ListStudentsTree.this.treeStudents.getCellRenderer();
            aux.setChalk(false);
            ListStudentsTree.this.treeStudents.setEnabled(true);
        }
    }
}

