/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.collaborative;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.colos.ejs.library.collaborative.DataSocket;
import org.colos.ejs.library.collaborative.QuestionStudentTool;

public class ConnectionEJS {
    private boolean ok = true;
    private Socket sock;
    private String identificator;
    private boolean student = true;
    private boolean chalk = false;
    private ObjectInputStream in;
    private ObjectOutputStream out;

    public ConnectionEJS(Socket con) {
        this.sock = con;
        try {
            this.out = new ObjectOutputStream(this.sock.getOutputStream());
            this.out.flush();
        }
        catch (IOException e) {
            System.err.println(QuestionStudentTool.spanish ? "Error en la apertura del buffer" : "Error in the Stream opening " + e.getMessage());
            this.ok = false;
        }
        try {
            this.in = new ObjectInputStream(this.sock.getInputStream());
        }
        catch (IOException e) {
            System.err.println(QuestionStudentTool.spanish ? "Error en el buffer de entrada" : "Error in the input Stream " + e.getMessage());
            this.ok = false;
        }
        if (this.ok) {
            try {
                DataSocket ds = (DataSocket)this.in.readObject();
                if (ds.getSignal().equals("ID")) {
                    this.identificator = ds.getIdentificator();
                    this.ok = true;
                } else {
                    this.ok = false;
                }
            }
            catch (IOException e) {
                System.err.println(QuestionStudentTool.spanish ? "Error en el objeto lector" : "Error in the Object reading of the Stream " + e.getMessage());
                this.ok = false;
            }
            catch (ClassNotFoundException e) {
                System.err.println(QuestionStudentTool.spanish ? "Error de ClassNotFoundException en el buffer" : "Error ClassNotFoundException of the Stream " + e.getMessage());
                this.ok = false;
            }
        }
    }

    protected void closeConnection() {
        try {
            this.out.flush();
            this.out.close();
            this.in.close();
            this.sock.close();
            this.ok = false;
        }
        catch (IOException e) {
            System.out.println(QuestionStudentTool.spanish ? "Error IOException en el cierre de la conexi\ufffdn " : "Error IOException in the closing of the connection " + e.getMessage());
        }
    }

    protected boolean activeConnection() {
        return this.ok;
    }

    protected String user() {
        return this.identificator;
    }

    protected boolean isStudent() {
        return this.student;
    }

    protected InetAddress IAddress() {
        return this.sock.getInetAddress();
    }

    protected Socket connectionSocket() {
        return this.sock;
    }

    protected ObjectInputStream connectionInput() {
        return this.in;
    }

    protected ObjectOutputStream connectionOutput() {
        return this.out;
    }

    protected void giveChalk() {
        this.chalk = true;
    }

    protected void removeChalk() {
        this.chalk = false;
    }

    protected boolean getChalk() {
        return this.chalk;
    }
}

