/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.collaborative;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.colos.ejs.library.collaborative.DataSend;
import org.colos.ejs.library.collaborative.ListStudentsTree;
import org.colos.ejs.library.collaborative.SimulationCollaborative;

public class ConfTeacherTool {
    private static final String http = "http://";
    private static final String strAccept = "accept";
    private String htmlGenerated = null;
    private String paramServer;
    private String paramPort;
    private InetAddress IPDirection;
    private Dimension dim;
    protected static ConfTeacherTool CONF_TEACH_TOOL = null;
    protected static Dimension defaultSize = new Dimension(500, 370);
    protected static String defaultServer = "http://localhost:8080";
    protected static String defaultPort = "50000";
    protected ListStudentsTree teacherGUI;
    protected SimulationCollaborative sim;
    protected ArrayList<String> ListFields = new ArrayList();
    JFrame mainFrame;
    JButton acceptButton;
    JButton cancelButton;
    JButton connectButton;
    JTextField ServerField;
    JTextField IPField;
    JTextField PortField;
    JTextField UserField;
    JPasswordField PasswordField;
    JTextField HtmlField;
    JLabel ServerLabel;
    JLabel PortLabel;
    JLabel UserLabel;
    JLabel PasswordLabel;
    JLabel HtmlLabel;
    JCheckBox IPCBox;
    JPanel panel;
    JPanel panelButton;
    JPanel panelButtonUp;
    JPanel panelButtonDown;
    JTextArea statusArea;
    JScrollPane panelArea;
    private boolean isCollaborative = false;
    protected static boolean spanish = false;
    private String directorname = null;

    public ConfTeacherTool() {
        this(defaultSize, null, defaultServer, defaultPort);
    }

    public ConfTeacherTool(Dimension dim, SimulationCollaborative sim, String paramServer, String paramPort) {
        this.dim = dim;
        this.sim = sim;
        this.paramServer = paramServer;
        this.paramPort = paramPort;
        try {
            if (sim.getModel()._getParameter("is_collaborative") != null && sim.getModel()._getParameter("is_collaborative").equals("true")) {
                this.isCollaborative = true;
            }
            if (this.isCollaborative) {
                this.paramPort = sim.getModel()._getParameter("Port_Teacher") != null ? sim.getModel()._getParameter("Port_Teacher") : "50000";
                if (sim.getModel()._getParameter("language") != null && sim.getModel()._getParameter("language").equals("es")) {
                    spanish = true;
                }
                this.directorname = sim.getModel()._getParameter("directorname") != null ? sim.getModel()._getParameter("directorname") : "teacher";
            }
        }
        catch (Exception e) {
            System.err.println(spanish ? "Par\ufffdmetros Moodle nulos" : "Null Teacher Applet Parameters");
        }
    }

    protected static ConfTeacherTool getTool(SimulationCollaborative simulation, String paramServer, String paramPort) {
        if (CONF_TEACH_TOOL == null) {
            CONF_TEACH_TOOL = new ConfTeacherTool(defaultSize, simulation, paramServer, paramPort);
        }
        return CONF_TEACH_TOOL;
    }

    protected static ConfTeacherTool getTool(Dimension dim, SimulationCollaborative simulation, String paramServer, String paramPort) {
        if (CONF_TEACH_TOOL == null) {
            CONF_TEACH_TOOL = new ConfTeacherTool(dim, simulation, paramServer, paramPort);
        }
        return CONF_TEACH_TOOL;
    }

    protected void createGUI() {
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.mainFrame = new JFrame("HTML generation");
        this.mainFrame.setSize(this.dim);
        this.acceptButton = new JButton("Accept");
        this.acceptButton.setHorizontalAlignment(0);
        this.acceptButton.setActionCommand(strAccept);
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfTeacherTool.this.acceptAction(evt);
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setHorizontalAlignment(0);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfTeacherTool.this.cancelAction(evt);
            }
        });
        this.connectButton = new JButton("Connect the student's server");
        this.connectButton.setHorizontalAlignment(0);
        this.connectButton.setEnabled(false);
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfTeacherTool.this.connectAction(evt);
            }
        });
        this.ServerField = new JTextField();
        this.ServerField.setText(this.paramServer);
        this.ServerField.setCaretPosition(this.ServerField.getText().length());
        this.UserField = new JTextField();
        this.PasswordField = new JPasswordField(10);
        this.IPField = new JTextField();
        this.IPDirection = this.getIPLocal();
        this.IPField.setText(this.IPDirection.getHostAddress());
        this.PortField = new JTextField();
        this.PortField.setText(this.paramPort);
        this.HtmlField = new JTextField();
        this.HtmlField.setEnabled(false);
        this.ServerLabel = new JLabel("Server URL");
        this.ServerLabel.setHorizontalAlignment(0);
        this.UserLabel = new JLabel("Identificator");
        this.UserLabel.setHorizontalAlignment(0);
        this.PasswordLabel = new JLabel("Password");
        this.PasswordLabel.setHorizontalAlignment(0);
        this.PortLabel = new JLabel("Port");
        this.PortLabel.setHorizontalAlignment(0);
        this.HtmlLabel = new JLabel();
        this.HtmlLabel.setForeground(new Color(255, 0, 0));
        this.HtmlLabel.setText("Web generated");
        this.HtmlLabel.setHorizontalAlignment(0);
        this.IPCBox = new JCheckBox();
        this.IPCBox.setText("Use local IP");
        this.IPCBox.setHorizontalAlignment(0);
        this.statusArea = new JTextArea();
        this.statusArea.setFont(new Font("Courier", 1, 12));
        this.statusArea.setLineWrap(true);
        this.statusArea.setWrapStyleWord(true);
        this.panelArea = new JScrollPane(this.statusArea);
        this.panelArea.setVerticalScrollBarPolicy(22);
        this.panelArea.setPreferredSize(new Dimension(100, 100));
        this.panelArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Communication channel"), BorderFactory.createEmptyBorder(5, 5, 5, 5)), this.panelArea.getBorder()));
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(6, 2));
        this.panel.add(this.ServerLabel);
        this.panel.add(this.ServerField);
        this.panel.add(this.IPCBox);
        this.panel.add(this.IPField);
        this.panel.add(this.PortLabel);
        this.panel.add(this.PortField);
        this.panel.add(this.UserLabel);
        this.panel.add(this.UserField);
        this.panel.add(this.PasswordLabel);
        this.panel.add(this.PasswordField);
        this.panel.add(this.HtmlLabel);
        this.panel.add(this.HtmlField);
        this.panelButtonUp = new JPanel();
        this.panelButtonUp.setLayout(new GridLayout(1, 2));
        this.panelButtonUp.add(this.acceptButton);
        this.panelButtonUp.add(this.cancelButton);
        this.panelButtonUp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 10, 7, 10), this.panelButtonUp.getBorder()));
        this.panelButtonDown = new JPanel();
        this.panelButtonDown.setLayout(new BorderLayout());
        this.panelButtonDown.add((Component)this.connectButton, "North");
        this.panelButtonDown.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), this.panelButtonDown.getBorder()));
        this.panelButton = new JPanel();
        this.panelButton.setLayout(new GridLayout(2, 1));
        this.panelButton.add(this.panelButtonUp);
        this.panelButton.add(this.panelButtonDown);
        this.mainFrame.getContentPane().add((Component)this.panel, "North");
        this.mainFrame.getContentPane().add((Component)this.panelButton, "Center");
        this.mainFrame.getContentPane().add((Component)this.panelArea, "South");
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainFrame.setLocation((d.width - ConfTeacherTool.defaultSize.width) / 2, (d.height - ConfTeacherTool.defaultSize.height) / 2);
    }

    private void cancelAction(ActionEvent evt) {
        this.setVisible(false);
        this.ServerField.setText(this.paramServer);
        this.UserField.setText("");
        this.PasswordField.setText("");
        this.IPField.setText(this.IPDirection.getHostAddress());
        this.PortField.setText(this.paramPort);
        this.HtmlField.setText("");
        this.statusArea.setText("");
    }

    private InetAddress getIPLocal() {
        InetAddress ipLocal = null;
        try {
            ipLocal = InetAddress.getLocalHost();
            try {
                Enumeration<NetworkInterface> ni = NetworkInterface.getNetworkInterfaces();
                while (ni.hasMoreElements()) {
                    NetworkInterface theNI = ni.nextElement();
                    Enumeration<InetAddress> ia = theNI.getInetAddresses();
                    while (ia.hasMoreElements()) {
                        InetAddress anAddress = ia.nextElement();
                        if (!anAddress.isSiteLocalAddress()) continue;
                        ipLocal = anAddress;
                    }
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return ipLocal;
    }

    private void acceptAction(ActionEvent evt) {
        if (this.htmlGenerated != null && ListStudentsTree.getTool() != null) {
            this.setText("A HTML page generated and a Server is Running");
            return;
        }
        this.ListFields.clear();
        this.ListFields.add(this.ServerField.getText());
        this.ListFields.add(this.IPField.getText());
        if (this.IPCBox.isSelected()) {
            this.ListFields.add("local");
        } else {
            this.ListFields.add("public");
        }
        this.ListFields.add(this.PortField.getText());
        this.ListFields.add(this.UserField.getText());
        this.ListFields.add(this.PasswordField.getText());
        if (!this.CheckEmptyFields(this.ListFields)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Some empty field", "Field Error", 0);
            return;
        }
        if (!this.PasswordField.getText().equals("ejs")) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error in the password", "Password Error", 0);
            return;
        }
        String pack = this.sim.getClass().getName();
        int index = pack.lastIndexOf(46);
        if (index >= 0) {
            pack = pack.substring(0, index);
        }
        pack = ConfTeacherTool.firstToUpper(pack);
        this.ListFields.add(pack);
        String _mainFrame = this.sim.getView().getElements().get(1).toString();
        this.ListFields.add(_mainFrame);
        String dimensionFrame = null;
        dimensionFrame = Integer.toString(this.sim.getView().getComponent((String)_mainFrame).getSize().width - 7);
        dimensionFrame = String.valueOf(dimensionFrame) + "-";
        dimensionFrame = String.valueOf(dimensionFrame) + Integer.toString(this.sim.getView().getComponent((String)_mainFrame).getSize().height - 15);
        this.ListFields.add(dimensionFrame);
        this.statusArea.setText("Sending Petition...");
        String response = this.petitionPost(new DataSend(this.ListFields, false));
        if (response.equals("Error")) {
            this.HtmlField.setText("No generated HTML");
        } else if ((response = response.substring(4, response.length())).contains("Error")) {
            this.setText(response);
            this.setText("No generated HTML");
        } else {
            this.HtmlField.setText(response);
            this.HtmlField.setEnabled(true);
            this.htmlGenerated = response;
            if (ListStudentsTree.getTool() == null) {
                this.connectButton.setEnabled(true);
            } else {
                this.setText("A server is just running");
            }
            this.setText("Generated HTML");
        }
    }

    private void connectAction(ActionEvent evt) {
        this.sim.setTeacherSim(true);
        this.sim.setStudentSim(false);
        this.teacherGUI = ListStudentsTree.getTool(this.sim, Integer.parseInt(this.PortField.getText()), this.directorname);
        this.teacherGUI.setVisible(true);
        this.connectButton.setEnabled(false);
    }

    protected void createStudentList() {
        this.sim.setTeacherSim(true);
        this.sim.setStudentSim(false);
        this.teacherGUI = ListStudentsTree.getTool(this.sim, Integer.parseInt(this.paramPort), this.directorname);
        this.teacherGUI.setVisible(true);
    }

    protected boolean getIsCollaborative() {
        return this.isCollaborative;
    }

    private boolean CheckEmptyFields(ArrayList<String> list) {
        int i = 0;
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            if (i == 0 ? it.next().equals(http) : it.next().equals("")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String dataSendtoDataPost(String[] _args) {
        String data = null;
        try {
            data = String.valueOf(URLEncoder.encode("IP", "UTF-8")) + "=" + URLEncoder.encode(_args[1], "UTF-8");
            data = String.valueOf(data) + "&" + URLEncoder.encode("IPLP", "UTF-8") + "=" + URLEncoder.encode(_args[2], "UTF-8");
            data = String.valueOf(data) + "&" + URLEncoder.encode("PORT", "UTF-8") + "=" + URLEncoder.encode(_args[3], "UTF-8");
            data = String.valueOf(data) + "&" + URLEncoder.encode("USER", "UTF-8") + "=" + URLEncoder.encode(_args[4], "UTF-8");
            data = String.valueOf(data) + "&" + URLEncoder.encode("PASSWORD", "UTF-8") + "=" + URLEncoder.encode(_args[5], "UTF-8");
            data = String.valueOf(data) + "&" + URLEncoder.encode("PACKAGE", "UTF-8") + "=" + URLEncoder.encode(_args[6], "UTF-8");
            data = String.valueOf(data) + "&" + URLEncoder.encode("MAINFRAME", "UTF-8") + "=" + URLEncoder.encode(_args[7], "UTF-8");
            data = String.valueOf(data) + "&" + URLEncoder.encode("DIMENSION", "UTF-8") + "=" + URLEncoder.encode(_args[8], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        }
        return data;
    }

    private static String firstToUpper(String _name) {
        return String.valueOf(_name.substring(0, 1).toUpperCase()) + _name.substring(1);
    }

    protected void setText(String text) {
        this.statusArea.append("\n");
        this.statusArea.append(text);
    }

    protected String petitionPost(DataSend send) {
        URL hostUrl = null;
        String html_response = null;
        try {
            String host = send.getHost();
            String dirHost = String.valueOf(host) + "/createHtmlStudent.php";
            hostUrl = new URL(dirHost);
            String[] _args = send.DataSendtoString();
            String sendDataPost = this.dataSendtoDataPost(_args);
            URLConnection conexion = hostUrl.openConnection();
            conexion.setDoOutput(true);
            OutputStreamWriter buffersalida = new OutputStreamWriter(conexion.getOutputStream());
            buffersalida.write(sendDataPost);
            buffersalida.flush();
            BufferedReader bufferentrada = new BufferedReader(new InputStreamReader(conexion.getInputStream()));
            String linea = null;
            while ((linea = bufferentrada.readLine()) != null) {
                html_response = String.valueOf(html_response) + linea;
            }
            buffersalida.close();
            bufferentrada.close();
        }
        catch (Exception e) {
            this.setText(e.getMessage());
            System.err.println(e.getMessage());
            return "Error";
        }
        return html_response;
    }

    protected void setVisible(boolean visible) {
        if (this.mainFrame == null) {
            return;
        }
        this.mainFrame.setResizable(false);
        this.mainFrame.setVisible(visible);
    }
}

