var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./SHMverticalsensor/verticalSHMsensoron2014-03-03_1624small.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["/org/opensourcephysics/resources/controls/images/close.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAh3ALEJFMhqBQAAK1gNXIiNFQArgVixCmQFgMKFVhIybLjCysCCGxdqxKaRFq2FJhsCwEZRoMmT2F4KXBFoZMyXKQXWtIhS5seDF136JIgwKM6cLGl6vAnTJ02SCpHeVEnQJsOCQTMG/djxKsKIEw1uXVjwoFVsAQEAOw==";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["./Android_robot.svg.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAAdCAYAAABfeMd1AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAgY0hSTQAAeiYAAICEAAD6AAAAgOgAAHUwAADqYAAAOpgAABdwnLpRPAAAABp0RVh0U29mdHdhcmUAUGFpbnQuTkVUIHYzLjUuMTFH80I3AAACl0lEQVRIS+1VvWsTYRgPdXJxEaGDjopjV538Kig6tEMHdbC4qqg4CQ7+AV1cBAU7KSRUkZLSRNO6VHImMY3aGqk1d7WWfuRKcxdz18SYvP5+R1IuaZJLLuAgHry8eZ/n95Hned97z+Np8ggh9meMbyvlculGMwzjzBNHfCtcwxxIe9e02LKivtbwuxfjIEY/xlBl5rqXeeKI79iEBBCHE98fCjU7vzn3Y7Q8s3BPTCdvCs5cM848nituDQ7ppiKF5q+Jp+FjTUfo83Whm0sSK+3IiG1IZz8qY9GzLQ2q5mPRcwJ4mby2jAD05PLrgRfvL1gGceWB1Z5G1TDOPHPEG+CR7/gAdDIqj+yIvkneFoFPVxuaMM589Q+Qh+eEo0mxZD72RfrbalN9deQVS9uPmh1XnqQeJtXsXKzVRjvlyK+czJ6d1uHHUbxMkqwGNbOg+oxCemVxY1y4HSb41KEedMPU92hGSvJGTlntmfhwWazrcVetqlZIvh86XHsjp4VmyGGPnA4Y9hbgDe7KpJ5PfZhMmrUmr7o0qeVT/79J05Yq6j/dLpSXs5+upc2prk5XPR/6P3Hjrk28jA9YwtPJW2JDn+3KhHzqUI+61OeddaBQ1Edx50RK5V/3VzPvUk73U6s8+dShHnSfUH/XhbmVW5CehY+7qoa8rdxXyfGqh/Pgl1Vv0Z+4iHIHa8yex86L8dkhwdleDXHEkwf+gKNJ5ZruA/hOdnt5se7KySN+F5uZt8eJIx6jry0DOyhjpKbsYrjsshDaw9keJ65j8Srhr5hophyqbVdQtypRg7o9rplKyHUlv0uFEX/ikrXJvsgZAbEZflI5+/BBYpx54lybQHAfP6XYaB1VvcX6cOVgHOGaceaJa2XyBwVrB+tcZqhVAAAAAElFTkSuQmCC";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./SHMverticalsensor/EF70-300MM_F45-56_side_om.jpg"]="data:image/jpeg;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
