var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./SHMxva/shmxva2014-02-20_0949small.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./SHMxva/lookangphoto.jpg"]="data:image/jpeg;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
