var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./SHMpendulum/pendulum_2014-02-19_1543small.png"]="data:image/png;base64,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";
__base64Images["./SHMpendulum/2014-11-07_1558s.png"]="data:image/png;base64,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";
__base64Images["./SHMpendulum/Simple_gravity_pendulum.svg.png"]="data:image/png;base64,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";
__base64Images["./SHMpendulum/2015-02-25_1000.png"]="data:image/png;base64,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";
__base64Images["./SHMpendulum/lookangphoto.jpg"]="data:image/jpeg;base64,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";
