angular.module('AppReader', ['ionic'])

.run(function($ionicPlatform) {
  $ionicPlatform.ready(function() {
    // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
    // for form inputs)
    if (window.cordova && window.cordova.plugins && window.cordova.plugins.Keyboard) {
      cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
      cordova.plugins.Keyboard.disableScroll(true);
    }
    if (window.StatusBar) { // org.apache.cordova.statusbar required
      StatusBar.styleDefault();
    }
  });
})

.factory('Pages', function() {
  return {
    selectLastItem: function($scope) {
      var index = window.localStorage['lastActivePage'];
      if (typeof index == "undefined") {
        $scope.setPage(0);
        return;
      }
      var intIndex = parseInt(index);
      if (isNaN(intIndex) || intIndex<0 || intIndex>=$scope.pages.length) intIndex =  0;
      //console.log ("index = "+index+" intIndex = "+intIndex);
      $scope.setPage(intIndex);
    },
    saveLastItem: function(index) {
      window.localStorage['lastActivePage'] = index;
    }
  };
})

.config(function($stateProvider, $urlRouterProvider) {
  $stateProvider
  .state('model_page', {
    url: '/model_page',
    templateUrl: 'model_page.html'
  })
  .state('references', {
    url: '/references',
    templateUrl: 'other_pages/references.html'
  })
  // if none of the above states are matched, use this as the fallback
  $urlRouterProvider.otherwise('/model_page');
})

.controller('AppReaderCtrl', function($scope, $state, Pages,
      $ionicHistory, $ionicSideMenuDelegate, $ionicScrollDelegate, $ionicModal,
      $window, $location, $anchorScroll, $timeout) {
    $scope.app_title = app_title;
    $scope.app_menu_title = app_menu_title;

    $scope.pages = app_toc;
    $scope.index = -1;
    $scope.currentPage = null;

    $scope.isIOS = ionic.Platform.isIOS();
    $scope.isAndroid = ionic.Platform.isAndroid();

    $ionicModal.fromTemplateUrl('other_pages/about.html', {
        scope: $scope
      }).then(function(modal) {
        $scope.modal = modal;
      });

    $scope.calculateDimensions = function(gesture) {
      $scope.dev_width = $window.innerWidth;
      $scope.dev_height = $window.innerHeight;
    };

    angular.element($window).bind('resize', function(){
      $scope.$apply(function() {
        $scope.calculateDimensions();
        $scope.setTitle($scope.index);
      });
    });

    $scope.calculateDimensions();

    function indexOfPage(page) {
      for (var i=0, n=$scope.pages.length; i<n; i++) {
        if ($scope.pages[i]==page) return i;
      }
      return 0;
    };

    $scope.setPage = function(index, anchor) {
      $scope.index = index;
      $ionicHistory.nextViewOptions({
                    disableAnimate: true,
                    disableBack: true
                  });
      var url;
      console.log ("Index = "+index);
      var page = $scope.pages[index];
      if (page.type=="references") url = 'references';
      else url = 'model_page';
      console.log ("URL = "+url);
      $scope.hidePrevious = index<=0;
      $scope.hideNext = index>=$scope.pages.length-1;
      $scope.currentPage = $scope.pages[index];
      $state.go(url);
      if (anchor) {
        //console.log ("Anchor = "+anchor);
        $timeout(function() {
          $location.hash(anchor);
          $ionicScrollDelegate.$getByHandle('ref_list');
          //handle.anchorScroll();
          //handle.scrollTop();
        }, 100);
      }
      //$ionicSideMenuDelegate.toggleLeft(false);
      Pages.saveLastItem(index);
      $scope.setTitle(index);
    };

    $scope.selectPage = function(page) {
      $scope.setPage(indexOfPage(page));
    };

    $scope.setTitle = function(index) {
      var itemTitle = $scope.pages[index].title;
  //    if ($scope.dev_width>800) $scope.header_title = book_title+" - "+itemTitle;
  //    else $scope.header_title = itemTitle;
      if ($scope.dev_width>800) $scope.app_title = app_title+" - ";
      else $scope.app_title = "";
      $scope.header_title = itemTitle;
    };

    $scope.toggleTOC = function(){
      $ionicSideMenuDelegate.toggleLeft();
    };

    selectRefs = function (anchor) {
      for (var i=0, n=$scope.pages.length; i<n; i++) {
        if ($scope.pages[i].type=="references") {
          $scope.setPage(i,anchor);
          return;
        }
      }
    };

    $scope.nextPage = function() {
      if ($scope.index<$scope.pages.length-1) $scope.setPage($scope.index+1);
    };

    $scope.previousPage = function() {
      if ($scope.index>0) $scope.setPage($scope.index-1);
    };

    Pages.selectLastItem($scope);

});
