/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;

public class InteractiveParticle
extends AbstractInteractiveElement {
    public static final int NONE = 0;
    public static final int ELLIPSE = 1;
    public static final int RECTANGLE = 2;
    public static final int ROUND_RECTANGLE = 3;
    public static final int WHEEL = 4;
    protected int shapeType = -1;
    protected boolean pixelSize = false;
    protected double a1 = 0.0;
    protected double b1 = 0.0;
    protected double[] coordinates = new double[6];
    protected double[] pixelOrigin = new double[5];
    protected Object3D[] objects = new Object3D[]{new Object3D(this, 0)};
    protected AffineTransform transform = new AffineTransform();

    public InteractiveParticle() {
        this(1);
    }

    public InteractiveParticle(int n) {
        this.setShapeType(n);
    }

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractiveParticle) {
            this.setShapeType(((InteractiveParticle)interactiveElement).shapeType);
            this.setPixelSize(((InteractiveParticle)interactiveElement).getPixelSize());
        }
    }

    public void setShapeType(int n) {
        if (this.shapeType == n) {
            return;
        }
        this.shapeType = n;
        switch (this.shapeType) {
            default: {
                this.style.displayObject = null;
                break;
            }
            case 1: 
            case 4: {
                this.style.displayObject = new Ellipse2D.Float();
                break;
            }
            case 2: {
                this.style.displayObject = new Rectangle2D.Float();
                break;
            }
            case 3: {
                this.style.displayObject = new RoundRectangle2D.Float();
            }
        }
    }

    public void setPixelSize(boolean bl) {
        this.pixelSize = bl;
    }

    public boolean getPixelSize() {
        return this.pixelSize;
    }

    protected double[] getPixelOrigin() {
        return this.pixelOrigin;
    }

    public void setSensitivity(int n) {
        this.actualSensitivity = n;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel);
        }
        if (this.positionEnabled) {
            if (this.actualSensitivity <= 0) {
                double d = this.pixelOrigin[0] - (double)n;
                double d2 = this.pixelOrigin[1] - (double)n2;
                if (this.style.angle != 0.0) {
                    double d3 = d * this.style.cosAngle - d2 * this.style.sinAngle;
                    d2 = d * this.style.sinAngle + d2 * this.style.cosAngle;
                    d = d3;
                }
                if (this.shapeType == 1 || this.shapeType == 4 ? d * d / (this.pixelOrigin[2] * this.pixelOrigin[2]) + d2 * d2 / (this.pixelOrigin[3] * this.pixelOrigin[3]) < 0.25 : Math.abs(d) < this.pixelOrigin[2] / 2.0 && Math.abs(d2) < this.pixelOrigin[3] / 2.0) {
                    return new InteractionTargetElementPosition(this);
                }
            } else if (Math.abs(this.pixelOrigin[0] - (double)n) < (double)this.actualSensitivity && Math.abs(this.pixelOrigin[1] - (double)n2) < (double)this.actualSensitivity) {
                return new InteractionTargetElementPosition(this);
            }
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        return this.objects;
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        Color color = drawingPanel3D.projectColor(this.style.edgeColor, this.objects[0].distance);
        Paint paint = this.style.fillPattern;
        if (paint instanceof Color) {
            paint = drawingPanel3D.projectColor((Color)paint, this.objects[0].distance);
        }
        this.drawIt(graphics2D, color, paint);
    }

    public void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged || drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        this.drawIt(graphics2D, this.style.edgeColor, this.style.fillPattern);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        this.projectPoints(drawingPanel);
        this.drawIt((Graphics2D)graphics, this.style.edgeColor, this.style.fillPattern);
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        double d;
        double d2;
        if (this.group != null) {
            this.coordinates[0] = this.group.x + this.x * this.group.sizex;
            this.coordinates[1] = this.group.y + this.y * this.group.sizey;
            this.coordinates[2] = this.group.z + this.z * this.group.sizez;
            this.coordinates[3] = this.sizex * this.group.sizex;
            this.coordinates[4] = this.sizey * this.group.sizey;
            this.coordinates[5] = this.sizez * this.group.sizez;
        } else {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.coordinates[3] = this.sizex;
            this.coordinates[4] = this.sizey;
            this.coordinates[5] = this.sizez;
        }
        drawingPanel.project(this.coordinates, this.pixelOrigin);
        if (this.pixelSize) {
            this.pixelOrigin[2] = this.sizex;
            this.pixelOrigin[3] = this.sizey;
        }
        this.objects[0].distance = this.pixelOrigin[4];
        switch (this.style.position) {
            default: {
                d2 = this.pixelOrigin[2] / 2.0;
                d = this.pixelOrigin[3] / 2.0;
                break;
            }
            case 1: {
                d2 = this.pixelOrigin[2] / 2.0;
                d = 0.0;
                break;
            }
            case 2: {
                d2 = this.pixelOrigin[2] / 2.0;
                d = this.pixelOrigin[3];
                break;
            }
            case 3: {
                d2 = this.pixelOrigin[2];
                d = this.pixelOrigin[3] / 2.0;
                break;
            }
            case 7: {
                d2 = this.pixelOrigin[2];
                d = this.pixelOrigin[3];
                break;
            }
            case 5: {
                d2 = this.pixelOrigin[2];
                d = 0.0;
                break;
            }
            case 4: {
                d2 = 0.0;
                d = this.pixelOrigin[3] / 2.0;
                break;
            }
            case 8: {
                d2 = 0.0;
                d = this.pixelOrigin[3];
                break;
            }
            case 6: {
                d2 = 0.0;
                d = 0.0;
            }
        }
        this.a1 = this.pixelOrigin[0] - d2;
        this.b1 = this.pixelOrigin[1] - d;
        this.hasChanged = false;
        this.panelWithValidProjection = drawingPanel;
    }

    private void drawIt(Graphics2D graphics2D, Color color, Paint paint) {
        if (!(this.style.displayObject instanceof RectangularShape)) {
            graphics2D.setColor(color);
            graphics2D.drawOval((int)this.pixelOrigin[0], (int)this.pixelOrigin[1], 1, 1);
            return;
        }
        RectangularShape rectangularShape = (RectangularShape)this.style.displayObject;
        AffineTransform affineTransform = graphics2D.getTransform();
        this.transform.setTransform(affineTransform);
        this.transform.rotate(-this.style.angle, this.pixelOrigin[0], this.pixelOrigin[1]);
        graphics2D.setTransform(this.transform);
        rectangularShape.setFrame(this.a1, this.b1, this.pixelOrigin[2], this.pixelOrigin[3]);
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(rectangularShape);
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(this.style.edgeStroke);
        if (this.shapeType == 4) {
            int n = (int)(this.b1 + this.pixelOrigin[3] / 2.0);
            graphics2D.drawLine((int)this.a1, n, (int)(this.a1 + this.pixelOrigin[2]), n);
            n = (int)(this.a1 + this.pixelOrigin[2] / 2.0);
            graphics2D.drawLine(n, (int)this.b1, n, (int)(this.b1 + this.pixelOrigin[3]));
        }
        graphics2D.draw(rectangularShape);
        graphics2D.setTransform(affineTransform);
    }

    public double getXMin() {
        if (!this.pixelSize) {
            return super.getXMin();
        }
        if (this.group == null) {
            return this.x;
        }
        return this.group.x + this.x;
    }

    public double getXMax() {
        if (!this.pixelSize) {
            return super.getXMax();
        }
        if (this.group == null) {
            return this.x;
        }
        return this.group.x + this.x;
    }

    public double getYMin() {
        if (!this.pixelSize) {
            return super.getYMin();
        }
        if (this.group == null) {
            return this.y;
        }
        return this.group.y + this.y;
    }

    public double getYMax() {
        if (!this.pixelSize) {
            return super.getYMax();
        }
        if (this.group == null) {
            return this.y;
        }
        return this.group.y + this.y;
    }

    public double getZMin() {
        if (!this.pixelSize) {
            return super.getZMin();
        }
        if (this.group == null) {
            return this.z;
        }
        return this.group.z + this.z;
    }

    public double getZMax() {
        if (!this.pixelSize) {
            return super.getZMax();
        }
        if (this.group == null) {
            return this.z;
        }
        return this.group.z + this.z;
    }
}

