/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridTableModel;

public class GridDataTable
extends JTable
implements ActionListener {
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");
    int refreshDelay = 0;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    GridTableModel tableModel;
    RowNumberRenderer rowNumberRenderer = new RowNumberRenderer();

    public GridDataTable(GridData gridData, int n) {
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.tableModel = new GridTableModel(gridData, n);
        this.setModel(this.tableModel);
        this.setAutoResizeMode(0);
        String string = this.getColumnName(0);
        TableColumn tableColumn = this.getColumn(string);
        int n2 = 20;
        tableColumn.setMinWidth(n2);
        tableColumn.setResizable(true);
        tableColumn.setWidth(n2);
        n2 = 60;
        int n3 = 1;
        int n4 = this.getColumnCount();
        while (n3 < n4) {
            string = this.getColumnName(n3);
            tableColumn = this.getColumn(string);
            tableColumn.setMinWidth(n2);
            tableColumn.setWidth(n2);
            tableColumn.setResizable(true);
            ++n3;
        }
        this.sizeColumnsToFit(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tableChanged(new TableModelEvent(this.tableModel, -1));
    }

    public void refreshTable() {
        if (this.refreshDelay > 0) {
            this.refreshTimer.start();
        } else {
            Runnable runnable = new Runnable(){

                public synchronized void run() {
                    GridDataTable.this.tableChanged(new TableModelEvent(GridDataTable.this.tableModel, -1));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        if (n3 == 0) {
            return this.rowNumberRenderer;
        }
        return this.getDefaultRenderer(this.getColumnClass(n2));
    }

    private static class RowNumberRenderer
    extends JLabel
    implements TableCellRenderer {
        public RowNumberRenderer() {
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.BLACK);
            this.setBackground(PANEL_BACKGROUND);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                this.setBackground(PANEL_BACKGROUND);
            }
            this.setText(object.toString());
            return this;
        }
    }
}

