/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.drawables.ControlDrawable2D;
import org.colos.ejs.library.control.drawables.Plot2DWrapper;
import org.colos.ejs.library.control.swing.ControlDrawablesParent;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.ColorMapper;
import org.opensourcephysics.display2d.ContourPlot;
import org.opensourcephysics.display2d.GridPlot;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.GridTableFrame;
import org.opensourcephysics.display2d.InterpolatedPlot;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.SurfacePlot;
import org.opensourcephysics.display2d.SurfacePlotMouseController;
import org.opensourcephysics.display2d.TestData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlScalarField
extends ControlDrawable2D
implements NeedsPreUpdate {
    private static final int SCALAR_FIELD_ADDED = 18;
    protected static final int X_MINIMUM = 0;
    protected static final int X_MAXIMUM = 1;
    protected static final int Y_MINIMUM = 2;
    protected static final int Y_MAXIMUM = 3;
    protected static final int DATA = 4;
    private Plot2D plot;
    private Plot2DWrapper wrapper;
    private JFrame legendFrame;
    private GridPointData pointdata;
    private boolean auto;
    private int levels;
    private int colormode;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    private double minZ;
    private double maxZ;
    private Color floorColor;
    private Color ceilingColor;
    protected int plotType;
    protected double minAbcise;
    protected double maxAbcise;
    protected double minOrdinate;
    protected double maxOrdinate;
    protected boolean mustUpdate;
    protected boolean typeChanged;
    protected boolean showGridLines;
    protected boolean visibility;
    private boolean legendChanged;
    private boolean showLegend;
    protected double[][] dataArray;
    protected Color[] palette;
    protected Color gridColor;
    protected double expandedFactor;
    private SurfacePlotMouseController controller;
    private static List<String> infoList = null;
    private GridTableFrame tableFrame = null;

    @Override
    protected Drawable createDrawable() {
        this.plotType = 0;
        return this.doCreateTheDrawable();
    }

    protected final Drawable doCreateTheDrawable() {
        this.maxY = Double.NaN;
        this.minY = Double.NaN;
        this.maxX = Double.NaN;
        this.minX = Double.NaN;
        this.dataArray = null;
        this.legendFrame = null;
        this.legendChanged = true;
        this.auto = true;
        this.minZ = -1.0;
        this.maxZ = 1.0;
        this.colormode = 0;
        this.levels = 16;
        this.palette = new Color[0];
        this.floorColor = Color.darkGray;
        this.ceilingColor = Color.lightGray;
        this.showGridLines = true;
        this.gridColor = Color.lightGray;
        this.expandedFactor = 0.0;
        this.visibility = true;
        this.expandedFactor = 0.0;
        this.pointdata = new GridPointData(30, 30, 1);
        this.pointdata.setCellScale(-1.0, 1.0, -1.0, 1.0);
        this.wrapper = new Plot2DWrapper();
        this.mustUpdate = true;
        this.typeChanged = true;
        this.checkPlotType();
        return this.wrapper;
    }

    @Override
    public void setParent(ControlParentOfDrawables controlParentOfDrawables) {
        if (this.myParent != null && this.controller != null) {
            this.myParent.getDrawingPanel().removeMouseListener(this.controller);
            this.myParent.getDrawingPanel().removeMouseMotionListener(this.controller);
            this.controller = null;
        }
        if (controlParentOfDrawables != null && controlParentOfDrawables instanceof ControlDrawablesParent && this.plot instanceof SurfacePlot) {
            DrawingPanel drawingPanel = ((ControlDrawablesParent)controlParentOfDrawables).getDrawingPanel();
            this.controller = new SurfacePlotMouseController(drawingPanel, this.plot);
            drawingPanel.addMouseListener(this.controller);
            drawingPanel.addMouseMotionListener(this.controller);
        }
        super.setParent(controlParentOfDrawables);
        if (Double.isNaN(this.minX) || Double.isNaN(this.maxX) || Double.isNaN(this.minY) || Double.isNaN(this.maxY)) {
            this.mustUpdate = true;
            this.preupdate();
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("z");
            infoList.add("autoscaleZ");
            infoList.add("minimumZ");
            infoList.add("maximumZ");
            infoList.add("levels");
            infoList.add("colormode");
            infoList.add("floorcolor");
            infoList.add("ceilingcolor");
            infoList.add("showgrid");
            infoList.add("gridcolor");
            infoList.add("visible");
            infoList.add("plotType");
            infoList.add("showLegend");
            infoList.add("expandedZ");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("minimumX")) {
            return "int|double ";
        }
        if (string.equals("maximumX")) {
            return "int|double ";
        }
        if (string.equals("minimumY")) {
            return "int|double ";
        }
        if (string.equals("maximumY")) {
            return "int|double ";
        }
        if (string.equals("z")) {
            return "double[][]";
        }
        if (string.equals("autoscaleZ")) {
            return "boolean";
        }
        if (string.equals("minimumZ")) {
            return "int|double";
        }
        if (string.equals("maximumZ")) {
            return "int|double";
        }
        if (string.equals("levels")) {
            return "int";
        }
        if (string.equals("colormode")) {
            return "ColorMode|int|Object[]";
        }
        if (string.equals("floorcolor")) {
            return "Color|Object";
        }
        if (string.equals("ceilingcolor")) {
            return "Color|Object";
        }
        if (string.equals("showgrid")) {
            return "boolean";
        }
        if (string.equals("gridcolor")) {
            return "Color|Object";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        if (string.equals("plotType")) {
            return "Plot2DType|int";
        }
        if (string.equals("showLegend")) {
            return "boolean";
        }
        if (string.equals("expandedZ")) {
            return "int|double ";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("Plot2DType") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("grid")) {
                return new IntegerValue(0);
            }
            if (string2.equals("interpolated")) {
                return new IntegerValue(1);
            }
            if (string2.equals("contour")) {
                return new IntegerValue(2);
            }
            if (string2.equals("surface")) {
                return new IntegerValue(3);
            }
        }
        return super.parseConstant(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.minX == value.getDouble()) break;
                this.minX = value.getDouble();
                this.mustUpdate = true;
                break;
            }
            case 1: {
                if (this.maxX == value.getDouble()) break;
                this.maxX = value.getDouble();
                this.mustUpdate = true;
                break;
            }
            case 2: {
                if (this.minY == value.getDouble()) break;
                this.minY = value.getDouble();
                this.mustUpdate = true;
                break;
            }
            case 3: {
                if (this.maxY == value.getDouble()) break;
                this.maxY = value.getDouble();
                this.mustUpdate = true;
                break;
            }
            case 4: {
                if (!(value.getObject() instanceof double[][])) break;
                this.dataArray = (double[][])value.getObject();
                this.mustUpdate = true;
                this.legendChanged = true;
                break;
            }
            case 5: {
                if (this.auto == value.getBoolean()) break;
                this.auto = value.getBoolean();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                this.legendChanged = true;
                break;
            }
            case 6: {
                if (this.minZ == value.getDouble()) break;
                this.minZ = value.getDouble();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                this.legendChanged = true;
                break;
            }
            case 7: {
                if (this.maxZ == value.getDouble()) break;
                this.maxZ = value.getDouble();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                this.legendChanged = true;
                break;
            }
            case 8: {
                if (this.plot instanceof ContourPlot) {
                    if (this.levels == value.getInteger()) break;
                    this.levels = value.getInteger();
                    ((ContourPlot)this.plot).setNumberOfLevels(this.levels);
                    if (this.colormode >= 0) {
                        this.plot.setColorPalette(ColorMapper.getColorPalette(this.levels, this.colormode));
                        this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                    }
                    this.legendChanged = true;
                    break;
                }
                if (value.getInteger() == this.levels || this.colormode < 0) break;
                this.levels = value.getInteger();
                this.plot.setColorPalette(ColorMapper.getColorPalette(this.levels, this.colormode));
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                this.legendChanged = true;
                break;
            }
            case 9: {
                if (value.getObject() instanceof Object[]) {
                    this.colormode = -1;
                    Object[] objectArray = (Object[])value.getObject();
                    if (objectArray.length != this.palette.length) {
                        this.palette = new Color[objectArray.length];
                    }
                    boolean bl = false;
                    int n2 = 0;
                    int n3 = this.palette.length;
                    while (n2 < n3) {
                        if (this.palette[n2] != (Color)objectArray[n2]) {
                            this.palette[n2] = (Color)objectArray[n2];
                            bl = true;
                        }
                        ++n2;
                    }
                    if (bl) {
                        this.plot.setColorPalette(this.palette);
                        this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                    }
                    this.legendChanged = true;
                    break;
                }
                if (this.colormode == value.getInteger()) break;
                this.colormode = value.getInteger();
                this.plot.setPaletteType(this.colormode);
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                this.legendChanged = true;
                break;
            }
            case 10: {
                if (!(value.getObject() instanceof Color) || this.floorColor == (Color)value.getObject()) break;
                this.floorColor = (Color)value.getObject();
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                this.legendChanged = true;
                break;
            }
            case 11: {
                if (!(value.getObject() instanceof Color) || this.ceilingColor == (Color)value.getObject()) break;
                this.ceilingColor = (Color)value.getObject();
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                this.legendChanged = true;
                break;
            }
            case 12: {
                this.showGridLines = value.getBoolean();
                this.plot.setShowGridLines(this.showGridLines);
                break;
            }
            case 13: {
                if (!(value.getObject() instanceof Color)) break;
                this.gridColor = (Color)value.getObject();
                this.plot.setGridLineColor(this.gridColor);
                break;
            }
            case 14: {
                this.visibility = value.getBoolean();
                this.plot.setVisible(this.visibility);
                break;
            }
            case 15: {
                if (value.getInteger() == this.plotType) break;
                this.plotType = value.getInteger();
                this.typeChanged = true;
                break;
            }
            case 16: {
                if (this.showLegend == value.getBoolean()) break;
                this.showLegend = value.getBoolean();
                this.legendChanged = true;
                break;
            }
            case 17: {
                if (value.getDouble() == this.expandedFactor) break;
                this.expandedFactor = value.getDouble();
                this.plot.setExpandedZ(true, this.expandedFactor);
                this.legendChanged = true;
                break;
            }
            default: {
                super.setValue(n - 18, value);
            }
        }
        if (this.isUnderEjs) {
            this.plot.update();
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.minX = Double.NaN;
                this.mustUpdate = true;
                break;
            }
            case 1: {
                this.maxX = Double.NaN;
                this.mustUpdate = true;
                break;
            }
            case 2: {
                this.minY = Double.NaN;
                this.mustUpdate = true;
                break;
            }
            case 3: {
                this.maxY = Double.NaN;
                this.mustUpdate = true;
                break;
            }
            case 4: {
                this.pointdata = new GridPointData(30, 30, 1);
                this.plot.setGridData(this.pointdata);
                this.dataArray = null;
                this.mustUpdate = true;
                this.legendChanged = true;
                break;
            }
            case 5: {
                this.auto = true;
                this.plot.setAutoscaleZ(true, this.minZ, this.maxZ);
                this.legendChanged = true;
                break;
            }
            case 6: {
                this.minZ = -1.0;
                this.plot.setAutoscaleZ(this.auto, -1.0, this.maxZ);
                this.legendChanged = true;
                break;
            }
            case 7: {
                this.maxZ = 1.0;
                this.plot.setAutoscaleZ(this.auto, this.minZ, 1.0);
                this.legendChanged = true;
                break;
            }
            case 8: {
                this.levels = 16;
                if (this.plot instanceof ContourPlot) {
                    ((ContourPlot)this.plot).setNumberOfLevels(this.levels);
                } else if (this.colormode >= 0) {
                    this.plot.setColorPalette(ColorMapper.getColorPalette(this.levels, this.colormode));
                    this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                }
                this.legendChanged = true;
                break;
            }
            case 9: {
                this.colormode = 0;
                this.plot.setPaletteType(0);
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                this.legendChanged = true;
                break;
            }
            case 10: {
                this.floorColor = Color.darkGray;
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                this.legendChanged = true;
                break;
            }
            case 11: {
                this.ceilingColor = Color.lightGray;
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                this.legendChanged = true;
                break;
            }
            case 12: {
                this.showGridLines = true;
                this.plot.setShowGridLines(true);
                break;
            }
            case 13: {
                this.gridColor = Color.lightGray;
                this.plot.setGridLineColor(this.gridColor);
                break;
            }
            case 14: {
                this.visibility = true;
                this.plot.setVisible(true);
                break;
            }
            case 15: {
                this.plotType = 0;
                this.typeChanged = true;
                break;
            }
            case 16: {
                this.showLegend = false;
                this.legendChanged = true;
                break;
            }
            case 17: {
                this.expandedFactor = 0.0;
                this.plot.setExpandedZ(true, 0.0);
                this.legendChanged = true;
                break;
            }
            default: {
                super.setDefaultValue(n - 18);
            }
        }
        if (this.isUnderEjs) {
            this.preupdate();
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "<none>";
            }
            case 4: {
                return "<none>";
            }
            case 5: {
                return "true";
            }
            case 6: {
                return "-1.0";
            }
            case 7: {
                return "1.0";
            }
            case 8: {
                return "16";
            }
            case 9: {
                return "SPECTRUM";
            }
            case 10: {
                return "DARKGRAY";
            }
            case 11: {
                return "LIGHTGRAY";
            }
            case 12: {
                return "true";
            }
            case 13: {
                return "LIGHTGRAY";
            }
            case 14: {
                return "true";
            }
            case 15: {
                return "GRID_PLOT";
            }
            case 16: {
                return "false";
            }
            case 17: {
                return "0";
            }
        }
        return super.getDefaultValueString(n - 18);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return null;
            }
        }
        return super.getValue(n - 18);
    }

    @Override
    public void destroy() {
        if (this.legendFrame != null) {
            this.legendFrame.setVisible(false);
        }
        super.destroy();
    }

    @Override
    public void preupdate() {
        if (!this.visibility) {
            return;
        }
        if (this.myParent == null) {
            return;
        }
        this.computeMinMax();
        this.commonPreupdate();
    }

    protected final void computeMinMax() {
        this.minAbcise = this.minX;
        this.maxAbcise = this.maxX;
        this.minOrdinate = this.minY;
        this.maxOrdinate = this.maxY;
        if (this.myParent != null) {
            DrawingPanel drawingPanel = this.myParent.getDrawingPanel();
            if (Double.isNaN(this.minAbcise)) {
                this.minAbcise = drawingPanel.getPreferredXMin();
            }
            if (Double.isNaN(this.maxAbcise)) {
                this.maxAbcise = drawingPanel.getPreferredXMax();
            }
            if (Double.isNaN(this.minOrdinate)) {
                this.minOrdinate = drawingPanel.getPreferredYMin();
            }
            if (Double.isNaN(this.maxOrdinate)) {
                this.maxOrdinate = drawingPanel.getPreferredYMax();
            }
        }
    }

    private void checkPlotType() {
        if (this.typeChanged) {
            switch (this.plotType) {
                case 1: {
                    this.plot = new InterpolatedPlot(this.pointdata);
                    break;
                }
                case 2: {
                    this.plot = new ContourPlot(this.pointdata);
                    ((ContourPlot)this.plot).setNumberOfLevels(this.levels);
                    break;
                }
                case 3: {
                    this.plot = new SurfacePlot(this.pointdata);
                    if (this.myParent == null) break;
                    DrawingPanel drawingPanel = this.myParent.getDrawingPanel();
                    if (this.controller != null) {
                        drawingPanel.removeMouseListener(this.controller);
                        drawingPanel.removeMouseMotionListener(this.controller);
                    }
                    this.controller = new SurfacePlotMouseController(this.myParent.getDrawingPanel(), this.plot);
                    drawingPanel.addMouseListener(this.controller);
                    drawingPanel.addMouseMotionListener(this.controller);
                    break;
                }
                default: {
                    this.plot = new GridPlot(this.pointdata);
                }
            }
            this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
            if (this.palette.length > 0) {
                this.plot.setColorPalette(this.palette);
            } else {
                this.plot.setColorPalette(ColorMapper.getColorPalette(this.levels, this.colormode));
            }
            this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
            this.plot.setShowGridLines(this.showGridLines);
            this.plot.setGridLineColor(this.gridColor);
            this.plot.setExpandedZ(true, this.expandedFactor);
            this.plot.setVisible(this.visibility);
            this.wrapper.setPlot2D(this.plot);
            this.legendChanged = true;
            this.typeChanged = false;
            this.mustUpdate = true;
        }
    }

    protected void commonPreupdate() {
        this.checkPlotType();
        if (this.mustUpdate) {
            if (this.dataArray == null) {
                if (this.pointdata.getLeft() != this.minAbcise || this.pointdata.getRight() != this.maxAbcise || this.pointdata.getBottom() != this.maxOrdinate || this.pointdata.getTop() != this.minOrdinate) {
                    if (this.plot instanceof GridPlot) {
                        this.pointdata.setCellScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                    } else {
                        this.pointdata.setScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                    }
                }
                double[][][] dArray = this.pointdata.getData();
                int n = 0;
                int n2 = dArray.length;
                while (n < n2) {
                    int n3 = 0;
                    int n4 = dArray[0].length;
                    while (n3 < n4) {
                        dArray[n][n3][2] = TestData.gaussian(dArray[n][n3][0], dArray[n][n3][1], 0.1);
                        ++n3;
                    }
                    ++n;
                }
            } else {
                int n = this.dataArray.length;
                int n5 = this.dataArray[0].length;
                if (this.pointdata.getNx() != n || this.pointdata.getNy() != n5) {
                    this.pointdata = new GridPointData(n, n5, 1);
                    if (this.plot instanceof GridPlot) {
                        this.pointdata.setCellScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                    } else {
                        this.pointdata.setScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                    }
                    double[][][] dArray = this.pointdata.getData();
                    int n6 = 0;
                    while (n6 < n) {
                        int n7 = 0;
                        while (n7 < n5) {
                            dArray[n6][n7][2] = this.dataArray[n6][n7];
                            ++n7;
                        }
                        ++n6;
                    }
                    this.plot.setGridData(this.pointdata);
                } else {
                    if (this.pointdata.getLeft() != this.minAbcise || this.pointdata.getRight() != this.maxAbcise || this.pointdata.getBottom() != this.maxOrdinate || this.pointdata.getTop() != this.minOrdinate) {
                        if (this.plot instanceof GridPlot) {
                            this.pointdata.setCellScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                        } else {
                            this.pointdata.setScale(this.minAbcise, this.maxAbcise, this.maxOrdinate, this.minOrdinate);
                        }
                    }
                    double[][][] dArray = this.pointdata.getData();
                    int n8 = 0;
                    while (n8 < n) {
                        int n9 = 0;
                        while (n9 < n5) {
                            dArray[n8][n9][2] = this.dataArray[n8][n9];
                            ++n9;
                        }
                        ++n8;
                    }
                }
            }
            this.mustUpdate = false;
        }
        if (this.legendChanged) {
            if (this.showLegend) {
                if (this.legendFrame != null) {
                    this.legendFrame.setVisible(false);
                }
                this.legendFrame = this.plot.showLegend();
            } else if (this.legendFrame != null) {
                this.legendFrame.setVisible(false);
                this.legendFrame = null;
            }
        }
        this.plot.update();
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDataTable")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ControlScalarField.this.showDataTable(true);
            }
        });
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), arrayList);
    }

    public synchronized void showDataTable(boolean bl) {
        if (bl) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                if (this.plot.getGridData() == null) {
                    return;
                }
                this.tableFrame = new GridTableFrame(this.plot.getGridData());
                this.tableFrame.setTitle(String.valueOf(this.getProperty("name")) + " Data");
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.tableFrame.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }
}

