/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ToolsRes;

public class Diagnostics {
    static final String NEWLINE = System.getProperty("line.separator", "\n");

    public static void aboutJava() {
        String string = System.getProperty("java.version", "unknown version");
        String string2 = System.getProperty("java.runtime.name");
        String string3 = System.getProperty("java.runtime.version");
        String string4 = System.getProperty("java.vm.name");
        String string5 = System.getProperty("java.vm.version");
        String string6 = String.valueOf(ToolsRes.getString("Diagnostics.Java.About.Version")) + " " + string + NEWLINE + string2 + " (build " + string3 + ")" + NEWLINE + string4 + " (build " + string5 + ")";
        JOptionPane.showMessageDialog(null, string6, ToolsRes.getString("Diagnostics.Java.About.Title"), 1);
    }

    public static void aboutQTJava() {
        String string = System.getProperty("java.ext.dirs");
        if (string.indexOf(";") > -1) {
            string = string.substring(0, string.indexOf(";"));
        }
        String string2 = System.getProperty("file.separator", "/");
        File file = new File(String.valueOf(string) + string2 + "QTJava.zip");
        if (file.exists()) {
            boolean bl = false;
            try {
                Class<?> clazz = Class.forName("quicktime.util.QTBuild");
                Method method = clazz.getMethod("info", null);
                String string3 = (String)method.invoke(null, null);
                string3 = string3.substring(string3.indexOf(":") + 1, string3.indexOf("]"));
                String string4 = String.valueOf(ToolsRes.getString("Diagnostics.QTJava.About.Version")) + " " + string3;
                JOptionPane.showMessageDialog(null, string4, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 1);
            }
            catch (Exception exception) {
                bl = true;
            }
            catch (Error error) {
                bl = true;
            }
            if (bl) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Diagnostics.QTJava.Error.Message"), ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("Diagnostics.QTJava.NotFound.Message1")) + " " + string + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.NotFound.Message2"), ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
        }
    }

    public static void aboutJava3D() {
        String string = System.getProperty("java.ext.dirs");
        if (string.indexOf(";") > -1) {
            string = string.substring(0, string.indexOf(";"));
        }
        String string2 = System.getProperty("file.separator", "/");
        File file = new File(String.valueOf(string) + string2 + "j3dcore.jar");
        if (file.exists()) {
            boolean bl = false;
            try {
                Class<?> clazz = Class.forName("javax.media.j3d.VirtualUniverse");
                Method method = clazz.getMethod("getProperties", null);
                Map map = (Map)method.invoke(null, null);
                String string3 = (String)map.get("j3d.version");
                String string4 = (String)map.get("j3d.vendor");
                String string5 = String.valueOf(ToolsRes.getString("Diagnostics.Java3D.About.Version")) + " " + string3 + NEWLINE + string4;
                JOptionPane.showMessageDialog(null, string5, ToolsRes.getString("Diagnostics.Java3D.About.Title"), 1);
            }
            catch (Exception exception) {
                bl = true;
            }
            catch (Error error) {
                bl = true;
            }
            if (bl) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Diagnostics.Java3D.Error.Message"), ToolsRes.getString("Diagnostics.Java3D.About.Title"), 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("Diagnostics.Java3D.NotFound.Message1")) + " " + string + NEWLINE + ToolsRes.getString("Diagnostics.Java3D.NotFound.Message2"), ToolsRes.getString("Diagnostics.Java3D.About.Title"), 2);
        }
    }

    public static void aboutJOGL() {
        String string = System.getProperty("java.ext.dirs");
        if (string.indexOf(";") > -1) {
            string = string.substring(0, string.indexOf(";"));
        }
        String string2 = System.getProperty("file.separator", "/");
        File file = new File(String.valueOf(string) + string2 + "jogl.jar");
        if (file.exists()) {
            boolean bl = false;
            try {
                Class<?> clazz = Class.forName("javax.media.opengl.glu.GLU");
                Field field = clazz.getField("versionString");
                String string3 = (String)field.get(null);
                String string4 = String.valueOf(ToolsRes.getString("Diagnostics.JOGL.About.Version")) + " " + string3;
                JOptionPane.showMessageDialog(null, string4, ToolsRes.getString("Diagnostics.JOGL.About.Title"), 1);
            }
            catch (Exception exception) {
                bl = true;
            }
            catch (Error error) {
                bl = true;
            }
            if (bl) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Diagnostics.JOGL.Error.Message"), ToolsRes.getString("Diagnostics.JOGL.About.Title"), 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("Diagnostics.JOGL.NotFound.Message1")) + " " + string + NEWLINE + ToolsRes.getString("Diagnostics.JOGL.NotFound.Message2"), ToolsRes.getString("Diagnostics.JOGL.About.Title"), 2);
        }
    }

    public static void aboutLaunchJar() {
        if (OSPRuntime.getLaunchJarPath() != null) {
            JarFile jarFile = OSPRuntime.getLaunchJar();
            try {
                if (jarFile != null) {
                    String string = String.valueOf(ToolsRes.getString("Diagnostics.Jar.About.Message.JarFile")) + " \"" + XML.getName(OSPRuntime.getLaunchJarPath()) + "\". ";
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        String string2 = jarEntry.getName().toLowerCase();
                        if (!string2.endsWith(".dsa") || !string2.startsWith("meta-inf")) continue;
                        string = String.valueOf(string) + ToolsRes.getString("Diagnostics.Jar.About.Message.Signed");
                        JOptionPane.showMessageDialog(null, string, ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
                        return;
                    }
                    string = String.valueOf(string) + ToolsRes.getString("Diagnostics.Jar.About.Message.NotSigned");
                    JOptionPane.showMessageDialog(null, string, ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(null, ToolsRes.getString("Diagnostics.Jar.About.Message.NoJarFile"), ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
        }
    }

    public static void aboutOS() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        String string3 = String.valueOf(ToolsRes.getString("Diagnostics.OS.About.Name")) + " " + string + NEWLINE;
        string3 = String.valueOf(string3) + ToolsRes.getString("Diagnostics.OS.About.Version") + " " + string2 + NEWLINE;
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String string4;
            String string5 = (String)enumeration.nextElement();
            if (!string5.startsWith("os.") || (string4 = System.getProperty(string5)).equals(string) || string4.equals(string2)) continue;
            string3 = String.valueOf(string3) + string5 + ":  " + string4 + NEWLINE;
        }
        JOptionPane.showMessageDialog(null, string3, ToolsRes.getString("Diagnostics.OS.About.Title"), 1);
    }
}

