/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.Selectable;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.axes.CartesianInteractive;
import org.opensourcephysics.tools.DataColumn;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataRefreshTool;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolPropsTable;
import org.opensourcephysics.tools.DataToolStatsTable;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FourierToolTab;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataToolTab
extends JPanel
implements Tool,
PropertyChangeListener {
    protected static String helpName = "data_tool_help.html";
    protected DataTool dataTool;
    protected int originatorID = 0;
    protected DatasetManager dataManager = new DatasetManager();
    protected JSplitPane[] splitPanes;
    protected DataToolPlotter plot;
    protected DataToolTable dataTable;
    protected DataToolStatsTable statsTable;
    protected DataToolPropsTable propsTable;
    protected JScrollPane statsScroller;
    protected JScrollPane propsScroller;
    protected JToolBar toolbar;
    protected JCheckBox statsCheckbox;
    protected JCheckBox bottomPaneCheckbox;
    protected JCheckBox propsCheckbox;
    protected DatasetCurveFitter curveFitter;
    protected JButton dataBuilderButton;
    protected JButton newColumnButton;
    protected JButton refreshDataButton;
    protected JCheckBox valueCheckbox;
    protected JCheckBox slopeCheckbox;
    protected JCheckBox areaCheckbox;
    protected Action bottomPaneAction;
    protected Action propsAndStatsAction;
    protected String fileName;
    protected JButton helpButton;
    protected int colorIndex = 0;
    protected boolean tabChanged;
    protected boolean userEditable = false;
    protected UndoableEditSupport undoSupport;
    protected UndoManager undoManager;
    protected FunctionTool dataBuilder;
    protected int fontLevel = FontSizer.getLevel();
    protected JobManager jobManager = new JobManager(this);
    protected JLabel statusLabel;
    protected JLabel editableLabel;
    protected CartesianInteractive plotAxes;
    protected boolean positionVisible = false;
    protected boolean slopeVisible = false;
    protected boolean areaVisible = false;
    protected JPopupMenu varPopup;
    protected boolean isHorzVarPopup;
    protected Action setVarAction;
    protected boolean isInitialized = false;

    public DataToolTab(Data data) {
        String string;
        this.dataTable = new DataToolTable(this);
        this.createGUI();
        String string2 = ToolsRes.getString("DataToolTab.DefaultName");
        if (data != null && (string = data.getName()) != null && !string.equals("")) {
            string2 = string;
        }
        this.setName(string2);
        this.loadData(data);
        this.tabChanged(false);
    }

    public ArrayList<DataColumn> loadData(Data data) {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>();
        if (data == null) {
            return arrayList;
        }
        ArrayList<DataColumn> arrayList2 = DataTool.getAllDataColumns(data);
        if (arrayList2 == null) {
            return arrayList;
        }
        boolean bl = false;
        if (this.dataManager.getDatasets().isEmpty()) {
            this.originatorID = data.getID();
            for (DataColumn dataColumn : arrayList2) {
                this.addColumn(dataColumn);
                arrayList.add(dataColumn);
            }
        } else {
            for (Dataset dataset : this.dataManager.getDatasets()) {
                DataColumn dataColumn = this.getIDMatch(dataset, arrayList2);
                if (dataColumn == null) continue;
                String string = dataset.getYColumnName();
                String string2 = dataColumn.getYColumnName();
                dataset.setXYColumnNames("row", "");
                string2 = this.getUniqueYColumnName(dataColumn, string2, false);
                dataset.setXYColumnNames("row", string);
                if (!Arrays.equals(dataset.getYPoints(), dataColumn.getYPoints()) || !string2.equals(string)) {
                    dataset.clear();
                    double[] dArray = DataTool.getRowArray(dataColumn.getIndex());
                    dataset.append(dArray, dataColumn.getYPoints());
                    dataset.setXYColumnNames("row", string2);
                    bl = true;
                }
                arrayList2.remove(dataColumn);
            }
            for (DataColumn dataColumn : arrayList2) {
                this.addColumn(dataColumn);
                arrayList.add(dataColumn);
            }
        }
        if (bl || !arrayList.isEmpty()) {
            this.dataTable.refreshTable();
            this.statsTable.refreshStatistics();
            this.refreshPlot();
            this.refreshGUI();
            this.tabChanged(true);
            this.varPopup = null;
        }
        return arrayList;
    }

    public void addColumns(Data data, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        ArrayList<Dataset> arrayList = this.dataManager.getDatasets();
        Dataset dataset = arrayList.isEmpty() ? null : arrayList.get(0);
        double[] dArray = object2 = dataset == null ? null : dataset.getYPoints();
        if (object2 != null) {
            while (((double[])object2).length > 0 && Double.isNaN(object2[((double[])object2).length - 1])) {
                object = new double[((double[])object2).length - 1];
                System.arraycopy(object2, 0, object, 0, ((Object)object).length);
                object2 = object;
            }
        }
        dataset = object2 == null || DataTool.containsDuplicateValues(object2) ? null : dataset;
        object = DataTool.getDataColumns(data);
        DataColumn dataColumn = null;
        if (dataset != null) {
            String string = dataset.getYColumnName();
            Iterator<DataColumn> iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                int n;
                DataColumn dataColumn2 = iterator.next();
                if (dataColumn != null || !dataColumn2.getYColumnName().equals(string)) continue;
                double[] dArray2 = dataColumn2.getYPoints();
                while (dArray2.length > 0 && Double.isNaN(dArray2[dArray2.length - 1])) {
                    double[] dArray3 = new double[dArray2.length - 1];
                    System.arraycopy(dArray2, 0, dArray3, 0, dArray3.length);
                    dArray2 = dArray3;
                }
                if (DataTool.containsDuplicateValues(dArray2)) continue;
                boolean bl4 = false;
                double[] dArray4 = dArray2;
                int n2 = dArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    double d = dArray4[n3];
                    if (DataTool.getIndex(d, object2, -1) > -1) {
                        bl4 = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl4) continue;
                dataColumn = dataColumn2;
                int n4 = 1;
                double d = -1.7976931348623157E308;
                Object object3 = object2;
                int n5 = ((double[])object2).length;
                int n6 = 0;
                while (n6 < n5) {
                    double d2 = object3[n6];
                    if (!(d2 > d)) {
                        n4 = -1;
                        break;
                    }
                    d = d2;
                    ++n6;
                }
                if (n4 == -1) {
                    d = Double.MAX_VALUE;
                    object3 = object2;
                    n5 = ((double[])object2).length;
                    n6 = 0;
                    while (n6 < n5) {
                        double d3 = object3[n6];
                        if (!(d3 < d)) {
                            n4 = 0;
                            break;
                        }
                        d = d3;
                        ++n6;
                    }
                }
                double[] dArray5 = new double[((double[])object2).length];
                System.arraycopy(object2, 0, dArray5, 0, ((double[])object2).length);
                dArray4 = new double[dArray2.length];
                n6 = 0;
                n5 = 0;
                while (n5 < dArray2.length) {
                    int n7 = DataTool.getIndex(dArray2[n5], object2, -1);
                    if (n7 == -1) {
                        dArray4[n6] = dArray2[n5];
                        ++n6;
                        dArray5 = DataTool.insert(dArray2[n5], dArray5, n4);
                    }
                    ++n5;
                }
                if (n6 <= 0) continue;
                double[] dArray6 = new double[n6];
                int[] nArray = new int[n6];
                int n8 = 0;
                while (n8 < n6) {
                    double d4 = dArray4[n8];
                    n = DataTool.getIndex(d4, dArray5, -1);
                    dArray6[n8] = n;
                    nArray[n8] = n;
                    ++n8;
                }
                Arrays.sort(nArray);
                double[] dArray7 = new double[n6];
                int n9 = 0;
                while (n9 < n6) {
                    int n10 = nArray[n9];
                    n = DataTool.getIndex(n10, dArray6, -1);
                    dArray7[n9] = dArray4[n];
                    ++n9;
                }
                this.dataTable.pasteValues.clear();
                this.dataTable.pasteValues.put(string, dArray7);
                HashMap<String, double[]> hashMap = this.dataTable.insertRows(nArray, this.dataTable.pasteValues);
                DataToolTable dataToolTable = this.dataTable;
                dataToolTable.getClass();
                DataToolTable.TableEdit tableEdit = dataToolTable.new DataToolTable.TableEdit(6, null, nArray, hashMap);
                this.undoSupport.postEdit(tableEdit);
                Iterator iterator2 = ((ArrayList)object).iterator();
                while (iterator2.hasNext()) {
                    DataColumn dataColumn3 = (DataColumn)iterator2.next();
                    if (dataColumn3 == dataColumn) continue;
                    double[] dArray8 = dataColumn3.getYPoints();
                    double[] dArray9 = DataTool.getRowArray(dArray5.length);
                    double[] dArray10 = new double[dArray9.length];
                    Arrays.fill(dArray10, Double.NaN);
                    int n11 = Math.min(dArray2.length, dArray8.length);
                    int n12 = 0;
                    while (n12 < n11) {
                        int n13 = DataTool.getIndex(dArray2[n12], dArray5, -1);
                        dArray10[n13] = dArray8[n12];
                        ++n12;
                    }
                    dataColumn3.clear();
                    dataColumn3.append(dArray9, dArray10);
                }
            }
        }
        ((ArrayList)object).remove(dataColumn);
        this.addColumns((ArrayList<DataColumn>)object, bl, bl2, bl3);
    }

    protected void addColumns(ArrayList<DataColumn> arrayList, boolean bl, boolean bl2, boolean bl3) {
        for (DataColumn dataColumn : arrayList) {
            int n = dataColumn.getID();
            if (bl2) {
                dataColumn.setID(-n);
            }
            ArrayList<DataColumn> arrayList2 = this.loadData(dataColumn);
            dataColumn.setID(n);
            if (arrayList2.isEmpty()) continue;
            for (DataColumn dataColumn2 : arrayList2) {
                dataColumn2.deletable = bl;
            }
            if (bl3) {
                int n2 = this.dataTable.getColumnCount() - 1;
                DataToolTable dataToolTable = this.dataTable;
                dataToolTable.getClass();
                DataToolTable.TableEdit tableEdit = dataToolTable.new DataToolTable.TableEdit(1, dataColumn.getYColumnName(), new Integer(n2), dataColumn);
                this.undoSupport.postEdit(tableEdit);
            }
            this.refreshDataBuilder();
        }
        this.dataTable.refreshUndoItems();
        this.refreshGUI();
    }

    protected void addColumn(DataColumn dataColumn) {
        String string;
        String string2 = dataColumn.getYColumnName();
        if (!string2.equals(string = this.getUniqueYColumnName(dataColumn, string2, false))) {
            String string3 = dataColumn.getXColumnName();
            dataColumn.setXYColumnNames(string3, string);
        }
        if (this.dataManager.getDatasets().isEmpty()) {
            dataColumn.setMarkerColor(Color.BLACK);
            dataColumn.setLineColor(Color.BLACK);
        }
        this.dataManager.addDataset(dataColumn);
        this.dataTable.getWorkingData(string);
    }

    public void setWorkingColumns(String string, String string2) {
        this.dataTable.setWorkingColumns(string, string2);
    }

    @Override
    public void setName(String string) {
        string = this.replaceSpacesWithUnderscores(string);
        super.setName(string);
        if (this.dataTool != null) {
            this.dataTool.refreshTabTitles();
        }
    }

    public void setUserEditable(boolean bl) {
        if (this.userEditable == bl) {
            return;
        }
        this.userEditable = bl;
        this.refreshGUI();
    }

    protected boolean isDeletable(Dataset dataset) {
        if (dataset == null) {
            return false;
        }
        if (!this.userEditable && dataset instanceof DataColumn) {
            DataColumn dataColumn = (DataColumn)dataset;
            if (!dataColumn.deletable) {
                return false;
            }
        }
        return true;
    }

    public FunctionTool getDataBuilder() {
        if (this.dataTool != null) {
            return this.dataTool.getDataBuilder();
        }
        if (this.dataBuilder == null) {
            this.dataBuilder = new FunctionTool(this){

                protected void refreshGUI() {
                    super.refreshGUI();
                    this.dropdown.setToolTipText(ToolsRes.getString("DataTool.DataBuilder.Dropdown.Tooltip"));
                    this.setTitle(ToolsRes.getString("DataTool.DataBuilder.Title"));
                }
            };
            this.dataBuilder.setFontLevel(this.fontLevel);
            this.dataBuilder.setHelpPath("data_builder_help.html");
            this.dataBuilder.addPropertyChangeListener("function", this);
        }
        this.refreshDataBuilder();
        return this.dataBuilder;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("function")) {
            String string2;
            this.tabChanged(true);
            this.dataTable.refreshTable();
            this.statsTable.refreshStatistics();
            if (propertyChangeEvent.getNewValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getNewValue().toString();
                this.dataTable.getWorkingData(string2);
            }
            if (propertyChangeEvent.getOldValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getOldValue().toString();
                this.dataTable.removeWorkingData(string2);
            }
            if (propertyChangeEvent.getNewValue() instanceof String) {
                string2 = propertyChangeEvent.getNewValue().toString();
                if (propertyChangeEvent.getOldValue() instanceof String) {
                    String string3 = propertyChangeEvent.getOldValue().toString();
                    this.columnNameChanged(string3, string2);
                } else {
                    this.dataTable.getWorkingData(string2);
                }
            }
            this.refreshPlot();
            this.varPopup = null;
        }
    }

    @Override
    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        if (xMLControlElement.failedToRead() || xMLControlElement.getObjectClass() == Object.class) {
            return;
        }
        this.jobManager.log(job, tool);
        if (Data.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            Data data = (Data)xMLControlElement.loadObject(null, true, true);
            this.loadData(data);
            this.jobManager.associate(job, this.dataManager);
            this.refreshGUI();
        } else if (DataToolTab.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            xMLControlElement.loadObject(this);
            this.refreshGUI();
        }
    }

    public void addFitFunction(KnownFunction knownFunction, boolean bl) {
        this.curveFitter.addFitFunction(knownFunction, bl);
    }

    public void clearData() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Dataset dataset : this.dataManager.getDatasets()) {
            arrayList.add(dataset.getYColumnName());
        }
        this.dataTable.setSelectedColumnNames(arrayList);
        this.dataTable.deleteSelectedColumns();
    }

    protected String replaceSpacesWithUnderscores(String string) {
        string.trim();
        int n = string.indexOf(" ");
        while (n > -1) {
            string = String.valueOf(string.substring(0, n)) + "_" + string.substring(n + 1);
            n = string.indexOf(" ");
        }
        return string;
    }

    protected void refreshDataBuilder() {
        if (this.dataTool != null) {
            this.dataTool.refreshDataBuilder();
            return;
        }
        if (this.dataBuilder == null) {
            return;
        }
        if (this.dataBuilder.getPanel(this.getName()) == null) {
            DataFunctionPanel object = new DataFunctionPanel(this.dataManager);
            this.dataBuilder.addPanel(this.getName(), object);
        }
        for (String string : this.dataBuilder.panels.keySet()) {
            if (string.equals(this.getName())) continue;
            this.dataBuilder.removePanel(string);
        }
    }

    protected void setFontLevel(int n) {
        if (this.fontLevel == n) {
            return;
        }
        this.fontLevel = n;
        this.plot.setFontLevel(n);
        FontSizer.setFonts(this.statsTable, n);
        FontSizer.setFonts(this.propsTable, n);
        this.curveFitter.setFontLevel(n);
        double d = FontSizer.getFactor(n);
        this.plot.getAxes().resizeFonts(d, this.plot);
        FontSizer.setFonts(this.plot.getPopupMenu(), n);
        if (this.propsTable.styleDialog != null) {
            FontSizer.setFonts(this.propsTable.styleDialog, n);
            this.propsTable.styleDialog.pack();
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.setFontLevel(this.fontLevel);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                DataToolTab.this.bottomPaneAction.actionPerformed(null);
                DataToolTab.this.propsAndStatsAction.actionPerformed(null);
                DataToolTab.this.propsTable.refreshTable();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void tabChanged(boolean bl) {
        this.tabChanged = bl;
    }

    protected DataToolTable.WorkingDataset getWorkingData() {
        this.dataTable.getSelectedData();
        return this.dataTable.workingData;
    }

    protected String getUniqueYColumnName(Dataset dataset, String string, boolean bl) {
        Object object;
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        string = string.replaceAll(" ", "");
        boolean bl2 = this.containsOperators(string);
        if (bl || bl2) {
            n2 = 0;
            n = 3;
            while (n2 < n) {
                ++n2;
                if (this.isDuplicateName(dataset, string)) {
                    object = JOptionPane.showInputDialog(this, "\"" + string + "\" " + ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Message"), ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Title"), 2, null, null, string);
                    String string2 = string = object == null ? null : object.toString();
                }
                if (string == null || string.equals("")) {
                    return null;
                }
                if (this.isReservedName(string)) {
                    object = JOptionPane.showInputDialog(this, "\"" + string + "\" " + ToolsRes.getString("DataToolTab.Dialog.ReservedName.Message"), ToolsRes.getString("DataToolTab.Dialog.ReservedName.Title"), 2, null, null, string);
                    String string3 = string = object == null ? null : object.toString();
                }
                if (string == null || string.equals("")) {
                    return null;
                }
                bl2 = this.containsOperators(string);
                if (bl2) {
                    object = JOptionPane.showInputDialog(this, ToolsRes.getString("DataToolTab.Dialog.OperatorInName.Message"), ToolsRes.getString("DataToolTab.Dialog.OperatorInName.Title"), 2, null, null, string);
                    String string4 = string = object == null ? null : object.toString();
                }
                if (string != null && !string.equals("")) continue;
                return null;
            }
        }
        if (bl2) {
            return null;
        }
        n2 = 0;
        try {
            Double.parseDouble(string);
            string = ToolsRes.getString("DataToolTab.NewColumn.Name");
        }
        catch (NumberFormatException numberFormatException) {}
        n = 0;
        if (this.isDuplicateName(dataset, string)) {
            object = TeXParser.getSubscript(string);
            try {
                n2 = Integer.parseInt((String)object);
                string = TeXParser.removeSubscript(string);
                n = 1;
            }
            catch (Exception exception) {}
        }
        object = string;
        while (n != 0 || this.isDuplicateName(dataset, (String)object) || this.isReservedName((String)object)) {
            object = TeXParser.addSubscript(string, String.valueOf(++n2));
            n = 0;
        }
        return object;
    }

    protected boolean isDuplicateName(Dataset dataset, String string) {
        if (this.dataManager.getDatasets().isEmpty()) {
            return false;
        }
        if (this.dataManager.getDataset(0).getXColumnName().equals(string)) {
            return true;
        }
        string = TeXParser.removeSubscripting(string);
        for (Dataset dataset2 : this.dataManager.getDatasets()) {
            String string2;
            if (dataset2 == dataset || !(string2 = TeXParser.removeSubscripting(dataset2.getYColumnName())).equals(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean isReservedName(String string) {
        String[] stringArray = FunctionTool.parserNames;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        if (DataTable.rowName.equals(string)) {
            return true;
        }
        stringArray = UserFunction.dummyVars;
        n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected boolean containsOperators(String string) {
        String[] stringArray = FunctionTool.parserOperators;
        int n = FunctionTool.parserOperators.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string.indexOf(string2) > -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void columnNameChanged(String string, String string2) {
        Object object;
        this.tabChanged(true);
        this.varPopup = null;
        String string3 = this.dataTable.getFormatPattern(string);
        this.dataTable.removeWorkingData(string);
        this.dataTable.getWorkingData(string2);
        this.dataTable.setFormatPattern(string2, string3);
        if (this.propsTable.styleDialog != null && this.propsTable.styleDialog.isVisible() && this.propsTable.styleDialog.getName().equals(string)) {
            this.propsTable.styleDialog.setName(string2);
            object = ToolsRes.getString("DataToolPropsTable.Dialog.Title");
            String string4 = TeXParser.removeSubscripting(string2);
            this.propsTable.styleDialog.setTitle(String.valueOf(object) + " \"" + string4 + "\"");
        }
        this.statsTable.refreshStatistics();
        object = this.getWorkingData();
        if (object == null) {
            return;
        }
        this.refreshPlot();
    }

    protected DataColumn createDataColumn() {
        Color color = DisplayColors.getMarkerColor(this.colorIndex);
        Color color2 = DisplayColors.getLineColor(this.colorIndex);
        if (!this.dataManager.getDatasets().isEmpty()) {
            ++this.colorIndex;
        }
        DataColumn dataColumn = new DataColumn();
        dataColumn.setMarkerColor(color);
        dataColumn.setLineColor(color2);
        dataColumn.setConnected(false);
        int n = Math.max(1, this.dataTable.getRowCount());
        double[] dArray = new double[n];
        Arrays.fill(dArray, Double.NaN);
        dataColumn.setPoints(dArray);
        dataColumn.setXColumnVisible(false);
        return dataColumn;
    }

    protected Dataset copy(Dataset dataset, Dataset dataset2, boolean bl) {
        Object object;
        Object object2;
        if (dataset2 == null) {
            dataset2 = new Dataset();
        }
        if (bl) {
            dataset2.clear();
            object2 = dataset.getXPoints();
            object = dataset.getYPoints();
            dataset2.append((double[])object2, (double[])object);
            dataset2.setID(dataset.getID());
        }
        dataset2.setName(dataset.getName());
        dataset2.setXYColumnNames(dataset.getXColumnName(), dataset.getYColumnName());
        dataset2.setMarkerShape(dataset.getMarkerShape());
        dataset2.setMarkerSize(dataset.getMarkerSize());
        object2 = dataset.getFillColor();
        object = dataset.getEdgeColor();
        dataset2.setMarkerColor((Color)object2, (Color)object);
        dataset2.setLineColor(dataset.getLineColor());
        dataset2.setConnected(dataset.isConnected());
        dataset2.setXColumnVisible(dataset.isXColumnVisible());
        dataset2.setYColumnVisible(dataset.isYColumnVisible());
        return dataset2;
    }

    protected String saveTableDataToFile() {
        String string = this.getName();
        OSPLog.finest("saving tabe data from " + string);
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        jFileChooser.setSelectedFile(new File(String.valueOf(string) + ".txt"));
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            string2 = XML.getRelativePath(string2);
            String string3 = this.getSelectedTableData();
            return DataTool.write(string3, string2);
        }
        return null;
    }

    protected void copyTableDataToClipboard() {
        OSPLog.finest("copying table data from " + this.getName());
        DataTool.copy(this.getSelectedTableData());
    }

    protected String getSelectedTableData() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getName() != null) {
            stringBuffer.append(String.valueOf(this.getName()) + "\n");
        }
        if (this.dataTable.getColumnCount() == 1 || this.dataTable.getRowCount() == 0) {
            return stringBuffer.toString();
        }
        this.dataTable.clearSelectionIfEmptyEndRow();
        int[] nArray = this.dataTable.getSelectedRows();
        if (nArray.length == 0) {
            this.dataTable.selectAll();
            nArray = this.dataTable.getSelectedRows();
        }
        int[] nArray2 = this.dataTable.getSelectedColumns();
        int n3 = 0;
        while (n3 < nArray2.length) {
            n2 = nArray2[n3];
            n = this.dataTable.convertColumnIndexToModel(n2);
            if (!this.dataTable.isRowNumberVisible() || n != 0) {
                stringBuffer.append(this.dataTable.getColumnName(n2));
                stringBuffer.append("\t");
            }
            ++n3;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append("\n");
        DateFormat dateFormat = DateFormat.getInstance();
        n2 = 0;
        while (n2 < nArray.length) {
            n = 0;
            while (n < nArray2.length) {
                int n4 = nArray2[n];
                int n5 = this.dataTable.convertColumnIndexToModel(n4);
                if (!this.dataTable.isRowNumberVisible() || n5 != 0) {
                    Object object = this.dataTable.getValueAt(nArray[n2], n4);
                    if (object != null) {
                        if (object instanceof Date) {
                            object = dateFormat.format(object);
                        }
                        stringBuffer.append(object);
                    }
                    stringBuffer.append("\t");
                }
                ++n;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void createGUI() {
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DataToolTab.this.refreshGUI();
            }
        });
        this.setLayout(new BorderLayout());
        this.splitPanes = new JSplitPane[3];
        this.splitPanes[0] = new JSplitPane(1);
        this.splitPanes[0].setResizeWeight(1.0);
        this.splitPanes[0].setOneTouchExpandable(true);
        this.splitPanes[1] = new JSplitPane(0);
        this.splitPanes[1].setResizeWeight(1.0);
        this.splitPanes[1].setDividerSize(0);
        this.splitPanes[2] = new JSplitPane(0);
        this.splitPanes[2].setDividerSize(0);
        this.splitPanes[2].setEnabled(false);
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                OSPLog.getOSPLog();
                if (DataToolTab.this.getSize().width > 0) {
                    DataToolTab.this.init();
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DataToolTab.this.bottomPaneAction.actionPerformed(null);
            }
        });
        this.dataTable.setRowNumberVisible(true);
        JScrollPane jScrollPane = new JScrollPane(this.dataTable);
        this.dataTable.refreshTable();
        jScrollPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DataToolTab.this.dataTable.clearSelection();
            }
        });
        jScrollPane.setToolTipText(ToolsRes.getString("DataToolTab.Scroller.Tooltip"));
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                DataToolTable.WorkingDataset workingDataset = DataToolTab.this.dataTable.workingData;
                DataToolTable.WorkingDataset workingDataset2 = DataToolTab.this.getWorkingData();
                if (workingDataset2 != workingDataset && DatasetCurveFitter.fitBuilder != null) {
                    DataToolTab.this.tabChanged(true);
                }
                if (workingDataset2 == null || workingDataset2 == workingDataset) {
                    return;
                }
                DataToolTab.this.plot.selectionBox.setSize(0, 0);
                DataToolTab.this.refreshPlot();
            }
        });
        this.bottomPaneAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.bottomPaneCheckbox == null) {
                    return;
                }
                DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[2].getDividerSize());
                DataToolTab.this.splitPanes[1].setDividerLocation(1.0);
                DataToolTab.this.splitPanes[1].remove(DataToolTab.this.curveFitter);
                DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                boolean bl = DataToolTab.this.bottomPaneCheckbox.isSelected();
                DataToolTab.this.splitPanes[1].setEnabled(bl);
                if (bl) {
                    DataToolTab.this.splitPanes[1].setBottomComponent(DataToolTab.this.curveFitter);
                    DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[0].getDividerSize());
                    DataToolTab.this.splitPanes[1].setDividerLocation(-1);
                    DataToolTab.this.plot.addDrawable(DataToolTab.this.curveFitter.getDrawer());
                }
                if (actionEvent != null) {
                    DataToolTab.this.refreshPlot();
                }
            }
        };
        this.bottomPaneCheckbox = new JCheckBox();
        this.bottomPaneCheckbox.setSelected(false);
        this.bottomPaneCheckbox.setOpaque(false);
        this.bottomPaneCheckbox.addActionListener(this.bottomPaneAction);
        this.newColumnButton = DataTool.createButton("");
        this.newColumnButton.addActionListener(new ActionListener(){

            public void actionPerformed(final ActionEvent actionEvent) {
                Object object;
                Object object2;
                DataColumn dataColumn = DataToolTab.this.createDataColumn();
                String string = ToolsRes.getString("DataToolTab.NewColumn.Name");
                string = DataToolTab.this.getUniqueYColumnName(dataColumn, string, false);
                Object object3 = JOptionPane.showInputDialog(DataToolTab.this, ToolsRes.getString("DataToolTab.Dialog.NameColumn.Message"), ToolsRes.getString("DataToolTab.Dialog.NameColumn.Title"), 3, null, null, string);
                if (object3 == null) {
                    return;
                }
                String string2 = DataToolTab.this.getUniqueYColumnName(dataColumn, object3.toString(), true);
                if (string2 == null) {
                    return;
                }
                if (string2.equals("")) {
                    object2 = ToolsRes.getString("DataToolTab.NewColumn.Name");
                    string2 = DataToolTab.this.getUniqueYColumnName(dataColumn, (String)object2, false);
                }
                OSPLog.finer("adding new column \"" + string2 + "\"");
                dataColumn.setXYColumnNames("row", string2);
                object2 = DataToolTab.this.loadData(dataColumn);
                if (!((ArrayList)object2).isEmpty()) {
                    object = ((ArrayList)object2).iterator();
                    while (object.hasNext()) {
                        DataColumn dataColumn2 = (DataColumn)object.next();
                        dataColumn2.deletable = true;
                    }
                }
                int n = DataToolTab.this.dataTable.getColumnCount() - 1;
                DataToolTable dataToolTable = DataToolTab.this.dataTable;
                dataToolTable.getClass();
                object = dataToolTable.new DataToolTable.TableEdit(1, string2, new Integer(n), dataColumn);
                DataToolTab.this.undoSupport.postEdit((UndoableEdit)object);
                DataToolTab.this.dataTable.refreshUndoItems();
                Runnable runnable = new Runnable(){

                    public synchronized void run() {
                        int n = (this).DataToolTab.this.dataTable.getColumnCount() - 1;
                        (this).DataToolTab.this.dataTable.changeSelection(0, n, false, false);
                        (this).DataToolTab.this.dataTable.editCellAt(0, n, actionEvent);
                        (this).DataToolTab.this.dataTable.editor.field.requestFocus();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        this.dataBuilderButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
        this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
        this.dataBuilderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.getDataBuilder().setSelectedPanel(DataToolTab.this.getName());
                DataToolTab.this.getDataBuilder().setVisible(true);
            }
        });
        this.refreshDataButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.Refresh.Text"));
        this.refreshDataButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Refresh.Tooltip"));
        this.refreshDataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.dataManager.setName(DataToolTab.this.getName());
                DataToolTab.this.jobManager.sendReplies(DataToolTab.this.dataManager);
            }
        });
        this.helpButton = DataTool.createButton(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.dataTool != null) {
                    DataTool.showHelp(DataTool.helpName);
                } else {
                    DataTool.showHelp(helpName);
                }
            }
        });
        this.valueCheckbox = new JCheckBox(ToolsRes.getString("DataToolTab.Checkbox.Position"));
        this.valueCheckbox.setSelected(false);
        this.valueCheckbox.setOpaque(false);
        this.valueCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Position.Tooltip"));
        this.valueCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.positionVisible = DataToolTab.this.valueCheckbox.isSelected();
                DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
                DataToolTab.this.plot.repaint();
            }
        });
        this.slopeCheckbox = new JCheckBox(ToolsRes.getString("DataToolTab.Checkbox.Slope"));
        this.slopeCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Slope.Tooltip"));
        this.slopeCheckbox.setSelected(false);
        this.slopeCheckbox.setOpaque(false);
        this.slopeCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.slopeVisible = DataToolTab.this.slopeCheckbox.isSelected();
                DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
                DataToolTab.this.plot.repaint();
            }
        });
        this.areaCheckbox = new JCheckBox(ToolsRes.getString("DataToolTab.Checkbox.Area"));
        this.areaCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Area.Tooltip"));
        this.areaCheckbox.setSelected(false);
        this.areaCheckbox.setOpaque(false);
        this.areaCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab.this.plot.setAreaVisible(DataToolTab.this.areaCheckbox.isSelected());
            }
        });
        this.propsAndStatsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                boolean bl = DataToolTab.this.statsCheckbox.isSelected();
                boolean bl2 = DataToolTab.this.propsCheckbox.isSelected();
                if (bl) {
                    DataToolTab.this.statsTable.refreshStatistics();
                }
                int n2 = DataToolTab.this.statsTable.getPreferredSize().height;
                int n3 = DataToolTab.this.propsTable.getPreferredSize().height;
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                int n4 = n = lookAndFeel.getClass().getName().indexOf("Nimbus") > -1 ? 8 : 4;
                if (bl && bl2) {
                    Box box = Box.createVerticalBox();
                    box.add(DataToolTab.this.statsScroller);
                    box.add(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setTopComponent(box);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n2 + n3 + 2 * n);
                } else if (bl) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.statsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n2 + n);
                } else if (bl2) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n3 + n);
                } else {
                    DataToolTab.this.splitPanes[2].setDividerLocation(0);
                }
            }
        };
        this.statsCheckbox = new JCheckBox(ToolsRes.getString("Checkbox.Statistics.Label"), false);
        this.statsCheckbox.setOpaque(false);
        this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        this.statsCheckbox.addActionListener(this.propsAndStatsAction);
        this.propsCheckbox = new JCheckBox(ToolsRes.getString("DataToolTab.Checkbox.Properties.Text"), true);
        this.propsCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Tooltip"));
        this.propsCheckbox.setOpaque(false);
        this.propsCheckbox.addActionListener(this.propsAndStatsAction);
        this.plot = new DataToolPlotter(this.getWorkingData());
        this.plotAxes = new DataToolAxes(this.plot);
        this.plot.setAxes(this.plotAxes);
        if (this.getWorkingData() != null) {
            this.plot.addDrawable(this.getWorkingData());
            this.plot.setTitle(this.getWorkingData().getName());
        }
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            Set<Integer> rowsInside = new HashSet<Integer>();
            Set<Integer> recent = new HashSet<Integer>();
            boolean boxActive;
            Interactive ia;

            public void mousePressed(MouseEvent mouseEvent) {
                this.ia = DataToolTab.this.plot.getInteractive();
                if (this.ia instanceof HighlightableDataset) {
                    HighlightableDataset highlightableDataset = (HighlightableDataset)this.ia;
                    int n = highlightableDataset.getHitIndex();
                    ListSelectionModel listSelectionModel = DataToolTab.this.dataTable.getColumnModel().getSelectionModel();
                    int n2 = DataToolTab.this.dataTable.getXColumn();
                    listSelectionModel.setSelectionInterval(n2, n2);
                    n2 = DataToolTab.this.dataTable.getYColumn();
                    listSelectionModel.addSelectionInterval(n2, n2);
                    if (!mouseEvent.isControlDown()) {
                        DataToolTab.this.dataTable.setSelectedModelRows(new int[]{n});
                    } else {
                        int[] nArray = DataToolTab.this.dataTable.getSelectedModelRows();
                        boolean bl = true;
                        int[] nArray2 = nArray;
                        int n3 = nArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int n5 = nArray2[n4];
                            if (n5 == n) {
                                bl = false;
                            }
                            ++n4;
                        }
                        int[] nArray3 = new int[bl ? nArray.length + 1 : nArray.length - 1];
                        if (bl) {
                            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                            nArray3[nArray.length] = n;
                        } else {
                            n4 = 0;
                            int[] nArray4 = nArray;
                            int n6 = nArray.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                n3 = nArray4[n7];
                                if (n3 != n) {
                                    nArray3[n4] = n3;
                                    ++n4;
                                }
                                ++n7;
                            }
                        }
                        DataToolTab.this.dataTable.setSelectedModelRows(nArray3);
                    }
                    DataToolTab.this.dataTable.getSelectedData();
                    DataToolTab.this.plot.repaint();
                    this.boxActive = false;
                    return;
                }
                if (this.ia != null) {
                    this.boxActive = false;
                    return;
                }
                boolean bl = this.boxActive = !OSPRuntime.isPopupTrigger(mouseEvent);
                if (this.boxActive) {
                    if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                        DataToolTab.this.dataTable.clearSelection();
                    }
                    this.rowsInside.clear();
                    int[] nArray = DataToolTab.this.dataTable.getSelectedModelRows();
                    int n = nArray.length;
                    int n8 = 0;
                    while (n8 < n) {
                        int n9 = nArray[n8];
                        this.rowsInside.add(new Integer(n9));
                        ++n8;
                    }
                    this.recent.clear();
                    Point point = mouseEvent.getPoint();
                    DataToolTab.this.plot.selectionBox.xstart = point.x;
                    DataToolTab.this.plot.selectionBox.ystart = point.y;
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!this.boxActive) {
                    return;
                }
                HighlightableDataset highlightableDataset = DataToolTab.this.getWorkingData();
                if (highlightableDataset == null) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                DataToolTab.this.plot.selectionBox.visible = true;
                DataToolTab.this.plot.selectionBox.setSize(point.x - DataToolTab.this.plot.selectionBox.xstart, point.y - DataToolTab.this.plot.selectionBox.ystart);
                double[] dArray = highlightableDataset.getXPoints();
                double[] dArray2 = highlightableDataset.getYPoints();
                int n = 0;
                while (n < dArray.length) {
                    double d = DataToolTab.this.plot.xToPix(dArray[n]);
                    double d2 = DataToolTab.this.plot.yToPix(dArray2[n]);
                    Integer n2 = DataToolTab.this.dataTable.workingRows.get(new Integer(n));
                    int n3 = n2;
                    if (DataToolTab.this.plot.selectionBox.contains(d, d2)) {
                        if (!this.rowsInside.contains(n2) && !this.recent.contains(n2)) {
                            if (this.rowsInside.isEmpty()) {
                                ListSelectionModel listSelectionModel = DataToolTab.this.dataTable.getColumnModel().getSelectionModel();
                                int n4 = DataToolTab.this.dataTable.getXColumn();
                                listSelectionModel.setSelectionInterval(n4, n4);
                                n4 = DataToolTab.this.dataTable.getYColumn();
                                listSelectionModel.addSelectionInterval(n4, n4);
                            }
                            this.rowsInside.add(n2);
                            this.recent.add(n2);
                            DataToolTab.this.dataTable.getSelectionModel().addSelectionInterval(n3, n3);
                        }
                    } else if (this.rowsInside.contains(n2) && this.recent.contains(n2)) {
                        DataToolTab.this.dataTable.getSelectionModel().removeSelectionInterval(n3, n3);
                        this.rowsInside.remove(n2);
                        this.recent.remove(n2);
                        DataToolTab.this.dataTable.getSelectionModel().removeSelectionInterval(n3, n3);
                        if (this.rowsInside.isEmpty()) {
                            DataToolTab.this.dataTable.getColumnModel().getSelectionModel().removeSelectionInterval(0, DataToolTab.this.dataTable.getColumnCount() - 1);
                        }
                    }
                    ++n;
                }
                highlightableDataset = DataToolTab.this.dataTable.getSelectedData();
                DataToolTab.this.plot.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DataToolTab.this.plot.selectionBox.visible = false;
                if (this.ia != null) {
                    if (this.ia instanceof Selectable) {
                        DataToolTab.this.plot.setMouseCursor(((Selectable)this.ia).getPreferredCursor());
                    } else {
                        DataToolTab.this.plot.setMouseCursor(Cursor.getPredefinedCursor(12));
                    }
                }
                DataToolTab.this.plot.repaint();
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                DataToolTable.WorkingDataset workingDataset = null;
                DataToolTab.this.plot.value = Double.NaN;
                DataToolTab.this.plot.slope = Double.NaN;
                double[] dArray = null;
                double[] dArray2 = null;
                int n = -1;
                if (DataToolTab.this.positionVisible || DataToolTab.this.slopeVisible || DataToolTab.this.areaVisible) {
                    workingDataset = DataToolTab.this.dataTable.workingData;
                    if (workingDataset == null) {
                        return;
                    }
                    if (workingDataset.getIndex() > 0) {
                        double d = DataToolTab.this.plot.pixToX(mouseEvent.getX());
                        n = DataToolTab.this.plot.findIndexNearestX(d, workingDataset);
                    }
                    dArray = workingDataset.getXPoints();
                    dArray2 = workingDataset.getYPoints();
                }
                if (DataToolTab.this.positionVisible && n > -1) {
                    DataToolTab.this.plot.value = dArray2[n];
                    DataToolTab.this.plot.crossbars.x = dArray[n];
                    DataToolTab.this.plot.crossbars.y = dArray2[n];
                    DataToolTab.this.plot.xVar = workingDataset.getXColumnName();
                    DataToolTab.this.plot.yVar = workingDataset.getYColumnName();
                }
                if (DataToolTab.this.slopeVisible && n > 0 && n < workingDataset.getIndex() - 1) {
                    DataToolTab.this.plot.slopeLine.x = dArray[n];
                    DataToolTab.this.plot.slopeLine.y = dArray2[n];
                    DataToolTab.this.plot.slope = (dArray2[n + 1] - dArray2[n - 1]) / (dArray[n + 1] - dArray[n - 1]);
                }
                if (DataToolTab.this.positionVisible || DataToolTab.this.slopeVisible || DataToolTab.this.areaVisible) {
                    DataToolTab.this.plot.setMessage(DataToolTab.this.plot.createMessage());
                }
                DataToolTab.this.plot.repaint();
            }
        };
        this.plot.addMouseListener(mouseInputAdapter);
        this.plot.addMouseMotionListener(mouseInputAdapter);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setBorder(BorderFactory.createEtchedBorder());
        this.toolbar.add(this.propsCheckbox);
        this.toolbar.add(this.bottomPaneCheckbox);
        this.toolbar.add(this.statsCheckbox);
        this.toolbar.add(this.valueCheckbox);
        this.toolbar.add(this.slopeCheckbox);
        this.toolbar.add(this.areaCheckbox);
        this.toolbar.add(Box.createGlue());
        this.toolbar.add(this.newColumnButton);
        this.toolbar.add(this.dataBuilderButton);
        this.toolbar.add(this.refreshDataButton);
        this.toolbar.add(this.helpButton);
        this.curveFitter = new DatasetCurveFitter(this.getWorkingData());
        this.curveFitter.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("changed")) {
                    DataToolTab.this.tabChanged(true);
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("drawer") && DataToolTab.this.bottomPaneCheckbox != null && DataToolTab.this.bottomPaneCheckbox.isSelected()) {
                    DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                    if (!(DataToolTab.this instanceof FourierToolTab)) {
                        DataToolTab.this.plot.addDrawable((FunctionDrawer)propertyChangeEvent.getNewValue());
                    }
                }
                DataToolTab.this.plot.repaint();
            }
        });
        this.statsTable = new DataToolStatsTable(this.dataTable);
        this.statsScroller = new JScrollPane(this.statsTable){

            public Dimension getPreferredSize() {
                Dimension dimension = DataToolTab.this.statsTable.getPreferredSize();
                return dimension;
            }
        };
        this.propsTable = new DataToolPropsTable(this.dataTable);
        this.propsTable.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("display")) {
                    DataToolTab.this.refreshPlot();
                }
            }
        });
        this.propsScroller = new JScrollPane(this.propsTable){

            public Dimension getPreferredSize() {
                Dimension dimension = DataToolTab.this.propsTable.getPreferredSize();
                return dimension;
            }
        };
        this.statusLabel = new JLabel(" ", 10);
        this.statusLabel.setFont(new JTextField().getFont());
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.editableLabel = new JLabel(" ", 11);
        this.editableLabel.setFont(new JTextField().getFont());
        this.editableLabel.setBorder(BorderFactory.createEmptyBorder(1, 12, 1, 2));
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.splitPanes[0], "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.statusLabel, "West");
        jPanel.add((Component)this.editableLabel, "East");
        this.add((Component)jPanel, "South");
        this.splitPanes[0].setLeftComponent(this.splitPanes[1]);
        this.splitPanes[0].setRightComponent(this.splitPanes[2]);
        this.splitPanes[1].setTopComponent(this.plot);
        this.splitPanes[1].setBottomComponent(this.curveFitter);
        this.splitPanes[2].setBottomComponent(jScrollPane);
        this.splitPanes[0].setDividerLocation(0);
        this.curveFitter.splitPane.setDividerLocation(0);
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
    }

    protected void refreshGUI() {
        Runnable runnable = new Runnable(){

            public void run() {
                boolean bl = DataToolTab.this.tabChanged;
                DataToolTab.this.newColumnButton.setText(ToolsRes.getString("DataToolTab.Button.NewColumn.Text"));
                DataToolTab.this.newColumnButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.NewColumn.Tooltip"));
                DataToolTab.this.dataBuilderButton.setText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
                DataToolTab.this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
                DataToolTab.this.dataBuilderButton.setEnabled(DataToolTab.this.originatorID != 0);
                DataToolTab.this.refreshDataButton.setText(ToolsRes.getString("DataToolTab.Button.Refresh.Text"));
                DataToolTab.this.refreshDataButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Refresh.Tooltip"));
                DataToolTab.this.statsCheckbox.setText(ToolsRes.getString("Checkbox.Statistics.Label"));
                DataToolTab.this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
                DataToolTab.this.bottomPaneCheckbox.setText(ToolsRes.getString("Checkbox.Fits.Label"));
                DataToolTab.this.bottomPaneCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Fits.ToolTip"));
                DataToolTab.this.propsCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Text"));
                DataToolTab.this.propsCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Tooltip"));
                DataToolTab.this.valueCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Position"));
                DataToolTab.this.valueCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Position.Tooltip"));
                DataToolTab.this.slopeCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Slope"));
                DataToolTab.this.slopeCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Slope.Tooltip"));
                DataToolTab.this.areaCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Area"));
                DataToolTab.this.areaCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Area.Tooltip"));
                DataToolTab.this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
                DataToolTab.this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
                DataToolTab.this.toolbar.remove(DataToolTab.this.newColumnButton);
                if (DataToolTab.this.userEditable) {
                    int n = DataToolTab.this.toolbar.getComponentIndex(DataToolTab.this.helpButton);
                    DataToolTab.this.toolbar.add((Component)DataToolTab.this.newColumnButton, n);
                    DataToolTab.this.toolbar.validate();
                }
                DataToolTab.this.toolbar.remove(DataToolTab.this.refreshDataButton);
                Collection<Tool> collection = DataToolTab.this.jobManager.getTools(DataToolTab.this.dataManager);
                for (Tool tool : collection) {
                    if (!(tool instanceof DataRefreshTool)) continue;
                    int n = DataToolTab.this.toolbar.getComponentIndex(DataToolTab.this.helpButton);
                    DataToolTab.this.toolbar.add((Component)DataToolTab.this.refreshDataButton, n);
                    DataToolTab.this.toolbar.validate();
                    break;
                }
                DataToolTab.this.curveFitter.refreshGUI();
                DataToolTab.this.statsTable.refreshGUI();
                DataToolTab.this.propsTable.refreshGUI();
                DataToolTab.this.refreshPlot();
                DataToolTab.this.refreshStatusBar();
                DataToolTab.this.tabChanged = bl;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        if (this.splitPanes[0].getDividerLocation() < 10) {
            this.splitPanes[0].setDividerLocation(0.7);
            this.curveFitter.splitPane.setDividerLocation(1.0);
        }
        this.splitPanes[1].setDividerLocation(1.0);
        this.propsAndStatsAction.actionPerformed(null);
        int n = 0;
        while (n < this.dataTable.getColumnCount()) {
            String string = this.dataTable.getColumnName(n);
            this.dataTable.getWorkingData(string);
            ++n;
        }
        this.refreshPlot();
        this.refreshGUI();
        this.isInitialized = true;
    }

    private void buildVarPopup() {
        if (this.setVarAction == null) {
            this.setVarAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string = jMenuItem.getActionCommand();
                    String string2 = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.plot.yVar : DataToolTab.this.plot.xVar;
                    int n = DataToolTab.this.dataTable.convertColumnIndexToView(0);
                    int n2 = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.dataTable.getXColumn() : DataToolTab.this.dataTable.getYColumn();
                    TableModel tableModel = DataToolTab.this.dataTable.getModel();
                    int n3 = 0;
                    while (n3 < tableModel.getColumnCount()) {
                        if (string.equals(DataToolTab.this.dataTable.getColumnName(n3))) {
                            if (n3 == n2) {
                                return;
                            }
                            DataToolTab.this.dataTable.getColumnModel().moveColumn(n3, n2);
                            break;
                        }
                        ++n3;
                    }
                    if (!string.equals(string2)) {
                        n2 = DataToolTab.this.isHorzVarPopup ? DataToolTab.this.dataTable.getYColumn() : DataToolTab.this.dataTable.getXColumn();
                        n3 = 0;
                        while (n3 < tableModel.getColumnCount()) {
                            if (string2.equals(DataToolTab.this.dataTable.getColumnName(n3))) {
                                DataToolTab.this.dataTable.getColumnModel().moveColumn(n3, n2);
                                break;
                            }
                            ++n3;
                        }
                    }
                    n2 = DataToolTab.this.dataTable.convertColumnIndexToView(0);
                    DataToolTab.this.dataTable.getColumnModel().moveColumn(n2, n);
                }
            };
        }
        this.varPopup = new JPopupMenu();
        Font font = new JTextField().getFont();
        for (Dataset dataset : this.dataManager.getDatasets()) {
            String string = TeXParser.removeSubscripting(dataset.getYColumnName());
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setActionCommand(dataset.getYColumnName());
            jMenuItem.addActionListener(this.setVarAction);
            jMenuItem.setFont(font);
            this.varPopup.add(jMenuItem);
        }
    }

    private DataColumn getIDMatch(Dataset dataset, ArrayList<DataColumn> arrayList) {
        if (arrayList == null || dataset == null) {
            return null;
        }
        for (DataColumn dataColumn : arrayList) {
            if (dataset.getID() != dataColumn.getID() || dataset.getColumnID() != dataColumn.getColumnID()) continue;
            return dataColumn;
        }
        return null;
    }

    protected boolean isDuplicateColumn(String string, double[] dArray) {
        for (Dataset dataset : this.dataManager.getDatasets()) {
            double[] dArray2 = dataset.getYPoints();
            if (!string.equals(dataset.getYColumnName()) || !this.isDuplicate(dArray, dataset.getYPoints())) continue;
            if (dArray.length > dArray2.length) {
                dataset.clear();
                dataset.append(dArray, dArray);
            }
            return true;
        }
        return false;
    }

    private boolean isDuplicate(double[] dArray, double[] dArray2) {
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            if (!(Double.isNaN(dArray[n2]) && Double.isNaN(dArray2[n2]) || dArray[n2] == dArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isOwnedBy(Data data) {
        if (data == null) {
            return false;
        }
        String string = data.getName();
        if (string != null && this.replaceSpacesWithUnderscores(string).equals(this.getName())) {
            return true;
        }
        return data.getID() == this.originatorID;
    }

    protected void refreshPlot() {
        this.curveFitter.setData(this.dataTable.getSelectedData());
        this.plot.removeDrawables(Dataset.class);
        DataToolTable.WorkingDataset workingDataset = this.getWorkingData();
        this.valueCheckbox.setEnabled(workingDataset != null && workingDataset.getIndex() > 0);
        if (!this.valueCheckbox.isEnabled()) {
            this.valueCheckbox.setSelected(false);
            this.positionVisible = false;
        }
        this.slopeCheckbox.setEnabled(workingDataset != null && workingDataset.getIndex() > 2);
        if (!this.slopeCheckbox.isEnabled()) {
            this.slopeCheckbox.setSelected(false);
            this.slopeVisible = false;
        }
        this.areaCheckbox.setEnabled(workingDataset != null && workingDataset.getIndex() > 1);
        if (!this.areaCheckbox.isEnabled()) {
            this.areaCheckbox.setSelected(false);
            this.areaVisible = false;
        }
        if (workingDataset != null) {
            String string;
            Object object2;
            int n = this.dataTable.convertColumnIndexToView(0);
            String string2 = this.dataTable.getColumnName(n == 0 ? 1 : 0);
            HashMap<String, DataToolTable.WorkingDataset> hashMap = this.dataTable.workingMap;
            for (Object object2 : hashMap.values()) {
                ((DataToolTable.WorkingDataset)object2).setXSource(workingDataset.getXSource());
                String string3 = ((Dataset)object2).getYColumnName();
                if (object2 == workingDataset || string3.equals(string2) || !((DataToolTable.WorkingDataset)object2).isMarkersVisible() && !((Dataset)object2).isConnected()) continue;
                ((HighlightableDataset)object2).clearHighlights();
                if (!((DataToolTable.WorkingDataset)object2).isMarkersVisible()) {
                    ((DataToolTable.WorkingDataset)object2).setMarkerShape(0);
                }
                this.plot.addDrawable((Drawable)object2);
            }
            this.plot.addDrawable(workingDataset);
            if (this.areaVisible) {
                this.plot.limits[0].x = Math.max(this.plot.limits[0].x, workingDataset.getXMin());
                this.plot.limits[0].x = Math.min(this.plot.limits[0].x, workingDataset.getXMax());
                this.plot.limits[1].x = Math.max(this.plot.limits[1].x, workingDataset.getXMin());
                this.plot.limits[1].x = Math.min(this.plot.limits[1].x, workingDataset.getXMax());
            }
            workingDataset.restoreHighlights();
            if (this.bottomPaneCheckbox != null && this.bottomPaneCheckbox.isSelected()) {
                this.plot.removeDrawable(this.curveFitter.getDrawer());
                this.plot.addDrawable(this.curveFitter.getDrawer());
            }
            String string4 = workingDataset.getColumnName(0);
            object2 = workingDataset.getColumnName(1);
            int n2 = 0;
            while (n2 < this.dataTable.getColumnCount()) {
                DataToolTable.WorkingDataset workingDataset2;
                string = this.dataTable.getColumnName(n2);
                if (!(string.equals(string4) || string.equals(workingDataset.getColumnName(1)) || string.equals(DataTable.rowName) || (workingDataset2 = this.dataTable.getWorkingData(string)) == null || !workingDataset2.markersVisible && !workingDataset2.isConnected())) {
                    object2 = String.valueOf(object2) + ", " + string;
                }
                ++n2;
            }
            this.plot.setAxisLabels(string4, (String)object2);
            String string5 = TeXParser.removeSubscripting(workingDataset.getColumnName(1));
            string = TeXParser.removeSubscripting(workingDataset.getColumnName(0));
            if (this.curveFitter.fit instanceof UserFunction) {
                this.curveFitter.eqnField.setText(String.valueOf(string5) + " = " + ((UserFunction)this.curveFitter.fit).getFullExpression(new String[]{string}));
            } else {
                this.curveFitter.eqnField.setText(String.valueOf(string5) + " = " + this.curveFitter.fit.getExpression(string));
            }
        } else {
            this.plot.setXLabel("");
            this.plot.setYLabel("");
        }
        if (this.dataTool != null) {
            this.dataTool.refreshTabTitles();
        }
        if (this.areaVisible) {
            this.plot.refreshArea(workingDataset);
        }
        this.repaint();
    }

    protected void refreshStatusBar() {
        if (this.dataManager.getDatasets().size() < 2) {
            this.statusLabel.setText(this.userEditable ? ToolsRes.getString("DataToolTab.StatusBar.Text.CreateColumns") : ToolsRes.getString("DataToolTab.StatusBar.Text.PasteColumns"));
        } else {
            this.statusLabel.setText(ToolsRes.getString("DataToolTab.StatusBar.Text.DragColumns"));
        }
        this.editableLabel.setText(this.userEditable ? ToolsRes.getString("DataTool.MenuItem.Editable").toLowerCase() : ToolsRes.getString("DataTool.MenuItem.Noneditable").toLowerCase());
        this.editableLabel.setForeground(this.userEditable ? Color.GREEN.darker() : Color.RED.darker());
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class DataToolAxes
    extends CartesianInteractive {
        DataToolAxes(PlottingPanel plottingPanel) {
            super(plottingPanel);
        }

        protected boolean hasHorzVariablesPopup() {
            return DataToolTab.this.dataTable.workingData != null;
        }

        protected JPopupMenu getHorzVariablesPopup() {
            if (DataToolTab.this.varPopup == null) {
                DataToolTab.this.buildVarPopup();
            }
            DataToolTab.this.isHorzVarPopup = true;
            FontSizer.setFonts(DataToolTab.this.varPopup, DataToolTab.this.fontLevel);
            Component[] componentArray = DataToolTab.this.varPopup.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                JMenuItem jMenuItem = (JMenuItem)component;
                if (this.xLine.getText().equals(jMenuItem.getActionCommand())) {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(1));
                } else {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(0));
                }
                ++n2;
            }
            return DataToolTab.this.varPopup;
        }

        protected boolean hasVertVariablesPopup() {
            return DataToolTab.this.dataTable.workingData != null;
        }

        protected JPopupMenu getVertVariablesPopup() {
            if (DataToolTab.this.varPopup == null) {
                DataToolTab.this.buildVarPopup();
            }
            DataToolTab.this.isHorzVarPopup = false;
            FontSizer.setFonts(DataToolTab.this.varPopup, DataToolTab.this.fontLevel);
            Component[] componentArray = DataToolTab.this.varPopup.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                JMenuItem jMenuItem = (JMenuItem)component;
                if (this.yLine.getText().equals(jMenuItem.getActionCommand())) {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(1));
                } else {
                    jMenuItem.setFont(jMenuItem.getFont().deriveFont(0));
                }
                ++n2;
            }
            return DataToolTab.this.varPopup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DataToolPlotter
    extends PlottingPanel {
        SelectionBox selectionBox;
        Crossbars crossbars;
        SlopeLine slopeLine;
        Dataset areaDataset;
        LimitLine[] limits;
        double value;
        double slope;
        double area;
        DecimalFormat sciFormat;
        DecimalFormat fixedFormat;
        String xVar;
        String yVar;
        String message;

        DataToolPlotter(Dataset dataset) {
            super(dataset == null ? "x" : dataset.getColumnName(0), dataset == null ? "y" : dataset.getColumnName(1), "");
            this.limits = new LimitLine[2];
            this.value = Double.NaN;
            this.slope = Double.NaN;
            this.sciFormat = new DecimalFormat("0.00E0");
            this.fixedFormat = new DecimalFormat("0.00");
            this.setAntialiasShapeOn(true);
            this.selectionBox = new SelectionBox();
            this.crossbars = new Crossbars();
            this.slopeLine = new SlopeLine();
            this.limits[0] = new LimitLine();
            this.limits[1] = new LimitLine();
            this.addDrawable(this.limits[0]);
            this.addDrawable(this.limits[1]);
            this.addDrawable(this.selectionBox);
        }

        @Override
        protected void paintDrawableList(Graphics graphics, ArrayList<Drawable> arrayList) {
            super.paintDrawableList(graphics, arrayList);
            if (arrayList.contains(DataToolTab.this.curveFitter.getDrawer())) {
                double[] dArray = DataToolTab.this.curveFitter.getDrawer().getYRange();
                if (dArray[0] >= this.getYMax() || dArray[1] <= this.getYMin()) {
                    String string = ToolsRes.getString("DataToolTab.Plot.Message.FitNotVisible");
                    if (this.message != null && !"".equals(this.message)) {
                        string = String.valueOf(string) + "  " + this.message;
                    }
                    this.setMessage(string);
                } else {
                    this.setMessage(this.message);
                }
            } else {
                this.setMessage(this.message);
            }
            this.slopeLine.draw(graphics);
            this.crossbars.draw(graphics);
        }

        void setAreaVisible(boolean bl) {
            DataToolTab.this.areaVisible = bl;
            if (this.areaDataset == null) {
                this.areaDataset = new Dataset();
                this.areaDataset.setMarkerShape(5);
                this.areaDataset.setConnected(false);
                this.areaDataset.setMarkerColor(new Color(102, 102, 102, 51));
                DataToolTable.WorkingDataset workingDataset = DataToolTab.this.dataTable.workingData;
                if (workingDataset != null && workingDataset.getIndex() > 1) {
                    this.limits[0].x = workingDataset.getXMin();
                    this.limits[1].x = workingDataset.getXMax();
                }
            }
            DataToolTab.this.refreshPlot();
            this.setMessage(this.createMessage());
        }

        void refreshArea(Dataset dataset) {
            if (!DataToolTab.this.areaVisible) {
                return;
            }
            this.area = 0.0;
            if (dataset == null) {
                DataToolTab.this.areaVisible = false;
                this.setMessage(this.createMessage());
                return;
            }
            double[] dArray = dataset.getXPoints();
            double[] dArray2 = dataset.getYPoints();
            this.areaDataset.clear();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            int n = 0;
            while (n < dArray.length) {
                double d = Math.min(this.limits[0].x, this.limits[1].x);
                double d2 = Math.max(this.limits[0].x, this.limits[1].x);
                if (dArray[n] >= d && dArray[n] <= d2) {
                    arrayList.add(new Double(dArray[n]));
                    arrayList2.add(new Double(dArray2[n]));
                }
                ++n;
            }
            if (!arrayList.isEmpty()) {
                dArray = new double[arrayList.size()];
                dArray2 = new double[arrayList.size()];
                n = 0;
                while (n < dArray.length) {
                    dArray[n] = (Double)arrayList.get(n);
                    dArray2[n] = (Double)arrayList2.get(n);
                    ++n;
                }
                this.areaDataset.append(dArray[0], 0.0);
                this.areaDataset.append(dArray, dArray2);
                this.areaDataset.append(dArray[dArray.length - 1], 0.0);
                n = dArray.length;
                if (n > 1) {
                    DataToolTab.this.plot.addDrawable(this.areaDataset);
                    this.area = dArray2[0] * (dArray[1] - dArray[0]);
                    this.area += dArray2[n - 1] * (dArray[n - 1] - dArray[n - 2]);
                    int n2 = 1;
                    while (n2 < n - 1) {
                        this.area += dArray2[n2] * (dArray[n2 + 1] - dArray[n2 - 1]);
                        ++n2;
                    }
                    this.area /= 2.0;
                }
            }
            this.setMessage(this.createMessage());
        }

        protected int findIndexNearestX(double d, Dataset dataset) {
            if (dataset == null) {
                return -1;
            }
            int n = dataset.getIndex() - 1;
            if (n == -1) {
                return -1;
            }
            d = Math.max(DataToolTab.this.plot.getXMin(), d);
            d = Math.min(DataToolTab.this.plot.getXMax(), d);
            double[] dArray = dataset.getXPoints();
            Arrays.sort(dArray);
            if (d < dArray[0]) {
                return 0;
            }
            if (d >= dArray[n]) {
                return n;
            }
            int n2 = 1;
            while (n2 < dArray.length) {
                if (d >= dArray[n2 - 1] && d < dArray[n2]) {
                    d = dArray[n2 - 1] < DataToolTab.this.plot.getXMin() ? dArray[n2] : (dArray[n2] > DataToolTab.this.plot.getXMax() ? dArray[n2 - 1] : (Math.abs(d - dArray[n2 - 1]) < Math.abs(d - dArray[n2]) ? dArray[n2 - 1] : dArray[n2]));
                    double[] dArray2 = dataset.getXPoints();
                    int n3 = 0;
                    while (n3 < dArray2.length) {
                        if (dArray2[n3] == d) {
                            return n3;
                        }
                        ++n3;
                    }
                    return -1;
                }
                ++n2;
            }
            return -1;
        }

        String createMessage() {
            StringBuffer stringBuffer = new StringBuffer();
            if (DataToolTab.this.positionVisible && !Double.isNaN(this.value)) {
                stringBuffer.append(String.valueOf(TeXParser.removeSubscripting(this.xVar)) + "=");
                stringBuffer.append(this.format(DataToolTab.this.plot.crossbars.x, this.getXMax() - this.getXMin()));
                stringBuffer.append("  ");
                stringBuffer.append(String.valueOf(TeXParser.removeSubscripting(this.yVar)) + "=");
                stringBuffer.append(this.format(DataToolTab.this.plot.crossbars.y, this.getYMax() - this.getYMin()));
            }
            if (DataToolTab.this.slopeVisible && !Double.isNaN(this.slope)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(ToolsRes.getString("DataToolPlotter.Message.Slope"));
                stringBuffer.append(this.format(DataToolTab.this.plot.slope, 0.0));
            }
            if (DataToolTab.this.areaVisible) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(ToolsRes.getString("DataToolPlotter.Message.Area"));
                stringBuffer.append(this.format(DataToolTab.this.plot.area, 0.0));
            }
            this.message = stringBuffer.toString();
            return this.message;
        }

        String format(double d, double d2) {
            double d3 = Math.min(1.0, d2) / 1000.0;
            if (Math.abs(d) < d3) {
                d = 0.0;
            }
            if (d2 < 1.0 && d != 0.0) {
                return this.sciFormat.format(d);
            }
            return Math.abs(d) <= 10.0 ? this.fixedFormat.format(d) : this.sciFormat.format(d);
        }

        void setAxisLabels(String string, String string2) {
            this.setXLabel(string);
            this.setYLabel(string2);
            this.xVar = TeXParser.removeSubscripting(string);
            this.yVar = TeXParser.removeSubscripting(string2);
            String string3 = String.valueOf(this.xVar) + "=";
            String string4 = "  " + this.yVar + "=";
            this.coordinateStrBuilder.setCoordinateLabels(string3, string4);
        }

        @Override
        protected void setFontLevel(int n) {
            super.setFontLevel(n);
        }

        class Crossbars {
            double x;
            double y;
            Color color = new Color(0, 0, 0);

            Crossbars() {
            }

            public void draw(Graphics graphics) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.positionVisible || Double.isNaN(DataToolPlotter.this.value)) {
                    return;
                }
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                graphics.drawLine(DataToolPlotter.this.getLeftGutter(), DataToolPlotter.this.yToPix(this.y), DataToolPlotter.this.getWidth() - DataToolPlotter.this.getRightGutter() - 1, DataToolPlotter.this.yToPix(this.y));
                graphics.drawLine(DataToolPlotter.this.xToPix(this.x), DataToolPlotter.this.getTopGutter(), DataToolPlotter.this.xToPix(this.x), DataToolPlotter.this.getHeight() - DataToolPlotter.this.getBottomGutter() - 1);
                graphics.setColor(color);
            }
        }

        class LimitLine
        extends Line2D.Double
        implements Selectable {
            double x;
            Stroke stroke = new BasicStroke(1.0f);
            Rectangle hitRect = new Rectangle();
            Color color = new Color(51, 51, 51);
            Cursor move;

            LimitLine() {
            }

            public void draw(DrawingPanel drawingPanel, Graphics graphics) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible) {
                    return;
                }
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                int n = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getTopGutter();
                int n2 = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBounds().height - ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getBottomGutter();
                int n3 = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.xToPix(this.x);
                this.setLine(n3 + 1, n, n3 + 1, n2);
                ((Graphics2D)graphics).fill(this.stroke.createStrokedShape(this));
                graphics.setColor(color);
                this.hitRect.setBounds(n3 - 2, n, 6, n2 - n - 20);
            }

            public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
                if (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible && this.hitRect.contains(n, n2)) {
                    return this;
                }
                return null;
            }

            public Cursor getPreferredCursor() {
                if (this.move == null) {
                    String string = "/org/opensourcephysics/resources/tools/images/limitcursor.gif";
                    Image image = ResourceLoader.getImage(string);
                    this.move = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "Move Integration Limit");
                }
                return this.move;
            }

            public void setXY(double d, double d2) {
                this.setX(d);
            }

            public void setX(double d) {
                DataToolTable.WorkingDataset workingDataset = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                int n = DataToolPlotter.this.findIndexNearestX(d, workingDataset);
                this.x = n == -1 ? d : workingDataset.getXPoints()[n];
                DataToolPlotter.this.refreshArea(workingDataset);
                DataToolPlotter.this.createMessage();
                ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.setMessage(DataToolPlotter.this.message);
            }

            public boolean isMeasured() {
                return ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.areaVisible;
            }

            public double getXMin() {
                DataToolTable.WorkingDataset workingDataset = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                double d = 0.0;
                double d2 = 0.0;
                if (workingDataset != null && workingDataset.getIndex() > 1) {
                    d = Math.abs(workingDataset.getXMax() - workingDataset.getXMin());
                    d2 = Math.min(workingDataset.getXMax(), workingDataset.getXMin());
                } else {
                    d = Math.abs(DataToolPlotter.this.limits[0].x - DataToolPlotter.this.limits[1].x);
                    d2 = Math.min(DataToolPlotter.this.limits[0].x, DataToolPlotter.this.limits[1].x);
                }
                return d2 - 0.02 * d;
            }

            public double getXMax() {
                DataToolTable.WorkingDataset workingDataset = ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.dataTable.workingData;
                double d = 0.0;
                double d2 = 0.0;
                if (workingDataset != null && workingDataset.getIndex() > 1) {
                    d = Math.abs(workingDataset.getXMax() - workingDataset.getXMin());
                    d2 = Math.max(workingDataset.getXMax(), workingDataset.getXMin());
                } else {
                    d = Math.abs(DataToolPlotter.this.limits[0].x - DataToolPlotter.this.limits[1].x);
                    d2 = Math.max(DataToolPlotter.this.limits[0].x, DataToolPlotter.this.limits[1].x);
                }
                return d2 + 0.02 * d;
            }

            public double getYMin() {
                return (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMin() + ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMax()) / 2.0;
            }

            public double getYMax() {
                return (((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMin() + ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.getYMax()) / 2.0;
            }

            public void setY(double d) {
            }

            public double getX() {
                return this.x;
            }

            public double getY() {
                return 0.0;
            }

            public void setSelected(boolean bl) {
            }

            public boolean isSelected() {
                return false;
            }

            public void toggleSelected() {
            }

            public boolean isEnabled() {
                return true;
            }

            public void setEnabled(boolean bl) {
            }
        }

        class SelectionBox
        extends Rectangle
        implements Drawable {
            boolean visible = true;
            int xstart;
            int ystart;
            Color color = new Color(0, 255, 0, 127);

            SelectionBox() {
            }

            public void setSize(int n, int n2) {
                int n3 = Math.min(0, n);
                int n4 = Math.min(0, n2);
                n = Math.abs(n);
                n2 = Math.abs(n2);
                super.setLocation(this.xstart + n3, this.ystart + n4);
                super.setSize(n, n2);
            }

            public void draw(DrawingPanel drawingPanel, Graphics graphics) {
                if (this.visible) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setColor(this.color);
                    graphics2D.draw(this);
                }
            }
        }

        class SlopeLine
        extends Line2D.Double {
            double x;
            double y;
            Stroke stroke = new BasicStroke(1.5f);
            int length = 30;
            Color color = new Color(0, 0, 0);

            SlopeLine() {
            }

            public void draw(Graphics graphics) {
                if (!((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.slopeVisible || Double.isNaN(DataToolPlotter.this.slope)) {
                    return;
                }
                double d = 1.0 * DataToolPlotter.this.getXPixPerUnit();
                double d2 = DataToolPlotter.this.slope * DataToolPlotter.this.getYPixPerUnit();
                double d3 = Math.sqrt(d * d + d2 * d2);
                double d4 = d2 / d3;
                double d5 = d / d3;
                int n = DataToolPlotter.this.xToPix(this.x);
                int n2 = DataToolPlotter.this.yToPix(this.y);
                this.setLine((double)n - (double)this.length * d5 + 1.0, (double)n2 + (double)this.length * d4 + 1.0, (double)n + (double)this.length * d5 + 1.0, (double)n2 - (double)this.length * d4 + 1.0);
                Color color = graphics.getColor();
                graphics.setColor(this.color);
                ((Graphics2D)graphics).fill(this.stroke.createStrokedShape(this));
                graphics.setColor(color);
            }
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        /*
         * WARNING - void declaration
         */
        public void saveObject(XMLControl xMLControl, Object object) {
            String[] stringArray;
            Object object2;
            DataToolTab dataToolTab = (DataToolTab)object;
            xMLControl.setValue("name", dataToolTab.getName());
            xMLControl.setValue("editable", dataToolTab.userEditable);
            DatasetManager datasetManager = new DatasetManager();
            ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
            for (Dataset object32 : dataToolTab.dataManager.getDatasets()) {
                if (object32 instanceof DataFunction) {
                    arrayList.add(object32);
                    continue;
                }
                datasetManager.addDataset(object32);
            }
            xMLControl.setValue("data", datasetManager);
            if (!arrayList.isEmpty()) {
                object2 = arrayList.toArray(new DataFunction[0]);
                xMLControl.setValue("data_functions", object2);
            }
            if (DatasetCurveFitter.fitBuilder != null) {
                object2 = new ArrayList<FunctionPanel>(DatasetCurveFitter.fitBuilder.panels.values());
                xMLControl.setValue("fits", object2);
            }
            xMLControl.setValue("selected_fit", dataToolTab.curveFitter.getSelectedFitName());
            xMLControl.setValue("autofit", dataToolTab.curveFitter.autofitCheckBox.isSelected());
            if (!dataToolTab.curveFitter.autofitCheckBox.isSelected()) {
                void var7_10;
                object2 = new double[dataToolTab.curveFitter.paramModel.getRowCount()];
                boolean n = false;
                while (var7_10 < ((DataFunction[])object2).length) {
                    stringArray = (String[])dataToolTab.curveFitter.paramModel.getValueAt((int)var7_10, 1);
                    object2[var7_10] = (DataFunction)stringArray.doubleValue();
                    ++var7_10;
                }
                xMLControl.setValue("fit_parameters", object2);
            }
            xMLControl.setValue("fit_color", dataToolTab.curveFitter.color);
            xMLControl.setValue("fit_visible", dataToolTab.bottomPaneCheckbox.isSelected());
            xMLControl.setValue("props_visible", dataToolTab.propsCheckbox.isSelected());
            xMLControl.setValue("stats_visible", dataToolTab.statsCheckbox.isSelected());
            int n = dataToolTab.splitPanes[0].getDividerLocation();
            xMLControl.setValue("split_pane", n);
            n = dataToolTab.curveFitter.splitPane.getDividerLocation();
            xMLControl.setValue("fit_split_pane", n);
            int[] nArray = dataToolTab.dataTable.getModelColumnOrder();
            xMLControl.setValue("column_order", nArray);
            stringArray = dataToolTab.dataTable.getHiddenMarkers();
            xMLControl.setValue("hidden_markers", stringArray);
            Collection<String> collection = dataToolTab.dataTable.getPatternColumns();
            if (!collection.isEmpty()) {
                ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
                for (String string : collection) {
                    String string2 = dataToolTab.dataTable.getFormatPattern(string);
                    arrayList2.add(new String[]{string, string2});
                }
                xMLControl.setValue("format_patterns", arrayList2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            DatasetManager datasetManager = (DatasetManager)xMLControl.getObject("data");
            if (datasetManager == null) {
                return new DataToolTab(null);
            }
            for (Dataset dataset : datasetManager.getDatasets()) {
                dataset.setXColumnVisible(false);
            }
            return new DataToolTab(datasetManager);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Runnable runnable2;
            String[] stringArray;
            Object object2;
            Object object32;
            final DataToolTab dataToolTab = (DataToolTab)object;
            dataToolTab.setName(xMLControl.getString("name"));
            for (Object object32 : xMLControl.getPropertyContent()) {
                if (!object32.getPropertyName().equals("data_functions")) continue;
                object2 = object32.getChildControls();
                int n = 0;
                while (n < ((XMLControl[])object2).length) {
                    DataFunction dataFunction = new DataFunction(dataToolTab.dataManager);
                    object2[n].loadObject(dataFunction);
                    dataFunction.setXColumnVisible(false);
                    dataToolTab.dataManager.addDataset(dataFunction);
                    ++n;
                }
                ArrayList<Dataset> arrayList = dataToolTab.dataManager.getDatasets();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    if (arrayList.get(n2) instanceof DataFunction) {
                        ((DataFunction)arrayList.get(n2)).refreshFunctionData();
                    }
                    ++n2;
                }
                dataToolTab.dataTable.refreshTable();
                break;
            }
            dataToolTab.userEditable = xMLControl.getBoolean("editable");
            object32 = (ArrayList)xMLControl.getObject("fits");
            if (object32 != null) {
                Iterator<Object> iterator = ((ArrayList)object32).iterator();
                while (iterator.hasNext()) {
                    object2 = (FitFunctionPanel)iterator.next();
                    DatasetCurveFitter.fitBuilder.addPanel(((Component)object2).getName(), (FunctionPanel)object2);
                }
            }
            object2 = xMLControl.getString("selected_fit");
            dataToolTab.curveFitter.fitDropDown.setSelectedItem(object2);
            boolean bl = xMLControl.getBoolean("autofit");
            dataToolTab.curveFitter.autofitCheckBox.setSelected(bl);
            double[] dArray = (double[])xMLControl.getObject("fit_parameters");
            if (dArray != null) {
                int n = 0;
                while (n < dArray.length) {
                    dataToolTab.curveFitter.setParameterValue(n, dArray[n]);
                    ++n;
                }
            }
            Color color = (Color)xMLControl.getObject("fit_color");
            dataToolTab.curveFitter.setColor(color);
            boolean bl2 = xMLControl.getBoolean("fit_visible");
            dataToolTab.bottomPaneCheckbox.setSelected(bl2);
            bl2 = xMLControl.getBoolean("props_visible");
            dataToolTab.propsCheckbox.setSelected(bl2);
            bl2 = xMLControl.getBoolean("stats_visible");
            dataToolTab.statsCheckbox.setSelected(bl2);
            final int n = xMLControl.getInt("split_pane");
            final int n3 = xMLControl.getInt("fit_split_pane");
            int[] nArray = (int[])xMLControl.getObject("column_order");
            dataToolTab.dataTable.setModelColumnOrder(nArray);
            if (nArray == null && (stringArray = (String[])xMLControl.getObject("working_columns")) != null) {
                dataToolTab.dataTable.setWorkingColumns(stringArray[0], stringArray[1]);
            }
            stringArray = (String[])xMLControl.getObject("hidden_markers");
            dataToolTab.dataTable.hideMarkers(stringArray);
            ArrayList arrayList = (ArrayList)xMLControl.getObject("format_patterns");
            if (arrayList != null) {
                for (Runnable runnable2 : arrayList) {
                    dataToolTab.dataTable.setFormatPattern(runnable2[0], runnable2[1]);
                }
            }
            runnable2 = new Runnable(){

                public synchronized void run() {
                    dataToolTab.bottomPaneAction.actionPerformed(null);
                    dataToolTab.propsAndStatsAction.actionPerformed(null);
                    dataToolTab.splitPanes[0].setDividerLocation(n);
                    dataToolTab.curveFitter.splitPane.setDividerLocation(n3);
                    dataToolTab.dataTable.refreshTable();
                    dataToolTab.propsTable.refreshTable();
                    dataToolTab.tabChanged(false);
                }
            };
            SwingUtilities.invokeLater(runnable2);
            return object;
        }
    }
}

