/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.numerics.GeneralStateEvent;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.numerics.ODEEventSolver;
import org.opensourcephysics.numerics.ODESolverException;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.numerics.ZenoEffectListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODEInterpolatorEventSolver
implements ODEEventSolver,
ODEAdaptiveSolver {
    public static final int INTERNAL_SOLVER_ERROR = 101;
    public static final int EVENT_NOT_FOUND = 102;
    public static final int ILLEGAL_EVENT_STATE = 103;
    public static final int ZENO_EFFECT = 104;
    public static final int TOO_MANY_STEPS_ERROR = 105;
    private boolean enableExceptions = true;
    protected boolean useBestInterpolation = false;
    private double stepSize = 0.1;
    private double absoluteTolerance = Double.NaN;
    private double relativeTolerance = Double.NaN;
    private double maxEventStep = Double.POSITIVE_INFINITY;
    private int zenoMaximumAllowedTimes = 500;
    private double proximityThreshold = 9.9E-324;
    private boolean coalesceCloseEvents = true;
    private int maxInternalSteps = 10000;
    private boolean runsForwards = this.stepSize > 0.0;
    private int dimension;
    private int timeIndex;
    private int errorCode = 0;
    private String errorMessage = "No error";
    private int numberOfAttempts = 0;
    private double[] test_ode_state;
    private double[] intermediate_ode_state;
    protected ODESolverInterpolator interpolatorSolver;
    private List<EventData> eventList = new ArrayList<EventData>();
    private List<EventData> happened = new ArrayList<EventData>();
    private List<EventData> temp_list = new ArrayList<EventData>();
    private double lastEventDataTime = Double.NaN;
    private EventData lastEventData = null;
    private int zenoCounter = 0;
    private List<ZenoEffectListener> zenoList = new ArrayList<ZenoEffectListener>();

    public ODEInterpolatorEventSolver(ODESolverInterpolator oDESolverInterpolator) {
        this.interpolatorSolver = oDESolverInterpolator;
    }

    public ODESolverInterpolator getSolver() {
        return this.interpolatorSolver;
    }

    public void setEnableExceptions(boolean bl) {
        this.enableExceptions = bl;
    }

    public void setEstimateFirstStep(boolean bl) {
        this.interpolatorSolver.setEstimateFirstStep(bl);
    }

    public void setBestInterpolation(boolean bl) {
        this.useBestInterpolation = bl;
    }

    public void setMaximumInternalSteps(int n) {
        this.maxInternalSteps = n;
    }

    public void setInternalStepSize(double d) {
        this.interpolatorSolver.setStepSize(this.runsForwards ? Math.abs(d) : -Math.abs(d));
    }

    public void setMaximumInternalStepSize(double d) {
        this.interpolatorSolver.setMaximumStepSize(d);
    }

    public void setTolerances(double d, double d2) {
        this.absoluteTolerance = d;
        this.relativeTolerance = d2;
        this.interpolatorSolver.setTolerances(this.absoluteTolerance, this.relativeTolerance);
    }

    public int getNumberOfAttempts() {
        return this.numberOfAttempts;
    }

    public void reinitialize() {
        double[] dArray = this.interpolatorSolver.getODE().getState();
        this.interpolatorSolver.reinitialize(dArray);
        this.errorCode = 0;
        this.errorMessage = "No error";
        for (EventData eventData : this.eventList) {
            eventData.reset(dArray);
        }
    }

    @Override
    public void setTolerance(double d) {
        this.setTolerances(d, 0.0);
    }

    @Override
    public double getTolerance() {
        return Math.max(this.absoluteTolerance, this.relativeTolerance);
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setMaximumEventStep(double d) {
        this.maxEventStep = Math.abs(d);
    }

    public double getMaximumEventStep() {
        return this.maxEventStep;
    }

    public void setCoalesceCloseEvents(boolean bl) {
        this.coalesceCloseEvents = bl;
    }

    public boolean isCoalesceCloseEvents() {
        return this.coalesceCloseEvents;
    }

    public void setEventProximityThreshold(double d) {
        this.proximityThreshold = d;
    }

    public double getEventProximityThreshold() {
        return this.proximityThreshold;
    }

    @Override
    public void addEvent(StateEvent stateEvent) {
        GeneralStateEvent generalStateEvent = stateEvent instanceof GeneralStateEvent ? (GeneralStateEvent)stateEvent : new GeneralStateEventAdapter(stateEvent);
        this.eventList.add(new EventData(generalStateEvent, this.interpolatorSolver.getODE().getState()));
    }

    @Override
    public void removeEvent(StateEvent stateEvent) {
        for (EventData eventData : this.eventList) {
            if (eventData.generalEvent instanceof GeneralStateEventAdapter) {
                if (((GeneralStateEventAdapter)eventData.generalEvent).getEvent() != stateEvent) continue;
                if (this.lastEventData == eventData) {
                    this.lastEventData = null;
                    this.zenoCounter = 0;
                }
                this.eventList.remove(eventData);
                return;
            }
            if (eventData.generalEvent != stateEvent) continue;
            if (this.lastEventData == eventData) {
                this.lastEventData = null;
                this.zenoCounter = 0;
            }
            this.eventList.remove(eventData);
            return;
        }
    }

    public void removeAllEvents() {
        this.eventList.clear();
    }

    @Override
    public void initialize(double d) {
        this.stepSize = d;
        this.runsForwards = this.stepSize > 0.0;
        this.interpolatorSolver.initialize(this.stepSize);
        double[] dArray = this.interpolatorSolver.getODE().getState();
        this.dimension = dArray.length;
        this.timeIndex = this.dimension - 1;
        this.test_ode_state = new double[this.dimension];
        this.intermediate_ode_state = new double[this.dimension];
        this.errorCode = 0;
        this.errorMessage = "No error";
        this.zenoCounter = 0;
        this.lastEventData = null;
        for (EventData eventData : this.eventList) {
            eventData.reset(dArray);
        }
    }

    @Override
    public void setStepSize(double d) {
        if (this.stepSize == d) {
            return;
        }
        this.stepSize = d;
        this.runsForwards = this.stepSize > 0.0;
        this.setInternalStepSize(this.interpolatorSolver.getStepSize());
    }

    @Override
    public double getStepSize() {
        return this.stepSize;
    }

    @Override
    public double step() {
        if (this.eventList.isEmpty()) {
            return this.stepWithoutEvents();
        }
        return this.stepWithEvents();
    }

    public double maxStep() {
        if (this.eventList.isEmpty()) {
            return this.maxStepWithoutEvents();
        }
        return this.maxStepWithEvents();
    }

    public void setZenoEffectDetection(int n) {
        this.zenoMaximumAllowedTimes = n;
    }

    public int getZenoEffectDetection() {
        return this.zenoMaximumAllowedTimes;
    }

    public void addZenoEffectListener(ZenoEffectListener zenoEffectListener) {
        this.zenoList.add(zenoEffectListener);
    }

    public void removeZenoEffectListener(ZenoEffectListener zenoEffectListener) {
        this.zenoList.remove(zenoEffectListener);
    }

    public double getIndependentVariableValue() {
        return this.interpolatorSolver.getODE().getState()[this.timeIndex];
    }

    public void setZeroZenoCounter() {
        this.zenoCounter = 0;
    }

    protected final void doTheInterpolation(double d, double[] dArray) {
        if (this.useBestInterpolation) {
            this.interpolatorSolver.bestInterpolate(d, dArray);
        } else {
            this.interpolatorSolver.interpolate(d, false, dArray);
        }
    }

    private final double maxStepWithoutEvents() {
        double[] dArray;
        double[] dArray2 = this.interpolatorSolver.getODE().getState();
        double d = dArray2[this.timeIndex];
        if (d + (dArray = this.interpolatorSolver.getCurrentRate())[this.timeIndex] == d) {
            return 0.0;
        }
        double d2 = this.interpolatorSolver.getMaximumTime();
        if (Double.isNaN(d2)) {
            return this.error(101, "Error when stepping the solver at " + dArray2[this.timeIndex]);
        }
        if (d == d2 && Double.isNaN(d2 = this.interpolatorSolver.internalStep())) {
            return this.error(101, "Error when stepping the solver at max step at " + dArray2[this.timeIndex]);
        }
        this.doTheInterpolation(d2, dArray2);
        return d2 - d;
    }

    /*
     * Unable to fully structure code
     */
    private double stepWithoutEvents() {
        block6: {
            var1_1 = this.interpolatorSolver.getODE().getState();
            var3_3 = var1_1[this.timeIndex];
            if (var3_3 + (var2_2 = this.interpolatorSolver.getCurrentRate())[this.timeIndex] == var3_3) {
                return 0.0;
            }
            var5_4 = var1_1[this.timeIndex] + this.stepSize;
            var7_5 = this.interpolatorSolver.getMaximumTime();
            if (Double.isNaN(var7_5)) {
                return this.error(101, "Error when stepping the solver at " + var1_1[this.timeIndex]);
            }
            var9_6 = 0;
            if (!this.runsForwards) ** GOTO lbl25
            while (var7_5 < var5_4) {
                var7_5 = this.interpolatorSolver.internalStep();
                if (Double.isNaN(var7_5)) {
                    return this.error(101, "Error when stepping the solver forwards at " + var1_1[this.timeIndex]);
                }
                if (++var9_6 <= this.maxInternalSteps) continue;
                var10_7 = var1_1[this.timeIndex];
                var12_8 = this.interpolatorSolver.bestInterpolate(var5_4, new double[this.dimension])[this.timeIndex];
                return this.error(105, "The solver exceeded the maximum of " + this.maxInternalSteps + " internal steps\nat " + var12_8 + ", starting from " + var10_7 + " for an step of " + this.stepSize);
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                var7_5 = this.interpolatorSolver.internalStep();
                if (Double.isNaN(var7_5)) {
                    return this.error(101, "Error when stepping the solver backwards at " + var1_1[this.timeIndex]);
                }
                if (++var9_6 <= this.maxInternalSteps) continue;
                return this.error(105, "The solver exceeded the number of internal steps at " + var1_1[this.timeIndex]);
lbl25:
                // 2 sources

                ** while (var7_5 > var5_4)
            }
        }
        this.doTheInterpolation(var5_4, var1_1);
        return this.stepSize;
    }

    private final double maxStepWithEvents() {
        EventData eventData;
        double[] dArray = this.interpolatorSolver.getODE().getState();
        if (this.zenoMaximumAllowedTimes > 0 && this.zenoCounter > this.zenoMaximumAllowedTimes && this.callZenoAction(dArray)) {
            return 0.0;
        }
        double d = dArray[this.timeIndex];
        double[] dArray2 = this.interpolatorSolver.getCurrentRate();
        if (d + dArray2[this.timeIndex] == d) {
            return 0.0;
        }
        double d2 = this.interpolatorSolver.getMaximumTime();
        if (Double.isNaN(d2)) {
            return this.error(101, "Error when stepping the solver at " + dArray[this.timeIndex]);
        }
        if (d == d2 && Double.isNaN(d2 = this.interpolatorSolver.internalStep())) {
            return this.error(101, "Error when stepping the solver forwards at " + dArray[this.timeIndex]);
        }
        if (this.lastEventData != null && !Double.isNaN(this.lastEventData.maxAdvance)) {
            d2 = this.runsForwards ? Math.min(d2, this.lastEventData.maxAdvance) : Math.max(d2, this.lastEventData.maxAdvance);
        }
        double d3 = this.runsForwards ? Math.min(d + this.maxEventStep, d2) : Math.max(d - this.maxEventStep, d2);
        while (true) {
            eventData = null;
            this.doTheInterpolation(d3, this.test_ode_state);
            eventData = this.findFirstEvent(dArray, d3, this.test_ode_state);
            if (eventData != null) break;
            if (d3 == d2) {
                System.arraycopy(this.test_ode_state, 0, dArray, 0, this.dimension);
                for (EventData eventData2 : this.eventList) {
                    eventData2.findPosition(dArray[this.timeIndex], eventData2.h);
                }
                return d2 - d;
            }
            d3 = this.runsForwards ? Math.min(d3 + this.maxEventStep, d2) : Math.max(d3 - this.maxEventStep, d2);
        }
        if (this.useBestInterpolation) {
            this.interpolatorSolver.bestInterpolate(eventData.time, dArray);
        } else {
            System.arraycopy(this.test_ode_state, 0, dArray, 0, this.dimension);
        }
        double d4 = dArray[this.timeIndex];
        eventData.generalEvent.action();
        this.reinitialize();
        dArray = this.interpolatorSolver.getODE().getState();
        if (d4 != dArray[this.timeIndex]) {
            this.zenoCounter = 0;
            this.lastEventData = null;
            return eventData.time - d;
        }
        if (this.lastEventData != null) {
            this.zenoCounter = Math.abs(this.lastEventDataTime - eventData.time) < this.proximityThreshold ? ++this.zenoCounter : 0;
        }
        this.lastEventData = eventData;
        this.lastEventDataTime = eventData.time;
        return eventData.time - d;
    }

    private double stepWithEvents() {
        double[] dArray = this.interpolatorSolver.getODE().getState();
        if (this.zenoMaximumAllowedTimes > 0 && this.zenoCounter > this.zenoMaximumAllowedTimes && this.callZenoAction(dArray)) {
            return 0.0;
        }
        double d = dArray[this.timeIndex];
        double[] dArray2 = this.interpolatorSolver.getCurrentRate();
        if (d + dArray2[this.timeIndex] == d) {
            return 0.0;
        }
        double d2 = d + this.stepSize;
        double d3 = this.interpolatorSolver.getMaximumTime();
        if (Double.isNaN(d3)) {
            return this.error(101, "Error when stepping the solver at " + dArray[this.timeIndex]);
        }
        double d4 = this.runsForwards ? Math.min(d + this.maxEventStep, d2) : Math.max(d - this.maxEventStep, d2);
        int n = 0;
        while (true) {
            boolean bl;
            EventData eventData = null;
            boolean bl2 = this.runsForwards ? d3 < d4 : (bl = d3 > d4);
            if (bl) {
                this.interpolatorSolver.bestInterpolate(d3, this.test_ode_state);
                eventData = this.findFirstEvent(dArray, d3, this.test_ode_state);
                if (eventData == null) {
                    System.arraycopy(this.test_ode_state, 0, dArray, 0, this.dimension);
                    for (EventData eventData2 : this.eventList) {
                        eventData2.findPosition(dArray[this.timeIndex], eventData2.h);
                    }
                    d3 = this.interpolatorSolver.internalStep();
                    if (Double.isNaN(d3)) {
                        return this.error(101, "Error when stepping the solver looking for an event at " + dArray[this.timeIndex]);
                    }
                    if (++n <= this.maxInternalSteps) continue;
                    return this.error(105, "The solver exceeded the number of internal steps at " + dArray[this.timeIndex]);
                }
            } else {
                this.doTheInterpolation(d4, this.test_ode_state);
                eventData = this.findFirstEvent(dArray, d4, this.test_ode_state);
                if (eventData == null) {
                    if (d4 == d2) {
                        System.arraycopy(this.test_ode_state, 0, dArray, 0, this.dimension);
                        for (EventData eventData2 : this.eventList) {
                            eventData2.findPosition(dArray[this.timeIndex], eventData2.h);
                        }
                        return d2 - d;
                    }
                    d4 = this.runsForwards ? Math.min(d4 + this.maxEventStep, d2) : Math.max(d4 - this.maxEventStep, d2);
                    continue;
                }
            }
            if (this.useBestInterpolation) {
                this.interpolatorSolver.bestInterpolate(eventData.time, dArray);
            } else {
                System.arraycopy(this.test_ode_state, 0, dArray, 0, this.dimension);
            }
            double d5 = dArray[this.timeIndex];
            boolean bl3 = eventData.generalEvent.action();
            this.reinitialize();
            n = 0;
            dArray = this.interpolatorSolver.getODE().getState();
            if (d5 != dArray[this.timeIndex]) {
                this.zenoCounter = 0;
                this.lastEventData = null;
                return eventData.time - d;
            }
            if (this.lastEventData != null) {
                if (Math.abs(this.lastEventDataTime - eventData.time) < this.proximityThreshold) {
                    ++this.zenoCounter;
                    if (this.coalesceCloseEvents) {
                        bl3 = false;
                    }
                } else {
                    this.zenoCounter = 0;
                }
            }
            this.lastEventData = eventData;
            this.lastEventDataTime = eventData.time;
            if (bl3) {
                return eventData.time - d;
            }
            if (this.zenoMaximumAllowedTimes > 0 && this.zenoCounter > this.zenoMaximumAllowedTimes && this.callZenoAction(dArray)) {
                return eventData.time - d;
            }
            d3 = this.interpolatorSolver.getMaximumTime();
            if (!Double.isNaN(eventData.maxAdvance)) {
                double d6 = d3 = this.runsForwards ? Math.min(d3, eventData.maxAdvance) : Math.max(d3, eventData.maxAdvance);
            }
            if (Double.isNaN(d3)) break;
        }
        return this.error(101, "Error when stepping the solver after an event at " + dArray[this.timeIndex]);
    }

    private boolean callZenoAction(double[] dArray) {
        if (this.zenoList.isEmpty()) {
            this.error(104, "A Zeno-like effect has been detected.\nLast event was " + this.lastEventData.generalEvent + " which took place at " + this.lastEventDataTime);
            return true;
        }
        boolean bl = false;
        for (ZenoEffectListener zenoEffectListener : this.zenoList) {
            if (!zenoEffectListener.zenoEffectAction(this.lastEventData.generalEvent, dArray)) continue;
            bl = true;
        }
        this.zenoCounter = 0;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private EventData findFirstEvent(double[] dArray, double d, double[] dArray2) {
        EventData eventData32;
        this.numberOfAttempts = 0;
        EventData eventData2 = this.happensRightNow(dArray[this.timeIndex], dArray2, this.happened, "at t1");
        if (eventData2 != null) {
            eventData2.time = dArray[this.timeIndex];
            eventData2.maxAdvance = d;
            System.arraycopy(dArray, 0, dArray2, 0, this.dimension);
            return eventData2;
        }
        if (this.happened.isEmpty()) {
            return null;
        }
        boolean bl = true;
        for (EventData eventData32 : this.eventList) {
            eventData32.hAfter = eventData32.h;
        }
        block1: while (bl) {
            ++this.numberOfAttempts;
            double d2 = this.nextPointToCheck(this.happened, dArray[this.timeIndex], d);
            this.doTheInterpolation(d2, this.intermediate_ode_state);
            EventData eventData4 = this.happensRightNow(dArray[this.timeIndex], this.intermediate_ode_state, this.temp_list, "short");
            if (eventData4 != null) {
                eventData4.time = dArray[this.timeIndex];
                eventData4.maxAdvance = d2;
                System.arraycopy(dArray, 0, dArray2, 0, this.dimension);
                return eventData4;
            }
            if (this.temp_list.isEmpty()) {
                EventData eventData5 = null;
                for (EventData eventData : this.happened) {
                    if (eventData.currentPosition == 2) {
                        if (!(eventData.h < eventData.generalEvent.getTolerance())) continue;
                        eventData5 = eventData;
                        break;
                    }
                    if (!(eventData.h > -eventData.generalEvent.getTolerance())) continue;
                    eventData5 = eventData;
                    break;
                }
                if (eventData5 != null) {
                    eventData5.time = d2;
                    eventData5.maxAdvance = d;
                    System.arraycopy(this.intermediate_ode_state, 0, dArray2, 0, this.dimension);
                    return eventData5;
                }
                System.arraycopy(this.intermediate_ode_state, 0, dArray, 0, this.dimension);
                for (EventData eventData : this.eventList) {
                    eventData.findPosition(dArray[this.timeIndex], eventData.h);
                }
                EventData eventData = this.happensRightNow(dArray[this.timeIndex], dArray2, this.happened, "at tTest");
                if (eventData != null) {
                    eventData.time = dArray[this.timeIndex];
                    eventData.maxAdvance = d;
                    System.arraycopy(dArray, 0, dArray2, 0, this.dimension);
                    return eventData;
                }
            } else {
                void var11_20;
                boolean bl2 = true;
                Object var11_19 = null;
                for (EventData eventData : this.temp_list) {
                    if (eventData.currentPosition == 2) {
                        if (eventData.h <= -eventData.generalEvent.getTolerance()) {
                            bl2 = false;
                            break;
                        }
                        EventData eventData5 = eventData;
                        continue;
                    }
                    if (eventData.h >= eventData.generalEvent.getTolerance()) {
                        bl2 = false;
                        break;
                    }
                    EventData eventData6 = eventData;
                }
                if (bl2 && var11_20 != null) {
                    var11_20.time = d2;
                    var11_20.maxAdvance = d;
                    System.arraycopy(this.intermediate_ode_state, 0, dArray2, 0, this.dimension);
                    return var11_20;
                }
                d = d2;
                System.arraycopy(this.intermediate_ode_state, 0, dArray2, 0, this.dimension);
                for (EventData eventData : this.eventList) {
                    eventData.hAfter = eventData.h;
                }
                this.happened.clear();
                this.happened.addAll(this.temp_list);
            }
            for (EventData eventData6 : this.happened) {
                if (this.numberOfAttempts <= eventData6.generalEvent.getMaxIterations()) continue;
                bl = false;
                continue block1;
            }
        }
        eventData32 = this.happened.get(0);
        this.error(102, "Warning : Event not found after " + this.numberOfAttempts + " attempts at t=" + dArray[this.timeIndex] + " h = " + eventData32.h + ".\nPlease check the code of your event, decrease the initial step size, the tolerance of the solver," + "\nor the event maximum step, or increase the maximum number of attempts." + "\nFirst event remaining in the queue: " + eventData32.generalEvent);
        eventData32.time = (dArray[this.timeIndex] + d) / 2.0;
        eventData32.maxAdvance = Double.NaN;
        this.interpolatorSolver.bestInterpolate(eventData32.time, dArray2);
        return eventData32;
    }

    private EventData happensRightNow(double d, double[] dArray, List<EventData> list, String string) {
        list.clear();
        block6: for (EventData eventData : this.eventList) {
            eventData.h = eventData.generalEvent.evaluate(dArray);
            switch (eventData.currentPosition) {
                default: {
                    if (!(eventData.h < 0.0)) continue block6;
                    list.add(eventData);
                    break;
                }
                case 1: {
                    if (!(eventData.h < 0.0) || !eventData.positiveFlag && eventData.eventType != 0) continue block6;
                    return eventData;
                }
                case 0: {
                    if (!(eventData.h < 0.0 ? eventData.positiveFlag || eventData.eventType == 0 : eventData.h > 0.0 && eventData.negativeFlag && eventData.eventType == 2)) continue block6;
                    return eventData;
                }
                case -1: {
                    if (!(eventData.eventType == 0 ? eventData.h <= -eventData.generalEvent.getTolerance() : eventData.eventType == 2 && eventData.negativeFlag && eventData.h > 0.0)) continue block6;
                    return eventData;
                }
                case -2: {
                    if (eventData.eventType == 2) {
                        if (!(eventData.h > 0.0)) continue block6;
                        list.add(eventData);
                        break;
                    }
                    if (eventData.eventType != 0) continue block6;
                    this.error(103, "The system started from an illegal state at " + d + " for the state event " + eventData.generalEvent);
                    return eventData;
                }
            }
        }
        return null;
    }

    private double nextPointToCheck(List<EventData> list, double d, double d2) {
        double d3 = d2;
        double d4 = d2 - d;
        double d5 = (d + d2) / 2.0;
        if (this.runsForwards) {
            for (EventData eventData : list) {
                switch (eventData.generalEvent.getRootFindingMethod()) {
                    default: {
                        d3 = Math.min(d3, d5);
                        break;
                    }
                    case 1: {
                        d3 = Math.min(d3, d - eventData.hBefore * d4 / (eventData.hAfter - eventData.hBefore));
                    }
                }
            }
        } else {
            for (EventData eventData : list) {
                switch (eventData.generalEvent.getRootFindingMethod()) {
                    default: {
                        d3 = Math.max(d3, d5);
                        break;
                    }
                    case 1: {
                        d3 = Math.max(d3, d - eventData.hBefore * d4 / (eventData.hAfter - eventData.hBefore));
                    }
                }
            }
        }
        return d3;
    }

    private double error(int n, String string) {
        this.errorCode = n;
        this.errorMessage = string;
        if (this.enableExceptions) {
            throw new ODESolverException(this.interpolatorSolver + ":\n" + string);
        }
        OSPLog.warning(string);
        return Double.NaN;
    }

    private class EventData {
        protected static final int POSITIVE = 2;
        protected static final int SMALL_POSITIVE = 1;
        protected static final int ZERO = 0;
        protected static final int SMALL_NEGATIVE = -1;
        protected static final int NEGATIVE = -2;
        GeneralStateEvent generalEvent;
        boolean positiveFlag;
        boolean negativeFlag;
        final int eventType;
        int currentPosition;
        double hBefore;
        double hAfter;
        double h;
        double time;
        double maxAdvance;

        EventData(GeneralStateEvent generalStateEvent, double[] dArray) {
            this.generalEvent = generalStateEvent;
            this.eventType = this.generalEvent.getTypeOfEvent();
            this.reset(dArray);
        }

        void reset(double[] dArray) {
            this.negativeFlag = false;
            this.positiveFlag = false;
            this.findPosition(dArray[ODEInterpolatorEventSolver.this.timeIndex], this.generalEvent.evaluate(dArray));
        }

        private void findPosition(double d, double d2) {
            this.hBefore = d2;
            if (this.hBefore >= this.generalEvent.getTolerance()) {
                this.currentPosition = 2;
                this.positiveFlag = true;
            } else if (this.hBefore > 0.0) {
                this.currentPosition = 1;
            } else if (this.hBefore == 0.0) {
                this.currentPosition = 0;
            } else if (this.hBefore > -this.generalEvent.getTolerance()) {
                this.currentPosition = -1;
            } else {
                this.currentPosition = -2;
                this.negativeFlag = true;
            }
            if (this.eventType == 0 && this.currentPosition == -2) {
                String string = "The state event " + this.generalEvent + " is in an illegal state: " + this.hBefore + " at " + d;
                string = ODEInterpolatorEventSolver.this.lastEventData == null ? String.valueOf(string) + "\nThere was no previous event" : String.valueOf(string) + "\nLast previous event was " + ((ODEInterpolatorEventSolver)ODEInterpolatorEventSolver.this).lastEventData.generalEvent + ", which took place at " + ODEInterpolatorEventSolver.this.lastEventDataTime;
                ODEInterpolatorEventSolver.this.error(103, string);
            }
        }
    }

    private class GeneralStateEventAdapter
    implements GeneralStateEvent {
        private StateEvent event;

        public GeneralStateEventAdapter(StateEvent stateEvent) {
            this.event = stateEvent;
        }

        public StateEvent getEvent() {
            return this.event;
        }

        public int getTypeOfEvent() {
            return 0;
        }

        public int getMaxIterations() {
            return 100;
        }

        public int getRootFindingMethod() {
            return 0;
        }

        public double getTolerance() {
            return this.event.getTolerance();
        }

        public double evaluate(double[] dArray) {
            return this.event.evaluate(dArray);
        }

        public boolean action() {
            return this.event.action();
        }
    }
}

