/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoIO {
    protected static JFileChooser chooser;
    protected static VideoFileFilter videoFileFilter;
    protected static Collection<VideoFileFilter> singleVideoTypeFilters;
    protected static FileFilter imageFileFilter;
    protected static ArrayList<VideoType> videoTypes;
    protected static ArrayList<VideoType> videoEngines;
    protected static String defaultXMLExt;
    public static boolean loadQTLast;
    protected static VideoEnginePanel videoEnginePanel;

    static {
        Object object;
        videoFileFilter = new VideoFileFilter();
        singleVideoTypeFilters = new TreeSet<VideoFileFilter>();
        videoTypes = new ArrayList();
        videoEngines = new ArrayList();
        defaultXMLExt = "xml";
        loadQTLast = true;
        try {
            object = "org.opensourcephysics.media.gif.GifVideoType";
            Class<?> clazz = Class.forName((String)object);
            VideoIO.addVideoType((VideoType)clazz.newInstance());
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        object = new VideoFileFilter("jpg", new String[]{"jpg", "jpeg"});
        VideoIO.addVideoType(new ImageVideoType((VideoFileFilter)object));
        object = new VideoFileFilter("png", new String[]{"png"});
        VideoIO.addVideoType(new ImageVideoType((VideoFileFilter)object));
        imageFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = VideoIO.getExtension(file);
                return string != null && (string.equals("gif") || string.equals("jpg"));
            }

            public String getDescription() {
                return MediaRes.getString("VideoIO.ImageFileFilter.Description");
            }
        };
        videoEnginePanel = new VideoEnginePanel();
    }

    protected VideoIO() {
    }

    public static String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public static JFileChooser getChooser() {
        if (chooser == null) {
            File file = OSPRuntime.chooserDir == null ? new File(System.getProperty("user.home")) : new File(OSPRuntime.chooserDir);
            chooser = new JFileChooser(file);
            chooser.addPropertyChangeListener(videoEnginePanel);
        }
        return chooser;
    }

    public static void setDefaultXMLExtension(String string) {
        defaultXMLExt = string;
    }

    public static String getRelativePath(String string) {
        if (string.indexOf("/") == -1 && string.indexOf("\\") == -1) {
            return string;
        }
        if (string.startsWith("http:")) {
            return string;
        }
        String string2 = string;
        String string3 = "";
        boolean bl = false;
        String string4 = System.getProperty("user.dir");
        if (string4 == null) {
            return string2;
        }
        int n = 0;
        while (n < 3) {
            int n2;
            if (n > 0) {
                n2 = string4.lastIndexOf("\\");
                if (n2 == -1) {
                    n2 = string4.lastIndexOf("/");
                }
                if (n2 == -1) break;
                string4 = string4.substring(0, n2);
                string3 = String.valueOf(string3) + "../";
            }
            if (string2.startsWith(string4)) {
                string2 = string2.substring(string4.length() + 1);
                n2 = string2.indexOf("\\");
                while (n2 != -1) {
                    string2 = String.valueOf(string2.substring(0, n2)) + "/" + string2.substring(n2 + 1);
                    n2 = string2.indexOf("\\");
                }
                string3 = String.valueOf(string3) + string2;
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            return string3;
        }
        return string2;
    }

    public static boolean updateVideoType(Class<? extends VideoType> clazz) {
        String string;
        String string2 = XML.forwardSlash(System.getProperty("java.ext.dirs"));
        if (string2.indexOf(string = System.getProperty("path.separator")) > -1) {
            string2 = string2.substring(0, string2.indexOf(string));
        }
        string2 = String.valueOf(string2) + "/";
        if (clazz.getSimpleName().equals("XuggleVideoType")) {
            String string3 = System.getenv("XUGGLE_HOME");
            if (string3 != null) {
                String[] stringArray = new String[]{"xuggle-xuggler.jar", "slf4j-api.jar", "logback-core.jar", "logback-classic.jar"};
                String string4 = String.valueOf(string3) + "/share/java/jars/";
                File file = new File(String.valueOf(string4) + stringArray[0]);
                if (file.exists()) {
                    long l = file.lastModified();
                    File file2 = new File(String.valueOf(string2) + stringArray[0]);
                    if (!file2.exists() || file2.lastModified() < l) {
                        String[] stringArray2 = stringArray;
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String string5 = stringArray2[n2];
                            file = new File(String.valueOf(string4) + string5);
                            if (!VideoIO.copyFile(file, file2 = new File(String.valueOf(string2) + string5))) {
                                return false;
                            }
                            ++n2;
                        }
                        return true;
                    }
                }
            }
        } else if (clazz.getSimpleName().equals("QTVideoType")) {
            String[] stringArray;
            if (OSPRuntime.isLinux()) {
                return false;
            }
            String string6 = "QTJava.zip";
            String[] stringArray3 = stringArray = new String[]{"C:/Program Files/QuickTime/QTSystem/", "C:/windows/system32/", "C:/windows/system/", "C:/winNT/system32/", "system/library/java/extensions/"};
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String string7 = stringArray3[n3];
                File file = new File(String.valueOf(string7) + string6);
                if (file.exists()) {
                    File file3 = new File(String.valueOf(string2) + string6);
                    long l = file.lastModified();
                    if (!file3.exists() || file3.lastModified() < l) {
                        return VideoIO.copyFile(file, file3);
                    }
                }
                ++n3;
            }
        }
        return false;
    }

    public static void testExec() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean copyFile(File file, File file2) {
        byte[] byArray = new byte[100000];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while (true) {
                byte[] byArray2 = byArray;
                // MONITORENTER : byArray
                int n = ((InputStream)fileInputStream).read(byArray);
                if (n == -1) {
                    // MONITOREXIT : byArray2
                    break;
                }
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                // MONITOREXIT : byArray2
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            file2.setLastModified(file.lastModified());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void addVideoType(VideoType videoType) {
        if (videoType != null) {
            boolean bl = false;
            for (VideoType object : videoTypes) {
                if (!object.getDescription().equals(videoType.getDescription()) || object.getClass() != videoType.getClass()) continue;
                bl = true;
            }
            if (!bl) {
                VideoFileFilter videoFileFilter;
                videoTypes.add(videoType);
                if (VideoIO.getVideoType("qt", null) != null) {
                    VideoIO.setQTLast(loadQTLast);
                }
                if ((videoFileFilter = videoType.getDefaultFileFilter()) != null && videoFileFilter.extensions != null) {
                    singleVideoTypeFilters.add(videoFileFilter);
                }
            }
        }
    }

    public static void addVideoEngine(VideoType videoType) {
        if (videoType != null) {
            boolean bl = false;
            for (VideoType videoType2 : videoEngines) {
                if (videoType2.getClass() != videoType.getClass()) continue;
                bl = true;
            }
            if (!bl) {
                videoEngines.add(videoType);
                videoEnginePanel.addVideoEngine(videoType);
            }
        }
    }

    public static VideoType getVideoType(String string, String string2) {
        Object object;
        if (string == null && string2 == null) {
            return null;
        }
        ArrayList<VideoType> arrayList = new ArrayList<VideoType>();
        if (string == null) {
            arrayList.addAll(videoTypes);
        } else {
            string = string.toLowerCase();
            for (VideoType videoType : videoTypes) {
                object = videoType.getClass().getSimpleName().toLowerCase();
                if (object.indexOf(string) <= -1) continue;
                arrayList.add(videoType);
            }
        }
        if (string2 == null) {
            if (arrayList.isEmpty()) {
                return null;
            }
            return (VideoType)arrayList.get(0);
        }
        string2 = string2.toLowerCase();
        for (VideoType videoType : arrayList) {
            object = videoType.getDefaultExtension();
            if (object == null || object.indexOf(string2) <= -1) continue;
            return videoType;
        }
        for (VideoType videoType : arrayList) {
            VideoFileFilter[] videoFileFilterArray = object = videoType.getFileFilters();
            int n = ((VideoFileFilter[])object).length;
            int n2 = 0;
            while (n2 < n) {
                VideoFileFilter videoFileFilter = videoFileFilterArray[n2];
                if (videoFileFilter.extensions != null) {
                    String[] stringArray = videoFileFilter.extensions;
                    int n3 = videoFileFilter.extensions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string3 = stringArray[n4];
                        if (string3.indexOf(string2) > -1) {
                            return videoType;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static VideoType[] getVideoTypes(String string) {
        VideoFileFilter[] videoFileFilterArray;
        ArrayList<VideoType> arrayList = new ArrayList<VideoType>();
        for (VideoType videoType : videoTypes) {
            videoFileFilterArray = videoType.getDefaultExtension();
            if (videoFileFilterArray == null || videoFileFilterArray.indexOf(string) <= -1) continue;
            arrayList.add(videoType);
        }
        for (VideoType videoType : videoTypes) {
            VideoFileFilter[] videoFileFilterArray2 = videoFileFilterArray = videoType.getFileFilters();
            int n = videoFileFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                VideoFileFilter videoFileFilter = videoFileFilterArray2[n2];
                if (videoFileFilter.extensions != null) {
                    String[] stringArray = videoFileFilter.extensions;
                    int n3 = videoFileFilter.extensions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string2 = stringArray[n4];
                        if (string2.indexOf(string) > -1 && !arrayList.contains(videoType)) {
                            arrayList.add(videoType);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return arrayList.toArray(new VideoType[0]);
    }

    public static VideoType[] getVideoTypes() {
        return videoTypes.toArray(new VideoType[0]);
    }

    public static void setQTLast(boolean bl) {
        loadQTLast = bl;
        if (bl) {
            int n = 0;
            while (n < videoTypes.size()) {
                VideoType videoType = videoTypes.get(n);
                if (videoType.getClass().getSimpleName().equals("QTVideoType") && n < videoTypes.size() - 1) {
                    videoTypes.remove(videoType);
                    videoTypes.add(videoType);
                    break;
                }
                ++n;
            }
        } else {
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            while (n3 < videoTypes.size()) {
                VideoType videoType = videoTypes.get(n3);
                if (videoType.getClass().getSimpleName().equals("QTVideoType")) {
                    n = n3;
                } else if (videoType.getClass().getSimpleName().equals("XuggleVideoType") && n2 == -1) {
                    n2 = n3;
                }
                ++n3;
            }
            if (n > -1 && n2 > -1 && n > n2) {
                VideoType videoType = videoTypes.remove(n);
                videoTypes.add(n2, videoType);
            }
        }
    }

    public static boolean isQTPreferred() {
        if (VideoIO.getVideoType("qt", null) == null) {
            return false;
        }
        if (VideoIO.getVideoType("xuggle", null) == null) {
            return true;
        }
        return !loadQTLast;
    }

    public static Video getVideo(File file) {
        Video video2 = null;
        for (VideoType videoType : videoTypes) {
            video2 = videoType.getVideo(file.getAbsolutePath());
            if (video2 != null) break;
        }
        return video2;
    }

    public static Video clone(Video video2) {
        if (video2 == null) {
            return null;
        }
        if (video2 instanceof ImageVideo) {
            ImageVideo imageVideo = (ImageVideo)video2;
            ImageVideo imageVideo2 = new ImageVideo(imageVideo.getImages());
            imageVideo2.rawImage = imageVideo2.images[0];
            Collection<Filter> collection = video2.getFilterStack().getFilters();
            if (collection != null) {
                for (Filter filter : collection) {
                    imageVideo2.getFilterStack().addFilter(filter);
                }
            }
            return imageVideo2;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(video2);
        return (Video)new XMLControlElement(xMLControlElement).loadObject(null);
    }

    public static File open(VideoPanel videoPanel) {
        return VideoIO.open(null, videoPanel);
    }

    public static File[] getChooserFiles(String string) {
        File[] fileArray;
        JFileChooser jFileChooser = VideoIO.getChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        int n = 1;
        if (string.toLowerCase().equals("open")) {
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.addChoosableFileFilter(videoFileFilter);
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
            n = jFileChooser.showOpenDialog(null);
            jFileChooser.removeChoosableFileFilter(videoFileFilter);
        } else if (string.toLowerCase().equals("open video")) {
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.addChoosableFileFilter(videoFileFilter);
            n = jFileChooser.showOpenDialog(null);
            jFileChooser.removeChoosableFileFilter(videoFileFilter);
        } else if (string.toLowerCase().equals("save")) {
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(true);
            fileArray = MediaRes.getString("VideoIO.FileName.Untitled");
            jFileChooser.setSelectedFile(new File(String.valueOf(fileArray) + "." + defaultXMLExt));
            n = jFileChooser.showSaveDialog(null);
        } else if (string.toLowerCase().equals("insert image")) {
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.addChoosableFileFilter(imageFileFilter);
            jFileChooser.setSelectedFile(new File(""));
            n = jFileChooser.showOpenDialog(null);
            jFileChooser.removeChoosableFileFilter(imageFileFilter);
            fileArray = jFileChooser.getSelectedFiles();
            jFileChooser.setSelectedFile(new File(""));
            if (n == 0) {
                return fileArray;
            }
        }
        if (n == 0) {
            fileArray = jFileChooser.getSelectedFile();
            jFileChooser.setSelectedFile(new File(""));
            return new File[]{fileArray};
        }
        return null;
    }

    public static File open(File file, VideoPanel videoPanel) {
        Object object;
        if (file == null && (object = VideoIO.getChooserFiles("open")) != null) {
            file = object[0];
        }
        if (file == null) {
            return null;
        }
        if (videoFileFilter.accept(file)) {
            object = VideoIO.getVideoTypes();
            Video video2 = null;
            int n = 0;
            while (n < ((Object)object).length) {
                video2 = object[n].getVideo(file.getAbsolutePath());
                if (video2 != null) {
                    OSPLog.info(String.valueOf(file.getName()) + " opened as type " + object[n].getDescription());
                    break;
                }
                OSPLog.info(String.valueOf(file.getName()) + " failed as type " + object[n].getDescription());
                ++n;
            }
            if (video2 != null) {
                videoPanel.setVideo(video2);
                videoPanel.repaint();
            } else {
                JOptionPane.showMessageDialog(videoPanel, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadVideo.Message")) + XML.getAbsolutePath(file));
            }
        } else {
            object = new XMLControlElement();
            ((XMLControlElement)object).read(file.getAbsolutePath());
            Class<?> clazz = ((XMLControlElement)object).getObjectClass();
            if (VideoPanel.class.isAssignableFrom(clazz)) {
                videoPanel.setDataFile(file);
                ((XMLControlElement)object).loadObject(videoPanel);
            } else {
                if (!((XMLControlElement)object).failedToRead()) {
                    JOptionPane.showMessageDialog(videoPanel, "\"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.XMLMismatch.Message"), MediaRes.getString("VideoIO.Dialog.XMLMismatch.Title"), 2);
                    return null;
                }
                JOptionPane.showMessageDialog(videoPanel, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadFile.Message")) + XML.getAbsolutePath(file));
            }
            videoPanel.changed = false;
        }
        return file;
    }

    public static File save(File file, VideoPanel videoPanel) {
        return VideoIO.save(file, videoPanel, MediaRes.getString("VideoIO.Dialog.SaveAs.Title"));
    }

    public static File save(File file, VideoPanel videoPanel, String string) {
        Object object;
        Video video2;
        if (file == null) {
            int n;
            video2 = videoPanel.getVideo();
            object = VideoIO.getChooser();
            ((JFileChooser)object).removeChoosableFileFilter(videoFileFilter);
            ((JFileChooser)object).removeChoosableFileFilter(imageFileFilter);
            ((JFileChooser)object).setDialogTitle(string);
            String string2 = MediaRes.getString("VideoIO.FileName.Untitled");
            if (videoPanel.getFilePath() != null) {
                string2 = XML.stripExtension(videoPanel.getFilePath());
            } else if (video2 != null && video2.getProperty("name") != null && (n = (string2 = (String)video2.getProperty("name")).lastIndexOf(".")) > 0) {
                string2 = string2.substring(0, n);
            }
            file = new File(String.valueOf(string2) + "." + defaultXMLExt);
            String string3 = XML.getDirectoryPath(string2);
            if (!string3.equals("")) {
                XML.createFolders(string3);
                ((JFileChooser)object).setCurrentDirectory(new File(string3));
            }
            ((JFileChooser)object).setSelectedFile(file);
            int n2 = ((JFileChooser)object).showSaveDialog(videoPanel);
            if (n2 == 0) {
                int n3;
                file = ((JFileChooser)object).getSelectedFile();
                if (!defaultXMLExt.equals(VideoIO.getExtension(file))) {
                    string2 = XML.stripExtension(file.getPath());
                    file = new File(String.valueOf(string2) + "." + defaultXMLExt);
                }
                if (file.exists() && (n3 = JOptionPane.showConfirmDialog(videoPanel, " \"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.FileExists.Message"), MediaRes.getString("VideoIO.Dialog.FileExists.Title"), 2)) != 0) {
                    return null;
                }
                videoPanel.setDataFile(file);
            } else {
                return null;
            }
        }
        if ((video2 = videoPanel.getVideo()) != null) {
            video2.setProperty("base", XML.getDirectoryPath(XML.getAbsolutePath(file)));
            if (video2 instanceof ImageVideo) {
                ((ImageVideo)video2).saveInvalidImages();
            }
        }
        object = new XMLControlElement(videoPanel);
        object.write(file.getAbsolutePath());
        videoPanel.changed = false;
        return file;
    }

    public static class StreamPiper
    implements Runnable {
        private final InputStream input;
        private final OutputStream output;

        public StreamPiper(InputStream inputStream, OutputStream outputStream) {
            this.input = inputStream;
            this.output = outputStream;
        }

        public void run() {
            try {
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = this.input.read(byArray)) >= 0) {
                    this.output.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected static class VideoEnginePanel
    extends JPanel
    implements PropertyChangeListener {
        JPanel emptyPanel;
        File selectedFile;
        ButtonGroup videoEngineButtonGroup = new ButtonGroup();
        HashMap<JRadioButton, VideoType> buttonMap = new HashMap();
        TitledBorder title;
        boolean isClosing = false;

        VideoEnginePanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.title = BorderFactory.createTitledBorder(MediaRes.getString("VideoEnginePanel.TitledBorder.Title"));
            this.setBorder(this.title);
            this.emptyPanel = new JPanel(){

                public Dimension getPreferredSize() {
                    return videoEnginePanel.getPreferredSize();
                }
            };
        }

        public void addVideoEngine(VideoType videoType) {
            JRadioButton jRadioButton = new JRadioButton(videoType.getDescription());
            jRadioButton.setActionCommand(videoType.getClass().getSimpleName());
            this.videoEngineButtonGroup.add(jRadioButton);
            this.buttonMap.put(jRadioButton, videoType);
            this.add(jRadioButton);
        }

        public VideoType getSelectedVideoType() {
            if (chooser.getAccessory() == null || chooser.getAccessory() == this.emptyPanel) {
                return null;
            }
            for (JRadioButton jRadioButton : this.buttonMap.keySet()) {
                String string;
                if (!jRadioButton.isSelected()) continue;
                VideoType videoType = this.buttonMap.get(jRadioButton);
                String string2 = videoType.getClass().getSimpleName();
                VideoType videoType2 = VideoIO.getVideoType(string2, string = XML.getExtension(this.selectedFile.getName()));
                return videoType2 == null ? videoType : videoType2;
            }
            return null;
        }

        public void reset() {
            this.isClosing = false;
            this.refresh();
        }

        public void refresh() {
            if (this.isClosing) {
                return;
            }
            this.selectedFile = chooser.getSelectedFile();
            if (this.buttonMap.size() < 2) {
                chooser.setAccessory(null);
                chooser.validate();
                return;
            }
            int n = 0;
            boolean bl = false;
            for (JRadioButton jRadioButton : this.buttonMap.keySet()) {
                if (jRadioButton.isSelected()) {
                    bl = true;
                }
                VideoType videoType = this.buttonMap.get(jRadioButton);
                VideoFileFilter[] videoFileFilterArray = videoType.getFileFilters();
                int n2 = videoFileFilterArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    VideoFileFilter videoFileFilter = videoFileFilterArray[n3];
                    if (this.selectedFile != null && ((FileFilter)videoFileFilter).accept(this.selectedFile)) {
                        ++n;
                    }
                    ++n3;
                }
            }
            if (n < 2) {
                chooser.setAccessory(this.emptyPanel);
            } else {
                chooser.setAccessory(n < 2 ? this.emptyPanel : videoEnginePanel);
                if (!bl) {
                    boolean bl2 = VideoIO.isQTPreferred();
                    for (JRadioButton jRadioButton : this.buttonMap.keySet()) {
                        boolean bl3 = jRadioButton.getActionCommand().indexOf("QT") > -1;
                        jRadioButton.setSelected(bl3 && bl2 || !bl3 && !bl2);
                    }
                }
            }
            chooser.validate();
            chooser.repaint();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.toLowerCase().indexOf("closing") > -1) {
                this.isClosing = true;
            } else if (string.equals("SelectedFileChangedProperty")) {
                this.refresh();
            }
        }
    }
}

