/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.Cryptic;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.Password;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLPropertyElement;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLControlElement
implements XMLControl {
    public static final int ALWAYS_DECRYPT = 0;
    public static final int PASSWORD_DECRYPT = 3;
    public static final int NEVER_DECRYPT = 5;
    public static int compactArraySize = 0;
    protected static String encoding = "UTF-8";
    protected String className = "java.lang.Object";
    protected Class<?> theClass = null;
    protected String name;
    protected Map<String, Integer> counts = new HashMap<String, Integer>();
    protected Object object;
    protected XMLProperty parent;
    protected int level;
    protected ArrayList<String> propNames = new ArrayList();
    protected ArrayList<XMLProperty> props = new ArrayList();
    protected BufferedReader input;
    protected BufferedWriter output;
    public boolean canWrite;
    protected boolean valid = false;
    protected boolean readFailed = false;
    protected String version;
    protected String doctype = "osp10.dtd";
    private String basepath;
    private String password;
    private int decryptPolicy = 0;

    public XMLControlElement() {
    }

    public XMLControlElement(Class<?> clazz) {
        this();
        this.setObjectClass(clazz);
    }

    public XMLControlElement(Object object) {
        this();
        this.setObjectClass(object.getClass());
        this.saveObject(object);
    }

    public XMLControlElement(XMLProperty xMLProperty) {
        this();
        this.parent = xMLProperty;
        this.level = xMLProperty.getLevel();
    }

    public XMLControlElement(String string) {
        this();
        if (string.startsWith("<?xml")) {
            this.readXML(string);
        } else {
            this.read(string);
        }
    }

    public XMLControlElement(XMLControl xMLControl) {
        this();
        this.readXML(xMLControl.toXML());
    }

    @Override
    public void setLockValues(boolean bl) {
    }

    @Override
    public void setValue(String string, boolean bl) {
        if (string == null) {
            return;
        }
        this.setXMLProperty(string, "boolean", String.valueOf(bl));
    }

    @Override
    public void setValue(String string, double d) {
        if (string == null) {
            return;
        }
        this.setXMLProperty(string, "double", String.valueOf(d));
    }

    @Override
    public void setValue(String string, int n) {
        if (string == null) {
            return;
        }
        this.setXMLProperty(string, "int", String.valueOf(n));
    }

    @Override
    public void setValue(String string, Object object) {
        if (string == null) {
            return;
        }
        if (object == null) {
            Iterator<XMLProperty> iterator = this.props.iterator();
            while (iterator.hasNext()) {
                XMLProperty xMLProperty = iterator.next();
                if (!string.equals(xMLProperty.getPropertyName())) continue;
                iterator.remove();
                this.propNames.remove(string);
                break;
            }
            return;
        }
        String string2 = XML.getDataType(object);
        if (string2 != null) {
            if (string2.equals("int") || string2.equals("double")) {
                object = object.toString();
            }
            this.setXMLProperty(string, string2, object);
        }
    }

    @Override
    public boolean getBoolean(String string) {
        XMLProperty xMLProperty = this.getXMLProperty(string);
        if (xMLProperty != null && xMLProperty.getPropertyType().equals("boolean")) {
            return "true".equals(xMLProperty.getPropertyContent().get(0));
        }
        if (xMLProperty != null && xMLProperty.getPropertyType().equals("string")) {
            return "true".equals(xMLProperty.getPropertyContent().get(0));
        }
        return false;
    }

    @Override
    public double getDouble(String string) {
        XMLProperty xMLProperty = this.getXMLProperty(string);
        if (xMLProperty != null && (xMLProperty.getPropertyType().equals("double") || xMLProperty.getPropertyType().equals("int"))) {
            return Double.parseDouble((String)xMLProperty.getPropertyContent().get(0));
        }
        return Double.NaN;
    }

    @Override
    public int getInt(String string) {
        XMLControl xMLControl;
        XMLProperty xMLProperty = this.getXMLProperty(string);
        if (xMLProperty != null && xMLProperty.getPropertyType().equals("int")) {
            return Integer.parseInt((String)xMLProperty.getPropertyContent().get(0));
        }
        if (xMLProperty != null && xMLProperty.getPropertyType().equals("object") && (xMLControl = (XMLControl)xMLProperty.getPropertyContent().get(0)).getObjectClass() == OSPCombo.class) {
            OSPCombo oSPCombo = (OSPCombo)xMLControl.loadObject(null);
            return oSPCombo.getSelectedIndex();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public String getString(String string) {
        XMLControl xMLControl;
        XMLProperty xMLProperty = this.getXMLProperty(string);
        if (xMLProperty != null && xMLProperty.getPropertyType().equals("string")) {
            String string2 = (String)xMLProperty.getPropertyContent().get(0);
            if (string2.indexOf("<![CDATA[") != -1) {
                string2 = string2.substring(string2.indexOf("<![CDATA[") + "<![CDATA[".length(), string2.indexOf("]]>"));
            }
            return string2;
        }
        if (string.equals("basepath") && this.getRootControl() != null) {
            return this.getRootControl().basepath;
        }
        if (xMLProperty != null && xMLProperty.getPropertyType().equals("object") && (xMLControl = (XMLControl)xMLProperty.getPropertyContent().get(0)).getObjectClass() == OSPCombo.class) {
            OSPCombo oSPCombo = (OSPCombo)xMLControl.loadObject(null);
            return oSPCombo.toString();
        }
        return null;
    }

    @Override
    public Object getObject(String string) {
        XMLProperty xMLProperty = this.getXMLProperty(string);
        if (xMLProperty != null) {
            String string2 = xMLProperty.getPropertyType();
            if (string2.equals("object")) {
                return this.objectValue(xMLProperty);
            }
            if (string2.equals("array")) {
                return this.arrayValue(xMLProperty);
            }
            if (string2.equals("collection")) {
                return this.collectionValue(xMLProperty);
            }
            if (string2.equals("int")) {
                return new Integer(this.intValue(xMLProperty));
            }
            if (string2.equals("double")) {
                return new Double(this.doubleValue(xMLProperty));
            }
            if (string2.equals("boolean")) {
                return new Boolean(this.booleanValue(xMLProperty));
            }
            if (string2.equals("string")) {
                return this.stringValue(xMLProperty);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getPropertyNames() {
        ArrayList<String> arrayList = this.propNames;
        synchronized (arrayList) {
            return new ArrayList<String>(this.propNames);
        }
    }

    @Override
    public String getPropertyType(String string) {
        XMLProperty xMLProperty = this.getXMLProperty(string);
        if (xMLProperty != null) {
            return xMLProperty.getPropertyType();
        }
        return null;
    }

    public void setPassword(String string) {
        this.password = string;
        if (this.getObjectClass() != Cryptic.class) {
            this.setValue("xml_password", string);
        }
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = this.getString("xml_password");
        }
        return this.password;
    }

    public void setDecryptPolicy(int n) {
        this.decryptPolicy = n == 5 ? 5 : (n == 3 ? 3 : 0);
    }

    @Override
    public String read(String string) {
        OSPLog.finest("reading " + string);
        Resource resource = ResourceLoader.getResource(string);
        if (resource != null) {
            this.read(resource.openReader());
            String string2 = XML.getDirectoryPath(string);
            if (!string2.equals("")) {
                ResourceLoader.addSearchPath(string2);
                this.basepath = string2;
            } else {
                this.basepath = XML.getDirectoryPath(resource.getAbsolutePath());
            }
            File file = resource.getFile();
            this.canWrite = file != null && file.canWrite();
            return resource.getAbsolutePath();
        }
        this.readFailed = true;
        return null;
    }

    @Override
    public void readXML(String string) {
        this.input = new BufferedReader(new StringReader(string));
        this.readInput();
        if (!this.failedToRead()) {
            this.canWrite = false;
        }
    }

    @Override
    public void read(Reader reader) {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.readInput();
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String readForClass(String string, Class<?> clazz) {
        Resource resource = ResourceLoader.getResource(string);
        if (resource == null) {
            return null;
        }
        this.input = new BufferedReader(resource.openReader());
        if (!this.isInputForClass(clazz)) {
            return null;
        }
        return this.read(string);
    }

    public boolean readXMLForClass(String string, Class<?> clazz) {
        this.input = new BufferedReader(new StringReader(string));
        if (!this.isInputForClass(clazz)) {
            return false;
        }
        this.readXML(string);
        return !this.readFailed;
    }

    @Override
    public boolean failedToRead() {
        return this.readFailed;
    }

    @Override
    public String write(String string) {
        Object object;
        Object object2;
        block8: {
            this.canWrite = true;
            int n = string.lastIndexOf("/");
            if (n < 0) {
                n = string.lastIndexOf("\\");
            }
            if (n > 0 && !((File)(object2 = new File((String)(object = string.substring(0, n + 1))))).exists() && !((File)object2).mkdir()) {
                this.canWrite = false;
                return null;
            }
            object = new File(string);
            if (!((File)object).exists() || ((File)object).canWrite()) break block8;
            JOptionPane.showMessageDialog(null, ControlsRes.getString("Dialog.ReadOnly.Message"), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
            this.canWrite = false;
            return null;
        }
        try {
            object2 = new FileOutputStream((File)object);
            Charset charset = Charset.forName(encoding);
            this.write(new OutputStreamWriter((OutputStream)object2, charset));
            if (((File)object).exists()) {
                String string2 = XML.getDirectoryPath(((File)object).getCanonicalPath());
                ResourceLoader.addSearchPath(string2);
            }
            if (this.isValid()) {
                string = string.indexOf("/") != -1 ? String.valueOf(string.substring(0, string.lastIndexOf("/") + 1)) + this.getDoctype() : (string.indexOf("\\") != -1 ? String.valueOf(string.substring(0, string.lastIndexOf("\\") + 1)) + this.getDoctype() : this.doctype);
                this.writeDocType(new FileWriter(string));
            }
            if (((File)object).exists()) {
                return XML.getAbsolutePath((File)object);
            }
        }
        catch (IOException iOException) {
            this.canWrite = false;
            OSPLog.warning(iOException.getMessage());
        }
        return null;
    }

    @Override
    public void write(Writer writer) {
        try {
            this.output = new BufferedWriter(writer);
            String string = this.toXML();
            if (this.getPassword() != null) {
                Cryptic cryptic = new Cryptic(string);
                XMLControlElement xMLControlElement = new XMLControlElement(cryptic);
                string = xMLControlElement.toXML();
            }
            this.output.write(string);
            this.output.flush();
            this.output.close();
        }
        catch (IOException iOException) {
            OSPLog.info(iOException.getMessage());
        }
    }

    public void writeDocType(Writer writer) {
        try {
            this.output = new BufferedWriter(writer);
            this.output.write(XML.getDTD(this.getDoctype()));
            this.output.flush();
            this.output.close();
        }
        catch (IOException iOException) {
            OSPLog.info(iOException.getMessage());
        }
    }

    @Override
    public String toXML() {
        return this.toString();
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public boolean isValid() {
        return this.valid && XML.getDTD(this.getDoctype()) != null;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDoctype(String string) {
        XML.getDTD(string);
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setObjectClass(Class<?> clazz) {
        if (this.object != null && !clazz.isInstance(this.object)) {
            throw new RuntimeException(this.object + " " + ControlsRes.getString("XMLControlElement.Exception.NotInstanceOf") + " " + clazz);
        }
        this.className = clazz.getName();
        this.theClass = clazz;
    }

    @Override
    public Class<?> getObjectClass() {
        if (this.className == null) {
            return null;
        }
        if (this.theClass != null && this.theClass.getName().equals(this.className)) {
            return this.theClass;
        }
        this.theClass = null;
        try {
            this.theClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        ClassLoader classLoader = XML.getClassLoader();
        if (classLoader != null && this.theClass == null) {
            try {
                this.theClass = classLoader.loadClass(this.className);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return this.theClass;
    }

    @Override
    public String getObjectClassName() {
        return this.className;
    }

    @Override
    public void saveObject(Object object) {
        Class<?> clazz;
        if (object == null) {
            object = this.object;
        }
        if ((clazz = this.getObjectClass()) == null || clazz.equals(Object.class)) {
            if (object == null) {
                return;
            }
            clazz = object.getClass();
        }
        if (clazz.isInstance(object)) {
            this.object = object;
            this.className = object.getClass().getName();
            this.clearValues();
            XML.ObjectLoader objectLoader = XML.getLoader(clazz);
            objectLoader.saveObject(this, object);
        }
    }

    @Override
    public Object loadObject(Object object) {
        return this.loadObject(object, false, false);
    }

    public Object loadObject(Object object, boolean bl) {
        return this.loadObject(object, bl, false);
    }

    public Object loadObject(Object object, boolean bl, boolean bl2) {
        int n;
        Class<?> clazz = this.getObjectClass();
        if (clazz == null) {
            if (object != null) {
                if (!bl && (n = JOptionPane.showConfirmDialog(null, String.valueOf(ControlsRes.getString("XMLControlElement.Dialog.UnknownClass.Message")) + " \"" + this.className + "\"" + XML.NEW_LINE + ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Query") + " \"" + object.getClass().getName() + "\"", ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Title"), 0, 3)) != 0) {
                    return object;
                }
                if (!this.importInto(object, bl2)) {
                    return object;
                }
                clazz = object.getClass();
            } else {
                return null;
            }
        }
        try {
            if (XML.getLoader(clazz).getClass() == XML.getLoader(object.getClass()).getClass()) {
                bl = true;
                bl2 = true;
            }
        }
        catch (Exception exception) {}
        if (object != null && !clazz.isInstance(object)) {
            if (!bl && (n = JOptionPane.showConfirmDialog(null, String.valueOf(ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Message")) + " \"" + clazz.getName() + "\"" + XML.NEW_LINE + ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Query") + " \"" + object.getClass().getName() + "\"", ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Title"), 0, 2)) != 0) {
                return object;
            }
            if (!this.importInto(object, bl2)) {
                return object;
            }
            clazz = object.getClass();
        }
        XML.ObjectLoader objectLoader = XML.getLoader(clazz);
        if (object == null) {
            if (this.object == null) {
                this.object = objectLoader.createObject(this);
            }
            object = this.object;
        }
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            this.object = object = objectLoader.loadObject(this, object);
        }
        return object;
    }

    @Override
    public void clearValues() {
        this.props.clear();
        this.propNames.clear();
    }

    @Override
    public void println(String string) {
        System.out.println(string);
    }

    @Override
    public void println() {
        System.out.println();
    }

    @Override
    public void print(String string) {
        System.out.print(string);
    }

    @Override
    public void clearMessages() {
    }

    @Override
    public void calculationDone(String string) {
    }

    @Override
    public String getPropertyName() {
        XMLProperty xMLProperty = this.getParentProperty();
        if (this.className == null) {
            if (xMLProperty == null) {
                return "null";
            }
            return xMLProperty.getPropertyName();
        }
        if (this.isArrayOrCollectionItem()) {
            if (this.name == null) {
                String string = this.getString("name");
                if (string != null && !"".equals(string)) {
                    this.name = this.className.substring(this.className.lastIndexOf(".") + 1);
                    this.name = String.valueOf(this.name) + " \"" + string + "\"";
                } else {
                    XMLProperty xMLProperty2 = this;
                    while (xMLProperty2.getParentProperty() != null) {
                        xMLProperty2 = xMLProperty2.getParentProperty();
                    }
                    if (xMLProperty2 instanceof XMLControlElement) {
                        XMLProperty xMLProperty3 = xMLProperty2;
                        this.name = this.className.substring(this.className.lastIndexOf(".") + 1);
                        this.name = ((XMLControlElement)xMLProperty3).addNumbering(this.name);
                    }
                }
            }
            return this.name;
        }
        if (xMLProperty != null) {
            return xMLProperty.getPropertyName();
        }
        return this.className.substring(this.className.lastIndexOf(".") + 1);
    }

    @Override
    public String getPropertyType() {
        return "object";
    }

    @Override
    public Class<?> getPropertyClass() {
        return this.getObjectClass();
    }

    @Override
    public XMLProperty getParentProperty() {
        return this.parent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public List<Object> getPropertyContent() {
        return new ArrayList<Object>(this.props);
    }

    @Override
    public XMLControl getChildControl(String string) {
        XMLControl[] xMLControlArray = this.getChildControls();
        int n = 0;
        while (n < xMLControlArray.length) {
            if (xMLControlArray[n].getPropertyName().equals(string)) {
                return xMLControlArray[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public XMLControl[] getChildControls() {
        ArrayList<XMLControl> arrayList = new ArrayList<XMLControl>();
        for (XMLProperty xMLProperty : this.props) {
            if (!xMLProperty.getPropertyType().equals("object")) continue;
            arrayList.add((XMLControl)xMLProperty.getPropertyContent().get(0));
        }
        return arrayList.toArray(new XMLControl[0]);
    }

    public XMLControlElement getRootControl() {
        if (this.parent == null) {
            return this;
        }
        XMLProperty xMLProperty = this.parent;
        while (xMLProperty.getParentProperty() != null) {
            xMLProperty = xMLProperty.getParentProperty();
        }
        if (xMLProperty instanceof XMLControlElement) {
            return (XMLControlElement)xMLProperty;
        }
        return null;
    }

    public String addNumbering(String string) {
        Integer n = this.counts.get(string);
        if (n == null) {
            n = new Integer(0);
        }
        n = new Integer(n + 1);
        this.counts.put(string, n);
        return String.valueOf(string) + " " + n.toString();
    }

    @Override
    public void setValue(String string) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.getLevel() == 0) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            if (this.isValid()) {
                stringBuffer.append(String.valueOf(XML.NEW_LINE) + "<!DOCTYPE object SYSTEM \"" + this.doctype + "\">");
            }
        }
        stringBuffer.append(String.valueOf(XML.NEW_LINE) + this.indent(this.getLevel()) + "<object class=\"" + this.className + "\"");
        if (this.version != null && this.getLevel() == 0) {
            stringBuffer.append(" version=\"" + this.version + "\"");
        }
        if (this.props.isEmpty()) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append(">");
            Iterator<XMLProperty> iterator = this.props.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
            }
            stringBuffer.append(String.valueOf(XML.NEW_LINE) + this.indent(this.getLevel()) + "</object>");
        }
        return stringBuffer.toString();
    }

    public <T> List<T> getObjects(Class<T> clazz) {
        return this.getObjects(clazz, false);
    }

    public <T> List<T> getObjects(Class<T> clazz, boolean bl) {
        List<XMLProperty> list;
        ArrayList<T> arrayList;
        if (bl) {
            arrayList = clazz.getName();
            arrayList = ((String)((Object)arrayList)).substring(((String)((Object)arrayList)).lastIndexOf(".") + 1);
            XMLTreeChooser xMLTreeChooser = new XMLTreeChooser(ControlsRes.getString("XMLControlElement.Chooser.SelectObjectsOfClass.Title"), String.valueOf(ControlsRes.getString("XMLControlElement.Chooser.SelectObjectsOfClass.Label")) + " " + arrayList, null);
            list = xMLTreeChooser.choose(this, clazz);
        } else {
            arrayList = new XMLTree(this);
            ((XMLTree)((Object)arrayList)).setHighlightedClass(clazz);
            ((XMLTree)((Object)arrayList)).selectHighlightedProperties();
            list = ((XMLTree)((Object)arrayList)).getSelectedProperties();
        }
        arrayList = new ArrayList<T>();
        for (XMLControl xMLControl : list) {
            arrayList.add(clazz.cast(xMLControl.loadObject(null)));
        }
        return arrayList;
    }

    public Object clone() {
        return new XMLControlElement(this);
    }

    private boolean isArrayOrCollectionItem() {
        XMLProperty xMLProperty = this.getParentProperty();
        if (xMLProperty != null) {
            return (xMLProperty = xMLProperty.getParentProperty()) != null && "arraycollection".indexOf(xMLProperty.getPropertyType()) >= 0;
        }
        return false;
    }

    private boolean importInto(Object object, boolean bl) {
        Object object2;
        XMLControlElement xMLControlElement = new XMLControlElement(object);
        Collection<String> collection = xMLControlElement.getPropertyNames();
        collection.retainAll(this.getPropertyNames());
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (XMLProperty object3 : this.props) {
            object2 = object3.getPropertyName();
            if (!collection.contains(object2)) continue;
            arrayList.add((String)object2);
            if (object3.getPropertyType().equals("object")) {
                arrayList2.add(object3.getPropertyClass().getSimpleName());
                continue;
            }
            arrayList2.add(object3.getPropertyContent().get(0));
        }
        ListChooser listChooser = new ListChooser(ControlsRes.getString("XMLControlElement.Chooser.ImportObjects.Title"), ControlsRes.getString("XMLControlElement.Chooser.ImportObjects.Label"));
        if (arrayList.isEmpty() || bl || listChooser.choose(arrayList, arrayList, arrayList2)) {
            Iterator<XMLProperty> iterator = this.props.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (arrayList.contains(object2.getPropertyName())) continue;
                iterator.remove();
                this.propNames.remove(object2.getPropertyName());
            }
            for (String string : xMLControlElement.getPropertyNames()) {
                if (arrayList.contains(string)) continue;
                String string2 = xMLControlElement.getPropertyType(string);
                if (string2.equals("int")) {
                    this.setValue(string, xMLControlElement.getInt(string));
                    continue;
                }
                if (string2.equals("double")) {
                    this.setValue(string, xMLControlElement.getDouble(string));
                    continue;
                }
                if (string2.equals("boolean")) {
                    this.setValue(string, xMLControlElement.getBoolean(string));
                    continue;
                }
                if (string2.equals("string")) {
                    this.setValue(string, xMLControlElement.getString(string));
                    continue;
                }
                this.setValue(string, xMLControlElement.getObject(string));
            }
            return true;
        }
        return false;
    }

    private void setXMLProperty(String string, String string2, Object object) {
        int n = -1;
        if (this.propNames.contains(string)) {
            Iterator<XMLProperty> iterator = this.props.iterator();
            while (iterator.hasNext()) {
                ++n;
                XMLProperty xMLProperty = iterator.next();
                if (!xMLProperty.getPropertyName().equals(string)) continue;
                iterator.remove();
                break;
            }
        } else {
            this.propNames.add(string);
        }
        if (n > -1) {
            this.props.add(n, new XMLPropertyElement(this, string, string2, object));
        } else {
            this.props.add(new XMLPropertyElement(this, string, string2, object));
        }
    }

    private XMLProperty getXMLProperty(String string) {
        if (string == null) {
            return null;
        }
        for (XMLProperty xMLProperty : this.props) {
            if (!string.equals(xMLProperty.getPropertyName())) continue;
            return xMLProperty;
        }
        return null;
    }

    private void readInput() {
        Object object;
        Object object2;
        block11: {
            this.readFailed = false;
            try {
                object2 = this.input.readLine();
                while (object2 != null && ((String)object2).indexOf("<object") == -1) {
                    object2 = this.input.readLine();
                }
                if (object2 != null) {
                    object = object2;
                    int n = ((String)object).indexOf("version=");
                    if (n != -1) {
                        object = ((String)object).substring(n + 9);
                        this.version = ((String)object).substring(0, ((String)object).indexOf("\""));
                    }
                    this.readObject(this, (String)object2);
                    break block11;
                }
                this.readFailed = true;
                return;
            }
            catch (Exception exception) {
                this.readFailed = true;
                OSPLog.warning("Failed to read xml: " + exception.getMessage());
                return;
            }
        }
        if (Cryptic.class.equals(this.getObjectClass())) {
            object2 = (Cryptic)this.loadObject(null);
            object = ((Cryptic)object2).decrypt();
            XMLControlElement xMLControlElement = new XMLControlElement((String)object);
            if (xMLControlElement.failedToRead()) {
                return;
            }
            String string = this.password;
            this.password = xMLControlElement.getString("xml_password");
            switch (this.decryptPolicy) {
                case 5: {
                    return;
                }
                case 3: {
                    if (this.password == null || this.password.equals("") || this.password.equals(string) || Password.verify(this.password, null)) break;
                    return;
                }
            }
            this.clearValues();
            this.object = null;
            this.className = Object.class.getName();
            this.theClass = null;
            this.readXML((String)object);
        }
    }

    private boolean isInputForClass(Class<?> clazz) {
        try {
            String string;
            String string2 = this.input.readLine();
            while (string2 != null && string2.indexOf("<object") == -1) {
                string2 = this.input.readLine();
            }
            if (string2 != null && (string = (string2 = string2.substring(string2.indexOf("class=") + 7)).substring(0, string2.indexOf("\""))).equals(clazz.getName())) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private XMLControlElement readObject(XMLControlElement xMLControlElement, String string) throws IOException {
        Object object;
        xMLControlElement.clearValues();
        string = string.substring(string.indexOf("class=") + 7);
        String string2 = string.substring(0, string.indexOf("\""));
        int n = string2.lastIndexOf(".");
        if (n > -1 && ((String)(object = string2.substring(0, n))).endsWith("org.opensourcephysics.media")) {
            string2 = String.valueOf(object) + ".core" + string2.substring(n);
        }
        xMLControlElement.className = string2;
        if (string.indexOf("/>") != -1) {
            this.input.readLine();
            return xMLControlElement;
        }
        object = xMLControlElement;
        string = this.input.readLine();
        while (string != null) {
            if (string.indexOf("</object>") != -1) {
                this.input.readLine();
                return xMLControlElement;
            }
            if (string.indexOf("<property") != -1) {
                XMLPropertyElement xMLPropertyElement = this.readProperty(new XMLPropertyElement((XMLProperty)object), string);
                xMLControlElement.props.add(xMLPropertyElement);
                xMLControlElement.propNames.add(xMLPropertyElement.getPropertyName());
            }
            string = this.input.readLine();
        }
        return xMLControlElement;
    }

    private XMLPropertyElement readProperty(XMLPropertyElement xMLPropertyElement, String string) throws IOException {
        xMLPropertyElement.name = string.substring(string.indexOf("name=") + 6, string.indexOf("type=") - 2);
        string = string.substring(string.indexOf("type=") + 6);
        xMLPropertyElement.type = string.substring(0, string.indexOf("\""));
        if (xMLPropertyElement.type.equals("array") || xMLPropertyElement.type.equals("collection")) {
            String string2;
            String string3 = (string = string.substring(string.indexOf("class=") + 7)).substring(0, string.indexOf("\""));
            int n = string3.lastIndexOf(".");
            if (n > -1 && (string2 = string3.substring(0, n)).endsWith("org.opensourcephysics.media")) {
                string3 = String.valueOf(string2) + ".core" + string3.substring(n);
            }
            xMLPropertyElement.className = string3;
            if (string.indexOf("/>") != -1) {
                return xMLPropertyElement;
            }
            string = this.input.readLine();
            while (string.indexOf("<property") != -1) {
                xMLPropertyElement.content.add(this.readProperty(new XMLPropertyElement(xMLPropertyElement), string));
                string = this.input.readLine();
            }
        } else if (xMLPropertyElement.type.equals("object")) {
            XMLControlElement xMLControlElement = this.readObject(new XMLControlElement(xMLPropertyElement), this.input.readLine());
            xMLPropertyElement.content.add(xMLControlElement);
            xMLPropertyElement.className = xMLControlElement.className;
        } else {
            if (string.indexOf("<![CDATA[") != -1) {
                String string4 = string.substring(string.indexOf("<![CDATA["));
                while (string4.indexOf("]]></property>") == -1) {
                    string4 = String.valueOf(string4) + XML.NEW_LINE + this.input.readLine();
                }
                string = string4.substring(0, string4.indexOf("]]></property>") + "]]>".length());
            } else {
                String string5 = string.substring(string.indexOf(">") + 1);
                while (string5.indexOf("</property>") == -1) {
                    string5 = String.valueOf(string5) + XML.NEW_LINE + this.input.readLine();
                }
                string = string5.substring(0, string5.indexOf("</property>"));
            }
            xMLPropertyElement.content.add(string);
        }
        return xMLPropertyElement;
    }

    private String indent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < 4 * n) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        return string;
    }

    private Object objectValue(XMLProperty xMLProperty) {
        if (!xMLProperty.getPropertyType().equals("object")) {
            return null;
        }
        XMLControl xMLControl = (XMLControl)xMLProperty.getPropertyContent().get(0);
        return xMLControl.loadObject(null);
    }

    private double doubleValue(XMLProperty xMLProperty) {
        if (!xMLProperty.getPropertyType().equals("double")) {
            return Double.NaN;
        }
        return Double.parseDouble((String)xMLProperty.getPropertyContent().get(0));
    }

    private int intValue(XMLProperty xMLProperty) {
        if (!xMLProperty.getPropertyType().equals("int")) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt((String)xMLProperty.getPropertyContent().get(0));
    }

    private boolean booleanValue(XMLProperty xMLProperty) {
        return xMLProperty.getPropertyContent().get(0).equals("true");
    }

    private String stringValue(XMLProperty xMLProperty) {
        if (!xMLProperty.getPropertyType().equals("string")) {
            return null;
        }
        String string = (String)xMLProperty.getPropertyContent().get(0);
        if (string.indexOf("<![CDATA[") != -1) {
            string = string.substring(string.indexOf("<![CDATA[") + "<![CDATA[".length(), string.indexOf("]]>"));
        }
        return string;
    }

    /*
     * Could not resolve type clashes
     */
    private Object arrayValue(XMLProperty xMLProperty) {
        if (!xMLProperty.getPropertyType().equals("array")) {
            return null;
        }
        Class<?> clazz = xMLProperty.getPropertyClass().getComponentType();
        List<Object> list = xMLProperty.getPropertyContent();
        if (list.isEmpty()) {
            return Array.newInstance(clazz, 0);
        }
        XMLProperty xMLProperty2 = (XMLProperty)list.get(0);
        if (xMLProperty2.getPropertyName().equals("array")) {
            Object object = xMLProperty2.getPropertyContent().get(0);
            if (object instanceof String) {
                return this.arrayValue((String)object, clazz);
            }
            return null;
        }
        XMLProperty xMLProperty3 = (XMLProperty)list.get(list.size() - 1);
        String string = xMLProperty3.getPropertyName();
        int n = Integer.parseInt(string.substring(1, string.indexOf("]")));
        Object object = Array.newInstance(clazz, n + 1);
        for (XMLProperty xMLProperty4 : list) {
            boolean bl;
            string = xMLProperty4.getPropertyName();
            n = Integer.parseInt(string.substring(1, string.indexOf("]")));
            String string2 = xMLProperty4.getPropertyType();
            if (string2.equals("object")) {
                Array.set(object, n, this.objectValue(xMLProperty4));
                continue;
            }
            if (string2.equals("int")) {
                bl = this.intValue(xMLProperty4);
                if (Object.class.isAssignableFrom(clazz)) {
                    Array.set(object, n, new Integer(bl ? 1 : 0));
                    continue;
                }
                Array.setInt(object, n, bl ? 1 : 0);
                continue;
            }
            if (string2.equals("double")) {
                double d = this.doubleValue(xMLProperty4);
                if (Object.class.isAssignableFrom(clazz)) {
                    Array.set(object, n, new Double(d));
                    continue;
                }
                Array.setDouble(object, n, d);
                continue;
            }
            if (string2.equals("boolean")) {
                bl = this.booleanValue(xMLProperty4);
                if (Object.class.isAssignableFrom(clazz)) {
                    Array.set(object, n, new Boolean(bl));
                    continue;
                }
                Array.setBoolean(object, n, bl);
                continue;
            }
            if (string2.equals("string")) {
                Array.set(object, n, this.stringValue(xMLProperty4));
                continue;
            }
            if (string2.equals("array")) {
                Array.set(object, n, this.arrayValue(xMLProperty4));
                continue;
            }
            if (!string2.equals("collection")) continue;
            Array.set(object, n, this.collectionValue(xMLProperty4));
        }
        return object;
    }

    private Object arrayValue(String string, Class<?> clazz) {
        if (!string.startsWith("{") || !string.endsWith("}")) {
            return null;
        }
        String string2 = string.substring(1, string.length() - 1);
        if (clazz.isArray()) {
            Boolean[] booleanArray;
            Object object;
            ArrayList<Boolean[]> arrayList = new ArrayList<Boolean[]>();
            ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
            Class<?> clazz2 = clazz.getComponentType();
            int n = string2.indexOf("{");
            int n2 = string2.indexOf("}");
            int n3 = string2.indexOf(",");
            while (n2 > 0) {
                if (n3 < n) {
                    arrayList2.add(true);
                    string2 = string2.substring(n3 + 1);
                } else {
                    object = string2.substring(n, n2 + 1);
                    booleanArray = this.arrayValue((String)object, clazz2);
                    arrayList.add(booleanArray);
                    arrayList2.add(false);
                    string2 = string2.substring(n2 + 1);
                    if (string2.startsWith(",")) {
                        string2 = string2.substring(1);
                    }
                }
                n = string2.indexOf("{");
                n2 = string2.indexOf("}");
                n3 = string2.indexOf(",");
            }
            while (n3 > -1) {
                arrayList2.add(true);
                string2 = string2.substring(n3 + 1);
                n3 = string2.indexOf(",");
            }
            if (string2.length() > 0) {
                arrayList2.add(true);
            }
            object = Array.newInstance(clazz, arrayList2.size());
            booleanArray = arrayList2.toArray(new Boolean[0]);
            Iterator iterator = arrayList.iterator();
            int n4 = 0;
            while (n4 < booleanArray.length) {
                if (!booleanArray[n4].booleanValue() && iterator.hasNext()) {
                    Object e = iterator.next();
                    Array.set(object, n4, e);
                }
                ++n4;
            }
            return object;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (!string2.equals("")) {
            int n = string2.indexOf(",");
            if (n > -1) {
                arrayList.add(string2.substring(0, n));
                string2 = string2.substring(n + 1);
                continue;
            }
            arrayList.add(string2);
            break;
        }
        Object object = Array.newInstance(clazz, arrayList.size());
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (clazz == Integer.TYPE) {
                int n5 = Integer.parseInt((String)iterator.next());
                Array.setInt(object, n++, n5);
                continue;
            }
            if (clazz == Double.TYPE) {
                double d = Double.parseDouble((String)iterator.next());
                Array.setDouble(object, n++, d);
                continue;
            }
            if (clazz != Boolean.TYPE) continue;
            boolean bl = ((String)iterator.next()).equals("true");
            Array.setBoolean(object, n++, bl);
        }
        return object;
    }

    private Object collectionValue(XMLProperty xMLProperty) {
        if (!xMLProperty.getPropertyType().equals("collection")) {
            return null;
        }
        Class<?> clazz = xMLProperty.getPropertyClass();
        try {
            Collection collection = (Collection)clazz.newInstance();
            List<Object> list = xMLProperty.getPropertyContent();
            for (XMLProperty xMLProperty2 : list) {
                String string = xMLProperty2.getPropertyType();
                if (string.equals("object")) {
                    collection.add(this.objectValue(xMLProperty2));
                    continue;
                }
                if (string.equals("string")) {
                    collection.add(this.stringValue(xMLProperty2));
                    continue;
                }
                if (string.equals("array")) {
                    collection.add(this.arrayValue(xMLProperty2));
                    continue;
                }
                if (!string.equals("collection")) continue;
                collection.add(this.collectionValue(xMLProperty2));
            }
            return collection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

