/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementImage;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public class SimpleElementImage
extends SimpleElement {
    private double[] coordinates = new double[3];
    private double[] size = new double[3];
    private double[] pixel = new double[3];
    private AffineTransform transform = new AffineTransform();

    public SimpleElementImage(ElementImage elementImage) {
        super(elementImage);
        this.objects = new Object3D[]{new Object3D(this, 0)};
    }

    public void processChanges(int n, int n2) {
        if ((n2 & 0x136) != 0 || (n2 & 0x40) != 0 || (n2 & 8) != 0) {
            this.projectPointAndSize();
        }
    }

    public void styleChanged(int n) {
        if (n == 5) {
            this.element.addChange(8);
        } else {
            super.styleChanged(n);
        }
    }

    void draw(Graphics2D graphics2D, int n) {
        this.drawIt(graphics2D);
    }

    void drawQuickly(Graphics2D graphics2D) {
        this.drawIt(graphics2D);
    }

    private void projectPointAndSize() {
        double d;
        double d2;
        ElementImage elementImage = (ElementImage)this.element;
        BufferedImage bufferedImage = elementImage.getImage();
        if (bufferedImage == null) {
            return;
        }
        System.arraycopy(Element.STD_ORIGIN, 0, this.coordinates, 0, 3);
        this.element.sizeAndToSpaceFrame(this.coordinates);
        System.arraycopy(this.coordinates, 0, this.pixel, 0, 3);
        this.element.getPanel().projectPosition(this.pixel);
        this.objects[0].setDistance(this.pixel[2] * this.style.getDepthFactor());
        if (elementImage.isTrueSize()) {
            this.size[0] = ((Image)bufferedImage).getWidth(null);
            this.size[1] = ((Image)bufferedImage).getHeight(null);
        } else {
            this.size[0] = this.element.getSizeX();
            this.size[1] = this.element.getSizeY();
            this.size[2] = this.element.getSizeZ();
            this.element.getPanel().projectSize(this.coordinates, this.size);
        }
        switch (this.style.getRelativePosition()) {
            default: {
                d2 = this.size[0] / 2.0;
                d = this.size[1] / 2.0;
                break;
            }
            case 1: {
                d2 = this.size[0] / 2.0;
                d = 0.0;
                break;
            }
            case 2: {
                d2 = this.size[0] / 2.0;
                d = this.size[1];
                break;
            }
            case 3: {
                d2 = this.size[0];
                d = this.size[1] / 2.0;
                break;
            }
            case 4: {
                d2 = 0.0;
                d = this.size[1] / 2.0;
                break;
            }
            case 5: {
                d2 = this.size[0];
                d = 0.0;
                break;
            }
            case 6: {
                d2 = 0.0;
                d = 0.0;
                break;
            }
            case 7: {
                d2 = this.size[0];
                d = this.size[1];
                break;
            }
            case 8: {
                d2 = 0.0;
                d = this.size[1];
            }
        }
        this.transform.setToTranslation(this.pixel[0], this.pixel[1]);
        double d3 = elementImage.getRotationAngle();
        if (d3 != 0.0) {
            this.transform.rotate(-d3);
        }
        this.transform.translate(-d2, -d);
        if (!elementImage.isTrueSize()) {
            this.transform.scale(this.size[0] / (double)((Image)bufferedImage).getWidth(null), this.size[1] / (double)((Image)bufferedImage).getHeight(null));
        }
    }

    private void drawIt(Graphics2D graphics2D) {
        ElementImage elementImage = (ElementImage)this.element;
        BufferedImage bufferedImage = elementImage.getImage();
        if (bufferedImage == null) {
            return;
        }
        graphics2D.drawImage(bufferedImage, this.transform, this.element.getPanel().getComponent());
    }
}

