/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import java.awt.Color;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3d;
import org.opensourcephysics.drawing3d.ElementImage;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementImage
extends Java3dElement {
    private TexCoord2f[] texCoord = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f)};
    private QuadArray quad = null;
    private BranchGroup bg = null;
    private Transform3D t3d = null;
    private TransformGroup tg = null;
    private double dz = 0.0;
    private double dy = 0.0;
    private double scale = 1.0;

    public Java3dElementImage(ElementImage elementImage) {
        this(elementImage, false);
    }

    public Java3dElementImage(ElementImage elementImage, boolean bl) {
        super(elementImage);
        this.element.getStyle().setDrawingLines(true);
        this.element.getStyle().setFillColor(Color.black);
        this.getAppearance().getPolygonAttributes().setCullFace(0);
        this.quad = new QuadArray(4, 35);
        this.quad.setCapability(1);
        this.quad.setCoordinate(0, new Point3f(0.0f, -0.5f, -0.5f));
        this.quad.setCoordinate(1, new Point3f(0.0f, 0.5f, -0.5f));
        this.quad.setCoordinate(2, new Point3f(0.0f, 0.5f, 0.5f));
        this.quad.setCoordinate(3, new Point3f(0.0f, -0.5f, 0.5f));
        if (bl) {
            this.quad.setTextureCoordinate(0, 3, this.texCoord[0]);
            this.quad.setTextureCoordinate(0, 2, this.texCoord[2]);
            this.quad.setTextureCoordinate(0, 1, this.texCoord[3]);
            this.quad.setTextureCoordinate(0, 0, this.texCoord[1]);
        } else {
            this.quad.setTextureCoordinate(0, 0, this.texCoord[0]);
            this.quad.setTextureCoordinate(0, 1, this.texCoord[2]);
            this.quad.setTextureCoordinate(0, 2, this.texCoord[3]);
            this.quad.setTextureCoordinate(0, 3, this.texCoord[1]);
        }
        this.tg = new TransformGroup();
        this.t3d = new Transform3D();
        this.t3d.rotY(((ElementImage)this.element).getRotationAngle());
        this.tg.setCapability(13);
        this.tg.setCapability(14);
        this.tg.setCapability(18);
        this.tg.setTransform(this.t3d);
        this.addNode((Node)this.tg);
        this.element.addChange(8);
        this.styleChanged(5);
    }

    public boolean isPrimitive() {
        return true;
    }

    public void styleChanged(int n) {
        if (n == 5) {
            double[] dArray = new double[]{this.element.getSizeX(), this.element.getSizeY(), this.element.getSizeZ()};
            switch (this.element.getStyle().getRelativePosition()) {
                default: {
                    this.dz = 0.0;
                    this.dy = 0.0;
                    break;
                }
                case 1: {
                    this.dz = -dArray[2] / 2.0;
                    this.dy = 0.0;
                    break;
                }
                case 2: {
                    this.dz = dArray[2] / 2.0;
                    this.dy = 0.0;
                    break;
                }
                case 3: {
                    this.dz = 0.0;
                    this.dy = -dArray[1] / 2.0;
                    break;
                }
                case 4: {
                    this.dz = 0.0;
                    this.dy = dArray[1] / 2.0;
                    break;
                }
                case 5: {
                    this.dz = -dArray[2] / 2.0;
                    this.dy = -dArray[1] / 2.0;
                    break;
                }
                case 6: {
                    this.dz = -dArray[2] / 2.0;
                    this.dy = dArray[1] / 2.0;
                    break;
                }
                case 7: {
                    this.dz = dArray[2] / 2.0;
                    this.dy = -dArray[1] / 2.0;
                    break;
                }
                case 8: {
                    this.dz = dArray[2] / 2.0;
                    this.dy = dArray[1] / 2.0;
                }
            }
            this.element.addChange(64);
        } else {
            super.styleChanged(n);
        }
    }

    public void processChanges(int n, int n2) {
        super.processChanges(n, n2);
        if ((n & 8) != 0) {
            if (((ElementImage)this.element).getImageFile() != null) {
                this.element.getStyle().setTexture(((ElementImage)this.element).getImageFile(), null, 0.0, false);
            } else {
                this.element.getStyle().setTexture(((ElementImage)this.element).getImage(), null, 0.0, false);
            }
            Shape3D shape3D = new Shape3D((Geometry)this.quad);
            shape3D.setAppearance(this.getAppearance());
            this.bg = new BranchGroup();
            this.bg.setCapability(17);
            this.bg.addChild((Node)shape3D);
            this.tg.addChild((Node)this.bg);
        }
        if ((n & 0x40) != 0) {
            this.t3d.setIdentity();
            this.t3d.rotY(((ElementImage)this.element).getRotationAngle());
            this.t3d.setTranslation(new Vector3d(0.0, this.dy, this.dz));
            this.t3d.setScale(this.scale);
            this.tg.setTransform(this.t3d);
        }
        if ((n & 4) != 0) {
            this.scale = ((ElementImage)this.element).isTrueSize() ? (double)Math.max(((ElementImage)this.element).getImage().getWidth(null) / 150, ((ElementImage)this.element).getImage().getHeight(null) / 150) : 1.0;
            this.t3d.setIdentity();
            this.t3d.setTranslation(new Vector3d(0.0, this.dy, this.dz));
            this.t3d.setScale(this.scale);
            this.tg.setTransform(this.t3d);
        }
    }
}

