/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementImage;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementImage;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ElementImage
extends Element {
    private String imageFile = null;
    private double angle = 0.0;
    private boolean trueSize = false;
    private Resource resource = null;
    protected BufferedImage image = null;

    public ElementImage() {
        this.setSizeXYZ(0.1, 0.1, 0.1);
        this.setImageFile("/org/opensourcephysics/resources/controls/images/window.gif");
    }

    protected ImplementingObject createImplementingObject(int n) {
        switch (n) {
            default: {
                return new SimpleElementImage(this);
            }
            case 1: 
        }
        return new Java3dElementImage(this);
    }

    public void setRotationAngle(double d) {
        if (this.angle == d) {
            return;
        }
        this.angle = d;
        this.addChange(64);
    }

    public double getRotationAngle() {
        return this.angle;
    }

    public void setImageFile(String string) {
        if (this.imageFile != null && this.imageFile.equals(string)) {
            return;
        }
        this.imageFile = string;
        if (string != null) {
            this.resource = ResourceLoader.getResource(string);
            if (this.resource != null) {
                this.image = this.resource.getBufferedImage();
                Component component = null;
                if (this.getPanel() != null) {
                    component = this.getPanel().getComponent();
                }
                Toolkit.getDefaultToolkit().prepareImage(this.image, -1, -1, component);
                this.addChange(8);
            }
        }
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.imageFile = null;
        this.image = bufferedImage;
        this.addChange(8);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setTrueSize(boolean bl) {
        if (this.trueSize == bl) {
            return;
        }
        this.trueSize = bl;
        this.addChange(4);
    }

    public boolean isTrueSize() {
        return this.trueSize;
    }
}

