/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementCone;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementCone;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class ElementCone
extends Element {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngle = 0;
    private int maxAngle = 360;
    private double truncationHeight = Double.NaN;

    public ElementCone() {
        this.getStyle().setResolution(new Resolution(3, 12, 5));
    }

    protected ImplementingObject createImplementingObject(int n) {
        switch (n) {
            default: {
                return new SimpleElementCone(this);
            }
            case 1: 
        }
        return new Java3dElementCone(this);
    }

    public void setClosedBottom(boolean bl) {
        if (this.closedBottom == bl) {
            return;
        }
        this.closedBottom = bl;
        this.addChange(8);
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean bl) {
        if (this.closedTop == bl) {
            return;
        }
        this.closedTop = bl;
        this.addChange(8);
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean bl) {
        if (this.closedLeft == bl) {
            return;
        }
        this.closedLeft = bl;
        this.addChange(8);
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean bl) {
        if (this.closedRight == bl) {
            return;
        }
        this.closedRight = bl;
        this.addChange(8);
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setTruncationHeight(double d) {
        if (this.truncationHeight == d) {
            return;
        }
        if (d < 0.0) {
            d = Double.NaN;
        }
        this.truncationHeight = d;
        this.addChange(8);
    }

    public double getTruncationHeight() {
        return this.truncationHeight;
    }

    public void setMinimumAngle(int n) {
        if (this.minAngle == n) {
            return;
        }
        this.minAngle = Math.max(0, Math.min(360, n));
        this.addChange(8);
    }

    public int getMinimumAngle() {
        return this.minAngle;
    }

    public void setMaximumAngle(int n) {
        if (this.maxAngle == n) {
            return;
        }
        this.maxAngle = Math.max(0, Math.min(360, n));
        this.addChange(8);
    }

    public int getMaximumAngle() {
        return this.maxAngle;
    }

    public boolean checkStandarCone() {
        return this.closedBottom && this.minAngle == 0 && this.maxAngle == 360 && Double.isNaN(this.truncationHeight);
    }

    public static double[][][] createStandardCone(int n, int n2, int n3, double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d3) {
        int n4;
        int n5;
        int n6 = n2 * n3;
        if (bl2) {
            n6 += n * n2;
        }
        if (!Double.isNaN(d3) && bl) {
            n6 += n * n2;
        }
        if (Math.abs(d2 - d) < 360.0) {
            if (bl3) {
                n6 += n * n3;
            }
            if (bl4) {
                n6 += n * n3;
            }
        }
        double[][][] dArray = new double[n6][4][3];
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[n2 + 1];
        int n7 = 0;
        while (n7 <= n2) {
            double d4 = ((double)(n2 - n7) * d + (double)n7 * d2) * (Math.PI / 180) / (double)n2;
            dArray2[n7] = Math.cos(d4) / 2.0;
            dArray3[n7] = Math.sin(d4) / 2.0;
            ++n7;
        }
        n7 = 0;
        double[] dArray4 = Element.X_UNIT_VECTOR;
        double[] dArray5 = Element.Y_UNIT_VECTOR;
        double[] dArray6 = Element.Z_UNIT_VECTOR;
        double[] dArray7 = new double[]{-dArray6[0] / 2.0, -dArray6[1] / 2.0, -dArray6[2] / 2.0};
        double d5 = Double.isNaN(d3) ? (double)n3 : (d3 == 0.0 ? 2.147483647E9 : (double)n3 / d3);
        double d6 = 1.0 / d5;
        int n8 = 0;
        while (n8 < n3) {
            n5 = 0;
            while (n5 < n2) {
                n4 = 0;
                while (n4 < 3) {
                    dArray[n7][0][n4] = dArray7[n4] + (dArray2[n5] * dArray4[n4] + dArray3[n5] * dArray5[n4]) * (d5 - (double)n8) / d5 + (double)n8 * d6 * dArray6[n4];
                    dArray[n7][1][n4] = dArray7[n4] + (dArray2[n5 + 1] * dArray4[n4] + dArray3[n5 + 1] * dArray5[n4]) * (d5 - (double)n8) / d5 + (double)n8 * d6 * dArray6[n4];
                    dArray[n7][2][n4] = dArray7[n4] + (dArray2[n5 + 1] * dArray4[n4] + dArray3[n5 + 1] * dArray5[n4]) * (d5 - (double)n8 - 1.0) / d5 + (double)(n8 + 1) * d6 * dArray6[n4];
                    dArray[n7][3][n4] = dArray7[n4] + (dArray2[n5] * dArray4[n4] + dArray3[n5] * dArray5[n4]) * (d5 - (double)n8 - 1.0) / d5 + (double)(n8 + 1) * d6 * dArray6[n4];
                    ++n4;
                }
                ++n5;
                ++n7;
            }
            ++n8;
        }
        if (bl2) {
            n8 = 0;
            while (n8 < n2) {
                n5 = 0;
                while (n5 < n) {
                    n4 = 0;
                    while (n4 < 3) {
                        dArray[n7][0][n4] = ((double)(n - n5) * dArray7[n4] + (double)n5 * dArray[n8][0][n4]) / (double)n;
                        dArray[n7][1][n4] = ((double)(n - n5 - 1) * dArray7[n4] + (double)(n5 + 1) * dArray[n8][0][n4]) / (double)n;
                        dArray[n7][2][n4] = ((double)(n - n5 - 1) * dArray7[n4] + (double)(n5 + 1) * dArray[n8][1][n4]) / (double)n;
                        dArray[n7][3][n4] = ((double)(n - n5) * dArray7[n4] + (double)n5 * dArray[n8][1][n4]) / (double)n;
                        ++n4;
                    }
                    ++n5;
                    ++n7;
                }
                ++n8;
            }
        }
        if (!Double.isNaN(d3) && bl) {
            n8 = n2 * (n3 - 1);
            dArray7[0] = dArray6[0];
            dArray7[1] = dArray6[1];
            dArray7[2] = Double.isNaN(d3) ? dArray6[2] - 0.5 : d3 * dArray6[2] - 0.5;
            n5 = 0;
            while (n5 < n2) {
                n4 = 0;
                while (n4 < n) {
                    int n9 = 0;
                    while (n9 < 3) {
                        dArray[n7][0][n9] = ((double)(n - n4) * dArray7[n9] + (double)n4 * dArray[n8 + n5][3][n9]) / (double)n;
                        dArray[n7][1][n9] = ((double)(n - n4 - 1) * dArray7[n9] + (double)(n4 + 1) * dArray[n8 + n5][3][n9]) / (double)n;
                        dArray[n7][2][n9] = ((double)(n - n4 - 1) * dArray7[n9] + (double)(n4 + 1) * dArray[n8 + n5][2][n9]) / (double)n;
                        dArray[n7][3][n9] = ((double)(n - n4) * dArray7[n9] + (double)n4 * dArray[n8 + n5][2][n9]) / (double)n;
                        ++n9;
                    }
                    ++n4;
                    ++n7;
                }
                ++n5;
            }
        }
        if (Math.abs(d2 - d) < 360.0) {
            int n10;
            int n11;
            int n12;
            double d7;
            dArray7[0] = -dArray6[0] / 2.0;
            dArray7[1] = -dArray6[1] / 2.0;
            dArray7[2] = -dArray6[2] / 2.0;
            if (bl4) {
                n8 = 0;
                double[] dArray8 = new double[3];
                double d8 = Double.isNaN(d3) ? (double)n3 : (d3 == 0.0 ? 2.147483647E9 : (double)n3 / d3);
                d7 = 1.0 / d8;
                n12 = 0;
                while (n12 < n3) {
                    dArray7[0] = (double)n12 * d7 * dArray6[0];
                    dArray7[1] = (double)n12 * d7 * dArray6[1];
                    dArray7[2] = (double)n12 * d7 * dArray6[2] - 0.5;
                    dArray8[0] = (double)(n12 + 1) * d7 * dArray6[0];
                    dArray8[1] = (double)(n12 + 1) * d7 * dArray6[1];
                    dArray8[2] = (double)(n12 + 1) * d7 * dArray6[2] - 0.5;
                    n11 = 0;
                    while (n11 < n) {
                        n10 = 0;
                        while (n10 < 3) {
                            dArray[n7][0][n10] = ((double)(n - n11) * dArray7[n10] + (double)n11 * dArray[n8][0][n10]) / (double)n;
                            dArray[n7][1][n10] = ((double)(n - n11 - 1) * dArray7[n10] + (double)(n11 + 1) * dArray[n8][0][n10]) / (double)n;
                            dArray[n7][2][n10] = ((double)(n - n11 - 1) * dArray8[n10] + (double)(n11 + 1) * dArray[n8][3][n10]) / (double)n;
                            dArray[n7][3][n10] = ((double)(n - n11) * dArray8[n10] + (double)n11 * dArray[n8][3][n10]) / (double)n;
                            ++n10;
                        }
                        ++n11;
                        ++n7;
                    }
                    ++n12;
                    n8 += n2;
                }
            }
            if (bl3) {
                n8 = n2 - 1;
                double[] dArray9 = new double[3];
                double d9 = Double.isNaN(d3) ? (double)n3 : (d3 == 0.0 ? 2.147483647E9 : (double)n3 / d3);
                d7 = 1.0 / d9;
                n12 = 0;
                while (n12 < n3) {
                    dArray7[0] = (double)n12 * d7 * dArray6[0];
                    dArray7[1] = (double)n12 * d7 * dArray6[1];
                    dArray7[2] = (double)n12 * d7 * dArray6[2] - 0.5;
                    dArray9[0] = (double)(n12 + 1) * d7 * dArray6[0];
                    dArray9[1] = (double)(n12 + 1) * d7 * dArray6[1];
                    dArray9[2] = (double)(n12 + 1) * d7 * dArray6[2] - 0.5;
                    n11 = 0;
                    while (n11 < n) {
                        n10 = 0;
                        while (n10 < 3) {
                            dArray[n7][0][n10] = ((double)(n - n11) * dArray7[n10] + (double)n11 * dArray[n8][1][n10]) / (double)n;
                            dArray[n7][1][n10] = ((double)(n - n11 - 1) * dArray7[n10] + (double)(n11 + 1) * dArray[n8][1][n10]) / (double)n;
                            dArray[n7][2][n10] = ((double)(n - n11 - 1) * dArray9[n10] + (double)(n11 + 1) * dArray[n8][2][n10]) / (double)n;
                            dArray[n7][3][n10] = ((double)(n - n11) * dArray9[n10] + (double)n11 * dArray[n8][2][n10]) / (double)n;
                            ++n10;
                        }
                        ++n11;
                        ++n7;
                    }
                    ++n12;
                    n8 += n2;
                }
            }
        }
        return dArray;
    }
}

