/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.TreeSet;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.xuggle.XuggleVideo;
import org.opensourcephysics.media.xuggle.XuggleVideoRecorder;

public class XuggleVideoType
implements VideoType {
    protected static TreeSet<VideoFileFilter> xuggleFileFilters = new TreeSet();
    protected static String xuggleClass = "com.xuggle.xuggler.IContainer";
    protected static PropertyChangeListener errorListener;
    protected static boolean isXuggleAvailable;
    protected boolean recordable = true;
    private VideoFileFilter singleTypeFilter;

    static {
        isXuggleAvailable = true;
        errorListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("xuggle_error")) {
                    isXuggleAvailable = false;
                }
            }
        };
        OSPLog.getOSPLog().addPropertyChangeListener(errorListener);
    }

    public XuggleVideoType() {
        if (!isXuggleAvailable) {
            throw new Error("Xuggle unavailable");
        }
        boolean bl = OSPLog.isConsoleMessagesLogged();
        try {
            OSPLog.setConsoleMessagesLogged(false);
            Class.forName(xuggleClass);
            OSPLog.setConsoleMessagesLogged(bl);
        }
        catch (Exception exception) {
            OSPLog.setConsoleMessagesLogged(bl);
            throw new Error("Xuggle unavailable");
        }
    }

    public XuggleVideoType(VideoFileFilter videoFileFilter) {
        this();
        if (videoFileFilter != null) {
            this.singleTypeFilter = videoFileFilter;
            xuggleFileFilters.add(videoFileFilter);
        }
    }

    public Video getVideo(String string) {
        try {
            XuggleVideo xuggleVideo = new XuggleVideo(string);
            xuggleVideo.setProperty("video_type", this);
            return xuggleVideo;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean canRecord() {
        return this.recordable;
    }

    public void setRecordable(boolean bl) {
        this.recordable = bl;
    }

    public VideoRecorder getRecorder() {
        return new XuggleVideoRecorder(this);
    }

    public VideoFileFilter[] getFileFilters() {
        return xuggleFileFilters.toArray(new VideoFileFilter[0]);
    }

    public VideoFileFilter getDefaultFileFilter() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter;
        }
        return null;
    }

    public boolean isType(Video video2) {
        return video2.getClass().equals(XuggleVideo.class);
    }

    public String getDescription() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDescription();
        }
        return MediaRes.getString("XuggleVideoType.Description");
    }

    public String getDefaultExtension() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDefaultExtension();
        }
        return null;
    }
}

