var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./pascalfluid/t_8xaJEam.png"]="data:image/png;base64,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";
__base64Images["./pascalfluid/BJUF_Yuqz.png"]="data:image/png;base64,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";
