var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./archimedes/ryZvTPCM-.png"]="data:image/png;base64,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";
__base64Images["./archimedes/SkTbGS8G-.png"]="data:image/png;base64,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";
__base64Images["./archimedes/Bysf-d0zb.png"]="data:image/png;base64,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";
__base64Images["./archimedes/B1BNGUDKG.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAA8CAYAAAA6/NlyAAAFAElEQVR4nO2aLZCrSBCAJ69OjBx343ZccIvMOtzijnNIJBKJY10kEhmJJKvIKc4h2VXkqbCKRBE3cXPiPa5INswMf8nWq9dVXZXUQE9/0z1dQ8OMMQZuIbPZTDgRY2w2tR/fpp7gq8lv4F9dfgP/6vLH1BNst1uw3++lrt1sNjrGeK+q6ttkDjHGRtcsy4DrukBRlLOpZJUQsrNtO0iSRBvbt9EMUUqB7/uAENK6tn0UIVQ5juOXZYm/DHAQBABjLEymIQohpJ7nvVRVhe4GHEURL6KjAjcj7vu+c3Ng27ZlQUcFrlXX9bhPtDuDVlUFNE3rCjs6MACAKYqS53muTAac53mXFJ4cGPxM8TiOdVmGGWNyT0vb7RY8PT2B4/HYmRRCCAzDCOfz+XeM8V5RlG09VhQFKYqCHA6HP9frtbHf74XV74r9UxRFf+u6vhFeLJvGXSOLEAKWZYEoigClVDqLsixTXdddEkJ2oGMVz7JMHZzSlNJOexZCCDzPA1VV9S6IP+eFvu87CKFKFpoQshMVslGrsWmaoCzLQaBXsgu5rruUhdY0LaGUwl7Aq9VKGna5XI4KeqlhGJoQQioD7brusjMwpVTm9AQQQiCKoklha82yTJXZ2xBC2nYUbTXu+75UZG8FW2ue54rMvjYMI5IGlo3u1GncpnEc6zKpfa1qXzW4XC6FsKZp3gW2Vs/zXvpE+aoxUXQhhKNX4z6qqmomgr48en4ykiTJl03lS42iyBABL5dLlwvsOA4XFmPc6eQ0tS4Wi5QHrGlawgUWHSFt2747ZNcoN09fZzdnWSZM5yRJ7g7ZVEopFB1IVquVVV9/1qZ9e+M3CxFCYLFYCBfllgIhPGma9i/vmvf398f69xlwURRc44ZhAAjhAPemkefn5394481HzjPgw+HANfz4+Mgdv5eI+titwKKGuczp6x5CCCl440VRkPp3J+AB7Z1JBWPMdbw38FeNMITwBCE8yVx7BgwhzAGnvB+PR3VkX0eT0+kkVU3PgEV7oU+D7RbSTNlr0kz5b20DfQzfS0SBaAV+eHj44N348fHxMMy1aUQE3MzcThFer9fGIM8mktfX1794460RbjbIr8l2u1W+YlpvNhudNz6fz7///+fyIC7qFw15czeFpmm64PkLLpoAnwyYphnyblZVNbs3ZFMdx/F5/hJCds3rPxkIw9AUrVgURca9QRljoCxLLHo0dBzH5wJXVYVERgghO153/1ZqGEYkCs7ldyK9DV32im6tMnsXY1xeBuaqsSzLVJExCCGd4isbGd3tdgRjXIp8DMPQvLy31aht24HMCu52O3JLWEoplGnPthXXVsMyBaE2PNYnRTKwuq7HIp+u7V0hMGMMyL6mxBiXMi+jh6axTGQBaH+vJASWTZ96Tze7g2NqmqYLmT1bLz4v46RWVnYyAH40vtM0XYwBWpYltixrJTu3TCGVXmHZl9HNtOoLnue54nneS9c5gyCwRbalnQiCwO4yea0IocqyrFUYhmbb6qdpuojjWLdtO+j6MUutlyeqwcCMMeD7vtPHmba9NpYt27YDWYbO6ZYkidbly5opFUJIZdJ4EDBjPwqZoijcht/UihCq+pz0egEz9uMho0sFHVN1XY/7HnZ6A9eaZZmqaVpyC1BVVbMu31VOAlxrHMf6VGmOMS677tXJgWtNkkRzHMcfCo8xLi3LWkVRZIz57P0f9eeRboLoGG0AAAAASUVORK5CYII=";
__base64Images["./archimedes/B10JgOUM-.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEwAACxMBAJqcGAAABIpJREFUeJzt2luolFUUwPHfeNTyaBmaXSlFEyvoQUQLKoqKCqoXX3qIop4qCLoJRdFNoiACi16CMuqABVEPXQ0hMk0zyrAw0EzS0MqitEK8VaeHPQfnfLNm5ps538y5NH/YMN/e+9tr7TV77W9fFl26dOnSpUuXLv9TSsMgcwGuxyKcWs7bjXVYgS0VdXtxHk7EQWzFro5p2iITMBPzMK0i/wy8h/4G6RVcijdxKCjfjNvLckYMJVyLldI/VanwdizDLxp3vpm0CXM60blGTJfvn21H+gmzh6L8UOeAGViNc1t4dy++lIbyfBzXog7b8TNOxhHsLOvUJxmobYwrC2r2X/sbS3BMRVuT8DD+zdTdhftxDW7Au03IOVhuc3zhPS9zcw3B3+BR3IkXsD9TfkudNpdU1PvC4El0gPtqyK2V3jbY2IWxKRD2rGqLz5GGZT8+Vd/tevAt/sHcGnVKWBPIrpdebqZjeTgtELJecouIi8t1HsrR9tPY0KDObRnZv2IV1qr+Cg2k66KGailci2OlWffyoOwlyYcj1mKbNPE14kf81qDO7orfj+B0XCkZeibeD94JjZ/HAD24UerEX9Ks29dAqYgdOWRxdCKsx0D5U1iKwxVle7AYX2feWYhZ2YYaGWCmNLT7cJH6M2ojpWuNjlY5gidrlB2SXCnLgmxGvQ7NxceOrtdHGjuxr075V0HeSdmMWiOgF+8otvO71Fd4gL0ab3j247sGdQ4HeT055IPHxDPpejyAe/CatKgZKLs6b+Md4mzV+t+R58WJ0iycffku1d/w8/GHUWyAyAUWqV6BrcAzqie6zyTDjFoiA5wT5L1Yp41XpVl3VBIZYHKQV+8bf0havIxK8q4EO/2N7xjNLoXHHGPZALkOe8ayAXqDvAPZjLFsgFlB3p5sRlEG+LOgdorkgiBvazajqPOyxVo/1GwXl2Se90lb+UHkNUCjkbIjZzud4njVW981gs911LFox3ZWAUp1kgtV9211VDEyQLSPjjZCI5ns8KeGASLGSUM6u5NaZvQYYYPBuu/VxFkA6fIxOg943sj/dE4x+JyiH28120gPPhIboU8bb1sK4CrVOt/dSkPTxZcf/XhDOjgZiTyhWt/5rTY2DZ8HDfZLN8KThqhsO1hniP6fZSo+ERvhQ8nnRgqTpePyIfl/xBSps5ER1uGEIoQUwBUK8v+ISWoHQmyU4niGm8cV6P8RE6XYncgIm3FKkcJaYK2C/T9ivHRKHBlhG84sWmBOeqXLkML9P6IHy8VG2Gl4gpcuC3QpzP8jxuG5QGi/tJSe2k7hAUsDPQr1/4iSdEUdGeHBdgvP8HpG/gFt8P+IkhQTlDXA6k4Ir+CDjPzvOyy/au+wpX71wlnVivwid3Y/ZJ5nS7FEnWCKan/PE45T6K5uA26qeJ4ghc4uke77G90utcoMaQLMLsQ2tkleTaarjgkczrSwvd2NubdFZYtOy9vd0VqUpKv04ez8Simcb9go4VYpgLmTHf9dCqNtal5r5yHnBCmEZp72HpwclgKm1ktRol26dOmSm/8AM3ZQ8XkeaZEAAAAASUVORK5CYII=";
__base64Images["./archimedes/Screenshot 2020-03-26 at 5.28.15 PM.png"]="data:image/png;base64,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";
